/*
 * Decompiled with CFR 0.152.
 */
import JMyron.JMyron;
import blobDetection.Blob;
import blobDetection.BlobDetection;
import com.stromberglabs.jopensurf.SURFInterestPoint;
import com.stromberglabs.jopensurf.Surf;
import ddf.minim.AudioSnippet;
import ddf.minim.Minim;
import guicomponents.G4P;
import guicomponents.GButton;
import guicomponents.GCheckbox;
import guicomponents.GCombo;
import guicomponents.GComponent;
import guicomponents.GLabel;
import guicomponents.GOption;
import guicomponents.GOptionGroup;
import guicomponents.GPanel;
import guicomponents.GSlider;
import guicomponents.GWSlider;
import guicomponents.GWinApplet;
import guicomponents.GWinData;
import guicomponents.GWindow;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import processing.core.PApplet;
import processing.core.PImage;
import processing.serial.Serial;
import procontroll.ControllButton;
import procontroll.ControllDevice;
import procontroll.ControllIO;
import procontroll.ControllSlider;

public class PSG_Processing_Code
extends PApplet {
    public int camWidth = 640;
    public int camHeight = 480;
    public boolean use_surf = true;
    public int surf_sensivity = 3;
    public String surfRefFile = "C:/Users/Britt/Desktop/Sentry/robot_live2.jpg";
    boolean PRINT_FRAMERATE = true;
    int[] diffPixelsColor;
    public int effect;
    public boolean mirrorCam;
    public float xMin;
    public float xMax;
    public float yMin;
    public float yMax;
    public int minBlobArea;
    public int tolerance;
    public boolean runWithoutArduino;
    public boolean connecting;
    public Surf mSurfRef;
    public Surf mSurfCap;
    public Map<SURFInterestPoint, SURFInterestPoint> mAMatchingPoints;
    public Map<SURFInterestPoint, SURFInterestPoint> mBMatchingPoints;
    public Map<SURFInterestPoint, SURFInterestPoint> pointsA;
    public Map<SURFInterestPoint, SURFInterestPoint> pointsB;
    public BufferedImage imageRef;
    public BufferedImage captureImage;
    public Serial arduinoPort;
    JMyron camInput;
    BlobDetection target;
    Blob blob;
    Blob biggestBlob;
    int[] Background;
    int[] rawImage;
    int[] rawBackground;
    int[] currFrame;
    int[] screenPixels;
    public int targetX;
    public int targetY;
    int fire;
    int[] prevFire;
    float xRatio;
    float yRatio;
    int possibleX;
    int possibleY;
    int displayX;
    int displayY;
    int oldX;
    int oldY;
    int xdiff;
    int ydiff;
    public float smoothingFactor;
    public boolean activeSmoothing;
    String strTargetx;
    String strTargety;
    String fireSelector;
    String scanSelector;
    public boolean showDifferentPixels;
    public boolean showTargetBox;
    public boolean showCameraView;
    public boolean firingMode;
    public boolean safety;
    public boolean controlMode;
    public boolean soundEffects;
    public boolean scanWhenIdle;
    public boolean trackingMotion;
    int idleTime;
    int idleBeginTime;
    boolean scan;
    public String serPortUsed;
    int[][] fireRestrictedZones;
    int restrictedZone;
    boolean showRestrictedZones;
    boolean selectingColor;
    boolean trackingColor;
    int trackColorTolerance;
    int trackColorRed;
    int trackColorGreen;
    int trackColorBlue;
    boolean selectingSafeColor;
    boolean safeColor;
    int safeColorMinSize;
    int safeColorTolerance;
    int safeColorRed;
    int safeColorGreen;
    int safeColorBlue;
    boolean useArrowKeys;
    public boolean useInputDevice;
    public boolean inputDeviceIsSetup;
    public ControllIO controlIO;
    public ControllDevice inputDevice;
    public ControllButton[] buttons;
    public ControllSlider[] sliders;
    public ControllButton[] fire_buttons;
    public ControllButton[] preciseAim_buttons;
    public ControllButton[] centerGun_buttons;
    public ControllButton[] autoOn_buttons;
    public ControllButton[] autoOff_buttons;
    public ControllButton[] inputToggle_buttons;
    public ControllButton[] randomSound_buttons;
    public ControllSlider[] pan_sliders;
    public ControllSlider[] tilt_sliders;
    public ControllSlider[] panInvert_sliders;
    public ControllSlider[] tiltInvert_sliders;
    public float xPosition;
    public float yPosition;
    String[] inStringSplit;
    int controlMode_i;
    int safety_i;
    int firingMode_i;
    int scanWhenIdle_i;
    int trackingMotion_i;
    int trackingColor_i;
    int leadTarget_i;
    int safeColor_i;
    int showRestrictedZones_i;
    int showDifferentPixels_i;
    int showTargetBox_i;
    int showCameraView_i;
    int mirrorCam_i;
    int soundEffects_i;
    boolean leadTarget;
    int nbDot;
    int antSens;
    float propX;
    float propY;
    int[] oldPossibleX;
    int[] oldPossibleY;
    int[] accX;
    int[] accY;
    int[] travelX;
    int[] travelY;
    float antX;
    float antY;
    int prevTargetX;
    int prevTargetY;
    public int controlPanelWindowX;
    public int controlPanelWindowY;
    GPanel panel_main;
    PImage panelBackgroundImg;
    GLabel label_serialOut;
    GLabel label_targetX;
    GLabel label_targetY;
    GLabel label_fire;
    GLabel label_fireSelector;
    GLabel label_scanSelector;
    GLabel label_runWithoutArduino;
    GLabel label_xMin;
    GLabel label_xMax;
    GLabel label_yMin;
    GLabel label_yMax;
    GLabel label_setxMin;
    GLabel label_setxMax;
    GLabel label_setyMin;
    GLabel label_setyMax;
    GCheckbox checkbox_leadTarget;
    GCheckbox checkbox_showRestrictedZones;
    GCheckbox checkbox_trackingColor;
    GCheckbox checkbox_safeColor;
    GCheckbox checkbox_trackingMotion;
    GCheckbox checkbox_showDifferentPixels;
    GCheckbox checkbox_showTargetBox;
    GCheckbox checkbox_mirrorCam;
    GCheckbox checkbox_controlMode;
    GCheckbox checkbox_safety;
    GCheckbox checkbox_showCameraView;
    GCheckbox checkbox_scanWhenIdle;
    GCheckbox checkbox_soundEffects;
    GCheckbox checkbox_activeSmoothing;
    GCheckbox checkbox_useInputDevice;
    GCheckbox checkbox_useArrowKeys;
    GButton button_viewCameraSettings;
    GButton button_setBackground;
    GButton button_selectColor;
    GButton button_selectSafeColor;
    GButton button_openWebsite;
    GButton button_playRandomSound;
    GButton button_saveSettings;
    GButton button_loadSettings;
    GButton button_retryArduinoConnect;
    GButton button_saveAndExit;
    GButton button_configJoystick;
    GButton button_resetCalibration;
    GButton button_flipX;
    GButton button_flipY;
    GWSlider slider_tolerance;
    GWSlider slider_trackColorTolerance;
    GWSlider slider_safeColorTolerance;
    GWSlider slider_safeColorMinSize;
    GWSlider slider_minBlobArea;
    GWSlider slider_nbDot;
    GWSlider slider_antSens;
    GWSlider slider_propX;
    GWSlider slider_propY;
    GWSlider slider_smoothingFactor;
    GLabel label_slider_tolerance;
    GLabel label_slider_trackColorTolerance;
    GLabel label_slider_safeColorTolerance;
    GLabel label_slider_safeColorMinSize;
    GLabel label_slider_minBlobArea;
    GLabel label_slider_nbDot;
    GLabel label_slider_antSens;
    GLabel label_slider_propX;
    GLabel label_slider_propY;
    GLabel label_smoothingFactor;
    GCombo dropdown_effect;
    GCombo dropdown_firingMode;
    GCombo dropdown_comPort;
    GOptionGroup opgMouseOver;
    GOption optHand;
    GOption optXhair;
    GOption optMove;
    GOption optText;
    GOption optWait;
    GWindow window_main;
    int sliderInertia;
    Minim minim;
    AudioSnippet s1;
    AudioSnippet s2;
    AudioSnippet s3;
    AudioSnippet s4;
    AudioSnippet s5;
    AudioSnippet s6;
    AudioSnippet s7;
    AudioSnippet s8;
    AudioSnippet s9;
    AudioSnippet s10;
    AudioSnippet s11;
    AudioSnippet s12;
    AudioSnippet s13;
    AudioSnippet s14;
    AudioSnippet s15;
    AudioSnippet s16;
    AudioSnippet s17;
    AudioSnippet s18;
    AudioSnippet s19;
    AudioSnippet s20;
    AudioSnippet s21;
    int soundTimer;
    int soundInterval;

    public PSG_Processing_Code() {
        int[] nArray = new int[3];
        nArray[0] = 255;
        nArray[1] = 255;
        this.diffPixelsColor = nArray;
        this.effect = 0;
        this.mirrorCam = false;
        this.xMin = 0.0f;
        this.xMax = 180.0f;
        this.yMin = 0.0f;
        this.yMax = 180.0f;
        this.minBlobArea = 30;
        this.tolerance = 100;
        this.runWithoutArduino = true;
        this.connecting = false;
        this.targetX = this.camWidth / 2;
        this.targetY = this.camHeight / 2;
        this.fire = 0;
        this.prevFire = new int[10];
        this.possibleX = this.camWidth / 2;
        this.possibleY = this.camHeight / 2;
        this.displayX = this.camWidth / 2;
        this.displayY = this.camHeight / 2;
        this.oldX = this.camWidth / 2;
        this.oldY = this.camHeight / 2;
        this.smoothingFactor = 0.8f;
        this.activeSmoothing = true;
        this.showDifferentPixels = false;
        this.showTargetBox = true;
        this.showCameraView = true;
        this.firingMode = true;
        this.safety = true;
        this.controlMode = false;
        this.soundEffects = false;
        this.scanWhenIdle = true;
        this.trackingMotion = true;
        this.idleTime = 10000;
        this.idleBeginTime = 0;
        this.scan = false;
        this.fireRestrictedZones = new int[30][4];
        this.restrictedZone = 1;
        this.showRestrictedZones = false;
        this.selectingColor = false;
        this.trackingColor = false;
        this.trackColorTolerance = 100;
        this.trackColorRed = 255;
        this.trackColorGreen = 255;
        this.trackColorBlue = 255;
        this.selectingSafeColor = false;
        this.safeColor = false;
        this.safeColorMinSize = 500;
        this.safeColorTolerance = 100;
        this.safeColorRed = 0;
        this.safeColorGreen = 255;
        this.safeColorBlue = 0;
        this.useArrowKeys = false;
        this.useInputDevice = false;
        this.inputDeviceIsSetup = false;
        this.buttons = new ControllButton[30];
        this.sliders = new ControllSlider[10];
        this.fire_buttons = new ControllButton[0];
        this.preciseAim_buttons = new ControllButton[0];
        this.centerGun_buttons = new ControllButton[0];
        this.autoOn_buttons = new ControllButton[0];
        this.autoOff_buttons = new ControllButton[0];
        this.inputToggle_buttons = new ControllButton[0];
        this.randomSound_buttons = new ControllButton[0];
        this.pan_sliders = new ControllSlider[0];
        this.tilt_sliders = new ControllSlider[0];
        this.panInvert_sliders = new ControllSlider[0];
        this.tiltInvert_sliders = new ControllSlider[0];
        this.xPosition = this.camWidth / 2;
        this.yPosition = this.camHeight / 2;
        this.leadTarget = true;
        this.nbDot = 10;
        this.antSens = 10;
        this.propX = 0.67f;
        this.propY = 0.11f;
        this.oldPossibleX = new int[this.nbDot + 1];
        this.oldPossibleY = new int[this.nbDot + 1];
        this.accX = new int[this.nbDot - 1];
        this.accY = new int[this.nbDot - 1];
        this.travelX = new int[this.nbDot - 1];
        this.travelY = new int[this.nbDot - 1];
        this.antX = 0.0f;
        this.antY = 0.0f;
        this.prevTargetX = this.targetX;
        this.prevTargetY = this.targetY;
        this.controlPanelWindowX = 50;
        this.controlPanelWindowY = 100;
        this.sliderInertia = 3;
        this.soundTimer = 0;
        this.soundInterval = 1000;
    }

    public void setup() {
        this.loadSettings();
        this.size(this.camWidth, this.camHeight);
        this.minim = new Minim((PApplet)this);
        this.loadSounds();
        this.playSound(18);
        this.camInput = new JMyron();
        this.camInput.start(this.camWidth, this.camHeight);
        this.camInput.findGlobs(0);
        this.camInput.adaptivity(1.01f);
        this.camInput.update();
        this.currFrame = this.camInput.image();
        this.rawImage = this.camInput.image();
        this.Background = this.camInput.image();
        this.rawBackground = this.camInput.image();
        this.screenPixels = this.camInput.image();
        this.target = new BlobDetection(this.camWidth, this.camHeight);
        this.target.setThreshold(0.9f);
        this.target.setPosDiscrimination(true);
        if (this.use_surf) {
            this.captureImage = new BufferedImage(this.camWidth, this.camHeight, 1);
            try {
                this.imageRef = ImageIO.read(new File(this.surfRefFile));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.mSurfRef = new Surf(this.imageRef);
        }
        this.retryArduinoConnect();
        this.xRatio = (float)this.camWidth / (this.xMax - this.xMin);
        this.yRatio = (float)this.camHeight / (this.yMax - this.yMin);
        this.drawControlPanel();
    }

    public void draw() {
        int n;
        if (this.PRINT_FRAMERATE) {
            PSG_Processing_Code.println((float)this.frameRate);
        }
        if (this.controlMode) {
            this.autonomousMode();
        } else if (!this.controlMode) {
            this.manualMode();
        }
        if (this.fire == 1) {
            this.idleBeginTime = this.millis();
            this.scan = false;
        } else {
            this.scan = this.millis() > this.idleBeginTime + this.idleTime && this.controlMode && this.scanWhenIdle;
        }
        if (!this.safety) {
            this.fire = 0;
        }
        this.strTargetx = "000" + PSG_Processing_Code.str((int)this.targetX);
        this.strTargetx = this.strTargetx.substring(this.strTargetx.length() - 3);
        this.strTargety = "000" + PSG_Processing_Code.str((int)this.targetY);
        this.strTargety = this.strTargety.substring(this.strTargety.length() - 3);
        this.fireSelector = PSG_Processing_Code.str((int)0);
        this.fireSelector = this.firingMode ? PSG_Processing_Code.str((int)1) : PSG_Processing_Code.str((int)3);
        this.scanSelector = this.scan ? PSG_Processing_Code.str((int)1) : PSG_Processing_Code.str((int)0);
        if (!this.runWithoutArduino && !this.connecting) {
            this.arduinoPort.write(String.valueOf('a') + this.strTargetx + this.strTargety + PSG_Processing_Code.str((int)this.fire) + this.fireSelector + this.scanSelector);
        }
        if (this.keyPressed && this.key == 't' || this.showRestrictedZones) {
            n = 0;
            while (n <= this.restrictedZone) {
                this.noStroke();
                this.fill(0.0f, 255.0f, 0.0f, 100.0f);
                this.rect(this.fireRestrictedZones[n][0], this.fireRestrictedZones[n][2], this.fireRestrictedZones[n][1] - this.fireRestrictedZones[n][0], this.fireRestrictedZones[n][3] - this.fireRestrictedZones[n][2]);
                ++n;
            }
        }
        if (this.selectingColor) {
            this.stroke(190.0f, 0.0f, 190.0f);
            this.strokeWeight(2.0f);
            this.fill(this.red(this.currFrame[this.mouseY * this.width + this.mouseX]), this.green(this.currFrame[this.mouseY * this.width + this.mouseX]), this.blue(this.currFrame[this.mouseY * this.width + this.mouseX]));
            this.rect(this.mouseX + 2, this.mouseY + 2, 30.0f, 30.0f);
        }
        if (this.selectingSafeColor) {
            this.stroke(0.0f, 255.0f, 0.0f);
            this.strokeWeight(2.0f);
            this.fill(this.red(this.currFrame[this.mouseY * this.width + this.mouseX]), this.green(this.currFrame[this.mouseY * this.width + this.mouseX]), this.blue(this.currFrame[this.mouseY * this.width + this.mouseX]));
            this.rect(this.mouseX + 2, this.mouseY + 2, 30.0f, 30.0f);
        }
        ++this.soundTimer;
        if (this.soundTimer == this.soundInterval) {
            this.randomIdleSound();
            this.soundTimer = 0;
        }
        n = 9;
        while (n >= 1) {
            this.prevFire[n] = this.prevFire[n - 1];
            --n;
        }
        this.prevFire[0] = this.fire;
        n = this.prevFire[0] + this.prevFire[1] + this.prevFire[2] + this.prevFire[3] + this.prevFire[4];
        int n2 = this.prevFire[5] + this.prevFire[6] + this.prevFire[7] + this.prevFire[8] + this.prevFire[9];
        if (n == 0 && n2 == 5) {
            int n3 = PApplet.parseInt((float)this.random(0.0f, 6.0f));
            if (n3 == 0) {
                this.playSound(1);
            }
            if (n3 == 1) {
                this.playSound(5);
            }
            if (n3 == 2) {
                this.playSound(9);
            }
            if (n3 == 3) {
                this.playSound(12);
            }
            if (n3 == 4) {
                this.playSound(13);
            }
            if (n3 == 5) {
                this.playSound(20);
            }
        }
        if (this.fire == 1) {
            this.strokeWeight(3.0f);
        }
        if (this.fire == 0) {
            this.strokeWeight(1.0f);
        }
        this.stroke(255.0f, 0.0f, 0.0f);
        this.noFill();
        this.line(this.displayX, 0.0f, this.displayX, this.camHeight);
        this.line(0.0f, this.displayY, this.camWidth, this.displayY);
        this.ellipse(this.displayX, this.displayY, 20.0f, 20.0f);
        this.ellipse(this.displayX, this.displayY, 28.0f, 22.0f);
        this.ellipse(this.displayX, this.displayY, 36.0f, 24.0f);
        this.updateControlPanels();
        this.prevTargetX = this.targetX;
        this.prevTargetY = this.targetY;
    }

    public void autonomousMode() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.inputDeviceIsSetup) {
            this.checkInputDevice();
        }
        if (this.selectingColor || this.selectingSafeColor) {
            this.cursor(1);
        } else {
            this.cursor(0);
        }
        this.camInput.update();
        this.rawBackground = this.camInput.retinaImage();
        this.rawImage = this.camInput.image();
        if (this.mirrorCam) {
            n5 = 0;
            while (n5 < this.camWidth * this.camHeight) {
                n4 = PSG_Processing_Code.floor((float)(n5 / this.camWidth));
                n3 = n5 - n4 * this.camWidth;
                n3 = this.camWidth - n3;
                this.currFrame[n5] = this.rawImage[n4 * this.camWidth + n3 - 1];
                this.Background[n5] = this.rawBackground[n4 * this.camWidth + n3 - 1];
                ++n5;
            }
        } else {
            this.currFrame = this.rawImage;
            this.Background = this.rawBackground;
        }
        this.loadPixels();
        n5 = 0;
        n4 = 0;
        while (n4 < this.camWidth * this.camHeight) {
            this.pixels[n4] = this.showCameraView ? this.currFrame[n4] : this.color(0, 0, 0);
            n3 = PSG_Processing_Code.abs((float)(this.red(this.currFrame[n4]) - this.red(this.Background[n4]))) + PSG_Processing_Code.abs((float)(this.green(this.currFrame[n4]) - this.green(this.Background[n4]))) + PSG_Processing_Code.abs((float)(this.blue(this.currFrame[n4]) - this.blue(this.Background[n4]))) > (float)(200 - this.tolerance) && this.trackingMotion ? 1 : 0;
            n2 = PSG_Processing_Code.abs((float)(this.red(this.currFrame[n4]) - (float)this.trackColorRed)) + PSG_Processing_Code.abs((float)(this.green(this.currFrame[n4]) - (float)this.trackColorGreen)) + PSG_Processing_Code.abs((float)(this.blue(this.currFrame[n4]) - (float)this.trackColorBlue)) < (float)this.trackColorTolerance && this.trackingColor ? 1 : 0;
            int n6 = n = PSG_Processing_Code.abs((float)(this.red(this.currFrame[n4]) - (float)this.safeColorRed)) + PSG_Processing_Code.abs((float)(this.green(this.currFrame[n4]) - (float)this.safeColorGreen)) + PSG_Processing_Code.abs((float)(this.blue(this.currFrame[n4]) - (float)this.safeColorBlue)) < (float)this.safeColorTolerance && this.safeColor ? 1 : 0;
            if (n3 != 0 || n2 != 0) {
                this.screenPixels[n4] = this.color(255, 255, 255);
                if (this.showDifferentPixels) {
                    if (this.effect == 0) {
                        this.pixels[n4] = this.color(this.diffPixelsColor[0], this.diffPixelsColor[1], this.diffPixelsColor[2]);
                    } else if (this.effect == 1) {
                        this.pixels[n4] = this.color(((float)this.diffPixelsColor[0] + this.red(this.currFrame[n4])) / 2.0f, ((float)this.diffPixelsColor[1] + this.green(this.currFrame[n4])) / 2.0f, ((float)this.diffPixelsColor[2] + this.blue(this.currFrame[n4])) / 2.0f);
                    } else if (this.effect == 2) {
                        this.pixels[n4] = this.color(255.0f - this.red(this.currFrame[n4]), 255.0f - this.green(this.currFrame[n4]), 255.0f - this.blue(this.currFrame[n4]));
                    } else if (this.effect == 3) {
                        this.pixels[n4] = this.color(((float)this.diffPixelsColor[0] + (255.0f - this.red(this.currFrame[n4]))) / 2.0f, ((float)this.diffPixelsColor[1] + (255.0f - this.green(this.currFrame[n4]))) / 2.0f, ((float)this.diffPixelsColor[2] + (255.0f - this.blue(this.currFrame[n4]))) / 2.0f);
                    }
                }
            } else {
                this.screenPixels[n4] = this.color(0, 0, 0);
            }
            if (n != 0) {
                ++n5;
                this.pixels[n4] = this.color(0, 255, 0);
                this.screenPixels[n4] = this.color(0, 0, 0);
            }
            ++n4;
        }
        this.updatePixels();
        n4 = 0;
        this.target.computeBlobs(this.screenPixels);
        n3 = 0;
        while (n3 < this.target.getBlobNb() - 1) {
            this.blob = this.target.getBlob(n3);
            n2 = PApplet.parseInt((float)(this.blob.w * (float)this.camWidth));
            if (n2 * (n = PApplet.parseInt((float)(this.blob.h * (float)this.camHeight))) >= n4) {
                this.biggestBlob = this.target.getBlob(n3);
                n4 = PApplet.parseInt((float)(this.biggestBlob.w * (float)this.camWidth)) * PApplet.parseInt((float)(this.biggestBlob.h * (float)this.camHeight));
            }
            ++n3;
        }
        this.possibleX = 0;
        this.possibleY = 0;
        if (n4 >= this.minBlobArea) {
            this.possibleX = PApplet.parseInt((float)(this.biggestBlob.x * (float)this.camWidth));
            this.possibleY = PApplet.parseInt((float)(this.biggestBlob.y * (float)this.camHeight));
        }
        if (n4 >= this.minBlobArea) {
            this.fire = 1;
            if (this.showTargetBox) {
                this.stroke(255.0f, 50.0f, 50.0f);
                this.strokeWeight(3.0f);
                this.fill(255.0f, 50.0f, 50.0f, 150.0f);
                this.rect(PApplet.parseInt((float)(this.biggestBlob.xMin * (float)this.camWidth)), PApplet.parseInt((float)(this.biggestBlob.yMin * (float)this.camHeight)), PApplet.parseInt((float)((this.biggestBlob.xMax - this.biggestBlob.xMin) * (float)this.camWidth)), PApplet.parseInt((float)((this.biggestBlob.yMax - this.biggestBlob.yMin) * (float)this.camHeight)));
            }
            this.anticipation();
            if (this.activeSmoothing) {
                this.xdiff = this.possibleX - this.oldX;
                this.ydiff = this.possibleY - this.oldY;
                this.possibleX = PApplet.parseInt((float)((float)this.oldX + (float)this.xdiff * (1.0f - this.smoothingFactor)));
                this.possibleY = PApplet.parseInt((float)((float)this.oldY + (float)this.ydiff * (1.0f - this.smoothingFactor)));
            }
            this.displayX = this.possibleX;
            this.displayY = this.possibleY;
            if (this.displayX < 0) {
                this.displayX = 0;
            }
            if (this.displayX > this.camWidth) {
                this.displayX = this.camWidth;
            }
            if (this.displayY < 0) {
                this.displayY = 0;
            }
            if (this.displayY > this.camHeight) {
                this.displayY = 0;
            }
            this.targetX = PApplet.parseInt((float)((float)this.possibleX / this.xRatio + this.xMin));
            this.targetY = PApplet.parseInt((float)((float)(this.camHeight - this.possibleY) / this.yRatio + this.yMin));
            this.oldX = this.possibleX;
            this.oldY = this.possibleY;
        } else {
            this.fire = 0;
        }
        n3 = 0;
        while (n3 <= this.restrictedZone) {
            if (this.possibleX > this.fireRestrictedZones[n3][0] && this.possibleX < this.fireRestrictedZones[n3][1] && this.possibleY > this.fireRestrictedZones[n3][2] && this.possibleY < this.fireRestrictedZones[n3][3]) {
                this.fire = 0;
            }
            ++n3;
        }
        if (n5 > this.safeColorMinSize && this.safeColor) {
            this.noStroke();
            this.fill(0.0f, 255.0f, 0.0f, 150.0f);
            this.rect(0.0f, 0.0f, this.width, this.height);
            this.fire = 0;
            this.targetX = PApplet.parseInt((float)((this.xMin + this.xMax) / 2.0f));
            this.targetY = PApplet.parseInt((float)this.yMin);
            this.displayX = this.camWidth / 2;
            this.displayY = this.camHeight;
        }
        if (this.use_surf) {
            this.captureImage.setRGB(0, 0, this.camWidth, this.camHeight, this.currFrame, 0, this.camWidth);
            this.mSurfCap = new Surf(this.captureImage);
            this.mBMatchingPoints = this.mSurfCap.getMatchingPoints(this.mSurfRef, true);
            System.out.println(this.mBMatchingPoints.size());
            if (this.mBMatchingPoints.size() >= this.surf_sensivity) {
                this.noStroke();
                this.fill(0.0f, 255.0f, 0.0f, 150.0f);
                this.rect(0.0f, 0.0f, this.width, this.height);
                this.fire = 0;
                this.targetX = PApplet.parseInt((float)((this.xMin + this.xMax) / 2.0f));
                this.targetY = PApplet.parseInt((float)this.yMin);
                this.displayX = this.camWidth / 2;
                this.displayY = this.camHeight;
            }
        }
    }

    public void manualMode() {
        int n;
        this.camInput.update();
        this.rawBackground = this.camInput.retinaImage();
        this.rawImage = this.camInput.image();
        if (this.mirrorCam) {
            n = 0;
            while (n < this.camWidth * this.camHeight) {
                int n2 = PSG_Processing_Code.floor((float)(n / this.camWidth));
                int n3 = n - n2 * this.camWidth;
                n3 = this.camWidth - n3;
                this.currFrame[n] = this.rawImage[n2 * this.camWidth + n3 - 1];
                this.Background[n] = this.rawBackground[n2 * this.camWidth + n3 - 1];
                ++n;
            }
        } else {
            this.currFrame = this.rawImage;
            this.Background = this.rawBackground;
        }
        this.loadPixels();
        n = 0;
        while (n < this.camWidth * this.camHeight) {
            this.pixels[n] = this.currFrame[n];
            ++n;
        }
        this.updatePixels();
        if (this.inputDeviceIsSetup) {
            this.checkInputDevice();
        }
        if (this.useInputDevice) {
            this.updateInputDevice();
            if (this.useArrowKeys && this.keyPressed) {
                if (this.keyCode == 37) {
                    this.xPosition -= 1.0f;
                }
                if (this.keyCode == 38) {
                    this.yPosition -= 1.0f;
                }
                if (this.keyCode == 39) {
                    this.xPosition += 1.0f;
                }
                if (this.keyCode == 40) {
                    this.yPosition += 1.0f;
                }
                this.fire = 0;
            }
        } else {
            if (this.useArrowKeys) {
                if (this.keyPressed) {
                    if (this.keyCode == 37) {
                        --this.displayX;
                    }
                    if (this.keyCode == 38) {
                        --this.displayY;
                    }
                    if (this.keyCode == 39) {
                        ++this.displayX;
                    }
                    if (this.keyCode == 40) {
                        ++this.displayY;
                    }
                    this.fire = 0;
                }
            } else {
                this.displayX = this.mouseX;
                this.displayY = this.mouseY;
                this.fire = this.mousePressed ? 1 : 0;
            }
            this.targetX = PSG_Processing_Code.constrain((int)PApplet.parseInt((float)((float)this.displayX / this.xRatio + this.xMin)), (int)0, (int)180);
            this.targetY = PSG_Processing_Code.constrain((int)PApplet.parseInt((float)((float)(this.camHeight - this.displayY) / this.yRatio + this.yMin)), (int)0, (int)180);
        }
    }

    public void mousePressed() {
        if (this.keyPressed && this.key == 'r') {
            PSG_Processing_Code.print((String)("constraints:" + this.mouseX + ", " + this.mouseY));
            this.fireRestrictedZones[this.restrictedZone][0] = this.mouseX;
            this.fireRestrictedZones[this.restrictedZone][2] = this.mouseY;
        }
        if (this.selectingColor) {
            this.trackColorRed = PApplet.parseInt((float)this.red(this.currFrame[this.mouseY * this.width + this.mouseX]));
            this.trackColorBlue = PApplet.parseInt((float)this.blue(this.currFrame[this.mouseY * this.width + this.mouseX]));
            this.trackColorGreen = PApplet.parseInt((float)this.green(this.currFrame[this.mouseY * this.width + this.mouseX]));
            this.selectingColor = false;
        }
        if (this.selectingSafeColor) {
            this.safeColorRed = PApplet.parseInt((float)this.red(this.currFrame[this.mouseY * this.width + this.mouseX]));
            this.safeColorBlue = PApplet.parseInt((float)this.blue(this.currFrame[this.mouseY * this.width + this.mouseX]));
            this.safeColorGreen = PApplet.parseInt((float)this.green(this.currFrame[this.mouseY * this.width + this.mouseX]));
            this.selectingSafeColor = false;
        }
    }

    public void mouseReleased() {
        if (this.keyPressed && this.key == 'r') {
            PSG_Processing_Code.println((String)(" ... " + this.mouseX + ", " + this.mouseY));
            this.fireRestrictedZones[this.restrictedZone][1] = this.mouseX;
            this.fireRestrictedZones[this.restrictedZone][3] = this.mouseY;
            if (this.fireRestrictedZones[this.restrictedZone][1] > this.fireRestrictedZones[this.restrictedZone][0] && this.fireRestrictedZones[this.restrictedZone][1] > this.fireRestrictedZones[this.restrictedZone][2]) {
                ++this.restrictedZone;
            }
        }
    }

    public void keyReleased() {
        if (this.key == 'p') {
            this.randomIdleSound();
        }
        if (this.key == ' ') {
            boolean bl = this.controlMode = !this.controlMode;
        }
        if (this.key == 'b') {
            this.camInput.adapt();
            this.playSound(15);
        }
        if (this.key == 'a') {
            this.xMin = PApplet.parseFloat((int)this.targetX);
            this.xRatio = (float)this.camWidth / (this.xMax - this.xMin);
        }
        if (this.key == 'd') {
            this.xMax = PApplet.parseFloat((int)this.targetX);
            this.xRatio = (float)this.camWidth / (this.xMax - this.xMin);
        }
        if (this.key == 's') {
            this.yMin = PApplet.parseFloat((int)this.targetY);
            this.yRatio = (float)this.camHeight / (this.yMax - this.yMin);
        }
        if (this.key == 'w') {
            this.yMax = PApplet.parseFloat((int)this.targetY);
            this.yRatio = (float)this.camHeight / (this.yMax - this.yMin);
        }
        if (this.key == '\uffff' && this.keyCode == 16) {
            this.useArrowKeys = !this.useArrowKeys;
        }
    }

    public void viewCameraSettings() {
        this.camInput.settings();
        this.playSound(21);
    }

    public void openWebsite() {
        this.link("http://psg.rudolphlabs.com/");
        this.playSound(15);
    }

    public void setBackground() {
        this.camInput.adapt();
        this.playSound(11);
    }

    public void playRandomSound() {
        this.randomIdleSound();
    }

    public void selectColor() {
        this.selectingColor = true;
    }

    public void selectSafeColor() {
        this.selectingSafeColor = true;
    }

    public void radioEffect(int n) {
        this.effect = n + 1;
    }

    public void stop() {
        if (this.soundEffects) {
            this.s1.rewind();
            this.s1.play();
            this.delay(2500);
            this.s1.close();
            this.s2.close();
            this.s3.close();
            this.s4.close();
            this.s5.close();
            this.s7.close();
            this.s6.close();
            this.s8.close();
            this.s9.close();
            this.s10.close();
            this.s11.close();
            this.s12.close();
            this.s13.close();
            this.s14.close();
            this.s15.close();
            this.s16.close();
            this.s17.close();
            this.s18.close();
            this.s19.close();
            this.s20.close();
            this.s21.close();
            this.minim.stop();
        }
        if (!this.runWithoutArduino) {
            this.arduinoPort.write("z0000000");
            this.delay(500);
            this.arduinoPort.stop();
        }
        this.camInput.stop();
        super.stop();
    }

    public void anticipation() {
        if (this.leadTarget) {
            if (this.oldPossibleX.length != this.nbDot + 1) {
                this.oldPossibleX = PSG_Processing_Code.expand((int[])this.oldPossibleX, (int)(this.nbDot + 1));
            }
            if (this.oldPossibleY.length != this.nbDot + 1) {
                this.oldPossibleY = PSG_Processing_Code.expand((int[])this.oldPossibleY, (int)(this.nbDot + 1));
            }
            if (this.accX.length != this.nbDot - 1) {
                this.accX = PSG_Processing_Code.expand((int[])this.accX, (int)(this.nbDot - 1));
            }
            if (this.accY.length != this.nbDot - 1) {
                this.accY = PSG_Processing_Code.expand((int[])this.accY, (int)(this.nbDot - 1));
            }
            if (this.travelX.length != this.nbDot - 1) {
                this.travelX = PSG_Processing_Code.expand((int[])this.travelX, (int)(this.nbDot - 1));
            }
            if (this.travelY.length != this.nbDot - 1) {
                this.travelY = PSG_Processing_Code.expand((int[])this.travelY, (int)(this.nbDot - 1));
            }
            this.oldPossibleX[0] = this.possibleX;
            this.oldPossibleY[0] = this.possibleY;
            int n = 0;
            while (n <= this.nbDot - 2) {
                if (PSG_Processing_Code.abs((int)(this.oldPossibleX[n] - this.oldPossibleX[n + 1])) < this.camWidth / this.antSens && PSG_Processing_Code.abs((int)(this.oldPossibleX[n + 1] - this.oldPossibleX[n + 2])) < this.camWidth / this.antSens) {
                    this.accX[n] = this.oldPossibleX[n] - this.oldPossibleX[n + 1] - (this.oldPossibleX[n + 1] - this.oldPossibleX[n + 2]);
                }
                if (PSG_Processing_Code.abs((int)(this.oldPossibleY[n] - this.oldPossibleY[n + 1])) < this.camHeight / this.antSens && PSG_Processing_Code.abs((int)(this.oldPossibleY[n + 1] - this.oldPossibleY[n + 2])) < this.camHeight / this.antSens) {
                    this.accY[n] = this.oldPossibleY[n] - this.oldPossibleY[n + 1] - (this.oldPossibleY[n + 1] - this.oldPossibleY[n + 2]);
                }
                ++n;
            }
            n = 0;
            while (n <= this.nbDot - 2) {
                this.travelX[n] = PSG_Processing_Code.abs((int)(this.oldPossibleX[n] - this.oldPossibleX[n + 1])) < this.camWidth / this.antSens ? this.oldPossibleX[n] - this.oldPossibleX[n + 1] : 0;
                this.travelY[n] = PSG_Processing_Code.abs((int)(this.oldPossibleY[n] - this.oldPossibleY[n + 1])) < this.camHeight / this.antSens ? this.oldPossibleY[n] - this.oldPossibleY[n + 1] : 0;
                ++n;
            }
            this.antX = 0.0f;
            this.antY = 0.0f;
            n = 0;
            while (n <= this.nbDot - 2) {
                this.antX = this.antX + (float)this.travelX[n] + (float)this.accX[n];
                this.antY = this.antY + (float)this.travelY[n] + (float)this.accY[n];
                ++n;
            }
            this.antX *= this.propX;
            this.antY *= this.propY;
            n = this.nbDot;
            while (n >= 1) {
                this.oldPossibleX[n] = this.oldPossibleX[n - 1];
                this.oldPossibleY[n] = this.oldPossibleY[n - 1];
                --n;
            }
            this.possibleX = PApplet.parseInt((float)((float)this.possibleX + this.antX));
            this.possibleY = PApplet.parseInt((float)((float)this.possibleY + this.antY));
        }
    }

    public void drawControlPanel() {
        G4P.setColorScheme((PApplet)this, (int)6);
        G4P.messagesEnabled((boolean)false);
        this.panel_main = new GPanel((PApplet)this, "Main", 0, 0, 600, 600);
        this.panel_main.setOpaque(false);
        this.panel_main.setCollapsed(false);
        this.label_serialOut = new GLabel((PApplet)this, "Serial Out:           ", 300, 475, 150, 20);
        this.label_serialOut.setBorder(0);
        this.label_serialOut.setOpaque(false);
        this.label_serialOut.setColorScheme(6);
        this.panel_main.add((GComponent)this.label_serialOut);
        this.label_targetX = new GLabel((PApplet)this, "Pan Servo Position:    ", 300, 495, 150, 20);
        this.label_targetX.setBorder(0);
        this.label_targetX.setOpaque(false);
        this.label_targetX.setColorScheme(6);
        this.panel_main.add((GComponent)this.label_targetX);
        this.label_targetY = new GLabel((PApplet)this, "Tilt Servo Position:    ", 300, 515, 150, 20);
        this.label_targetY.setBorder(0);
        this.label_targetY.setOpaque(false);
        this.label_targetY.setColorScheme(6);
        this.panel_main.add((GComponent)this.label_targetY);
        this.label_fire = new GLabel((PApplet)this, "Not Firing", 300, 535, 150, 20);
        this.label_fire.setBorder(0);
        this.label_fire.setOpaque(false);
        this.label_fire.setColorScheme(2);
        this.panel_main.add((GComponent)this.label_fire);
        this.label_fireSelector = new GLabel((PApplet)this, "Automatic", 300, 555, 150, 20);
        this.label_fireSelector.setBorder(0);
        this.label_fireSelector.setOpaque(false);
        this.label_fireSelector.setColorScheme(6);
        this.panel_main.add((GComponent)this.label_fireSelector);
        this.label_scanSelector = new GLabel((PApplet)this, "Scan When Idle", 300, 575, 150, 20);
        this.label_scanSelector.setBorder(0);
        this.label_scanSelector.setOpaque(false);
        this.label_scanSelector.setColorScheme(6);
        this.panel_main.add((GComponent)this.label_scanSelector);
        this.label_runWithoutArduino = new GLabel((PApplet)this, "No Controller", 460, 475, 120, 20);
        this.label_runWithoutArduino.setBorder(0);
        this.label_runWithoutArduino.setOpaque(false);
        this.label_runWithoutArduino.setColorScheme(4);
        this.panel_main.add((GComponent)this.label_runWithoutArduino);
        this.label_xMin = new GLabel((PApplet)this, "xMin: 000", 35, 362, 150, 20);
        this.label_xMin.setBorder(0);
        this.label_xMin.setOpaque(false);
        this.label_xMin.setColorScheme(4);
        this.panel_main.add((GComponent)this.label_xMin);
        this.label_xMax = new GLabel((PApplet)this, "xMax: 180", 145, 362, 150, 20);
        this.label_xMax.setBorder(0);
        this.label_xMax.setOpaque(false);
        this.label_xMax.setColorScheme(4);
        this.panel_main.add((GComponent)this.label_xMax);
        this.label_yMin = new GLabel((PApplet)this, "yMin: 000", 35, 392, 150, 20);
        this.label_yMin.setBorder(0);
        this.label_yMin.setOpaque(false);
        this.label_yMin.setColorScheme(4);
        this.panel_main.add((GComponent)this.label_yMin);
        this.label_yMax = new GLabel((PApplet)this, "yMax: 180", 145, 392, 150, 20);
        this.label_yMax.setBorder(0);
        this.label_yMax.setOpaque(false);
        this.label_yMax.setColorScheme(4);
        this.panel_main.add((GComponent)this.label_yMax);
        this.label_setxMin = new GLabel((PApplet)this, "to set xMin press A", 10, 375, 120, 10);
        this.panel_main.add((GComponent)this.label_setxMin);
        this.label_setxMax = new GLabel((PApplet)this, "to set xMax press D", 120, 375, 120, 10);
        this.panel_main.add((GComponent)this.label_setxMax);
        this.label_setyMin = new GLabel((PApplet)this, "to set yMin press S", 10, 405, 120, 10);
        this.panel_main.add((GComponent)this.label_setyMin);
        this.label_setyMax = new GLabel((PApplet)this, "to set yMax press W", 120, 405, 120, 10);
        this.panel_main.add((GComponent)this.label_setyMax);
        this.checkbox_leadTarget = new GCheckbox((PApplet)this, "Enable Target Anticipation", 310, 325, 10);
        this.checkbox_leadTarget.setSelected(this.leadTarget);
        this.checkbox_leadTarget.setBorder(0);
        this.panel_main.add((GComponent)this.checkbox_leadTarget);
        this.checkbox_showRestrictedZones = new GCheckbox((PApplet)this, "Show Restricted Zones  (to set, hold R and click+drag)", 10, 480, 10);
        this.checkbox_showRestrictedZones.setSelected(this.showRestrictedZones);
        this.checkbox_showRestrictedZones.setBorder(0);
        this.panel_main.add((GComponent)this.checkbox_showRestrictedZones);
        this.checkbox_trackingColor = new GCheckbox((PApplet)this, "Track A Color", 10, 255, 10);
        this.checkbox_trackingColor.setSelected(this.trackingColor);
        this.checkbox_trackingColor.setBorder(0);
        this.panel_main.add((GComponent)this.checkbox_trackingColor);
        this.checkbox_safeColor = new GCheckbox((PApplet)this, "Enable Safe Color", 310, 175, 10);
        this.checkbox_safeColor.setSelected(this.safeColor);
        this.checkbox_safeColor.setBorder(0);
        this.panel_main.add((GComponent)this.checkbox_safeColor);
        this.checkbox_trackingMotion = new GCheckbox((PApplet)this, "Track Motion", 10, 205, 10);
        this.checkbox_trackingMotion.setSelected(this.trackingMotion);
        this.checkbox_trackingMotion.setBorder(0);
        this.panel_main.add((GComponent)this.checkbox_trackingMotion);
        this.checkbox_showDifferentPixels = new GCheckbox((PApplet)this, "Show Different Pixels", 10, 500, 10);
        this.checkbox_showDifferentPixels.setSelected(this.showDifferentPixels);
        this.checkbox_showDifferentPixels.setBorder(0);
        this.panel_main.add((GComponent)this.checkbox_showDifferentPixels);
        this.checkbox_showTargetBox = new GCheckbox((PApplet)this, "Show Target Box", 10, 520, 10);
        this.checkbox_showTargetBox.setSelected(this.showTargetBox);
        this.checkbox_showTargetBox.setBorder(0);
        this.panel_main.add((GComponent)this.checkbox_showTargetBox);
        this.checkbox_mirrorCam = new GCheckbox((PApplet)this, "Mirror Webcam", 10, 540, 10);
        this.checkbox_mirrorCam.setSelected(this.mirrorCam);
        this.checkbox_mirrorCam.setBorder(0);
        this.panel_main.add((GComponent)this.checkbox_mirrorCam);
        this.checkbox_controlMode = new GCheckbox((PApplet)this, "Enable Autonomous Mode (press SPACE to toggle)", 10, 25, 10);
        this.checkbox_controlMode.setSelected(this.controlMode);
        this.checkbox_controlMode.setBorder(0);
        this.panel_main.add((GComponent)this.checkbox_controlMode);
        this.checkbox_safety = new GCheckbox((PApplet)this, "Enable Weapon", 10, 325, 10);
        this.checkbox_safety.setSelected(this.safety);
        this.checkbox_safety.setBorder(0);
        this.panel_main.add((GComponent)this.checkbox_safety);
        this.checkbox_showCameraView = new GCheckbox((PApplet)this, "Show Camera View", 10, 560, 10);
        this.checkbox_showCameraView.setSelected(this.showCameraView);
        this.checkbox_showCameraView.setBorder(0);
        this.panel_main.add((GComponent)this.checkbox_showCameraView);
        this.checkbox_scanWhenIdle = new GCheckbox((PApplet)this, "Scan When Idle", 10, 345, 10);
        this.checkbox_scanWhenIdle.setSelected(this.scanWhenIdle);
        this.checkbox_scanWhenIdle.setBorder(0);
        this.panel_main.add((GComponent)this.checkbox_scanWhenIdle);
        this.checkbox_soundEffects = new GCheckbox((PApplet)this, "Enable Sounds Effects", 315, 25, 10);
        this.checkbox_soundEffects.setSelected(this.soundEffects);
        this.checkbox_soundEffects.setBorder(0);
        this.panel_main.add((GComponent)this.checkbox_soundEffects);
        this.checkbox_activeSmoothing = new GCheckbox((PApplet)this, "Smoothing", 460, 25, 10);
        this.checkbox_activeSmoothing.setSelected(this.activeSmoothing);
        this.checkbox_activeSmoothing.setBorder(0);
        this.panel_main.add((GComponent)this.checkbox_activeSmoothing);
        this.checkbox_useInputDevice = new GCheckbox((PApplet)this, "Use Joystick/Game Controller Input", 10, 45, 10);
        this.checkbox_useInputDevice.setSelected(this.useInputDevice);
        this.checkbox_useInputDevice.setBorder(0);
        this.panel_main.add((GComponent)this.checkbox_useInputDevice);
        this.checkbox_useArrowKeys = new GCheckbox((PApplet)this, "Use Arrow Keys to Fine Adjust (press SHIFT to toggle)", 10, 65, 10);
        this.checkbox_useArrowKeys.setSelected(this.useArrowKeys);
        this.checkbox_useArrowKeys.setBorder(0);
        this.panel_main.add((GComponent)this.checkbox_useArrowKeys);
        this.button_viewCameraSettings = new GButton((PApplet)this, "Webcam Settings", 460, 75, 120, 10);
        this.panel_main.add((GComponent)this.button_viewCameraSettings);
        this.button_setBackground = new GButton((PApplet)this, "Save Current Image as Background", 110, 205, 185, 10);
        this.panel_main.add((GComponent)this.button_setBackground);
        this.button_selectColor = new GButton((PApplet)this, "Select Color to Track", 110, 255, 185, 10);
        this.panel_main.add((GComponent)this.button_selectColor);
        this.button_selectSafeColor = new GButton((PApplet)this, "Select Safe Color  ", 310, 200, 20, 10);
        this.panel_main.add((GComponent)this.button_selectSafeColor);
        this.button_openWebsite = new GButton((PApplet)this, "", "Sentry_Logo_Tiny.png", 1, 545, 560, 36, 24);
        this.panel_main.add((GComponent)this.button_openWebsite);
        this.button_playRandomSound = new GButton((PApplet)this, "Play a Random Sound", 320, 75, 120, 10);
        this.panel_main.add((GComponent)this.button_playRandomSound);
        this.button_saveSettings = new GButton((PApplet)this, "Save Settings", 320, 110, 120, 10);
        this.panel_main.add((GComponent)this.button_saveSettings);
        this.button_loadSettings = new GButton((PApplet)this, "Re-Load Settings", 460, 110, 120, 10);
        this.panel_main.add((GComponent)this.button_loadSettings);
        this.button_saveAndExit = new GButton((PApplet)this, "Save Settings & Exit", 10, 95, 280, 40);
        this.panel_main.add((GComponent)this.button_saveAndExit);
        this.button_retryArduinoConnect = new GButton((PApplet)this, "Retry/Connect", 460, 500, 120, 10);
        this.panel_main.add((GComponent)this.button_retryArduinoConnect);
        this.button_configJoystick = new GButton((PApplet)this, "Configure", 200, 45, 70, 10);
        this.panel_main.add((GComponent)this.button_configJoystick);
        this.button_resetCalibration = new GButton((PApplet)this, "Reset Calibration", 10, 425, 220, 10);
        this.panel_main.add((GComponent)this.button_resetCalibration);
        this.button_flipX = new GButton((PApplet)this, "Flip X", 240, 370, 40, 10);
        this.panel_main.add((GComponent)this.button_flipX);
        this.button_flipY = new GButton((PApplet)this, "Flip Y", 240, 400, 40, 10);
        this.panel_main.add((GComponent)this.button_flipY);
        this.slider_tolerance = new GWSlider((PApplet)this, 10, 225, 200);
        this.slider_tolerance.setLimits(this.tolerance, 0, 200);
        this.slider_tolerance.setRenderMaxMinLabel(false);
        this.slider_tolerance.setRenderValueLabel(false);
        this.slider_tolerance.setTickCount(10);
        this.slider_tolerance.setInertia(this.sliderInertia);
        this.panel_main.add((GComponent)this.slider_tolerance);
        this.label_slider_tolerance = new GLabel((PApplet)this, "Tolerance: ", 210, 225, 150, 20);
        this.label_slider_tolerance.setBorder(0);
        this.label_slider_tolerance.setOpaque(false);
        this.label_slider_tolerance.setColorScheme(4);
        this.panel_main.add((GComponent)this.label_slider_tolerance);
        this.slider_trackColorTolerance = new GWSlider((PApplet)this, 10, 275, 200);
        this.slider_trackColorTolerance.setLimits(this.trackColorTolerance, 0, 300);
        this.slider_trackColorTolerance.setRenderMaxMinLabel(false);
        this.slider_trackColorTolerance.setRenderValueLabel(false);
        this.slider_trackColorTolerance.setTickCount(12);
        this.slider_trackColorTolerance.setInertia(this.sliderInertia);
        this.panel_main.add((GComponent)this.slider_trackColorTolerance);
        this.label_slider_trackColorTolerance = new GLabel((PApplet)this, "Tolerance: ", 210, 275, 150, 20);
        this.label_slider_trackColorTolerance.setBorder(0);
        this.label_slider_trackColorTolerance.setOpaque(false);
        this.label_slider_trackColorTolerance.setColorScheme(4);
        this.panel_main.add((GComponent)this.label_slider_trackColorTolerance);
        this.slider_safeColorTolerance = new GWSlider((PApplet)this, 310, 230, 200);
        this.slider_safeColorTolerance.setLimits(this.safeColorTolerance, 0, 300);
        this.slider_safeColorTolerance.setRenderMaxMinLabel(false);
        this.slider_safeColorTolerance.setRenderValueLabel(false);
        this.slider_safeColorTolerance.setTickCount(12);
        this.slider_safeColorTolerance.setInertia(this.sliderInertia);
        this.panel_main.add((GComponent)this.slider_safeColorTolerance);
        this.label_slider_safeColorTolerance = new GLabel((PApplet)this, "Tolerance: ", 510, 230, 150, 20);
        this.label_slider_safeColorTolerance.setBorder(0);
        this.label_slider_safeColorTolerance.setOpaque(false);
        this.label_slider_safeColorTolerance.setColorScheme(4);
        this.panel_main.add((GComponent)this.label_slider_safeColorTolerance);
        this.slider_safeColorMinSize = new GWSlider((PApplet)this, 310, 260, 200);
        this.slider_safeColorMinSize.setLimits(this.safeColorMinSize, 0, 5000);
        this.slider_safeColorMinSize.setRenderMaxMinLabel(false);
        this.slider_safeColorMinSize.setRenderValueLabel(false);
        this.slider_safeColorMinSize.setTickCount(10);
        this.slider_safeColorMinSize.setInertia(this.sliderInertia);
        this.panel_main.add((GComponent)this.slider_safeColorMinSize);
        this.label_slider_safeColorMinSize = new GLabel((PApplet)this, "Min Area: ", 510, 260, 150, 20);
        this.label_slider_safeColorMinSize.setBorder(0);
        this.label_slider_safeColorMinSize.setOpaque(false);
        this.label_slider_safeColorMinSize.setColorScheme(4);
        this.panel_main.add((GComponent)this.label_slider_safeColorMinSize);
        this.slider_minBlobArea = new GWSlider((PApplet)this, 10, 175, 200);
        this.slider_minBlobArea.setLimits(this.minBlobArea, 0, 10000);
        this.slider_minBlobArea.setRenderMaxMinLabel(false);
        this.slider_minBlobArea.setRenderValueLabel(false);
        this.slider_minBlobArea.setTickCount(10);
        this.slider_minBlobArea.setInertia(this.sliderInertia);
        this.panel_main.add((GComponent)this.slider_minBlobArea);
        this.label_slider_minBlobArea = new GLabel((PApplet)this, "Min Size: ", 210, 175, 150, 20);
        this.label_slider_minBlobArea.setBorder(0);
        this.label_slider_minBlobArea.setOpaque(false);
        this.label_slider_minBlobArea.setColorScheme(4);
        this.panel_main.add((GComponent)this.label_slider_minBlobArea);
        this.slider_nbDot = new GWSlider((PApplet)this, 310, 350, 200);
        this.slider_nbDot.setLimits(this.nbDot, 2, 22);
        this.slider_nbDot.setRenderMaxMinLabel(false);
        this.slider_nbDot.setRenderValueLabel(false);
        this.slider_nbDot.setTickCount(10);
        this.slider_nbDot.setInertia(this.sliderInertia);
        this.panel_main.add((GComponent)this.slider_nbDot);
        this.label_slider_nbDot = new GLabel((PApplet)this, "Memory: ", 510, 350, 150, 20);
        this.label_slider_nbDot.setBorder(0);
        this.label_slider_nbDot.setOpaque(false);
        this.label_slider_nbDot.setColorScheme(4);
        this.panel_main.add((GComponent)this.label_slider_nbDot);
        this.slider_antSens = new GWSlider((PApplet)this, 310, 375, 200);
        this.slider_antSens.setLimits(this.antSens, 1, 100);
        this.slider_antSens.setRenderMaxMinLabel(false);
        this.slider_antSens.setRenderValueLabel(false);
        this.slider_antSens.setTickCount(10);
        this.slider_antSens.setInertia(this.sliderInertia);
        this.panel_main.add((GComponent)this.slider_antSens);
        this.label_slider_antSens = new GLabel((PApplet)this, "Sensitivity: ", 510, 375, 150, 20);
        this.label_slider_antSens.setBorder(0);
        this.label_slider_antSens.setOpaque(false);
        this.label_slider_antSens.setColorScheme(4);
        this.panel_main.add((GComponent)this.label_slider_antSens);
        this.slider_propX = new GWSlider((PApplet)this, 310, 400, 120);
        this.slider_propX.setLimits(this.propX, 0.0f, 3.0f);
        this.slider_propX.setValueType(1);
        this.slider_propX.setRenderMaxMinLabel(false);
        this.slider_propX.setRenderValueLabel(false);
        this.slider_propX.setTickCount(7);
        this.slider_propX.setInertia(this.sliderInertia);
        this.panel_main.add((GComponent)this.slider_propX);
        this.label_slider_propX = new GLabel((PApplet)this, "X Degree of Anticipation: ", 430, 400, 300, 20);
        this.label_slider_propX.setBorder(0);
        this.label_slider_propX.setOpaque(false);
        this.label_slider_propX.setColorScheme(4);
        this.panel_main.add((GComponent)this.label_slider_propX);
        this.slider_propY = new GWSlider((PApplet)this, 310, 425, 120);
        this.slider_propY.setLimits(this.propY, 0.0f, 3.0f);
        this.slider_propY.setValueType(1);
        this.slider_propY.setRenderMaxMinLabel(false);
        this.slider_propY.setRenderValueLabel(false);
        this.slider_propY.setTickCount(7);
        this.slider_propY.setInertia(this.sliderInertia);
        this.panel_main.add((GComponent)this.slider_propY);
        this.label_slider_propY = new GLabel((PApplet)this, "Y Degree of Anticipation: ", 430, 425, 300, 20);
        this.label_slider_propY.setBorder(0);
        this.label_slider_propY.setOpaque(false);
        this.label_slider_propY.setColorScheme(4);
        this.panel_main.add((GComponent)this.label_slider_propY);
        this.slider_smoothingFactor = new GWSlider((PApplet)this, 310, 50, 180);
        this.slider_smoothingFactor.setLimits(this.smoothingFactor, 0.0f, 1.0f);
        this.slider_smoothingFactor.setValueType(1);
        this.slider_smoothingFactor.setRenderMaxMinLabel(false);
        this.slider_smoothingFactor.setRenderValueLabel(false);
        this.slider_smoothingFactor.setTickCount(10);
        this.slider_smoothingFactor.setInertia(this.sliderInertia);
        this.panel_main.add((GComponent)this.slider_smoothingFactor);
        this.label_smoothingFactor = new GLabel((PApplet)this, "Smoothing Factor", 490, 50, 100, 20);
        this.label_smoothingFactor.setBorder(0);
        this.label_smoothingFactor.setOpaque(false);
        this.label_smoothingFactor.setColorScheme(4);
        this.panel_main.add((GComponent)this.label_smoothingFactor);
        String[] stringArray = new String[]{"Opaque", "Transparent", "Negative", "Negative & Transparent"};
        this.dropdown_effect = new GCombo((PApplet)this, stringArray, stringArray.length, 140, 500, 140);
        this.dropdown_effect.setSelected(this.effect);
        this.panel_main.add((GComponent)this.dropdown_effect);
        String[] stringArray2 = new String[]{"Automatic", "Semi-Auto"};
        this.dropdown_firingMode = new GCombo((PApplet)this, stringArray2, stringArray2.length, 140, 320, 100);
        this.dropdown_firingMode.setSelected(PApplet.parseInt((boolean)this.firingMode));
        this.panel_main.add((GComponent)this.dropdown_firingMode);
        if (Serial.list().length > 0) {
            String[] stringArray3 = PSG_Processing_Code.append((String[])Serial.list(), (String)"Select to Override");
            this.dropdown_comPort = new GCombo((PApplet)this, stringArray3, stringArray3.length, 460, 520, 120);
            this.dropdown_comPort.setSelected(stringArray3.length - 1);
            this.panel_main.add((GComponent)this.dropdown_comPort);
        }
        G4P.setMouseOverEnabled((boolean)true);
        this.panelBackgroundImg = this.loadImage("Panel_Background.png");
        this.window_main = new GWindow((PApplet)this, "Control Panel", this.controlPanelWindowX, this.controlPanelWindowY, this.panelBackgroundImg, true, null);
        this.window_main.setOnTop(false);
        this.window_main.add((GComponent)this.panel_main);
        this.window_main.addDrawHandler((Object)this, "drawController");
        this.panel_main.setXY(0, 0);
    }

    public void updateControlPanels() {
        this.setLabelText(this.label_serialOut, "Serial Out: a" + this.strTargetx + this.strTargety + PSG_Processing_Code.str((int)this.fire) + this.fireSelector + this.scanSelector);
        this.setLabelText(this.label_targetX, "Pan Servo Position: " + this.strTargetx);
        this.setLabelText(this.label_slider_tolerance, "Tolerance: " + PSG_Processing_Code.str((int)this.tolerance));
        this.setLabelText(this.label_slider_trackColorTolerance, "Tolerance: " + PSG_Processing_Code.str((int)this.trackColorTolerance));
        this.setLabelText(this.label_slider_safeColorTolerance, "Tolerance: " + PSG_Processing_Code.str((int)this.safeColorTolerance));
        this.setLabelText(this.label_slider_safeColorMinSize, "Min Area: " + PSG_Processing_Code.str((int)this.safeColorMinSize));
        this.setLabelText(this.label_slider_minBlobArea, "Min Size: " + PSG_Processing_Code.str((int)this.minBlobArea));
        this.setLabelText(this.label_slider_nbDot, "Memory: " + PSG_Processing_Code.str((int)this.nbDot));
        this.setLabelText(this.label_slider_antSens, "Sensitivity: " + PSG_Processing_Code.str((int)this.antSens));
        this.setLabelText(this.label_slider_propX, "X Degree of Anitcipation: " + PSG_Processing_Code.str((float)this.propX));
        this.setLabelText(this.label_slider_propY, "Y Degree of Anitcipation: " + PSG_Processing_Code.str((float)this.propY));
        this.setLabelText(this.label_xMin, "xMin: " + PSG_Processing_Code.str((float)this.xMin));
        this.setLabelText(this.label_xMax, "xMax: " + PSG_Processing_Code.str((float)this.xMax));
        this.setLabelText(this.label_yMin, "yMin: " + PSG_Processing_Code.str((float)this.yMin));
        this.setLabelText(this.label_yMax, "yMax: " + PSG_Processing_Code.str((float)this.yMax));
        if (this.prevTargetX != this.targetX) {
            this.label_targetX.setOpaque(true);
        } else {
            this.label_targetX.setOpaque(false);
        }
        if (this.prevTargetY != this.targetY) {
            this.label_targetY.setOpaque(true);
        } else {
            this.label_targetY.setOpaque(false);
        }
        this.setLabelText(this.label_targetY, "Tilt Servo Position: " + this.strTargety);
        if (PApplet.parseBoolean((int)this.fire)) {
            this.label_fire.setOpaque(true);
            this.setLabelText(this.label_fire, "Firing");
        } else {
            this.label_fire.setOpaque(false);
            this.setLabelText(this.label_fire, "Not Firing");
        }
        if (this.firingMode) {
            this.setLabelText(this.label_fireSelector, "Semi-Automatic");
        } else {
            this.setLabelText(this.label_fireSelector, "Automatic");
        }
        if (!this.runWithoutArduino) {
            this.label_runWithoutArduino.setOpaque(true);
            this.setLabelText(this.label_runWithoutArduino, "Controller on " + this.serPortUsed);
        } else {
            this.label_runWithoutArduino.setOpaque(false);
            this.setLabelText(this.label_runWithoutArduino, "No Controller");
        }
        if (this.connecting) {
            this.label_runWithoutArduino.setOpaque(true);
            this.setLabelText(this.label_runWithoutArduino, "connecting...");
        }
        if (this.scanWhenIdle) {
            this.setLabelText(this.label_scanSelector, "Scan When Idle");
        } else {
            this.setLabelText(this.label_scanSelector, "Don't Scan When Idle");
        }
        this.checkbox_controlMode.setSelected(this.controlMode);
        this.checkbox_useInputDevice.setSelected(this.useInputDevice);
        this.checkbox_useArrowKeys.setSelected(this.useArrowKeys);
    }

    public void handleComboEvents(GCombo gCombo) {
        if (gCombo == this.dropdown_effect) {
            this.effect = this.dropdown_effect.selectedIndex();
        }
        if (gCombo == this.dropdown_firingMode) {
            this.firingMode = PApplet.parseBoolean((int)this.dropdown_firingMode.selectedIndex());
        }
        if (gCombo == this.dropdown_comPort && this.dropdown_comPort.selectedIndex() < Serial.list().length) {
            if (!this.runWithoutArduino) {
                this.connecting = true;
                PSG_Processing_Code.println((String)"Manual override. Stopping old serial connection...");
                this.arduinoPort.stop();
                PSG_Processing_Code.println((String)"Stopped old serial connection.");
            }
            PSG_Processing_Code.println((String)("New COM port selected manually: " + Serial.list()[this.dropdown_comPort.selectedIndex()]));
            this.arduinoPort = new Serial((PApplet)this, Serial.list()[this.dropdown_comPort.selectedIndex()], 4800);
            PSG_Processing_Code.println((String)("Serial Port used = " + Serial.list()[this.dropdown_comPort.selectedIndex()]));
            this.serPortUsed = Serial.list()[this.dropdown_comPort.selectedIndex()];
            this.runWithoutArduino = false;
            this.connecting = false;
        }
    }

    public void handleSliderEvents(GSlider gSlider) {
        if (gSlider == this.slider_tolerance) {
            this.tolerance = this.slider_tolerance.getValue();
        }
        if (gSlider == this.slider_trackColorTolerance) {
            this.trackColorTolerance = this.slider_trackColorTolerance.getValue();
        }
        if (gSlider == this.slider_safeColorTolerance) {
            this.safeColorTolerance = this.slider_safeColorTolerance.getValue();
        }
        if (gSlider == this.slider_minBlobArea) {
            this.minBlobArea = this.slider_minBlobArea.getValue();
        }
        if (gSlider == this.slider_safeColorMinSize) {
            this.safeColorMinSize = this.slider_safeColorMinSize.getValue();
        }
        if (gSlider == this.slider_nbDot) {
            this.nbDot = this.slider_nbDot.getValue();
        }
        if (gSlider == this.slider_antSens) {
            this.antSens = this.slider_antSens.getValue();
        }
        if (gSlider == this.slider_propX) {
            this.propX = this.slider_propX.getValuef();
        }
        if (gSlider == this.slider_propY) {
            this.propY = this.slider_propY.getValuef();
        }
        if (gSlider == this.slider_smoothingFactor) {
            this.smoothingFactor = this.slider_smoothingFactor.getValuef();
        }
    }

    public void handleButtonEvents(GButton gButton) {
        float f;
        float f2;
        if (gButton == this.button_viewCameraSettings && gButton.eventType == 769) {
            this.viewCameraSettings();
        }
        if (gButton == this.button_setBackground && gButton.eventType == 769) {
            this.setBackground();
        }
        if (gButton == this.button_selectColor && gButton.eventType == 769) {
            this.selectColor();
        }
        if (gButton == this.button_selectSafeColor && gButton.eventType == 769) {
            this.selectSafeColor();
        }
        if (gButton == this.button_openWebsite && gButton.eventType == 769) {
            this.openWebsite();
        }
        if (gButton == this.button_playRandomSound && gButton.eventType == 769) {
            this.playRandomSound();
        }
        if (gButton == this.button_saveSettings && gButton.eventType == 769) {
            this.saveSettings();
        }
        if (gButton == this.button_loadSettings && gButton.eventType == 769) {
            this.loadSettings();
        }
        if (gButton == this.button_saveAndExit && gButton.eventType == 769) {
            this.saveSettings();
            this.delay(100);
            this.exit();
        }
        if (gButton == this.button_retryArduinoConnect && gButton.eventType == 769) {
            if (!this.runWithoutArduino) {
                this.arduinoPort.stop();
            }
            this.runWithoutArduino = false;
            this.retryArduinoConnect();
        }
        if (gButton == this.button_configJoystick && gButton.eventType == 769) {
            this.configJoystick();
        }
        if (gButton == this.button_resetCalibration && gButton.eventType == 769) {
            this.xMin = 0.0f;
            this.xMax = 180.0f;
            this.yMin = 0.0f;
            this.yMax = 180.0f;
            this.xRatio = (float)this.camWidth / (this.xMax - this.xMin);
            this.yRatio = (float)this.camHeight / (this.yMax - this.yMin);
        }
        if (gButton == this.button_flipX && gButton.eventType == 769) {
            f2 = this.xMin;
            this.xMin = f = this.xMax;
            this.xMax = f2;
            this.xRatio = (float)this.camWidth / (this.xMax - this.xMin);
        }
        if (gButton == this.button_flipY && gButton.eventType == 769) {
            f2 = this.yMin;
            this.yMin = f = this.yMax;
            this.yMax = f2;
            this.yRatio = (float)this.camHeight / (this.yMax - this.yMin);
        }
    }

    public void handleCheckboxEvents(GCheckbox gCheckbox) {
        if (gCheckbox == this.checkbox_leadTarget) {
            this.leadTarget = this.checkbox_leadTarget.isSelected();
        }
        if (gCheckbox == this.checkbox_showRestrictedZones) {
            this.showRestrictedZones = this.checkbox_showRestrictedZones.isSelected();
        }
        if (gCheckbox == this.checkbox_trackingColor) {
            this.trackingColor = this.checkbox_trackingColor.isSelected();
        }
        if (gCheckbox == this.checkbox_safeColor) {
            this.safeColor = this.checkbox_safeColor.isSelected();
        }
        if (gCheckbox == this.checkbox_trackingMotion) {
            this.trackingMotion = this.checkbox_trackingMotion.isSelected();
        }
        if (gCheckbox == this.checkbox_showDifferentPixels) {
            this.showDifferentPixels = this.checkbox_showDifferentPixels.isSelected();
        }
        if (gCheckbox == this.checkbox_showTargetBox) {
            this.showTargetBox = this.checkbox_showTargetBox.isSelected();
        }
        if (gCheckbox == this.checkbox_mirrorCam) {
            this.mirrorCam = this.checkbox_mirrorCam.isSelected();
        }
        if (gCheckbox == this.checkbox_controlMode) {
            this.controlMode = this.checkbox_controlMode.isSelected();
        }
        if (gCheckbox == this.checkbox_safety) {
            this.safety = this.checkbox_safety.isSelected();
        }
        if (gCheckbox == this.checkbox_showCameraView) {
            this.showCameraView = this.checkbox_showCameraView.isSelected();
        }
        if (gCheckbox == this.checkbox_scanWhenIdle) {
            this.scanWhenIdle = this.checkbox_scanWhenIdle.isSelected();
        }
        if (gCheckbox == this.checkbox_soundEffects) {
            this.soundEffects = this.checkbox_soundEffects.isSelected();
        }
        if (gCheckbox == this.checkbox_activeSmoothing) {
            this.activeSmoothing = this.checkbox_activeSmoothing.isSelected();
        }
        if (gCheckbox == this.checkbox_useInputDevice) {
            this.useInputDevice = this.checkbox_useInputDevice.isSelected();
        }
        if (gCheckbox == this.checkbox_useArrowKeys) {
            this.useArrowKeys = this.checkbox_useArrowKeys.isSelected();
        }
    }

    public void drawController(GWinApplet gWinApplet, GWinData gWinData) {
    }

    public void setLabelText(GLabel gLabel, String string) {
        try {
            gLabel.setText(string);
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void retryArduinoConnect() {
        this.connecting = true;
        if (!this.runWithoutArduino) {
            long l;
            int n = 0;
            int n2 = Serial.list().length;
            PSG_Processing_Code.println((Object)Serial.list());
            PSG_Processing_Code.println((String)("Serial Port Count = " + n2));
            if (n2 == 0) {
                this.runWithoutArduino = true;
                PSG_Processing_Code.println((String)"no Arduino detected. Will run without Arduino. Cheers");
            }
            n = 0;
            while (n < n2) {
                PSG_Processing_Code.println((String)("Testing port " + Serial.list()[n]));
                this.arduinoPort = new Serial((PApplet)this, Serial.list()[n], 4800);
                l = this.millis();
                while ((long)this.millis() - l < 2000L) {
                }
                this.arduinoPort.clear();
                this.arduinoPort.bufferUntil(84);
                l = this.millis();
                while ((long)this.millis() - l < 100L) {
                }
                if (this.arduinoPort.available() > 0) {
                    char c = this.arduinoPort.readChar();
                    if (c == 'T') {
                        break;
                    }
                } else {
                    this.arduinoPort.stop();
                }
                if (n == n2 - 1) {
                    this.runWithoutArduino = true;
                    PSG_Processing_Code.println((String)"no Arduino detected. Will run without Arduino. Cheers");
                }
                ++n;
            }
            if (!this.runWithoutArduino) {
                PSG_Processing_Code.println((String)("Serial Port used = " + Serial.list()[n]));
                this.serPortUsed = Serial.list()[n];
                l = this.millis();
                while ((long)this.millis() - l < 5000L) {
                }
            }
        }
        this.connecting = false;
    }

    public void configJoystick() {
        PSG_Processing_Code.println((String)"Opening InputDeviceSetupTool.exe...");
        this.useInputDevice = false;
        this.checkbox_useInputDevice.setSelected(this.useInputDevice);
        this.inputDeviceIsSetup = false;
        try {
            PSG_Processing_Code.open((String)this.dataPath("Input Device Setup Tool/InputDeviceSetupTool.exe"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            PSG_Processing_Code.println((String)"Could not open InputDeviceSetupTool.exe");
            return;
        }
    }

    public void setupInputDevice() {
        if (!this.inputDeviceIsSetup) {
            String[] stringArray = new String[49];
            stringArray = this.loadStrings("data/Input Device Setup Tool/settings_inputDevice.txt");
            this.controlIO = ControllIO.getInstance((PApplet)this);
            try {
                this.inputDevice = this.controlIO.getDevice(stringArray[2]);
            }
            catch (Exception exception) {
                PSG_Processing_Code.println((String)"ERROR: Specified input device is not connected!");
                this.useInputDevice = false;
                this.checkbox_useInputDevice.setSelected(this.useInputDevice);
                return;
            }
            this.inputDevice.setTolerance(0.025f);
            PSG_Processing_Code.println((String)("Device Selected = " + this.inputDevice.getName()));
            int n = this.inputDevice.getNumberOfButtons();
            int n2 = 0;
            while (n2 < n) {
                if (n2 < this.buttons.length) {
                    this.buttons[n2] = this.inputDevice.getButton(n2);
                }
                ++n2;
            }
            n2 = this.inputDevice.getNumberOfSliders();
            int n3 = 0;
            while (n3 < n2) {
                if (n3 < this.sliders.length) {
                    this.sliders[n3] = this.inputDevice.getSlider(n3);
                }
                ++n3;
            }
            n3 = 0;
            while (n3 <= 29) {
                if (stringArray[n3 + 6].equals("Fire")) {
                    this.fire_buttons = (ControllButton[])PSG_Processing_Code.append((Object)this.fire_buttons, (Object)this.buttons[n3]);
                } else if (stringArray[n3 + 6].equals("Precise Aim")) {
                    this.preciseAim_buttons = (ControllButton[])PSG_Processing_Code.append((Object)this.preciseAim_buttons, (Object)this.buttons[n3]);
                } else if (stringArray[n3 + 6].equals("Center Gun")) {
                    this.centerGun_buttons = (ControllButton[])PSG_Processing_Code.append((Object)this.centerGun_buttons, (Object)this.buttons[n3]);
                } else if (stringArray[n3 + 6].equals("Auto Aim On")) {
                    this.autoOn_buttons = (ControllButton[])PSG_Processing_Code.append((Object)this.autoOn_buttons, (Object)this.buttons[n3]);
                } else if (stringArray[n3 + 6].equals("Auto Aim Off")) {
                    this.autoOff_buttons = (ControllButton[])PSG_Processing_Code.append((Object)this.autoOff_buttons, (Object)this.buttons[n3]);
                } else if (stringArray[n3 + 6].equals("Input Dev On/Off")) {
                    this.inputToggle_buttons = (ControllButton[])PSG_Processing_Code.append((Object)this.inputToggle_buttons, (Object)this.buttons[n3]);
                } else if (stringArray[n3 + 6].equals("Random Sound")) {
                    this.randomSound_buttons = (ControllButton[])PSG_Processing_Code.append((Object)this.randomSound_buttons, (Object)this.buttons[n3]);
                }
                ++n3;
            }
            n3 = 0;
            while (n3 <= 9) {
                if (stringArray[n3 + 39].equals("Pan")) {
                    this.pan_sliders = (ControllSlider[])PSG_Processing_Code.append((Object)this.pan_sliders, (Object)this.sliders[n3]);
                } else if (stringArray[n3 + 39].equals("Tilt")) {
                    this.tilt_sliders = (ControllSlider[])PSG_Processing_Code.append((Object)this.tilt_sliders, (Object)this.sliders[n3]);
                } else if (stringArray[n3 + 39].equals("Pan (Invert)")) {
                    this.panInvert_sliders = (ControllSlider[])PSG_Processing_Code.append((Object)this.panInvert_sliders, (Object)this.sliders[n3]);
                } else if (stringArray[n3 + 39].equals("Tilt (Invert)")) {
                    this.tiltInvert_sliders = (ControllSlider[])PSG_Processing_Code.append((Object)this.tiltInvert_sliders, (Object)this.sliders[n3]);
                }
                ++n3;
            }
            this.inputDeviceIsSetup = true;
        }
    }

    public void updateInputDevice() {
        if (!this.inputDeviceIsSetup) {
            this.setupInputDevice();
        } else {
            float f = 0.0f;
            int n = 0;
            while (n < this.pan_sliders.length) {
                f += this.pan_sliders[n].getValue();
                ++n;
            }
            n = 0;
            while (n < this.panInvert_sliders.length) {
                f -= this.panInvert_sliders[n].getValue();
                ++n;
            }
            float f2 = 0.0f;
            int n2 = 0;
            while (n2 < this.tilt_sliders.length) {
                f2 += this.tilt_sliders[n2].getValue();
                ++n2;
            }
            n2 = 0;
            while (n2 < this.tiltInvert_sliders.length) {
                f2 -= this.tiltInvert_sliders[n2].getValue();
                ++n2;
            }
            n2 = 0;
            int n3 = 0;
            while (n3 < this.fire_buttons.length) {
                if (this.fire_buttons[n3].pressed()) {
                    n2 = 1;
                }
                ++n3;
            }
            n3 = 0;
            int n4 = 0;
            while (n4 < this.centerGun_buttons.length) {
                if (this.centerGun_buttons[n4].pressed()) {
                    n3 = 1;
                }
                ++n4;
            }
            n4 = 0;
            int n5 = 0;
            while (n5 < this.preciseAim_buttons.length) {
                if (this.preciseAim_buttons[n5].pressed()) {
                    n4 = 1;
                }
                ++n5;
            }
            float f3 = PSG_Processing_Code.map((float)PSG_Processing_Code.pow((float)PSG_Processing_Code.abs((float)f), (float)2.0f), (float)0.0f, (float)1.0f, (float)1.0f, (float)(this.camWidth / 10));
            float f4 = PSG_Processing_Code.map((float)PSG_Processing_Code.pow((float)PSG_Processing_Code.abs((float)f2), (float)2.0f), (float)0.0f, (float)1.0f, (float)1.0f, (float)(this.camWidth / 10));
            if (n4 != 0) {
                f3 *= 0.25f;
                f4 *= 0.25f;
            }
            this.xPosition += f3 * f;
            this.yPosition += f4 * f2;
            this.xPosition = PSG_Processing_Code.constrain((float)this.xPosition, (float)0.0f, (float)this.camWidth);
            this.yPosition = PSG_Processing_Code.constrain((float)this.yPosition, (float)0.0f, (float)this.camHeight);
            if (n3 != 0) {
                this.xPosition = this.camWidth / 2;
                this.yPosition = this.camHeight / 2;
            }
            this.fire = n2 != 0 ? 1 : 0;
            this.targetX = PApplet.parseInt((float)(this.xPosition / this.xRatio + this.xMin));
            this.targetY = PApplet.parseInt((float)(((float)this.camHeight - this.yPosition) / this.yRatio + this.yMin));
            this.displayX = PApplet.parseInt((float)this.xPosition);
            this.displayY = PApplet.parseInt((float)this.yPosition);
        }
    }

    public void checkInputDevice() {
        if (!this.inputDeviceIsSetup) {
            this.setupInputDevice();
        } else {
            boolean bl = false;
            int n = 0;
            while (n < this.autoOff_buttons.length) {
                if (this.autoOff_buttons[n].pressed()) {
                    bl = true;
                }
                ++n;
            }
            n = 0;
            int n2 = 0;
            while (n2 < this.autoOn_buttons.length) {
                if (this.autoOn_buttons[n2].pressed()) {
                    n = 1;
                }
                ++n2;
            }
            n2 = 0;
            int n3 = 0;
            while (n3 < this.randomSound_buttons.length) {
                if (this.randomSound_buttons[n3].pressed()) {
                    n2 = 1;
                }
                ++n3;
            }
            n3 = 0;
            int n4 = 0;
            while (n4 < this.inputToggle_buttons.length) {
                if (this.inputToggle_buttons[n4].pressed()) {
                    n3 = 1;
                }
                ++n4;
            }
            if (bl) {
                this.controlMode = false;
            }
            if (n != 0) {
                this.controlMode = true;
            }
            if (n2 != 0) {
                this.randomIdleSound();
                while (n2 != 0) {
                    n2 = 0;
                    n4 = 0;
                    while (n4 < this.randomSound_buttons.length) {
                        if (this.randomSound_buttons[n4].pressed()) {
                            n2 = 1;
                        }
                        ++n4;
                    }
                }
            }
            if (n3 != 0) {
                this.useInputDevice = !this.useInputDevice;
                while (n3 != 0) {
                    n3 = 0;
                    n4 = 0;
                    while (n4 < this.inputToggle_buttons.length) {
                        if (this.inputToggle_buttons[n4].pressed()) {
                            n3 = 1;
                        }
                        ++n4;
                    }
                }
            }
        }
    }

    public void saveSettings() {
        String[] stringArray = new String[]{PSG_Processing_Code.str((int)this.camWidth), PSG_Processing_Code.str((int)this.camHeight), PSG_Processing_Code.str((float)this.xMin), PSG_Processing_Code.str((float)this.xMax), PSG_Processing_Code.str((float)this.yMin), PSG_Processing_Code.str((float)this.yMax), PSG_Processing_Code.str((int)this.effect), PSG_Processing_Code.str((boolean)this.mirrorCam), PSG_Processing_Code.str((int)this.minBlobArea), PSG_Processing_Code.str((int)this.tolerance), PSG_Processing_Code.str((boolean)this.runWithoutArduino), PSG_Processing_Code.str((float)this.smoothingFactor), PSG_Processing_Code.str((boolean)this.activeSmoothing), PSG_Processing_Code.str((boolean)this.showDifferentPixels), PSG_Processing_Code.str((boolean)this.showTargetBox), PSG_Processing_Code.str((boolean)this.showCameraView), PSG_Processing_Code.str((boolean)this.firingMode), PSG_Processing_Code.str((boolean)this.safety), PSG_Processing_Code.str((boolean)this.controlMode), PSG_Processing_Code.str((boolean)this.soundEffects), PSG_Processing_Code.str((boolean)this.scanWhenIdle), PSG_Processing_Code.str((boolean)this.trackingMotion), PSG_Processing_Code.str((boolean)this.showRestrictedZones), PSG_Processing_Code.str((boolean)this.trackingColor), PSG_Processing_Code.str((int)this.trackColorTolerance), PSG_Processing_Code.str((int)this.trackColorRed), PSG_Processing_Code.str((int)this.trackColorGreen), PSG_Processing_Code.str((int)this.trackColorBlue), PSG_Processing_Code.str((boolean)this.safeColor), PSG_Processing_Code.str((int)this.safeColorMinSize), PSG_Processing_Code.str((int)this.safeColorTolerance), PSG_Processing_Code.str((int)this.safeColorRed), PSG_Processing_Code.str((int)this.safeColorGreen), PSG_Processing_Code.str((int)this.safeColorBlue), PSG_Processing_Code.str((boolean)this.useInputDevice), PSG_Processing_Code.str((boolean)this.leadTarget), PSG_Processing_Code.str((int)this.nbDot), PSG_Processing_Code.str((int)this.antSens), PSG_Processing_Code.str((float)this.propX), PSG_Processing_Code.str((float)this.propY)};
        this.saveStrings("data/settings.txt", stringArray);
        PSG_Processing_Code.println((String)"Successfully saved settings to \"settings.txt\"");
    }

    public void loadSettings() {
        String[] stringArray = new String[40];
        stringArray = this.loadStrings("settings.txt");
        this.xMin = PApplet.parseFloat((String)stringArray[2]);
        this.xMax = PApplet.parseFloat((String)stringArray[3]);
        this.yMin = PApplet.parseFloat((String)stringArray[4]);
        this.yMax = PApplet.parseFloat((String)stringArray[5]);
        this.xRatio = (float)this.camWidth / (this.xMax - this.xMin);
        this.yRatio = (float)this.camHeight / (this.yMax - this.yMin);
        this.effect = PApplet.parseInt((String)stringArray[6]);
        this.mirrorCam = PApplet.parseBoolean((String)stringArray[7]);
        this.minBlobArea = PApplet.parseInt((String)stringArray[8]);
        this.tolerance = PApplet.parseInt((String)stringArray[9]);
        this.runWithoutArduino = PApplet.parseBoolean((String)stringArray[10]);
        this.smoothingFactor = PApplet.parseFloat((String)stringArray[11]);
        this.activeSmoothing = PApplet.parseBoolean((String)stringArray[12]);
        this.showDifferentPixels = PApplet.parseBoolean((String)stringArray[13]);
        this.showTargetBox = PApplet.parseBoolean((String)stringArray[14]);
        this.showCameraView = PApplet.parseBoolean((String)stringArray[15]);
        this.firingMode = PApplet.parseBoolean((String)stringArray[16]);
        this.safety = PApplet.parseBoolean((String)stringArray[17]);
        this.controlMode = PApplet.parseBoolean((String)stringArray[18]);
        this.soundEffects = PApplet.parseBoolean((String)stringArray[19]);
        this.scanWhenIdle = PApplet.parseBoolean((String)stringArray[20]);
        this.trackingMotion = PApplet.parseBoolean((String)stringArray[21]);
        this.showRestrictedZones = PApplet.parseBoolean((String)stringArray[22]);
        this.trackingColor = PApplet.parseBoolean((String)stringArray[23]);
        this.trackColorTolerance = PApplet.parseInt((String)stringArray[24]);
        this.trackColorRed = PApplet.parseInt((String)stringArray[25]);
        this.trackColorGreen = PApplet.parseInt((String)stringArray[26]);
        this.trackColorBlue = PApplet.parseInt((String)stringArray[27]);
        this.safeColor = PApplet.parseBoolean((String)stringArray[28]);
        this.safeColorMinSize = PApplet.parseInt((String)stringArray[29]);
        this.safeColorTolerance = PApplet.parseInt((String)stringArray[30]);
        this.safeColorRed = PApplet.parseInt((String)stringArray[31]);
        this.safeColorGreen = PApplet.parseInt((String)stringArray[32]);
        this.safeColorBlue = PApplet.parseInt((String)stringArray[33]);
        this.useInputDevice = PApplet.parseBoolean((String)stringArray[34]);
        this.leadTarget = PApplet.parseBoolean((String)stringArray[35]);
        this.nbDot = PApplet.parseInt((String)stringArray[36]);
        this.antSens = PApplet.parseInt((String)stringArray[37]);
        this.propX = PApplet.parseFloat((String)stringArray[38]);
        this.propY = PApplet.parseFloat((String)stringArray[39]);
        PSG_Processing_Code.println((String)"Successfully loaded settings from \"settings.txt\"");
    }

    public void loadSounds() {
        this.s1 = this.minim.loadSnippet("data/your business is appreciated.wav");
        this.s2 = this.minim.loadSnippet("data/who's there.wav");
        this.s3 = this.minim.loadSnippet("data/there you are.wav");
        this.s4 = this.minim.loadSnippet("data/there you are(2).wav");
        this.s5 = this.minim.loadSnippet("data/target lost.wav");
        this.s6 = this.minim.loadSnippet("data/target aquired.wav");
        this.s7 = this.minim.loadSnippet("data/sleep mode activated.wav");
        this.s8 = this.minim.loadSnippet("data/sentry mode activated.wav");
        this.s9 = this.minim.loadSnippet("data/no hard feelings.wav");
        this.s10 = this.minim.loadSnippet("data/is anyone there.wav");
        this.s11 = this.minim.loadSnippet("data/i see you.wav");
        this.s12 = this.minim.loadSnippet("data/i dont hate you.wav");
        this.s13 = this.minim.loadSnippet("data/i dont blame you.wav");
        this.s14 = this.minim.loadSnippet("data/hey its me.wav");
        this.s15 = this.minim.loadSnippet("data/hello.wav");
        this.s16 = this.minim.loadSnippet("data/gotcha.wav");
        this.s17 = this.minim.loadSnippet("data/dispensing product.wav");
        this.s18 = this.minim.loadSnippet("data/deploying.wav");
        this.s19 = this.minim.loadSnippet("data/could you come over here.wav");
        this.s20 = this.minim.loadSnippet("data/are you still there.wav");
        this.s21 = this.minim.loadSnippet("data/activated.wav");
    }

    public void playSound(int n) {
        if (this.soundEffects) {
            if (n == 1) {
                this.s1.rewind();
                this.s1.play();
            }
            if (n == 2) {
                this.s2.rewind();
                this.s2.play();
            }
            if (n == 3) {
                this.s3.rewind();
                this.s3.play();
            }
            if (n == 4) {
                this.s4.rewind();
                this.s4.play();
            }
            if (n == 5) {
                this.s5.rewind();
                this.s5.play();
            }
            if (n == 6) {
                this.s6.rewind();
                this.s6.play();
            }
            if (n == 7) {
                this.s7.rewind();
                this.s7.play();
            }
            if (n == 8) {
                this.s8.rewind();
                this.s8.play();
            }
            if (n == 9) {
                this.s9.rewind();
                this.s9.play();
            }
            if (n == 10) {
                this.s10.rewind();
                this.s10.play();
            }
            if (n == 11) {
                this.s11.rewind();
                this.s11.play();
            }
            if (n == 12) {
                this.s12.rewind();
                this.s12.play();
            }
            if (n == 13) {
                this.s13.rewind();
                this.s13.play();
            }
            if (n == 14) {
                this.s14.rewind();
                this.s14.play();
            }
            if (n == 15) {
                this.s15.rewind();
                this.s15.play();
            }
            if (n == 16) {
                this.s16.rewind();
                this.s16.play();
            }
            if (n == 17) {
                this.s17.rewind();
                this.s17.play();
            }
            if (n == 18) {
                this.s18.rewind();
                this.s18.play();
            }
            if (n == 19) {
                this.s19.rewind();
                this.s19.play();
            }
            if (n == 20) {
                this.s20.rewind();
                this.s20.play();
            }
            if (n == 21) {
                this.s21.rewind();
                this.s21.play();
            }
        }
    }

    public void randomIdleSound() {
        if (this.soundEffects) {
            int n = PApplet.parseInt((float)this.random(1.0f, 11.0f));
            if (n == 1) {
                this.s2.rewind();
                this.s2.play();
            }
            if (n == 2) {
                this.s7.rewind();
                this.s7.play();
            }
            if (n == 3) {
                this.s9.rewind();
                this.s9.play();
            }
            if (n == 4) {
                this.s10.rewind();
                this.s10.play();
            }
            if (n == 5) {
                this.s11.rewind();
                this.s11.play();
            }
            if (n == 6) {
                this.s12.rewind();
                this.s12.play();
            }
            if (n == 7) {
                this.s13.rewind();
                this.s13.play();
            }
            if (n == 8) {
                this.s14.rewind();
                this.s14.play();
            }
            if (n == 9) {
                this.s19.rewind();
                this.s19.play();
            }
            if (n == 10) {
                this.s20.rewind();
                this.s20.play();
            }
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#F0F0F0", "PSG_Processing_Code"});
    }
}

