/*
 * Decompiled with CFR 0.152.
 */
package com.stromberglabs.jopensurf;

import com.stromberglabs.jopensurf.IntegralImage;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;

public class ImageTransformUtils {
    public static BufferedImage convertToGrayscale(BufferedImage input) {
        BufferedImage output = new BufferedImage(input.getWidth(), input.getHeight(), input.getType());
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        op.filter(input, output);
        return output;
    }

    public static float BoxIntegral(IntegralImage img, int row, int col, int rows, int cols) {
        int height = img.getHeight();
        int width = img.getWidth();
        int r1 = Math.min(row, height) - 1;
        int c1 = Math.min(col, width) - 1;
        int r2 = Math.min(row + rows, height) - 1;
        int c2 = Math.min(col + cols, width) - 1;
        float A = r1 >= 0 && c1 >= 0 ? img.getValue(c1, r1) : 0.0f;
        float B = r1 >= 0 && c2 >= 0 ? img.getValue(c2, r1) : 0.0f;
        float C = r2 >= 0 && c1 >= 0 ? img.getValue(c1, r2) : 0.0f;
        float D = r2 >= 0 && c2 >= 0 ? img.getValue(c2, r2) : 0.0f;
        return Math.max(0.0f, A - B - C + D);
    }

    public static BufferedImage getTransformedImage(BufferedImage image, double scaleX, double scaleY, double shearX, double shearY) {
        AffineTransform transform = new AffineTransform();
        if (scaleX > 0.0 && scaleY > 0.0) {
            transform.scale(scaleX, scaleY);
        }
        if (shearX > 0.0 && shearY > 0.0) {
            transform.shear(shearX, shearY);
        }
        AffineTransformOp op = new AffineTransformOp(transform, 2);
        BufferedImage dest = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        op.filter(image, dest);
        return dest;
    }

    public static void main(String[] args) {
    }
}

