/*
 * Decompiled with CFR 0.152.
 */
package com.stromberglabs.jopensurf;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.Serializable;

public class IntegralImage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private float[][] mIntImage;
    private int mWidth = -1;
    private int mHeight = -1;

    public float[][] getValues() {
        return this.mIntImage;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public float getValue(int column, int row) {
        return this.mIntImage[column][row];
    }

    public IntegralImage(BufferedImage input) {
        this.mIntImage = new float[input.getWidth()][input.getHeight()];
        this.mWidth = this.mIntImage.length;
        this.mHeight = this.mIntImage[0].length;
        int width = input.getWidth();
        int height = input.getHeight();
        WritableRaster raster = input.getRaster();
        int[] pixel = new int[4];
        int y = 0;
        while (y < height) {
            float sum = 0.0f;
            int x = 0;
            while (x < width) {
                raster.getPixel(x, y, pixel);
                float intensity = (float)Math.round(0.299 * (double)pixel[0] + 0.587 * (double)pixel[1] + 0.114 * (double)pixel[2]) / 255.0f;
                this.mIntImage[x][y] = y == 0 ? sum : (sum += intensity) + this.mIntImage[x][y - 1];
                ++x;
            }
            ++y;
        }
    }
}

