/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.FScrollbar;
import guicomponents.FTextComponent;
import guicomponents.GComponent;
import guicomponents.HotSpot;
import guicomponents.StyledString;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PGraphicsJava2D;
import processing.core.PImage;

public class FTextField
extends FTextComponent {
    int pad = 2;

    public FTextField(PApplet pApplet, float f, float f2, float f3, float f4) {
        this(pApplet, f, f2, f3, f4, 0);
    }

    public FTextField(PApplet pApplet, float f, float f2, float f3, float f4, int n) {
        super(pApplet, f, f2, f3, f4, n);
        this.tx = this.ty = (float)this.pad;
        this.tw = this.width - (float)(2 * this.pad);
        this.th = this.height - (float)((this.sbPolicy & 2) != 0 ? 11 : 0);
        this.gpTextDisplayArea = new GeneralPath();
        this.gpTextDisplayArea.moveTo(0.0f, 0.0f);
        this.gpTextDisplayArea.lineTo(0.0f, this.th);
        this.gpTextDisplayArea.lineTo(this.tw, this.th);
        this.gpTextDisplayArea.lineTo(this.tw, 0.0f);
        this.gpTextDisplayArea.closePath();
        this.buffer = (PGraphicsJava2D)this.winApp.createGraphics((int)this.width, (int)this.height, "processing.core.PGraphicsJava2D");
        this.buffer.rectMode(0);
        this.buffer.g2.setFont(this.fLocalFont);
        this.hotspots = new HotSpot[]{new HotSpot.HSrect(1, this.tx, this.ty, this.tw, this.th), new HotSpot.HSrect(9, 0.0f, 0.0f, this.width, this.height)};
        if ((this.sbPolicy & 2) != 0) {
            this.hsb = new FScrollbar(pApplet, 0.0f, 0.0f, this.tw, 10.0f);
            this.addCompoundControl(this.hsb, this.tx, this.ty + this.th + 2.0f, 0.0f);
            this.hsb.addEventHandler(this, "hsbEventHandler");
            this.hsb.setAutoHide(this.autoHide);
        }
        this.setTextNew(" ");
        this.z = 0;
        this.registerAutos_DMPK(true, true, false, true);
    }

    public void setTextNew(String string) {
        if (string == null || string.length() == 0) {
            string = " ";
        }
        this.text = string;
        this.stext = new StyledString(this.buffer.g2, string);
        if (this.hsb != null) {
            if (this.stext.getMaxLineLength() < this.tw) {
                this.hsb.setValue(0.0f, 1.0f);
            } else {
                this.hsb.setValue(0.0f, this.tw / this.stext.getMaxLineLength());
            }
        }
    }

    protected void updateBuffer() {
        if (this.bufferInvalid) {
            Graphics2D graphics2D = this.buffer.g2;
            StyledString.TextLayoutHitInfo textLayoutHitInfo = null;
            StyledString.TextLayoutHitInfo textLayoutHitInfo2 = null;
            this.buffer.beginDraw();
            if (this.opaque) {
                this.buffer.background(this.palette[6]);
            } else {
                this.buffer.background(this.buffer.color(255, 0));
            }
            this.buffer.translate(this.tx, this.ty);
            this.buffer.noStroke();
            this.buffer.fill(this.palette[7]);
            this.buffer.rect(-1.0f, -1.0f, this.tw + 2.0f, this.th + 2.0f);
            graphics2D.setClip(this.gpTextDisplayArea);
            this.buffer.translate(-this.ptx, -this.pty);
            LinkedList<StyledString.TextLayoutInfo> linkedList = this.stext.getLines(graphics2D);
            boolean bl = this.hasSelection();
            if (bl) {
                if (this.endTLHI.compareTo(this.startTLHI) == -1) {
                    textLayoutHitInfo = this.endTLHI;
                    textLayoutHitInfo2 = this.startTLHI;
                } else {
                    textLayoutHitInfo = this.startTLHI;
                    textLayoutHitInfo2 = this.endTLHI;
                }
            }
            if (this.stext.length() > 0) {
                this.buffer.pushMatrix();
                for (StyledString.TextLayoutInfo textLayoutInfo : linkedList) {
                    TextLayout textLayout = textLayoutInfo.layout;
                    this.buffer.translate(0.0f, textLayout.getAscent());
                    if (bl && textLayoutInfo.compareTo(textLayoutHitInfo.tli) >= 0 && textLayoutInfo.compareTo(textLayoutHitInfo2.tli) <= 0) {
                        int n = textLayoutHitInfo.thi.getInsertionIndex();
                        int n2 = textLayoutHitInfo2.thi.getInsertionIndex();
                        graphics2D.setColor(this.jpalette[14]);
                        Shape shape = textLayout.getLogicalHighlightShape(n, n2);
                        graphics2D.fill(shape);
                    }
                    graphics2D.setColor(this.jpalette[2]);
                    textLayoutInfo.layout.draw(graphics2D, 0.0f, 0.0f);
                    this.buffer.translate(0.0f, textLayout.getDescent() + textLayout.getLeading());
                }
                this.buffer.popMatrix();
            }
            graphics2D.setClip(null);
            this.buffer.endDraw();
            this.bufferInvalid = false;
        }
    }

    protected boolean keepCursorInDisplay() {
        boolean bl = false;
        if (this.endTLHI != null) {
            if (this.caretX < this.ptx) {
                this.ptx -= 1.0f;
                if (this.ptx < 0.0f) {
                    this.ptx = 0.0f;
                }
                bl = true;
            } else if (this.caretX > this.ptx + this.tw - 4.0f) {
                this.ptx += 1.0f;
                bl = true;
            }
            if (bl && this.hsb != null) {
                this.hsb.setValue(this.ptx / (this.stext.getMaxLineLength() + 4.0f));
            }
        }
        if (bl) {
            this.bufferInvalid = true;
        }
        return bl;
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.ox -= this.tx;
        this.oy -= this.ty;
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        if (this.currSpot == 1 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (this.currSpot != 1) break;
                if (focusIsWith != this && this.z > FTextField.focusObjectZ()) {
                    this.takeFocus();
                }
                this.mdx = this.winApp.mouseX;
                this.mdy = this.winApp.mouseY;
                this.endTLHI = this.stext.calculateFromXY(this.buffer.g2, this.ox + this.ptx, this.oy + this.pty);
                this.startTLHI = new StyledString.TextLayoutHitInfo(this.endTLHI);
                this.calculateCaretPos(this.endTLHI);
                this.bufferInvalid = true;
                break;
            }
            case 502: {
                this.dragging = false;
                this.bufferInvalid = true;
                break;
            }
            case 506: {
                if (focusIsWith != this) break;
                this.dragging = true;
                this.endTLHI = this.stext.calculateFromXY(this.buffer.g2, this.ox + this.ptx, this.oy + this.pty);
                this.calculateCaretPos(this.endTLHI);
                this.bufferInvalid = true;
                this.keepCursorInDisplay();
            }
        }
    }

    protected boolean processKeyPressed(KeyEvent keyEvent, boolean bl, boolean bl2) {
        int n = keyEvent.getKeyCode();
        boolean bl3 = false;
        switch (n) {
            case 37: {
                bl3 = this.moveCaretLeft(this.endTLHI);
                break;
            }
            case 39: {
                bl3 = this.moveCaretRight(this.endTLHI);
                break;
            }
            case 36: {
                bl3 = this.moveCaretStartOfLine(this.endTLHI);
                break;
            }
            case 35: {
                bl3 = this.moveCaretEndOfLine(this.endTLHI);
            }
        }
        this.calculateCaretPos(this.endTLHI);
        if (bl3) {
            if (!bl) {
                this.startTLHI.copyFrom(this.endTLHI);
            } else {
                this.bufferInvalid = true;
            }
        }
        return bl3;
    }

    public void keyEvent(KeyEvent keyEvent) {
        block3: {
            boolean bl;
            boolean bl2;
            block4: {
                if (!(this.visible && this.enabled && this.available)) {
                    return;
                }
                if (focusIsWith != this || this.endTLHI == null) break block3;
                bl2 = (keyEvent.getModifiersEx() & 0x40) == 64;
                boolean bl3 = bl = (keyEvent.getModifiersEx() & 0x80) == 128;
                if (keyEvent.getID() != 401) break block4;
                this.processKeyPressed(keyEvent, bl2, bl);
                this.setScrollbarValues(this.ptx, this.pty);
                while (this.keepCursorInDisplay()) {
                }
                break block3;
            }
            if (keyEvent.getID() != 400 || keyEvent.getKeyChar() == '\uffff') break block3;
            this.processKeyTyped(keyEvent, bl2, bl);
            this.setScrollbarValues(this.ptx, this.pty);
            while (this.keepCursorInDisplay()) {
            }
        }
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        this.updateBuffer();
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.pushMatrix();
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        if (this.showCaret && this.endTLHI != null) {
            Object object = this.endTLHI.tli.layout.getCaretInfo(this.endTLHI.thi);
            float f = -this.ptx + object[0];
            float f2 = -this.pty + this.endTLHI.tli.yPosInPara;
            float f3 = f2 - object[3] + object[5];
            if (f >= 0.0f && f <= this.tw && f2 >= 0.0f && f3 <= this.th) {
                this.winApp.strokeWeight(1.9f);
                this.winApp.stroke(this.palette[15]);
                this.winApp.line(this.tx + f, this.ty + Math.max(0.0f, f2), this.tx + f, this.ty + Math.min(this.th, f3));
            }
        }
        this.winApp.popMatrix();
        if (this.children != null) {
            for (GComponent gComponent : this.children) {
                gComponent.draw();
            }
        }
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }
}

