/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.GCScheme;
import guicomponents.GComponent;
import guicomponents.GConstants;
import guicomponents.GCursorImageChanger;
import guicomponents.GFont;
import guicomponents.GMessenger;
import guicomponents.GWinApplet;
import guicomponents.GWindow;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PStyle;

public class G4P
implements PConstants,
GConstants {
    private static HashMap<PApplet, AppletInfo> applets = new HashMap();
    public static PApplet mainWinApp = null;
    public static PStyle g4pStyle = null;
    public static boolean messages = true;
    public static final String[] fontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private static GCursorImageChanger mcd = new GCursorImageChanger();
    public static boolean overControl = false;
    public static boolean cursorChangeEnabled = false;
    public static int mouseOff = 0;
    public static int mouseOver = 12;

    public static String getFamily(String string) {
        for (String string2 : fontFamilies) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return string2;
        }
        return "Dialog";
    }

    public static void setMouseOverEnabled(boolean bl) {
        if (cursorChangeEnabled != bl && mainWinApp != null) {
            if (!bl) {
                Set<PApplet> set = applets.keySet();
                for (PApplet pApplet : set) {
                    pApplet.cursor(mouseOff);
                }
            }
            cursorChangeEnabled = bl;
        }
    }

    public static void refresh() {
        Set<PApplet> set = applets.keySet();
        for (PApplet pApplet : set) {
            pApplet.repaint();
        }
    }

    public static void cursor(int n, int n2) {
        mouseOff = n;
        mouseOver = n2;
    }

    public static void cursor(int n) {
        mouseOver = n;
    }

    public static void addComponent(PApplet pApplet, GComponent gComponent) {
        AppletInfo appletInfo;
        if (g4pStyle == null) {
            G4P.getStyle();
        }
        if ((appletInfo = applets.get(pApplet)) == null) {
            appletInfo = G4P.addWindow(pApplet);
            appletInfo.orgMatrix = pApplet.g.is2D() ? new PMatrix2D() : new PMatrix3D(1.0f, 0.0f, 0.0f, -0.5f * (float)pApplet.width, 0.0f, 1.0f, 0.0f, -0.5f * (float)pApplet.height, 0.0f, 0.0f, 1.0f, -0.5f * (float)pApplet.height / (float)Math.tan(0.5235987755982988), 0.0f, 0.0f, 0.0f, 1.0f);
        }
        appletInfo.addComponent(gComponent);
    }

    public static void dumpComponent(GComponent gComponent) {
        AppletInfo appletInfo = applets.get(gComponent.getPApplet());
        if (appletInfo != null) {
            appletInfo.removeControl(gComponent);
        }
    }

    public static void addWindow(GWindow gWindow) {
        if (gWindow != null && gWindow.papplet != null) {
            G4P.addWindow(gWindow.papplet);
        }
    }

    public static AppletInfo addWindow(PApplet pApplet) {
        AppletInfo appletInfo = applets.get(pApplet);
        if (appletInfo == null) {
            if (applets.isEmpty()) {
                mainWinApp = pApplet;
                mainWinApp.registerPost((Object)mcd);
            }
            appletInfo = new AppletInfo(pApplet);
            applets.put(pApplet, appletInfo);
        }
        return appletInfo;
    }

    public static void removeWindow(GWindow gWindow) {
        if (gWindow != null && gWindow.papplet != null) {
            applets.remove(gWindow.papplet);
        }
    }

    public static boolean isWindowActive(GWindow gWindow) {
        if (gWindow != null && gWindow.papplet != null) {
            return applets.containsKey(gWindow.papplet);
        }
        return false;
    }

    private static void getStyle() {
        PGraphics pGraphics = new PGraphics();
        g4pStyle = pGraphics.getStyle();
        G4P.g4pStyle.rectMode = 0;
        G4P.g4pStyle.ellipseMode = 3;
        G4P.g4pStyle.imageMode = 0;
        G4P.g4pStyle.shapeMode = 0;
        G4P.g4pStyle.colorMode = 1;
        G4P.g4pStyle.colorModeA = 255.0f;
        G4P.g4pStyle.colorModeX = 255.0f;
        G4P.g4pStyle.colorModeY = 255.0f;
        G4P.g4pStyle.colorModeZ = 255.0f;
    }

    public static void setColorScheme(PApplet pApplet, int n) {
        if (pApplet != null) {
            GComponent.globalColor = GCScheme.getColor(pApplet, n);
        }
    }

    public static void setFont(PApplet pApplet, String string, int n) {
        if (pApplet != null) {
            GComponent.globalFont = GFont.getFont(pApplet, string, n);
        }
    }

    public static void setFont(String string, int n) {
        G4P.setFont(string, n, 0);
    }

    public static void setFont(String string, int n, int n2) {
        GComponent.fGlobalFont = new Font(string, n, n2);
    }

    public static void setFont(Font font) {
        GComponent.fGlobalFont = font;
    }

    public static void draw(PApplet pApplet) {
        AppletInfo appletInfo = applets.get(pApplet);
        if (appletInfo != null && appletInfo.paControls.size() > 0) {
            if (appletInfo.autoDrawOn) {
                for (GComponent gComponent : appletInfo.paControls) {
                    if (gComponent.getParent() != null) continue;
                    gComponent.regDraw = false;
                    gComponent.getPApplet().unregisterDraw((Object)gComponent);
                }
                appletInfo.autoDrawOn = false;
            }
            pApplet.noLights();
            pApplet.pushMatrix();
            pApplet.hint(2);
            pApplet.resetMatrix();
            pApplet.applyMatrix(appletInfo.orgMatrix);
            for (GComponent gComponent : appletInfo.paControls) {
                if (gComponent.getParent() != null || gComponent.getPApplet() != pApplet) continue;
                gComponent.draw();
            }
            pApplet.hint(-2);
            pApplet.popMatrix();
        }
    }

    private static void unregisterFromPAppletDraw(PApplet pApplet) {
        AppletInfo appletInfo = applets.get(pApplet);
        if (appletInfo != null) {
            for (GComponent gComponent : appletInfo.paControls) {
                if (gComponent.getParent() != null) continue;
                gComponent.regDraw = false;
                gComponent.getPApplet().unregisterDraw((Object)gComponent);
            }
            appletInfo.autoDrawOn = false;
        }
    }

    public static boolean isAutoDrawOn(PApplet pApplet) {
        AppletInfo appletInfo = applets.get(pApplet);
        if (appletInfo != null) {
            return appletInfo.autoDrawOn;
        }
        return false;
    }

    public static void messagesEnabled(boolean bl) {
        messages = bl;
    }

    public static void setDrawOrder(GWindow gWindow) {
        GWinApplet gWinApplet = gWindow.papplet;
        G4P.setDrawOrder(gWinApplet);
    }

    public static void setDrawOrder(PApplet pApplet) {
        AppletInfo appletInfo = applets.get(pApplet);
        if (appletInfo != null && appletInfo.autoDrawOn) {
            Collections.sort(appletInfo.paControls, new GComponent.Z_Order());
            if (appletInfo.autoDrawOn) {
                for (GComponent gComponent : appletInfo.paControls) {
                    if (gComponent.getParent() != null) continue;
                    pApplet.unregisterDraw((Object)gComponent);
                }
                for (GComponent gComponent : appletInfo.paControls) {
                    if (gComponent.getParent() != null) continue;
                    pApplet.registerDraw((Object)gComponent);
                }
            }
        }
    }

    public static void moveToFrontForDraw(GComponent gComponent) {
        PApplet pApplet = gComponent.getPApplet();
        AppletInfo appletInfo = applets.get(pApplet);
        if (appletInfo != null && appletInfo.paControls.remove(gComponent)) {
            appletInfo.paControls.add(gComponent);
            if (gComponent.parent == null && pApplet != null && appletInfo.autoDrawOn) {
                pApplet.unregisterDraw((Object)gComponent);
                pApplet.registerDraw((Object)gComponent);
            }
        }
    }

    public static void moveToFrontForMouse(GComponent gComponent) {
        PApplet pApplet = gComponent.getPApplet();
        AppletInfo appletInfo = applets.get(pApplet);
        if (appletInfo != null && appletInfo.paControls.remove(gComponent)) {
            appletInfo.paControls.add(gComponent);
            pApplet.unregisterMouseEvent((Object)gComponent);
            pApplet.registerMouseEvent((Object)gComponent);
        }
    }

    private static class AppletInfo {
        public PMatrix orgMatrix;
        public List<GComponent> paControls;
        public boolean autoDrawOn = true;

        public AppletInfo(PApplet pApplet) {
            this.orgMatrix = pApplet.g.is3D() ? pApplet.getMatrix((PMatrix3D)null) : pApplet.getMatrix((PMatrix2D)null);
            this.paControls = new LinkedList<GComponent>();
        }

        public boolean addComponent(GComponent gComponent) {
            if (gComponent == null) {
                return false;
            }
            if (this.paControls.contains(gComponent)) {
                GMessenger.message(65793, gComponent, null);
                return false;
            }
            this.paControls.add(gComponent);
            return true;
        }

        public boolean removeControl(GComponent gComponent) {
            return this.paControls.remove(gComponent);
        }
    }
}

