/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GCScheme;
import guicomponents.GComponent;
import guicomponents.GFont;
import java.awt.Point;
import java.awt.event.MouseEvent;
import processing.core.PApplet;
import processing.core.PImage;

public class GButton
extends GComponent {
    public static final int OFF = 0;
    public static final int OVER = 1;
    public static final int DOWN = 2;
    protected int status;
    protected PImage[] bimage = new PImage[3];
    protected int btnImgWidth = 0;
    protected int imageAlign = 4;
    protected boolean useImages = false;
    protected boolean reportAllButtonEvents = false;
    protected int imgAlignX;

    public GButton(PApplet pApplet, String string, int n, int n2, int n3, int n4) {
        super(pApplet, n, n2);
        this.setText(string);
        this.buttonCtorCore(n3, n4);
    }

    public GButton(PApplet pApplet, String string, int n, int n2, int n3, int n4, int n5) {
        super(pApplet, n2, n3);
        this.setImages(string, n);
        this.btnImgWidth = this.getMaxButtonImageWidth();
        this.buttonCtorCore(n4, n5);
    }

    public GButton(PApplet pApplet, String string, String string2, int n, int n2, int n3, int n4, int n5) {
        super(pApplet, n2, n3);
        this.setImages(string2, n);
        this.btnImgWidth = this.getMaxButtonImageWidth();
        this.setText(string);
        this.buttonCtorCore(n4, n5);
    }

    private void buttonCtorCore(int n, int n2) {
        this.width = Math.max(n, this.textWidth + 8);
        this.height = Math.max(n2, this.localFont.getSize() + 4);
        this.border = 1;
        this.setImageAlign(this.imageAlign);
        this.textAlignHorz = 4;
        this.textAlignVert = 64;
        this.calcAlignX();
        this.calcAlignY();
        this.createEventHandler(G4P.mainWinApp, "handleButtonEvents", new Class[]{GButton.class});
        this.registerAutos_DMPK(true, true, false, false);
        this.z = 24;
    }

    public void setColours(int n, int n2, int n3) {
        this.localColor.btnOff = n;
        this.localColor.btnOver = n2;
        this.localColor.btnDown = n3;
    }

    protected int getMaxButtonImageWidth() {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            n = Math.max(n, this.bimage[i] == null ? 0 : this.bimage[i].width);
        }
        this.useImages = n > 0;
        return n;
    }

    protected int getMaxButtonImageHeight() {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            n = Math.max(n, this.bimage[i] == null ? 0 : this.bimage[i].height);
        }
        return n;
    }

    public void setImages(String string, String string2, String string3) {
        this.bimage[0] = this.winApp.loadImage(string);
        if (this.bimage[0] == null && G4P.messages) {
            System.out.println("Can't find normal button image file");
        }
        this.bimage[1] = this.winApp.loadImage(string2);
        if (this.bimage[1] == null && G4P.messages) {
            System.out.println("Can't find over button image file");
        }
        this.bimage[2] = this.winApp.loadImage(string3);
        if (this.bimage[2] == null && G4P.messages) {
            System.out.println("Can't find pressed button image file");
        }
        this.getMaxButtonImageWidth();
        if (this.useImages && this.imageAlign == 4 && this.text.length() > 0) {
            this.imageAlign = 1;
        }
    }

    public void setImages(String[] stringArray) {
        if (stringArray != null && stringArray.length > 1) {
            this.setImages(stringArray[0], stringArray[1 % stringArray.length], stringArray[2 % stringArray.length]);
            this.getMaxButtonImageWidth();
            if (this.useImages && this.imageAlign == 4 && this.text.length() > 0) {
                this.imageAlign = 1;
            }
        }
    }

    public void setImages(String string, int n) {
        n = PApplet.constrain((int)n, (int)1, (int)3);
        if (string != null && n > 0) {
            PImage pImage = this.winApp.loadImage(string);
            if (pImage == null) {
                if (G4P.messages) {
                    System.out.println("Can't find button image file");
                }
            } else {
                this.setImages(pImage, n);
            }
            this.getMaxButtonImageWidth();
            if (this.useImages && this.imageAlign == 4 && this.text.length() > 0) {
                this.imageAlign = 1;
            }
        }
    }

    public void setImages(PImage pImage, PImage pImage2, PImage pImage3) {
        this.bimage[0] = pImage;
        this.bimage[1] = pImage2;
        this.bimage[2] = pImage3;
        this.getMaxButtonImageWidth();
        if (this.useImages && this.imageAlign == 4 && this.text.length() > 0) {
            this.imageAlign = 1;
        }
    }

    public void setImages(PImage[] pImageArray) {
        if (pImageArray != null) {
            int n;
            for (n = 0; n < pImageArray.length; ++n) {
                this.bimage[n] = pImageArray[n];
            }
            for (n = pImageArray.length; n < 3; ++n) {
                this.bimage[n] = this.bimage[pImageArray.length - 1];
            }
            this.getMaxButtonImageWidth();
            if (this.useImages && this.imageAlign == 4 && this.text.length() > 0) {
                this.imageAlign = 1;
            }
        }
    }

    public void setImages(PImage pImage, int n) {
        if (pImage != null && n > 0) {
            int n2;
            int n3 = pImage.width / n;
            for (n2 = 0; n2 < n; ++n2) {
                this.bimage[n2] = new PImage(n3, pImage.height, 2);
                this.bimage[n2].copy(pImage, n2 * n3, 0, n3, pImage.height, 0, 0, n3, pImage.height);
            }
            for (n2 = n; n2 < 3; ++n2) {
                this.bimage[n2] = this.bimage[n - 1];
            }
            this.getMaxButtonImageWidth();
            if (this.useImages && this.imageAlign == 4 && this.text.length() > 0) {
                this.imageAlign = 1;
            }
        }
    }

    public void setColorScheme(int n) {
        this.localColor = GCScheme.getColor(this.winApp, n);
    }

    public void setText(String string) {
        if (string != null && string != "") {
            if (this.useImages && this.imageAlign == 4) {
                this.setImageAlign(1);
            }
            this.text = string;
            this.winApp.textFont(this.localFont, (float)this.localFont.getSize());
            this.textWidth = Math.round(this.winApp.textWidth(string));
            this.calcAlignX();
            this.calcAlignY();
        }
    }

    public void setFont(String string, int n) {
        this.setFont(string, n, true);
    }

    public void setFont(String string, int n, boolean bl) {
        int n2 = this.textWidth;
        int n3 = this.localFont.getSize();
        this.localFont = GFont.getFont(this.winApp, string, n);
        if (bl) {
            if (n > n3) {
                this.height += (float)(n - n3);
            }
            this.setText(this.text);
            if (this.textWidth > n2) {
                this.width += (float)(this.textWidth - n2);
            }
        }
        this.calcAlignX();
        this.calcAlignY();
    }

    public void setImageAlign(int n) {
        if (this.useImages) {
            switch (n) {
                case 1: {
                    this.imageAlign = n;
                    this.imgAlignX = 4;
                    break;
                }
                case 2: {
                    this.imageAlign = n;
                    this.imgAlignX = (int)(this.width - (float)this.btnImgWidth - 4.0f);
                    break;
                }
                case 4: {
                    if (this.text.length() == 0) {
                        this.imageAlign = n;
                        this.imgAlignX = (int)((this.width - (float)this.btnImgWidth) / 2.0f);
                        break;
                    }
                    this.imageAlign = 1;
                    this.imgAlignX = 4;
                }
            }
        }
        this.calcAlignX();
    }

    protected void calcAlignX() {
        int n = (int)this.width;
        int n2 = 0;
        if (this.useImages) {
            n -= this.btnImgWidth;
            if (this.imageAlign == 1) {
                n2 = this.btnImgWidth;
            }
        }
        switch (this.textAlignHorz) {
            case 1: {
                this.alignX = n2 + this.border + 4;
                break;
            }
            case 2: {
                this.alignX = n2 + n - this.textWidth - this.border - 4;
                break;
            }
            case 4: {
                this.alignX = n2 + this.border + 4 + (n - this.textWidth) / 2;
            }
        }
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        if (this.border == 0) {
            this.winApp.strokeWeight(0.0f);
            this.winApp.noStroke();
        } else {
            this.winApp.strokeWeight((float)this.border);
            this.winApp.stroke(this.localColor.btnBorder);
        }
        switch (this.status) {
            case 0: {
                this.winApp.fill(this.localColor.btnOff);
                break;
            }
            case 1: {
                this.winApp.fill(this.localColor.btnOver);
                break;
            }
            case 2: {
                this.winApp.fill(this.localColor.btnDown);
            }
        }
        this.winApp.rect((float)point.x, (float)point.y, this.width, this.height);
        if (this.useImages && this.bimage != null && this.bimage[this.status] != null) {
            this.winApp.image(this.bimage[this.status], (float)(point.x + this.imgAlignX), (float)point.y + (this.height - (float)this.bimage[this.status].height) / 2.0f);
        }
        this.winApp.noStroke();
        this.winApp.fill(this.localColor.btnFont);
        this.winApp.textFont(this.localFont, (float)this.localFont.getSize());
        this.winApp.text(this.text, (float)(point.x + this.alignX), (float)(point.y + this.alignY), this.width, this.height);
        this.winApp.popStyle();
    }

    public void fireAllEvents(boolean bl) {
        this.reportAllButtonEvents = bl;
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (!this.visible || !this.enabled) {
            return;
        }
        boolean bl = this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (bl) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (focusIsWith == this || !bl || this.z <= GButton.focusObjectZ()) break;
                this.mdx = this.winApp.mouseX;
                this.mdy = this.winApp.mouseY;
                this.status = 2;
                this.takeFocus();
                this.eventType = 770;
                if (!this.reportAllButtonEvents) break;
                this.fireEvent();
                break;
            }
            case 500: {
                if (focusIsWith != this) break;
                this.status = 0;
                this.loseFocus(null);
                this.eventType = 769;
                this.fireEvent();
                break;
            }
            case 502: {
                if (focusIsWith != this || !this.mouseHasMoved(this.winApp.mouseX, this.winApp.mouseY)) break;
                this.loseFocus(null);
                if (this.isOver(this.winApp.mouseX, this.winApp.mouseY)) {
                    this.eventType = 769;
                    this.fireEvent();
                } else if (this.reportAllButtonEvents) {
                    this.eventType = 771;
                    this.fireEvent();
                }
                this.status = 0;
                break;
            }
            case 503: {
                this.status = this.isOver(this.winApp.mouseX, this.winApp.mouseY) ? 1 : 0;
            }
        }
    }
}

