/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GComponent;
import guicomponents.GFont;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import processing.core.PApplet;

public class GPanel
extends GComponent {
    protected boolean tabOnly = true;
    protected int tabHeight;
    protected float dockX;
    protected float dockY;
    protected boolean beingDragged = false;

    public GPanel(PApplet pApplet, String string, int n, int n2, int n3, int n4) {
        super(pApplet, n, n2);
        this.panelCtorCore(string, n3, n4);
    }

    private void panelCtorCore(String string, int n, int n2) {
        this.children = new LinkedList();
        this.setText(string);
        this.tabHeight = (int)(1.2f * (float)this.localFont.getSize() + 4.0f);
        this.constrainPanelPosition();
        this.opaque = true;
        this.dockX = this.x;
        this.dockY = this.y;
        this.width = n;
        this.height = n2;
        this.z = 1024;
        this.createEventHandler(G4P.mainWinApp, "handlePanelEvents", new Class[]{GPanel.class});
        this.registerAutos_DMPK(true, true, false, false);
    }

    public void setFont(String string, int n) {
        this.localFont = GFont.getFont(this.winApp, string, n);
        this.tabHeight = (int)(1.2f * (float)this.localFont.getSize() + 4.0f);
        this.setText(this.text);
    }

    public void bringToFront() {
        if (this.parent != null) {
            this.parent.bringToFront();
        }
        G4P.moveToFrontForDraw(this);
    }

    protected void loseFocus(GComponent gComponent) {
        focusIsWith = null;
        this.beingDragged = false;
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        this.winApp.pushMatrix();
        this.winApp.translate((float)point.x, (float)point.y);
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        this.winApp.noStroke();
        if (this.border > 0) {
            this.winApp.strokeWeight((float)this.border);
            this.winApp.stroke(this.localColor.pnlBorder);
        }
        this.winApp.fill(this.localColor.pnlTabBack);
        int n = (int)(this.tabOnly ? (float)(this.textWidth + 16) : this.width);
        this.winApp.rect(0.0f, (float)(-this.tabHeight), (float)n, (float)this.tabHeight);
        this.winApp.fill(this.localColor.pnlFont);
        this.winApp.textFont(this.localFont, (float)this.localFont.getSize());
        this.winApp.text(this.text, 4.0f, (float)(-(this.tabHeight + this.localFont.getSize()) / 2 - 2), (float)this.textWidth, (float)this.tabHeight);
        if (!this.tabOnly && this.opaque) {
            this.winApp.fill(this.localColor.pnlBack);
            this.winApp.rect(0.0f, 0.0f, this.width, this.height);
        }
        this.winApp.popStyle();
        this.winApp.popMatrix();
        if (!this.tabOnly) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((GComponent)iterator.next()).draw();
            }
        }
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (!this.visible || !this.enabled) {
            return;
        }
        boolean bl = this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (bl) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (focusIsWith != this && bl && this.z >= GPanel.focusObjectZ()) {
                    this.mdx = this.winApp.mouseX;
                    this.mdy = this.winApp.mouseY;
                    this.takeFocus();
                    this.beingDragged = true;
                }
                if (focusIsWith == null || focusIsWith == this || this.z != GPanel.focusObjectZ() || !this.isOverPanel(this.winApp.mouseX, this.winApp.mouseY)) break;
                focusIsWith.loseFocus(null);
                break;
            }
            case 500: {
                if (focusIsWith != this) break;
                this.tabOnly = !this.tabOnly;
                this.setCollapsed(this.tabOnly);
                this.eventType = this.tabOnly ? 513 : 514;
                this.fireEvent();
                if (this.tabOnly) {
                    this.x = this.dockX;
                    this.y = this.dockY;
                } else {
                    this.dockX = this.x;
                    this.dockY = this.y;
                    if (this.y + this.height > (float)this.winApp.getHeight()) {
                        this.y = (float)this.winApp.getHeight() - this.height;
                    }
                    if (this.x + this.width > (float)this.winApp.getWidth()) {
                        this.x = (float)this.winApp.getWidth() - this.width;
                    }
                }
                this.loseFocus(null);
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                break;
            }
            case 502: {
                if (focusIsWith != this || !this.mouseHasMoved(this.winApp.mouseX, this.winApp.mouseY)) break;
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                this.loseFocus(null);
                break;
            }
            case 506: {
                if (focusIsWith != this || this.parent != null) break;
                this.x += (float)(this.winApp.mouseX - this.winApp.pmouseX);
                this.y += (float)(this.winApp.mouseY - this.winApp.pmouseY);
                this.beingDragged = true;
                this.eventType = 515;
                this.fireEvent();
                this.constrainPanelPosition();
                if (this.tabOnly) break;
                this.dockX = this.x;
                this.dockY = this.y;
            }
        }
    }

    public boolean isDragging() {
        return this.beingDragged;
    }

    private void constrainPanelPosition() {
        int n = (int)(this.tabOnly ? (float)(this.textWidth + 8) : this.width);
        int n2 = (int)(this.tabOnly ? 0.0f : this.height);
        if (this.x < 0.0f) {
            this.x = 0.0f;
        } else if (this.x + (float)n > (float)this.winApp.getWidth()) {
            this.x = this.winApp.getWidth() - n;
        }
        if (this.y - (float)this.tabHeight < 0.0f) {
            this.y = this.tabHeight;
        } else if (this.y + (float)n2 > (float)this.winApp.getHeight()) {
            this.y = this.winApp.getHeight() - n2;
        }
    }

    public boolean isOver(int n, int n2) {
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        int n3 = (int)(this.tabOnly ? (float)(this.textWidth + 8) : this.width);
        return n >= point.x && n <= point.x + n3 && n2 >= point.y - this.tabHeight && n2 <= point.y;
    }

    public boolean isOverPanel(int n, int n2) {
        if (this.tabOnly) {
            return this.isOver(n, n2);
        }
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        return n >= point.x && (float)n <= (float)point.x + this.width && n2 >= point.y - this.tabHeight && (float)n2 <= (float)point.y + this.height;
    }

    public void setControlsEnabled(boolean bl) {
        if (this.children != null) {
            for (GComponent gComponent : this.children) {
                gComponent.setEnabled(bl);
            }
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        if (!bl) {
            this.setControlsEnabled(false);
        }
    }

    public void setAlpha(int n) {
        this.localColor.setAlpha(n);
        if (!this.children.isEmpty()) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((GComponent)iterator.next()).setAlpha(n);
            }
        }
    }

    public void setCollapsed(boolean bl) {
        this.tabOnly = bl;
        if (!this.tabOnly) {
            this.constrainPanelPosition();
        } else {
            this.setControlsEnabled(false);
        }
    }

    public boolean isCollapsed() {
        return this.tabOnly;
    }

    public int getTabHeight() {
        return this.tabHeight;
    }
}

