/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GComponent;
import java.awt.event.MouseEvent;
import processing.core.PApplet;

public abstract class GSlider
extends GComponent {
    public static final int INTEGER = 0;
    public static final int DECIMAL = 1;
    public static final int EXPONENT = 2;
    protected float init;
    protected float maxValue = 0.0f;
    protected float minValue = 100.0f;
    protected float value;
    protected int _valueType = 0;
    protected int thumbMin;
    protected int thumbMax;
    protected int thumbPos;
    protected int thumbTargetPos;
    protected int thumbSize = 10;
    protected int thumbInertia = 1;
    protected int offset;
    protected boolean isValueChanging = false;

    public GSlider(PApplet pApplet, int n, int n2, int n3, int n4) {
        super(pApplet, n, n2);
        this.width = n3;
        this.height = n4;
        this.z = 24;
        this.registerAutos_DMPK(true, true, true, false);
        this.createEventHandler(G4P.mainWinApp, "handleSliderEvents", new Class[]{GSlider.class});
    }

    public GSlider(PApplet pApplet, int n, int n2) {
        super(pApplet, n, n2);
    }

    public void setLimits(int n, int n2, int n3) {
        this.minValue = Math.min(n2, n3);
        this.maxValue = Math.max(n2, n3);
        this.init = Math.round(PApplet.constrain((float)n, (float)this.minValue, (float)this.maxValue));
        if ((float)(this.thumbMax - this.thumbMin) < this.maxValue - this.minValue && G4P.messages) {
            System.out.println(this.getClass().getSimpleName() + ".setLimits");
            System.out.println("  not all values in the range " + n2 + " - " + n3 + " can be returned");
            System.out.print("  either reduce the range or make the slider ");
            if (this.getClass().getSimpleName().equals("GHorzSlider")) {
                System.out.print("width");
            } else {
                System.out.print("height");
            }
            System.out.println(" at least " + (n3 - n2 + this.thumbSize));
        }
        this.thumbTargetPos = this.thumbPos;
        this.setValue(n, true);
        this._valueType = 0;
    }

    public void setLimits(float f, float f2, float f3) {
        this.minValue = Math.min(f2, f3);
        this.maxValue = Math.max(f2, f3);
        this.init = PApplet.constrain((float)f, (float)this.minValue, (float)this.maxValue);
        this.thumbTargetPos = this.thumbPos;
        this.setValue(this.init, true);
        if (this._valueType == 0) {
            this._valueType = 1;
        }
    }

    public void mouseEvent(MouseEvent mouseEvent) {
    }

    public boolean isOver(int n, int n2) {
        return false;
    }

    public int getMinValue() {
        return Math.round(this.minValue);
    }

    public int getMaxValue() {
        return Math.round(this.maxValue);
    }

    public void setValueType(int n) {
        this._valueType = n;
    }

    public int getValueType() {
        return this._valueType;
    }

    public int getValue() {
        return Math.round(this.value);
    }

    public float getValuef() {
        if (this._valueType == 0) {
            return Math.round(this.value);
        }
        return this.value;
    }

    public boolean isValueChanging() {
        return this.isValueChanging;
    }

    public void setValue(int n) {
        this.value = PApplet.constrain((float)n, (float)this.minValue, (float)this.maxValue);
        this.thumbTargetPos = (int)PApplet.map((float)this.value, (float)this.minValue, (float)this.maxValue, (float)this.thumbMin, (float)this.thumbMax);
    }

    public void setValue(int n, boolean bl) {
        this.setValue(n);
        if (bl) {
            this.thumbPos = this.thumbTargetPos;
        }
    }

    public void setValue(float f) {
        this.value = PApplet.constrain((float)f, (float)this.minValue, (float)this.maxValue);
        this.thumbTargetPos = (int)PApplet.map((float)this.value, (float)this.minValue, (float)this.maxValue, (float)this.thumbMin, (float)this.thumbMax);
    }

    public void setValue(float f, boolean bl) {
        this.setValue(f);
        if (bl) {
            this.thumbPos = this.thumbTargetPos;
        }
    }

    public void setInertia(int n) {
        this.thumbInertia = PApplet.constrain((int)n, (int)1, (int)100);
    }

    public void pre() {
        int n = this.thumbInertia;
        if (this.thumbPos == this.thumbTargetPos) {
            this.isValueChanging = false;
        } else {
            int n2;
            while ((n2 = (this.thumbTargetPos - this.thumbPos) / n) == 0 && --n > 0) {
            }
            if (n2 != 0) {
                this.thumbPos += n2;
                float f = PApplet.map((float)this.thumbPos, (float)this.thumbMin, (float)this.thumbMax, (float)this.minValue, (float)this.maxValue);
                boolean bl = f != this.value;
                this.value = f;
                if (bl) {
                    this.eventType = 257;
                    this.fireEvent();
                }
            } else {
                this.isValueChanging = false;
            }
        }
    }

    public void draw() {
    }
}

