/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GComponent;
import guicomponents.GSlider;
import java.awt.Point;
import java.awt.event.MouseEvent;
import processing.core.PApplet;

public class GVertSlider
extends GSlider {
    public GVertSlider(PApplet pApplet, int n, int n2, int n3, int n4) {
        super(pApplet, n, n2, n3, n4);
        this.initThumbDetails();
        this.z = 24;
    }

    protected void initThumbDetails() {
        this.thumbSize = (int)Math.max(20.0f, this.height / 20.0f);
        this.thumbMin = this.thumbSize / 2;
        this.thumbMax = (int)(this.height - (float)(this.thumbSize / 2));
        this.thumbTargetPos = this.thumbPos;
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        this.winApp.noStroke();
        this.winApp.fill(this.localColor.sdrTrack);
        this.winApp.rect((float)point.x, (float)point.y, this.width, this.height);
        this.winApp.fill(this.localColor.sdrThumb);
        this.winApp.rect((float)point.x, (float)(point.y + this.thumbPos - this.thumbSize / 2), this.width, (float)this.thumbSize);
        if (this.border != 0) {
            this.winApp.strokeWeight((float)this.border);
            this.winApp.noFill();
            this.winApp.stroke(this.localColor.sdrBorder);
            this.winApp.rect((float)point.x, (float)point.y, this.width, this.height);
        }
        this.winApp.popStyle();
    }

    protected void loseFocus(GComponent gComponent) {
        if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        String string = this.parent == null ? "" : this.parent.getClass().getSimpleName();
        focusIsWith = string.equalsIgnoreCase("GCombo") ? this.parent : null;
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (!this.visible || !this.enabled) {
            return;
        }
        boolean bl = this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (bl || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (focusIsWith == this || !bl || this.z <= GVertSlider.focusObjectZ()) break;
                this.mdx = this.winApp.mouseX;
                this.mdy = this.winApp.mouseY;
                this.takeFocus();
                break;
            }
            case 500: {
                if (focusIsWith != this) break;
                this.loseFocus(null);
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                break;
            }
            case 502: {
                if (focusIsWith != this || !this.mouseHasMoved(this.winApp.mouseX, this.winApp.mouseY)) break;
                this.loseFocus(null);
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                break;
            }
            case 506: {
                if (focusIsWith != this) break;
                this.isValueChanging = true;
                Point point = new Point(0, 0);
                this.calcAbsPosition(point);
                this.thumbTargetPos = PApplet.constrain((int)(this.winApp.mouseY - this.offset - point.y), (int)this.thumbMin, (int)this.thumbMax);
            }
        }
    }

    public boolean isOver(int n, int n2) {
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        if (n >= point.x && (float)n <= (float)point.x + this.width && n2 >= point.y + this.thumbPos - this.thumbSize / 2 && n2 <= point.y + this.thumbPos + this.thumbSize / 2) {
            this.offset = n2 - (point.y + this.thumbPos);
            return true;
        }
        return false;
    }
}

