/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GFont;
import guicomponents.GSlider;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import processing.core.PApplet;
import processing.core.PImage;

public class GWSlider
extends GSlider {
    public String unit;
    protected PImage _leftEnd;
    protected PImage _thumb;
    protected PImage _thumb_mouseover;
    protected PImage _rightEnd;
    protected PImage _centre;
    protected String _skin;
    protected int _numTicks;
    protected int _tickLength;
    protected int _tickOffset;
    protected int _precision;
    protected boolean _renderMaxMinLabel;
    protected boolean _renderValueLabel;
    protected boolean _stickToTicks;
    protected String[] _tickLabels;
    protected boolean _isMouseOverThumb;
    protected boolean _mousePressedOverThumb;
    protected int[] _tickPositions;
    protected float[] _tickValues;
    protected int _tickColour;
    protected int _fontColour;
    protected int _currTickStuck;

    public void setPrecision(int n) {
        this._precision = PApplet.constrain((int)n, (int)0, (int)6);
    }

    public void setValue(int n) {
        this.value = PApplet.constrain((float)n, (float)this.minValue, (float)this.maxValue);
        this.thumbTargetPos = (int)PApplet.map((float)this.value, (float)this.minValue, (float)this.maxValue, (float)this.thumbMin, (float)this.thumbMax);
        if (this._stickToTicks) {
            this._stickToTickByValue(this.value);
        }
    }

    public void setValue(float f) {
        this.value = PApplet.constrain((float)f, (float)this.minValue, (float)this.maxValue);
        this.thumbTargetPos = (int)PApplet.map((float)this.value, (float)this.minValue, (float)this.maxValue, (float)this.thumbMin, (float)this.thumbMax);
        if (this._stickToTicks) {
            this._stickToTickByValue(this.value);
        }
    }

    public void setValueToTickNumber(int n) {
        if (this._stickToTicks) {
            n = PApplet.constrain((int)n, (int)0, (int)this._numTicks);
            float f = PApplet.map((float)n, (float)0.0f, (float)this._numTicks, (float)this.minValue, (float)this.maxValue);
            this._stickToTickByValue(f);
        }
    }

    public void setTickCount(int n) {
        this._numTicks = n;
        this._tickLabels = null;
        this._calcTickPositions();
        if (this._stickToTicks) {
            this._stickToTickByValue(this.value);
        }
    }

    public void setTickLabels(String[] stringArray) {
        this._tickLabels = stringArray;
        this._numTicks = stringArray.length - 1;
        this._calcTickPositions();
        if (this._stickToTicks) {
            this._stickToTickByValue(this.value);
        }
    }

    public void setStickToTicks(boolean bl) {
        this._stickToTicks = bl;
        if (bl) {
            this._stickToTickByValue(this.value);
        }
        this._calcTickPositions();
    }

    public void setTickLength(int n) {
        this._tickLength = PApplet.constrain((int)n, (int)1, (int)10);
        this._calcControlWidthHeight();
    }

    public void setRenderMaxMinLabel(boolean bl) {
        this._renderMaxMinLabel = bl;
        this._calcControlWidthHeight();
    }

    public void setRenderValueLabel(boolean bl) {
        this._renderValueLabel = bl;
    }

    public void setTickColour(int n, int n2, int n3) {
        this.setTickColour(this.winApp.color(n, n2, n3));
    }

    public void setTickColour(int n) {
        this._tickColour = n;
    }

    public void setFontColour(int n, int n2, int n3) {
        this.setFontColour(this.winApp.color(n, n2, n3));
    }

    public void setFontColour(int n) {
        this._fontColour = n;
    }

    public GWSlider(PApplet pApplet, int n, int n2, int n3) {
        this(pApplet, "gwSlider", n, n2, n3);
    }

    public GWSlider(PApplet pApplet, String string, int n, int n2, int n3) {
        super(pApplet, n, n2);
        this.width = n3;
        this.height = 1.0f;
        this.z = 24;
        this._skin = string == null ? "gwSlider" : string;
        this._numTicks = 5;
        this._tickLength = 5;
        this._tickOffset = 3;
        this._renderMaxMinLabel = true;
        this._renderValueLabel = true;
        this._stickToTicks = false;
        this._precision = 2;
        this._valueType = 0;
        this._tickColour = this.winApp.color(0);
        this._fontColour = this.winApp.color(0);
        this.unit = "";
        this._leftEnd = this.winApp.loadImage(this._skin + "/end_left.png");
        this._rightEnd = this.winApp.loadImage(this._skin + "/end_right.png");
        this._thumb = this.winApp.loadImage(this._skin + "/handle.png");
        this._thumb_mouseover = this.winApp.loadImage(this._skin + "/handle_mouseover.png");
        PImage pImage = this.winApp.loadImage(this._skin + "/centre.png");
        String string2 = "";
        if (this._leftEnd == null) {
            string2 = string2 + "end_left.png\n";
        }
        if (this._rightEnd == null) {
            string2 = string2 + "end_right.png\n";
        }
        if (this._thumb == null) {
            string2 = string2 + "handle.png\n";
        }
        if (this._thumb_mouseover == null) {
            string2 = string2 + "handle_mouseover.png\n";
        }
        if (pImage == null) {
            string2 = string2 + "centre.png\n";
        }
        if (string2 != "") {
            PApplet.println((String)("The following files could not be found for the skin " + this._skin + ": \n" + string2 + "\nCheck that these files are correctly placed in the data directory under a folder with" + " the same name as the skin used.\n"));
        }
        if (pImage.width != 1) {
            PApplet.println((String)"The supplied centre image for this skin is not of width 1px.");
        }
        if (pImage.height != this._leftEnd.height || pImage.height != this._rightEnd.height) {
            PApplet.println((String)"The image components of the slider are not all the same height.");
        }
        this.height = pImage.height;
        int n4 = n3 - this._leftEnd.width - this._rightEnd.width;
        if (n4 < 0) {
            n4 = 1;
        }
        this._centre = new PImage(n4, pImage.height);
        pImage.loadPixels();
        this._centre.loadPixels();
        for (int i = 0; i < this._centre.height; ++i) {
            for (int j = 0; j < this._centre.width; ++j) {
                this._centre.pixels[i * this._centre.width + j] = pImage.pixels[i];
            }
        }
        this._centre.updatePixels();
        pImage.updatePixels();
        this.thumbMin = this._leftEnd.width;
        this.thumbMax = this._leftEnd.width + this._centre.width;
        this.setLimits(50.0f, 0.0f, 100.0f);
        this.localFont = globalFont;
        this._calcControlWidthHeight();
        this._calcTickPositions();
        this.z = 24;
        this.createEventHandler(G4P.mainWinApp, "handleSliderEvents", new Class[]{GSlider.class});
        this.registerAutos_DMPK(true, true, true, false);
    }

    protected void _calcControlWidthHeight() {
        this.width = this._leftEnd.width + this._centre.width + this._rightEnd.width;
        this.height = this._centre.height + this._tickLength + this._tickOffset;
        if (this._renderMaxMinLabel) {
            this.height += (float)this.localFont.getSize();
        }
    }

    protected void _calcTickPositions() {
        Point point = new Point();
        this.calcAbsPosition(point);
        float f = this.maxValue - this.minValue;
        float f2 = f / (float)this._numTicks;
        this._tickPositions = new int[this._numTicks + 1];
        this._tickValues = new float[this._numTicks + 1];
        for (int i = 0; i <= this._numTicks; ++i) {
            this._tickPositions[i] = Math.round(PApplet.map((float)(this.minValue + (float)i * f2), (float)this.minValue, (float)this.maxValue, (float)this.thumbMin, (float)this.thumbMax));
            this._tickValues[i] = this.minValue + (float)i * f2;
        }
    }

    protected void _stickToTickByValue(float f) {
        float f2 = this.maxValue - this.minValue;
        float f3 = f2 / (float)this._numTicks;
        int n = Math.round(PApplet.constrain((float)(f - this.minValue), (float)0.0f, (float)f2) / f3);
        this._currTickStuck = PApplet.constrain((int)n, (int)0, (int)this._numTicks);
        this.thumbTargetPos = this._tickPositions[this._currTickStuck];
        this.value = this.minValue + (float)this._currTickStuck * f3;
    }

    protected void _stickToTickByPosition(float f) {
        Point point = new Point();
        this.calcAbsPosition(point);
        float f2 = this.maxValue - this.minValue;
        float f3 = f2 / (float)this._numTicks;
        float f4 = PApplet.map((float)f, (float)this.thumbMin, (float)this.thumbMax, (float)this.minValue, (float)this.maxValue);
        int n = Math.round((f4 - this.minValue) / f3);
        this._currTickStuck = PApplet.constrain((int)n, (int)0, (int)(this._tickPositions.length - 1));
        this.thumbTargetPos = this._tickPositions[this._currTickStuck];
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (!this.visible || !this.enabled) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        bl = this.isOver(mouseEvent.getX(), mouseEvent.getY());
        if (bl) {
            bl2 = this.isOverThumb(mouseEvent.getX(), mouseEvent.getY());
            if (bl2 || focusIsWith == this) {
                cursorIsOver = this;
            } else if (cursorIsOver == this) {
                cursorIsOver = null;
            }
        } else {
            cursorIsOver = cursorIsOver == this ? null : cursorIsOver;
        }
        Point point = new Point();
        this.calcAbsPosition(point);
        switch (mouseEvent.getID()) {
            case 501: {
                if (focusIsWith == this || !bl || this.z <= GWSlider.focusObjectZ()) break;
                this.takeFocus();
                this._mousePressedOverThumb = bl2;
                break;
            }
            case 502: {
                if (focusIsWith == this) {
                    if (this._stickToTicks) {
                        this._stickToTickByPosition(this.winApp.mouseX - point.x);
                    } else {
                        this.thumbTargetPos = PApplet.constrain((int)(this.winApp.mouseX - point.x), (int)this.thumbMin, (int)this.thumbMax);
                    }
                    this.loseFocus(null);
                    this.eventType = 771;
                    this.fireEvent();
                }
                this._isMouseOverThumb = false;
                this._mousePressedOverThumb = false;
                break;
            }
            case 506: {
                if (focusIsWith != this || !this._mousePressedOverThumb) break;
                this.thumbTargetPos = PApplet.constrain((int)(this.winApp.mouseX - point.x), (int)this.thumbMin, (int)this.thumbMax);
                this.isValueChanging = true;
                break;
            }
            case 503: {
                this._isMouseOverThumb = this.isOverThumb(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && this.hasKeyFocus()) {
            if (keyEvent.getKeyCode() == 37) {
                if (this._stickToTicks) {
                    this._currTickStuck = PApplet.constrain((int)(this._currTickStuck - 1), (int)0, (int)(this._tickPositions.length - 1));
                    this.thumbTargetPos = this._tickPositions[this._currTickStuck];
                } else {
                    this.thumbTargetPos = PApplet.constrain((int)(this.thumbTargetPos - 1), (int)this.thumbMin, (int)this.thumbMax);
                }
            } else if (keyEvent.getKeyCode() == 39) {
                if (this._stickToTicks) {
                    this._currTickStuck = PApplet.constrain((int)(this._currTickStuck + 1), (int)0, (int)(this._tickPositions.length - 1));
                    this.thumbTargetPos = this._tickPositions[this._currTickStuck];
                } else {
                    this.thumbTargetPos = PApplet.constrain((int)(this.thumbTargetPos + 1), (int)this.thumbMin, (int)this.thumbMax);
                }
            }
        }
    }

    public boolean isOver(int n, int n2) {
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        float f = (float)((double)this._centre.height * 0.5 - (double)this._thumb.height * 0.5);
        return n >= point.x && (float)n <= (float)point.x + this.width && (float)n2 >= (float)point.y + f && (float)n2 <= (float)point.y + this.height - f;
    }

    public boolean isOverThumb(int n, int n2) {
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        Rectangle rectangle = new Rectangle((int)((double)(point.x + this.thumbPos) - 0.5 * (double)this._thumb.width - 1.0), (int)((double)point.y + 0.5 * (double)this._centre.height - 0.5 * (double)this._thumb.height - 1.0), this._thumb.width + 1, this._thumb.height + 1);
        return rectangle.contains(n, n2);
    }

    public void setFont(String string, int n) {
        this.localFont = GFont.getFont(this.winApp, string, n);
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        String string = null;
        switch (this._valueType) {
            case 0: {
                string = "%d%s";
                break;
            }
            case 1: {
                string = "%." + this._precision + "f%s";
                break;
            }
            case 2: {
                string = "%." + this._precision + "E%s";
            }
        }
        this.winApp.pushStyle();
        Point point = new Point();
        this.calcAbsPosition(point);
        this.winApp.imageMode(0);
        if (this._leftEnd != null) {
            this.winApp.image(this._leftEnd, (float)point.x, (float)point.y);
        }
        if (this._centre != null) {
            this.winApp.image(this._centre, (float)(point.x + this._leftEnd.width), (float)point.y);
        }
        if (this._rightEnd != null) {
            this.winApp.image(this._rightEnd, (float)(point.x + this._leftEnd.width + this._centre.width), (float)point.y);
        }
        this.winApp.textFont(this.localFont);
        this.winApp.textAlign(3);
        float f = (float)this._centre.width / (float)this._numTicks;
        this.winApp.stroke(this._tickColour);
        this.winApp.strokeWeight(1.0f);
        this.winApp.fill(this._fontColour);
        float f2 = point.y + this._centre.height + this._tickOffset + this._tickLength + this.localFont.getSize();
        for (int i = 0; i < this._tickPositions.length; ++i) {
            Point point2;
            if (this._tickLabels != null) {
                point2 = new Point(this._tickPositions[i], (int)f2);
                this.winApp.text(this._tickLabels[i], (float)(point.x + point2.x), (float)point2.y);
            } else if (i == 0 && this._renderMaxMinLabel) {
                point2 = new Point(point.x + this._leftEnd.width + Math.round((float)i * f), point.y + this._centre.height + this._tickOffset + this._tickLength + this.localFont.getSize());
                if (this._valueType == 0) {
                    this.winApp.text(String.format(string, Math.round(this.minValue), this.unit), (float)point2.x, (float)point2.y);
                } else {
                    this.winApp.text(String.format(string, Float.valueOf(this.minValue), this.unit), (float)point2.x, (float)point2.y);
                }
            } else if (i == this._numTicks && this._renderMaxMinLabel) {
                point2 = new Point(point.x + this._leftEnd.width + Math.round((float)i * f), point.y + this._centre.height + this._tickOffset + this._tickLength + this.localFont.getSize());
                if (this._valueType == 0) {
                    this.winApp.text(String.format(string, Math.round(this.maxValue), this.unit), (float)point2.x, (float)point2.y);
                } else {
                    this.winApp.text(String.format(string, Float.valueOf(this.maxValue), this.unit), (float)point2.x, (float)point2.y);
                }
            }
            this.winApp.beginShape(4);
            this.winApp.vertex((float)(point.x + this._tickPositions[i]), (float)(point.y + this._centre.height + this._tickOffset));
            this.winApp.vertex((float)(point.x + this._tickPositions[i]), (float)(point.y + this._centre.height + this._tickOffset + this._tickLength));
            this.winApp.endShape();
            this.winApp.pushStyle();
            this.winApp.stroke(230);
            this.winApp.beginShape(4);
            this.winApp.vertex((float)(point.x + this._tickPositions[i] + 1), (float)(point.y + this._centre.height + this._tickOffset));
            this.winApp.vertex((float)(point.x + this._tickPositions[i] + 1), (float)(point.y + this._centre.height + this._tickOffset + this._tickLength));
            this.winApp.endShape();
            this.winApp.popStyle();
            if (this._thumb != null) {
                if (!this._isMouseOverThumb) {
                    this.winApp.image(this._thumb, (float)((long)(point.x + this.thumbPos) - Math.round((double)this._thumb.width * 0.5) + 1L), (float)((double)point.y + 0.5 * (double)this._centre.height - 0.5 * (double)this._thumb.height));
                } else {
                    this.winApp.image(this._thumb_mouseover, (float)((long)(point.x + this.thumbPos) - Math.round((double)this._thumb_mouseover.width * 0.5) + 1L), (float)((double)point.y + 0.5 * (double)this._centre.height - 0.5 * (double)this._thumb_mouseover.height));
                }
            }
            if (!this._renderValueLabel) continue;
            if (this._valueType == 0) {
                this.winApp.text(String.format(string, Math.round(this.value), this.unit), (float)(point.x + this.thumbPos), (float)point.y - (float)this._thumb.height * 0.5f + 0.5f * (float)this._centre.height - 4.0f);
                continue;
            }
            this.winApp.text(String.format(string, Float.valueOf(this.value), this.unit), (float)(point.x + this.thumbPos), (float)point.y - (float)this._thumb.height * 0.5f + 0.5f * (float)this._centre.height - 4.0f);
        }
        this.winApp.popStyle();
    }
}

