/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.ImageGraphicAttribute;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.LinkedList;
import java.util.ListIterator;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StyledString
implements Serializable {
    private transient AttributedString styledText = null;
    private transient ImageGraphicAttribute spacer = null;
    private transient LineBreakMeasurer lineMeasurer = null;
    private transient LinkedList<TextLayoutInfo> linesInfo = new LinkedList();
    private transient Font font = null;
    private String plainText = "";
    private LinkedList<AttributeRun> baseStyle = new LinkedList();
    private LinkedList<AttributeRun> atrun = new LinkedList();
    private int wrapWidth = 100;
    private boolean invalidLayout = true;
    private boolean invalidText = true;
    private boolean justify = false;
    private float justifyRatio = 0.7f;
    private float textHeight = 0.0f;
    private float maxLineLength = 0.0f;
    private float maxLineHeight = 0.0f;
    private int nbrLines;

    public StyledString(String string) {
        this(null, string);
    }

    public StyledString(Graphics2D graphics2D, String string) {
        this.wrapWidth = Integer.MAX_VALUE;
        this.spacer = this.getParagraghSpacer(1);
        this.plainText = string.replaceAll("\n", " ");
        if (this.plainText.length() == 0) {
            this.plainText = " ";
        }
        this.styledText = new AttributedString(this.plainText);
        this.applyAttributes();
        if (graphics2D != null) {
            this.linesInfo = this.getLines(graphics2D);
        }
    }

    public StyledString(String string, int n) {
        this(null, string, n);
    }

    public StyledString(Graphics2D graphics2D, String string, int n) {
        this.wrapWidth = n > 0 && n < Integer.MAX_VALUE ? n : Integer.MAX_VALUE;
        this.spacer = this.getParagraghSpacer(this.wrapWidth);
        this.plainText = string;
        this.removeBlankLines();
        if (this.plainText.length() == 0) {
            this.plainText = " ";
        }
        this.styledText = new AttributedString(this.plainText);
        this.styledText = this.insertParagraphMarkers(this.plainText, this.styledText);
        this.applyAttributes();
        if (graphics2D != null) {
            this.linesInfo = this.getLines(graphics2D);
        }
    }

    public String getPlainText() {
        return this.plainText;
    }

    public int length() {
        return this.plainText.length();
    }

    public void setJustify(boolean bl) {
        if (this.justify != bl) {
            this.justify = bl;
            this.invalidLayout = true;
        }
    }

    public void setJustifyRatio(float f) {
        if (this.justifyRatio != f) {
            this.justifyRatio = f;
            if (this.justify) {
                this.invalidLayout = true;
            }
        }
    }

    private AttributedString insertParagraphMarkers(String string, AttributedString attributedString) {
        this.plainText = string;
        int n = string.indexOf(10, 0);
        while (n >= 0) {
            attributedString.addAttribute(TextAttribute.CHAR_REPLACEMENT, this.spacer, n, n + 1);
            n = string.indexOf(10, n + 1);
        }
        return attributedString;
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
        AttributeRun attributeRun = new AttributeRun(attribute, object, n, n2);
        this.atrun.addLast(attributeRun);
        this.applyAttributes();
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object) {
        this.addAttribute(attribute, object, -1, Integer.MAX_VALUE);
    }

    private void applyAttributes() {
        if (this.plainText.length() > 0) {
            for (AttributeRun attributeRun : this.baseStyle) {
                this.styledText.addAttribute(attributeRun.atype, attributeRun.value);
            }
            for (AttributeRun attributeRun : this.atrun) {
                if (attributeRun.end == Integer.MAX_VALUE) {
                    this.styledText.addAttribute(attributeRun.atype, attributeRun.value);
                    continue;
                }
                this.styledText.addAttribute(attributeRun.atype, attributeRun.value, attributeRun.start, attributeRun.end);
            }
        }
        this.invalidLayout = true;
    }

    public boolean insertCharacters(int n, String string) {
        int n2 = string.length();
        this.plainText = this.plainText.equals(" ") ? string : this.plainText.substring(0, n) + string + this.plainText.substring(n);
        this.removeBlankLines();
        for (AttributeRun attributeRun : this.atrun) {
            if (attributeRun.end >= Integer.MAX_VALUE || attributeRun.end < n) continue;
            AttributeRun attributeRun2 = attributeRun;
            Integer.valueOf(attributeRun2.end + n2);
            attributeRun2.end = attributeRun2.end;
            if (attributeRun.start < n) continue;
            attributeRun2 = attributeRun;
            Integer.valueOf(attributeRun2.start + n2);
            attributeRun2.start = attributeRun2.start;
        }
        this.invalidText = true;
        return true;
    }

    public void clearAllAttributes() {
        this.atrun.clear();
        this.invalidLayout = true;
    }

    public boolean deleteCharacters(int n, int n2) {
        if (n < 0 || n + n2 > this.plainText.length()) {
            return false;
        }
        this.plainText = n != 0 ? this.plainText.substring(0, n) + this.plainText.substring(n + n2) : this.plainText.substring(n + n2);
        this.removeBlankLines();
        if (this.plainText.length() == 0) {
            this.atrun.clear();
            this.plainText = " ";
            this.styledText = null;
        } else {
            ListIterator<AttributeRun> listIterator = this.atrun.listIterator(this.atrun.size());
            while (listIterator.hasPrevious()) {
                AttributeRun attributeRun = listIterator.previous();
                if (attributeRun.end >= Integer.MAX_VALUE || attributeRun.end < n) continue;
                AttributeRun attributeRun2 = attributeRun;
                Integer.valueOf(attributeRun2.end - n2);
                attributeRun2.end = attributeRun2.end;
                if (attributeRun.start > attributeRun.end) {
                    listIterator.remove();
                    continue;
                }
                if (attributeRun.start < n) continue;
                attributeRun2 = attributeRun;
                Integer.valueOf(attributeRun2.start - n2);
                attributeRun2.start = attributeRun2.start;
            }
        }
        this.invalidText = true;
        return true;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
            this.baseStyle.clear();
            this.baseStyle.add(new AttributeRun(TextAttribute.FAMILY, this.font.getFamily()));
            this.baseStyle.add(new AttributeRun(TextAttribute.SIZE, this.font.getSize()));
            if (this.font.isBold()) {
                this.baseStyle.add(new AttributeRun(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD));
            }
            if (this.font.isItalic()) {
                this.baseStyle.add(new AttributeRun(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE));
            }
        }
    }

    public LinkedList<TextLayoutInfo> getLines(Graphics2D graphics2D) {
        if (this.font != graphics2D.getFont()) {
            this.setFont(graphics2D.getFont());
            this.invalidText = true;
        }
        if (this.invalidText && this.plainText.length() > 0) {
            this.styledText = new AttributedString(this.plainText);
            this.styledText = this.insertParagraphMarkers(this.plainText, this.styledText);
            this.applyAttributes();
            this.invalidLayout = true;
        }
        if (this.invalidLayout) {
            if (this.plainText.length() == 0) {
                System.out.println("");
            }
            this.linesInfo.clear();
            if (this.plainText.length() > 0) {
                this.textHeight = 0.0f;
                this.maxLineLength = 0.0f;
                this.maxLineHeight = 0.0f;
                this.nbrLines = 0;
                AttributedCharacterIterator attributedCharacterIterator = this.styledText.getIterator(null, 0, this.plainText.length());
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                this.lineMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                float f = 0.0f;
                int n = 0;
                while (this.lineMeasurer.getPosition() < this.plainText.length()) {
                    float f2;
                    TextLayout textLayout = this.lineMeasurer.nextLayout(this.wrapWidth);
                    float f3 = textLayout.getVisibleAdvance();
                    if (this.justify && this.justify && f3 > this.justifyRatio * (float)this.wrapWidth) {
                        f2 = f3 > (float)this.wrapWidth ? f3 - (float)this.wrapWidth : (float)this.wrapWidth;
                        textLayout = textLayout.getJustifiedLayout(f2);
                    }
                    if ((f2 = this.getHeight(textLayout)) > this.maxLineHeight) {
                        this.maxLineHeight = f2;
                    }
                    this.textHeight += f2;
                    if (f3 <= (float)this.wrapWidth && f3 > this.maxLineLength) {
                        this.maxLineLength = f3;
                    }
                    this.linesInfo.add(new TextLayoutInfo(this.nbrLines, textLayout, n, textLayout.getCharacterCount(), f));
                    n += textLayout.getCharacterCount();
                    f += f2;
                    ++this.nbrLines;
                }
            }
            this.invalidLayout = false;
        }
        return this.linesInfo;
    }

    public int getNbrLines() {
        return this.nbrLines;
    }

    public float getTextAreaHeight() {
        return this.textHeight;
    }

    public float getMaxLineLength() {
        return this.maxLineLength;
    }

    public float getMaxLineHeight() {
        return this.maxLineHeight;
    }

    private float getHeight(TextLayout textLayout) {
        return textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
    }

    public float getWrapWidth() {
        return this.wrapWidth;
    }

    public TextLayoutHitInfo calculateFromXY(Graphics2D graphics2D, float f, float f2) {
        TextHitInfo textHitInfo = null;
        TextLayoutInfo textLayoutInfo = null;
        TextLayoutHitInfo textLayoutHitInfo = null;
        if (this.invalidLayout) {
            this.getLines(graphics2D);
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        textLayoutInfo = this.getLayoutFromYpos(f2);
        textHitInfo = textLayoutInfo.layout.hitTestChar(f, f2 -= textLayoutInfo.yPosInPara);
        textLayoutHitInfo = new TextLayoutHitInfo(textLayoutInfo, textHitInfo);
        return textLayoutHitInfo;
    }

    public TextLayoutInfo getTLIforLineNo(int n) {
        return this.linesInfo.get(n);
    }

    TextLayoutInfo getLayoutFromYpos(float f) {
        TextLayoutInfo textLayoutInfo = null;
        if (!this.linesInfo.isEmpty()) {
            for (int i = this.linesInfo.size() - 1; i >= 0; --i) {
                textLayoutInfo = this.linesInfo.get(i);
                if (textLayoutInfo.yPosInPara <= f) break;
            }
        }
        return textLayoutInfo;
    }

    TextLayoutInfo getTLIforCharNo(int n) {
        TextLayoutInfo textLayoutInfo = null;
        if (!this.linesInfo.isEmpty()) {
            for (int i = this.linesInfo.size() - 1; i >= 0; --i) {
                textLayoutInfo = this.linesInfo.get(i);
                if (textLayoutInfo.startCharIndex < n) break;
            }
        }
        return textLayoutInfo;
    }

    void removeBlankLines() {
        while (this.plainText.indexOf("\n\n") >= 0) {
            this.invalidText = true;
            this.plainText = this.plainText.replaceAll("\n\n", "\n");
        }
    }

    private ImageGraphicAttribute getParagraghSpacer(int n) {
        if (n == Integer.MAX_VALUE) {
            n = 1;
        }
        BufferedImage bufferedImage = new BufferedImage(n, 10, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(new Color(255, 255, 255, 0));
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        return new ImageGraphicAttribute(bufferedImage, -1);
    }

    public static void save(PApplet pApplet, StyledString styledString, String string) {
        try {
            OutputStream outputStream = pApplet.createOutput(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(styledString);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static StyledString load(PApplet pApplet, String string) {
        StyledString styledString = null;
        try {
            InputStream inputStream = pApplet.createInput(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            styledString = (StyledString)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return styledString;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.spacer = this.getParagraghSpacer(this.wrapWidth);
        this.styledText = new AttributedString(this.plainText);
        this.styledText = this.insertParagraphMarkers(this.plainText, this.styledText);
        this.applyAttributes();
    }

    protected class AttributeRun {
        public AttributedCharacterIterator.Attribute atype;
        public Object value;
        public Integer start;
        public Integer end;

        public AttributeRun(AttributedCharacterIterator.Attribute attribute, Object object) {
            this.atype = attribute;
            this.value = object;
            this.start = Integer.MIN_VALUE;
            this.end = Integer.MAX_VALUE;
        }

        public AttributeRun(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
            this.atype = attribute;
            this.value = object;
            this.start = n;
            this.end = n2;
        }

        public boolean sameType(AttributeRun attributeRun) {
            return this.atype == attributeRun.atype;
        }

        public boolean sameValue(AttributeRun attributeRun) {
            if (this.value instanceof Float && attributeRun.value instanceof Float) {
                return (Float)this.value == (Float)attributeRun.value;
            }
            if (this.value instanceof Integer && attributeRun.value instanceof Integer) {
                return (Integer)this.value == (Integer)attributeRun.value;
            }
            if (this.value instanceof String && attributeRun.value instanceof String) {
                return ((String)this.value).equalsIgnoreCase((String)attributeRun.value);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TextLayoutInfo
    implements Comparable<TextLayoutInfo> {
        public TextLayout layout;
        public int lineNo;
        public int startCharIndex;
        public int nbrChars;
        public float yPosInPara;

        public TextLayoutInfo(int n, TextLayout textLayout, int n2, int n3, float f) {
            this.lineNo = n;
            this.layout = textLayout;
            this.startCharIndex = n2;
            this.nbrChars = n3;
            this.yPosInPara = f;
        }

        @Override
        public int compareTo(TextLayoutInfo textLayoutInfo) {
            if (this.lineNo == textLayoutInfo.lineNo) {
                return 0;
            }
            return this.startCharIndex < textLayoutInfo.startCharIndex ? -1 : 1;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("{ Line starts @ " + this.startCharIndex);
            stringBuilder.append("  last index " + (this.startCharIndex + this.nbrChars + 1));
            stringBuilder.append("  (" + this.nbrChars + ")  ");
            return new String(stringBuilder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TextLayoutHitInfo
    implements Comparable<TextLayoutHitInfo> {
        public TextLayoutInfo tli;
        public TextHitInfo thi;

        public TextLayoutHitInfo(TextLayoutInfo textLayoutInfo, TextHitInfo textHitInfo) {
            this.tli = textLayoutInfo;
            this.thi = textHitInfo;
        }

        public TextLayoutHitInfo(TextLayoutHitInfo textLayoutHitInfo) {
            this.tli = textLayoutHitInfo.tli;
            this.thi = textLayoutHitInfo.thi;
        }

        public void copyFrom(TextLayoutHitInfo textLayoutHitInfo) {
            this.tli = textLayoutHitInfo.tli;
            this.thi = textLayoutHitInfo.thi;
        }

        public void setInfo(TextLayoutInfo textLayoutInfo, TextHitInfo textHitInfo) {
            this.tli = textLayoutInfo;
            this.thi = textHitInfo;
        }

        @Override
        public int compareTo(TextLayoutHitInfo textLayoutHitInfo) {
            int n = this.tli.compareTo(textLayoutHitInfo.tli);
            if (n != 0) {
                return n;
            }
            if (this.thi.equals(textLayoutHitInfo.thi)) {
                return 0;
            }
            if (this.thi.getCharIndex() != textLayoutHitInfo.thi.getCharIndex()) {
                return this.thi.getCharIndex() < textLayoutHitInfo.thi.getCharIndex() ? -1 : 1;
            }
            return this.thi.isLeadingEdge() ? -1 : 1;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.tli.toString());
            stringBuilder.append("  Hit char = " + this.thi.getCharIndex());
            return new String(stringBuilder);
        }
    }
}

