/*
 * Decompiled with CFR 0.152.
 */
package com.stromberglabs.jopensurf;

import com.stromberglabs.jopensurf.InterestPoint;
import java.io.Serializable;
import java.util.Arrays;

public class SURFInterestPoint
implements Serializable,
Cloneable,
InterestPoint {
    private static final long serialVersionUID = 1L;
    private float mX;
    private float mY;
    private float mScale;
    private float mOrientation;
    private int mLaplacian;
    private float[] mDescriptor;
    private float mDx;
    private float mDy;
    private int mClusterIndex;

    public SURFInterestPoint(float x, float y, float scale, int laplacian) {
        this.mX = x;
        this.mY = y;
        this.mScale = scale;
        this.mLaplacian = laplacian;
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public float getScale() {
        return this.mScale;
    }

    public float getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(float orientation) {
        this.mOrientation = orientation;
    }

    public int getLaplacian() {
        return this.mLaplacian;
    }

    public float[] getDescriptor() {
        return this.mDescriptor;
    }

    @Override
    public float[] getLocation() {
        return this.mDescriptor;
    }

    public void setDescriptor(float[] descriptor) {
        this.mDescriptor = descriptor;
    }

    public float getDx() {
        return this.mDx;
    }

    public void setDx(float dx) {
        this.mDx = dx;
    }

    public float getDy() {
        return this.mDy;
    }

    public void setDy(float dy) {
        this.mDy = dy;
    }

    public int getClusterIndex() {
        return this.mClusterIndex;
    }

    public void setClusterIndex(int clusterIndex) {
        this.mClusterIndex = clusterIndex;
    }

    @Override
    public double getDistance(InterestPoint point) {
        double sum = 0.0;
        if (point.getLocation() == null || this.mDescriptor == null) {
            return 3.4028234663852886E38;
        }
        int i = 0;
        while (i < this.mDescriptor.length) {
            double diff = this.mDescriptor[i] - point.getLocation()[i];
            sum += diff * diff;
            ++i;
        }
        return Math.sqrt(sum);
    }

    public Float getCoord(int dimension) {
        return Float.valueOf(this.mDescriptor[dimension]);
    }

    public int getDimensions() {
        return this.mDescriptor.length;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isEquivalentTo(SURFInterestPoint point) {
        boolean isEquivalent = true;
        isEquivalent &= this.mX == point.getX();
        isEquivalent &= this.mY == point.getY();
        isEquivalent &= this.mDx == point.getDx();
        isEquivalent &= this.mDy == point.getDy();
        isEquivalent &= this.mOrientation == point.getOrientation();
        isEquivalent &= this.mScale == point.getScale();
        isEquivalent &= this.mLaplacian == point.getLaplacian();
        return isEquivalent &= Arrays.equals(this.mDescriptor, point.getDescriptor());
    }
}

