/*
 * Decompiled with CFR 0.152.
 */
package com.stromberglabs.jopensurf;

import com.stromberglabs.jopensurf.FastHessian;
import com.stromberglabs.jopensurf.GaussianConstants;
import com.stromberglabs.jopensurf.ImageTransformUtils;
import com.stromberglabs.jopensurf.IntegralImage;
import com.stromberglabs.jopensurf.SURFInterestPoint;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class Surf
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int HESSIAN_OCTAVES = 5;
    private static final int HESSIAN_INIT_SAMPLE = 2;
    private static final float HESSIAN_THRESHOLD = 4.0E-4f;
    private static final float HESSIAN_BALANCE_VALUE = 0.81f;
    private transient BufferedImage mOriginalImage;
    private FastHessian mHessian;
    private List<SURFInterestPoint> mFreeOrientedPoints;
    private List<SURFInterestPoint> mUprightPoints;
    private List<SURFInterestPoint> mDescriptorFreeInterestPoints;
    private int mNumOctaves = 5;
    private float mThreshold = 4.0E-4f;
    private float mBalanceValue = 0.81f;
    private IntegralImage mIntegralImage;

    public Surf(BufferedImage image) {
        this(image, 0.81f, 4.0E-4f, 5);
    }

    public Surf(BufferedImage image, float balanceValue, float threshold, int octaves) {
        this.mOriginalImage = image;
        this.mNumOctaves = octaves;
        this.mBalanceValue = balanceValue;
        this.mThreshold = threshold;
        this.mIntegralImage = new IntegralImage(this.mOriginalImage);
        this.mHessian = new FastHessian(this.mIntegralImage, this.mNumOctaves, 2, this.mThreshold, this.mBalanceValue);
        this.mDescriptorFreeInterestPoints = this.mHessian.getIPoints();
    }

    public List<SURFInterestPoint> getUprightInterestPoints() {
        return this.getPoints(true);
    }

    public List<SURFInterestPoint> getFreeOrientedInterestPoints() {
        return this.getPoints(false);
    }

    private List<SURFInterestPoint> getPoints(boolean upright) {
        List<SURFInterestPoint> points;
        List<SURFInterestPoint> list = points = upright ? this.mUprightPoints : this.mFreeOrientedPoints;
        if (points == null) {
            points = this.getDescriptorFreeInterestPoints();
            if (upright) {
                this.mUprightPoints = points;
            } else {
                this.mFreeOrientedPoints = points;
            }
            for (SURFInterestPoint point : points) {
                this.getOrientation(point);
                this.getMDescriptor(point, upright);
            }
        }
        return points;
    }

    private List<SURFInterestPoint> getDescriptorFreeInterestPoints() {
        ArrayList<SURFInterestPoint> points = new ArrayList<SURFInterestPoint>(this.mDescriptorFreeInterestPoints.size());
        for (SURFInterestPoint point : this.mDescriptorFreeInterestPoints) {
            try {
                points.add((SURFInterestPoint)point.clone());
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return points;
    }

    private float haarX(int row, int column, int s) {
        return ImageTransformUtils.BoxIntegral(this.mIntegralImage, row - s / 2, column, s, s / 2) - 1.0f * ImageTransformUtils.BoxIntegral(this.mIntegralImage, row - s / 2, column - s / 2, s, s / 2);
    }

    private float haarY(int row, int column, int s) {
        return ImageTransformUtils.BoxIntegral(this.mIntegralImage, row, column - s / 2, s / 2, s) - 1.0f * ImageTransformUtils.BoxIntegral(this.mIntegralImage, row - s / 2, column - s / 2, s / 2, s);
    }

    private void getOrientation(SURFInterestPoint input) {
        float scale = input.getScale();
        int s = Math.round(scale);
        int r = Math.round(input.getY());
        int c = Math.round(input.getX());
        ArrayList<Double> xHaarResponses = new ArrayList<Double>();
        ArrayList<Double> yHaarResponses = new ArrayList<Double>();
        ArrayList<Double> angles = new ArrayList<Double>();
        int i = -6;
        while (i <= 6) {
            int j = -6;
            while (j <= 6) {
                if (i * i + j * j < 36) {
                    double gauss = GaussianConstants.Gauss25[Math.abs(i)][Math.abs(j)];
                    double xHaarResponse = gauss * (double)this.haarX(r + j * s, c + i * s, 4 * s);
                    double yHaarResponse = gauss * (double)this.haarY(r + j * s, c + i * s, 4 * s);
                    xHaarResponses.add(xHaarResponse);
                    yHaarResponses.add(yHaarResponse);
                    angles.add(this.getAngle(xHaarResponse, yHaarResponse));
                }
                ++j;
            }
            ++i;
        }
        float sumX = 0.0f;
        float sumY = 0.0f;
        float max = 0.0f;
        float orientation = 0.0f;
        float ang1 = 0.0f;
        while ((double)ang1 < Math.PI * 2) {
            float ang2 = (float)((double)ang1 + 1.0471975511965976 > Math.PI * 2 ? (double)ang1 - 5.235987755982989 : (double)ang1 + 1.0471975511965976);
            sumY = 0.0f;
            sumX = 0.0f;
            int k = 0;
            while (k < angles.size()) {
                float ang = ((Double)angles.get(k)).floatValue();
                if (ang1 < ang2 && ang1 < ang && ang < ang2) {
                    sumX += ((Double)xHaarResponses.get(k)).floatValue();
                    sumY += ((Double)yHaarResponses.get(k)).floatValue();
                } else if (ang2 < ang1 && (ang > 0.0f && ang < ang2 || ang > ang1 && (double)ang < Math.PI * 2)) {
                    sumX += ((Double)xHaarResponses.get(k)).floatValue();
                    sumY += ((Double)yHaarResponses.get(k)).floatValue();
                }
                ++k;
            }
            if (sumX * sumX + sumY * sumY > max) {
                max = sumX * sumX + sumY * sumY;
                orientation = (float)this.getAngle(sumX, sumY);
            }
            ang1 += 0.15f;
        }
        input.setOrientation(orientation);
    }

    private void getMDescriptor(SURFInterestPoint point, boolean upright) {
        int count = 0;
        double co = 1.0;
        double si = 0.0;
        float[] desc = new float[64];
        double gauss_s1 = 0.0;
        double gauss_s2 = 0.0;
        double xs = 0.0;
        double ys = 0.0;
        double rx = 0.0;
        double ry = 0.0;
        double rrx = 0.0;
        double rry = 0.0;
        double len = 0.0;
        int i = 0;
        int ix = 0;
        int j = 0;
        int jx = 0;
        float cx = -0.5f;
        float cy = 0.0f;
        double scale = point.getScale();
        int x = Math.round(point.getX());
        int y = Math.round(point.getY());
        if (!upright) {
            co = Math.cos(point.getOrientation());
            si = Math.sin(point.getOrientation());
        }
        i = -8;
        while (i < 12) {
            j = -8;
            i -= 4;
            cx += 1.0f;
            cy = -0.5f;
            while (j < 12) {
                double mdy = 0.0;
                double mdx = 0.0;
                double dy = 0.0;
                double dx = 0.0;
                cy += 1.0f;
                ix = i + 5;
                jx = (j -= 4) + 5;
                xs = Math.round((double)x + ((double)(-jx) * scale * si + (double)ix * scale * co));
                ys = Math.round((double)y + ((double)jx * scale * co + (double)ix * scale * si));
                int k = i;
                while (k < i + 9) {
                    int l = j;
                    while (l < j + 9) {
                        int sample_x = (int)Math.round((double)x + (-1.0 * (double)l * scale * si + (double)k * scale * co));
                        int sample_y = (int)Math.round((double)y + ((double)l * scale * co + (double)k * scale * si));
                        gauss_s1 = this.gaussian(xs - (double)sample_x, ys - (double)sample_y, 2.5 * scale);
                        rx = this.haarX(sample_y, sample_x, (int)(2L * Math.round(scale)));
                        ry = this.haarY(sample_y, sample_x, (int)(2L * Math.round(scale)));
                        rrx = gauss_s1 * (-rx * si + ry * co);
                        rry = gauss_s1 * (rx * co + ry * si);
                        dx += rrx;
                        dy += rry;
                        mdx += Math.abs(rrx);
                        mdy += Math.abs(rry);
                        ++l;
                    }
                    ++k;
                }
                gauss_s2 = this.gaussian(cx - 2.0f, cy - 2.0f, 1.5);
                desc[count++] = (float)(dx * gauss_s2);
                desc[count++] = (float)(dy * gauss_s2);
                desc[count++] = (float)(mdx * gauss_s2);
                desc[count++] = (float)(mdy * gauss_s2);
                len += (dx * dx + dy * dy + mdx * mdx + mdy * mdy) * (gauss_s2 * gauss_s2);
                j += 9;
            }
            i += 9;
        }
        len = Math.sqrt(len);
        i = 0;
        while (i < 64) {
            int n = i++;
            desc[n] = (float)((double)desc[n] / len);
        }
        point.setDescriptor(desc);
    }

    private double getAngle(double xHaarResponse, double yHaarResponse) {
        if (xHaarResponse >= 0.0 && yHaarResponse >= 0.0) {
            return Math.atan(yHaarResponse / xHaarResponse);
        }
        if (xHaarResponse < 0.0 && yHaarResponse >= 0.0) {
            return Math.PI - Math.atan(-yHaarResponse / xHaarResponse);
        }
        if (xHaarResponse < 0.0 && yHaarResponse < 0.0) {
            return Math.PI + Math.atan(yHaarResponse / xHaarResponse);
        }
        if (xHaarResponse >= 0.0 && yHaarResponse < 0.0) {
            return Math.PI * 2 - Math.atan(-yHaarResponse / xHaarResponse);
        }
        return 0.0;
    }

    public Map<SURFInterestPoint, SURFInterestPoint> getMatchingPoints(Surf descriptor, boolean upright) {
        System.out.println("Finding matching points..");
        HashMap<SURFInterestPoint, SURFInterestPoint> matchingPoints = new HashMap<SURFInterestPoint, SURFInterestPoint>();
        List<SURFInterestPoint> points = upright ? this.getUprightInterestPoints() : this.getFreeOrientedInterestPoints();
        for (SURFInterestPoint a : points) {
            double smallestDistance = 3.4028234663852886E38;
            double nextSmallestDistance = 3.4028234663852886E38;
            SURFInterestPoint possibleMatch = null;
            for (SURFInterestPoint b : upright ? descriptor.getUprightInterestPoints() : descriptor.getFreeOrientedInterestPoints()) {
                double distance = a.getDistance(b);
                if (distance < smallestDistance) {
                    nextSmallestDistance = smallestDistance;
                    smallestDistance = distance;
                    possibleMatch = b;
                    continue;
                }
                if (!(distance < nextSmallestDistance)) continue;
                nextSmallestDistance = distance;
            }
            if (!(smallestDistance / nextSmallestDistance < 0.75)) continue;
            matchingPoints.put(a, possibleMatch);
        }
        System.out.println("Done finding matching points");
        return matchingPoints;
    }

    public String getStringRepresentation(boolean freeOriented) {
        StringBuffer buffer = new StringBuffer();
        for (SURFInterestPoint point : freeOriented ? this.getFreeOrientedInterestPoints() : this.getUprightInterestPoints()) {
            float[] fArray = point.getDescriptor();
            int n = fArray.length;
            int n2 = 0;
            while (n2 < n) {
                double val = fArray[n2];
                buffer.append(String.valueOf(Double.doubleToLongBits(val)) + ",");
                ++n2;
            }
        }
        buffer.substring(0, buffer.length() - 1);
        return buffer.toString();
    }

    public void setStringRepresentation(String str) {
    }

    private double gaussian(double x, double y, double sig) {
        return 1.0 / (Math.PI * 2 * sig * sig) * Math.exp(-(x * x + y * y) / (2.0 * sig * sig));
    }

    public boolean isEquivalentTo(Surf surf) {
        List<SURFInterestPoint> pointsA = surf.getFreeOrientedInterestPoints();
        List<SURFInterestPoint> pointsB = this.getFreeOrientedInterestPoints();
        if (pointsA.size() != pointsB.size()) {
            return false;
        }
        int i = 0;
        while (i < pointsA.size()) {
            SURFInterestPoint pointB;
            SURFInterestPoint pointA = pointsA.get(i);
            if (!pointA.isEquivalentTo(pointB = pointsB.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void saveToFile(Surf surf, String file) {
        try {
            ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(file));
            stream.writeObject(surf);
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Surf readFromFile(String location) {
        File file = new File(location);
        if (file != null && file.exists()) {
            try {
                ObjectInputStream str = new ObjectInputStream(new FileInputStream(file));
                return (Surf)str.readObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.mFreeOrientedPoints == null) {
            this.getFreeOrientedInterestPoints();
        }
        if (this.mUprightPoints == null) {
            this.getUprightInterestPoints();
        }
        out.defaultWriteObject();
    }

    public static void main(String[] args) {
        try {
            BufferedImage image = ImageIO.read(new File("H:\\workspace\\javaopensurf\\example\\lenna.png"));
            Surf board = new Surf(image);
            Surf.saveToFile(board, "C:\\surf_test.bin");
            Surf boarder = Surf.readFromFile("C:\\surf_test.bin");
            List<SURFInterestPoint> points = boarder.getFreeOrientedInterestPoints();
            System.out.println("Found " + points.size() + " interest points");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

