/*
 * Decompiled with CFR 0.152.
 */
package com.stromberglabs.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class SizedPriorityQueue<T> {
    private int mSize;
    private boolean mGetLowest = true;
    private LinkedList<T> mList;
    private LinkedList<Double> mPriorities;
    private Comparator<T> mComparator;

    public SizedPriorityQueue(int size, boolean getLowest) {
        this.mSize = size;
        this.mGetLowest = getLowest;
        this.mList = new LinkedList();
        this.mPriorities = new LinkedList();
    }

    public SizedPriorityQueue(int size, boolean getLowest, Comparator<T> comparator) {
        this(size, getLowest);
        this.mComparator = comparator;
    }

    public void add(T value) {
        if (this.mComparator == null) {
            throw new RuntimeException("Trying to use priority queue default add without comparator defined");
        }
        int index = 0;
        for (Object val : this.mList) {
            int comparison = this.mComparator.compare(val, value);
            if (this.mGetLowest && comparison < 0 || !this.mGetLowest && comparison > 0) break;
            ++index;
        }
        if (index < this.mSize - 1) {
            this.mList.add(index, value);
        }
        if (this.mList.size() > this.mSize) {
            this.mList.removeLast();
        }
    }

    public void add(T value, double priority) {
        int index = 0;
        Iterator iterator = this.mPriorities.iterator();
        while (iterator.hasNext()) {
            double val = (Double)iterator.next();
            double comparison = priority - val;
            if (this.mGetLowest && comparison < 0.0 || !this.mGetLowest && comparison > 0.0) break;
            ++index;
        }
        if (index < this.mSize - 1) {
            this.mList.add(index, value);
            this.mPriorities.add(index, priority);
        }
        if (this.mList.size() > this.mSize) {
            this.mList.removeLast();
            this.mPriorities.removeLast();
        }
    }

    public T pop() {
        if (this.mPriorities.size() > 0) {
            this.mPriorities.pop();
        }
        return this.mList.pop();
    }

    public T poll() {
        return this.mList.peek();
    }

    public int size() {
        return this.mList.size();
    }

    public List<T> getAllScores() {
        return this.mList;
    }

    public static void main(String[] args) {
        int numScores = 10;
        int numTopScores = 5;
        Random r = new Random(2L);
        SizedPriorityQueue<Integer> queue = new SizedPriorityQueue<Integer>(numTopScores, false);
        int i = 0;
        while (i < numScores) {
            double score = r.nextDouble();
            System.out.println("inserting score: " + score + ", number " + i);
            queue.add(i, score);
            ++i;
        }
        while (queue.size() > 0) {
            System.out.println(queue.pop());
        }
    }
}

