/*
 * Decompiled with CFR 0.152.
 */
package procontroll;

import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import processing.core.PApplet;
import procontroll.ControllDevice;

public class ControllIO
implements Runnable {
    public static final int ON_PRESS = 0;
    public static final int ON_RELEASE = 1;
    public static final int WHILE_PRESS = 2;
    private static ControllIO instance;
    private final ControllerEnvironment environment;
    private final PApplet parent;
    private final List devices = new ArrayList();
    private final Thread thread;
    private boolean active = true;

    private ControllIO(PApplet i_parent) {
        this.environment = ControllerEnvironment.getEnvironment();
        this.parent = i_parent;
        this.parent.registerDispose((Object)this);
        this.parent.registerPre((Object)this);
        this.setupDevices();
        this.thread = new Thread(this);
        this.thread.start();
    }

    private void setupDevices() {
        Controller[] controllers = this.environment.getControllers();
        int i = 0;
        while (i < controllers.length) {
            this.devices.add(new ControllDevice(controllers[i], this.parent));
            ++i;
        }
    }

    public static ControllIO getInstance(PApplet i_parent) {
        if (instance == null) {
            instance = new ControllIO(i_parent);
        }
        return instance;
    }

    public void dispose() {
        this.active = false;
    }

    public void printDevices() {
        System.out.println("\n<<< available proCONTROLL devices: >>>\n");
        int i = 0;
        while (i < this.devices.size()) {
            System.out.print("     " + i + ": ");
            System.out.println(((ControllDevice)this.devices.get(i)).getName());
            ++i;
        }
        System.out.println("\n<<< >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
    }

    public int getNumberOfDevices() {
        return this.devices.size();
    }

    public ControllDevice getDevice(int i_deviceNumber) {
        if (i_deviceNumber >= this.getNumberOfDevices()) {
            throw new RuntimeException("There is no device with the number " + i_deviceNumber + ".");
        }
        ControllDevice result = (ControllDevice)this.devices.get(i_deviceNumber);
        result.open();
        return result;
    }

    public ControllDevice getDevice(String i_deviceName) {
        int i = 0;
        while (i < this.getNumberOfDevices()) {
            ControllDevice device = (ControllDevice)this.devices.get(i);
            if (device.getName().equals(i_deviceName)) {
                device.open();
                return device;
            }
            ++i;
        }
        throw new RuntimeException("There is no device with the name " + i_deviceName + ".");
    }

    public void pre() {
        int i = 0;
        while (i < this.devices.size()) {
            ((ControllDevice)this.devices.get(i)).updateRelative();
            ++i;
        }
    }

    public void run() {
        while (this.active) {
            int i = 0;
            while (i < this.devices.size()) {
                ((ControllDevice)this.devices.get(i)).update();
                ++i;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void plug(Object i_object, String i_methodName, int i_eventType, int i_intputDevice, int i_input) {
        ControllDevice device = this.getDevice(i_intputDevice);
        device.plug(i_object, i_methodName, i_eventType, i_input);
    }

    public void plug(String i_methodName, int i_eventType, int i_intputDevice, int i_input) {
        this.plug((Object)this.parent, i_methodName, i_eventType, i_intputDevice, i_input);
    }

    public void plug(Object i_object, String i_methodName, int i_eventType, String i_intputDevice, String i_input) {
        ControllDevice device = this.getDevice(i_intputDevice);
        device.plug(i_object, i_methodName, i_eventType, i_input);
    }

    public void plug(String i_methodName, int i_eventType, String i_intputDevice, String i_input) {
        this.plug((Object)this.parent, i_methodName, i_eventType, i_intputDevice, i_input);
    }
}

