/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.FScrollbar;
import guicomponents.FTextComponent;
import guicomponents.GComponent;
import guicomponents.HotSpot;
import guicomponents.StyledString;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PGraphicsJava2D;
import processing.core.PImage;

public class FTextArea
extends FTextComponent {
    private static float pad = 6.0f;

    public FTextArea(PApplet pApplet, float f, float f2, float f3, float f4) {
        this(pApplet, f, f2, f3, f4, 0);
    }

    public FTextArea(PApplet pApplet, float f, float f2, float f3, float f4, int n) {
        super(pApplet, f, f2, f3, f4, n);
        this.tx = this.ty = pad;
        this.tw = this.width - 2.0f * pad - (float)((this.sbPolicy & 1) != 0 ? 18 : 0);
        this.th = this.height - 2.0f * pad - (float)((this.sbPolicy & 2) != 0 ? 18 : 0);
        this.gpTextDisplayArea = new GeneralPath();
        this.gpTextDisplayArea.moveTo(0.0f, 0.0f);
        this.gpTextDisplayArea.lineTo(0.0f, this.th);
        this.gpTextDisplayArea.lineTo(this.tw, this.th);
        this.gpTextDisplayArea.lineTo(this.tw, 0.0f);
        this.gpTextDisplayArea.closePath();
        this.buffer = (PGraphicsJava2D)this.winApp.createGraphics((int)this.width, (int)this.height, "processing.core.PGraphicsJava2D");
        this.buffer.rectMode(0);
        this.buffer.g2.setFont(this.fLocalFont);
        this.hotspots = new HotSpot[]{new HotSpot.HSrect(1, this.tx, this.ty, this.tw, this.th), new HotSpot.HSrect(9, 0.0f, 0.0f, this.width, this.height)};
        if ((this.sbPolicy & 2) != 0) {
            this.hsb = new FScrollbar(pApplet, 0.0f, 0.0f, this.tw, 16.0f);
            this.addCompoundControl(this.hsb, this.tx, this.ty + this.th + 2.0f, 0.0f);
            this.hsb.addEventHandler(this, "hsbEventHandler");
            this.hsb.setAutoHide(this.autoHide);
        }
        if ((this.sbPolicy & 1) != 0) {
            this.vsb = new FScrollbar(pApplet, 0.0f, 0.0f, this.th, 16.0f);
            this.addCompoundControl(this.vsb, this.tx + this.tw + 18.0f, this.ty, 1.5707964f);
            this.vsb.addEventHandler(this, "vsbEventHandler");
            this.vsb.setAutoHide(this.autoHide);
        }
        this.setTextNew(" ", (int)this.tw);
        this.z = 0;
        this.registerAutos_DMPK(true, true, false, true);
    }

    public void setTextNew(String string) {
        this.setText(string, (int)this.tw);
    }

    public void setTextNew(String string, int n) {
        this.text = string;
        this.stext = new StyledString(this.buffer.g2, string, n);
        if (this.vsb != null) {
            float f = this.stext.getTextAreaHeight();
            this.pty = 0.0f;
            this.ptx = 0.0f;
            if (f < this.th) {
                this.vsb.setValue(0.0f, 1.0f);
            } else {
                this.vsb.setValue(0.0f, this.th / f);
            }
        }
        if (this.hsb != null) {
            if (this.stext.getMaxLineLength() < this.tw) {
                this.hsb.setValue(0.0f, 1.0f);
            } else {
                this.hsb.setValue(0.0f, this.tw / this.stext.getMaxLineLength());
            }
        }
    }

    protected void updateBuffer() {
        if (this.bufferInvalid) {
            Graphics2D graphics2D = this.buffer.g2;
            StyledString.TextLayoutHitInfo textLayoutHitInfo = null;
            StyledString.TextLayoutHitInfo textLayoutHitInfo2 = null;
            this.buffer.beginDraw();
            if (this.opaque) {
                this.buffer.background(this.palette[6]);
            } else {
                this.buffer.background(this.buffer.color(255, 0));
            }
            this.buffer.translate(this.tx, this.ty);
            this.buffer.noStroke();
            this.buffer.fill(this.palette[7]);
            this.buffer.rect(-1.0f, -1.0f, this.tw + 2.0f, this.th + 2.0f);
            graphics2D.setClip(this.gpTextDisplayArea);
            this.buffer.translate(-this.ptx, -this.pty);
            LinkedList<StyledString.TextLayoutInfo> linkedList = this.stext.getLines(graphics2D);
            boolean bl = this.hasSelection();
            if (bl) {
                if (this.endTLHI.compareTo(this.startTLHI) == -1) {
                    textLayoutHitInfo = this.endTLHI;
                    textLayoutHitInfo2 = this.startTLHI;
                } else {
                    textLayoutHitInfo = this.startTLHI;
                    textLayoutHitInfo2 = this.endTLHI;
                }
            }
            for (StyledString.TextLayoutInfo textLayoutInfo : linkedList) {
                TextLayout textLayout = textLayoutInfo.layout;
                this.buffer.translate(0.0f, textLayout.getAscent());
                if (bl && textLayoutInfo.compareTo(textLayoutHitInfo.tli) >= 0 && textLayoutInfo.compareTo(textLayoutHitInfo2.tli) <= 0) {
                    int n = 0;
                    n = textLayoutInfo.compareTo(textLayoutHitInfo.tli) == 0 ? textLayoutHitInfo.thi.getInsertionIndex() : 0;
                    int n2 = textLayoutHitInfo2.thi.getInsertionIndex();
                    n2 = textLayoutInfo.compareTo(textLayoutHitInfo2.tli) == 0 ? textLayoutHitInfo2.thi.getInsertionIndex() : textLayoutInfo.nbrChars - 1;
                    graphics2D.setColor(this.jpalette[14]);
                    Shape shape = textLayout.getLogicalHighlightShape(n, n2);
                    graphics2D.fill(shape);
                }
                graphics2D.setColor(this.jpalette[2]);
                textLayoutInfo.layout.draw(graphics2D, 0.0f, 0.0f);
                this.buffer.translate(0.0f, textLayout.getDescent() + textLayout.getLeading());
            }
            graphics2D.setClip(null);
            this.buffer.endDraw();
            this.bufferInvalid = false;
        }
    }

    protected boolean keepCursorInDisplay() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.endTLHI != null) {
            if (this.caretX < this.ptx) {
                this.ptx -= 1.0f;
                if (this.ptx < 0.0f) {
                    this.ptx = 0.0f;
                }
                bl = true;
            } else if (this.caretX > this.ptx + this.tw - 2.0f) {
                this.ptx += 1.0f;
                bl = true;
            }
            if (this.caretY < this.pty) {
                this.pty -= 1.0f;
                if (this.pty < 0.0f) {
                    this.pty = 0.0f;
                }
                bl2 = true;
            } else if (this.caretY > this.pty + this.th + this.stext.getMaxLineHeight()) {
                this.pty += 1.0f;
                bl2 = true;
            }
            if (bl && this.hsb != null) {
                this.hsb.setValue(this.ptx / (this.stext.getMaxLineLength() + 4.0f));
            }
            if (bl2 && this.vsb != null) {
                this.vsb.setValue(this.pty / (this.stext.getTextAreaHeight() + 1.5f * this.stext.getMaxLineHeight()));
            }
        }
        if (bl || bl2) {
            this.bufferInvalid = true;
        }
        return bl | bl2;
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        this.updateBuffer();
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.pushMatrix();
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        if (this.showCaret && this.endTLHI != null) {
            Object object = this.endTLHI.tli.layout.getCaretInfo(this.endTLHI.thi);
            float f = -this.ptx + object[0];
            float f2 = -this.pty + this.endTLHI.tli.yPosInPara;
            float f3 = f2 - object[3] + object[5];
            if (f >= 0.0f && f <= this.tw && f2 >= 0.0f && f3 <= this.th) {
                this.winApp.strokeWeight(1.9f);
                this.winApp.stroke(this.palette[15]);
                this.winApp.line(this.tx + f, this.ty + Math.max(0.0f, f2), this.tx + f, this.ty + Math.min(this.th, f3));
            }
        }
        this.winApp.popMatrix();
        if (this.children != null) {
            for (GComponent gComponent : this.children) {
                gComponent.draw();
            }
        }
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    protected boolean processKeyPressed(KeyEvent keyEvent, boolean bl, boolean bl2) {
        int n = keyEvent.getKeyCode();
        boolean bl3 = false;
        switch (n) {
            case 37: {
                bl3 = this.moveCaretLeft(this.endTLHI);
                break;
            }
            case 39: {
                bl3 = this.moveCaretRight(this.endTLHI);
                break;
            }
            case 38: {
                bl3 = this.moveCaretUp(this.endTLHI);
                break;
            }
            case 40: {
                bl3 = this.moveCaretDown(this.endTLHI);
                break;
            }
            case 36: {
                if (bl2) {
                    bl3 = this.moveCaretStartOfText(this.endTLHI);
                    break;
                }
                bl3 = this.moveCaretStartOfLine(this.endTLHI);
                break;
            }
            case 35: {
                bl3 = bl2 ? this.moveCaretEndOfText(this.endTLHI) : this.moveCaretEndOfLine(this.endTLHI);
            }
        }
        this.calculateCaretPos(this.endTLHI);
        if (this.caretX > this.stext.getWrapWidth()) {
            switch (n) {
                case 35: 
                case 37: 
                case 38: 
                case 40: {
                    this.moveCaretLeft(this.endTLHI);
                    bl3 = true;
                    break;
                }
                case 39: {
                    if (!this.moveCaretRight(this.endTLHI)) {
                        this.moveCaretLeft(this.endTLHI);
                    }
                    bl3 = true;
                }
            }
            this.calculateCaretPos(this.endTLHI);
        }
        if (bl3) {
            if (!bl) {
                this.startTLHI.copyFrom(this.endTLHI);
            } else {
                this.bufferInvalid = true;
            }
        }
        return bl3;
    }

    public void keyEvent(KeyEvent keyEvent) {
        block3: {
            boolean bl;
            boolean bl2;
            block4: {
                if (!(this.visible && this.enabled && this.available)) {
                    return;
                }
                if (focusIsWith != this || this.endTLHI == null) break block3;
                bl2 = (keyEvent.getModifiersEx() & 0x40) == 64;
                boolean bl3 = bl = (keyEvent.getModifiersEx() & 0x80) == 128;
                if (keyEvent.getID() != 401) break block4;
                this.processKeyPressed(keyEvent, bl2, bl);
                this.setScrollbarValues(this.ptx, this.pty);
                while (this.keepCursorInDisplay()) {
                }
                break block3;
            }
            if (keyEvent.getID() != 400 || keyEvent.getKeyChar() == '\uffff') break block3;
            this.processKeyTyped(keyEvent, bl2, bl);
            this.setScrollbarValues(this.ptx, this.pty);
            while (this.keepCursorInDisplay()) {
            }
        }
    }

    protected boolean moveCaretStartOfLine(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.thi.getCharIndex() == 0) {
            return false;
        }
        textLayoutHitInfo.thi = textLayoutHitInfo.tli.layout.getNextLeftHit(1);
        return true;
    }

    protected boolean moveCaretEndOfLine(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.thi.getCharIndex() == textLayoutHitInfo.tli.nbrChars - 1) {
            return false;
        }
        textLayoutHitInfo.thi = textLayoutHitInfo.tli.layout.getNextRightHit(textLayoutHitInfo.tli.nbrChars - 1);
        return true;
    }

    protected boolean moveCaretStartOfText(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.tli.lineNo == 0 && textLayoutHitInfo.thi.getCharIndex() == 0) {
            return false;
        }
        textLayoutHitInfo.tli = this.stext.getTLIforLineNo(0);
        textLayoutHitInfo.thi = textLayoutHitInfo.tli.layout.getNextLeftHit(1);
        return true;
    }

    protected boolean moveCaretEndOfText(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.tli.lineNo == this.stext.getNbrLines() - 1 && textLayoutHitInfo.thi.getCharIndex() == textLayoutHitInfo.tli.nbrChars - 1) {
            return false;
        }
        textLayoutHitInfo.tli = this.stext.getTLIforLineNo(this.stext.getNbrLines() - 1);
        textLayoutHitInfo.thi = textLayoutHitInfo.tli.layout.getNextRightHit(textLayoutHitInfo.tli.nbrChars - 1);
        return true;
    }

    protected boolean moveCaretUp(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.tli.lineNo == 0) {
            return false;
        }
        StyledString.TextLayoutInfo textLayoutInfo = this.stext.getTLIforLineNo(textLayoutHitInfo.tli.lineNo - 1);
        TextHitInfo textHitInfo = textLayoutInfo.layout.hitTestChar(this.caretX, 0.0f);
        textLayoutHitInfo.tli = textLayoutInfo;
        textLayoutHitInfo.thi = textHitInfo;
        return true;
    }

    protected boolean moveCaretDown(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.tli.lineNo == this.stext.getNbrLines() - 1) {
            return false;
        }
        StyledString.TextLayoutInfo textLayoutInfo = this.stext.getTLIforLineNo(textLayoutHitInfo.tli.lineNo + 1);
        TextHitInfo textHitInfo = textLayoutInfo.layout.hitTestChar(this.caretX, 0.0f);
        textLayoutHitInfo.tli = textLayoutInfo;
        textLayoutHitInfo.thi = textHitInfo;
        return true;
    }

    protected boolean moveCaretLeft(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        TextHitInfo textHitInfo = textLayoutHitInfo.tli.layout.getNextLeftHit(textLayoutHitInfo.thi);
        if (textHitInfo == null) {
            if (textLayoutHitInfo.tli.lineNo == 0) {
                return false;
            }
            StyledString.TextLayoutInfo textLayoutInfo = this.stext.getTLIforLineNo(textLayoutHitInfo.tli.lineNo - 1);
            textHitInfo = textLayoutInfo.layout.getNextRightHit(textLayoutInfo.nbrChars - 1);
            textLayoutHitInfo.tli = textLayoutInfo;
            textLayoutHitInfo.thi = textHitInfo;
        } else {
            textLayoutHitInfo.thi = textHitInfo;
        }
        return true;
    }

    protected boolean moveCaretRight(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        TextHitInfo textHitInfo = textLayoutHitInfo.tli.layout.getNextRightHit(textLayoutHitInfo.thi);
        if (textHitInfo == null) {
            if (textLayoutHitInfo.tli.lineNo >= this.stext.getNbrLines() - 1) {
                return false;
            }
            StyledString.TextLayoutInfo textLayoutInfo = this.stext.getTLIforLineNo(textLayoutHitInfo.tli.lineNo + 1);
            textHitInfo = textLayoutInfo.layout.getNextLeftHit(1);
            textLayoutHitInfo.tli = textLayoutInfo;
            textLayoutHitInfo.thi = textHitInfo;
        } else {
            textLayoutHitInfo.thi = textHitInfo;
        }
        return true;
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.ox -= this.tx;
        this.oy -= this.ty;
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        if (this.currSpot == 1 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (this.currSpot != 1) break;
                if (focusIsWith != this && this.z > FTextArea.focusObjectZ()) {
                    this.takeFocus();
                }
                this.mdx = this.winApp.mouseX;
                this.mdy = this.winApp.mouseY;
                this.endTLHI = this.stext.calculateFromXY(this.buffer.g2, this.ox + this.ptx, this.oy + this.pty);
                this.startTLHI = new StyledString.TextLayoutHitInfo(this.endTLHI);
                this.calculateCaretPos(this.endTLHI);
                this.bufferInvalid = true;
                break;
            }
            case 502: {
                this.dragging = false;
                break;
            }
            case 506: {
                if (focusIsWith != this) break;
                this.dragging = true;
                this.endTLHI = this.stext.calculateFromXY(this.buffer.g2, this.ox + this.ptx, this.oy + this.pty);
                this.calculateCaretPos(this.endTLHI);
                this.bufferInvalid = true;
                this.keepCursorInDisplay();
            }
        }
    }

    protected void calculateCaretPos(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        float[] fArray = textLayoutHitInfo.tli.layout.getCaretInfo(textLayoutHitInfo.thi);
        this.caretX = fArray[0];
        this.caretY = textLayoutHitInfo.tli.yPosInPara;
    }
}

