/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GComponent;
import guicomponents.GFont;
import java.awt.Point;
import java.awt.event.MouseEvent;
import processing.core.PApplet;
import processing.core.PImage;

public class GCheckbox
extends GComponent {
    protected boolean selected;
    protected static PImage imgSelected;
    protected static PImage imgCleared;

    public GCheckbox(PApplet pApplet, String string, int n, int n2, int n3) {
        super(pApplet, n, n2);
        this.checkboxCtorCore(string, n3);
    }

    private void checkboxCtorCore(String string, int n) {
        if (imgSelected == null) {
            imgSelected = this.winApp.loadImage("check1.png");
        }
        if (imgCleared == null) {
            imgCleared = this.winApp.loadImage("check0.png");
        }
        this.width = n;
        this.height = Math.max(this.localFont.getSize() + 4, GCheckbox.imgCleared.height);
        this.opaque = false;
        this.setText(string);
        this.z = 24;
        this.createEventHandler(G4P.mainWinApp, "handleCheckboxEvents", new Class[]{GCheckbox.class});
        this.registerAutos_DMPK(true, true, false, false);
    }

    public void setFont(String string, int n) {
        int n2 = this.textWidth;
        int n3 = this.localFont.getSize();
        this.localFont = GFont.getFont(this.winApp, string, n);
        if (n != n3) {
            this.height += (float)(n - n3);
        }
        this.setText(this.text);
        if (this.textWidth > n2) {
            this.width += (float)(this.textWidth - n2);
        }
    }

    protected void calcAlignX() {
        switch (this.textAlignHorz) {
            case 1: {
                this.alignX = GCheckbox.imgSelected.width + 2 * this.border + 4;
                break;
            }
            case 2: {
                this.alignX = (int)(this.width - (float)this.textWidth - (float)(2 * this.border) - 4.0f);
                break;
            }
            case 4: {
                this.alignX = (int)((float)GCheckbox.imgSelected.width + (this.width - (float)GCheckbox.imgSelected.width - (float)this.textWidth) / 2.0f);
            }
        }
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        if (!this.text.equals("")) {
            if (this.border != 0) {
                this.winApp.strokeWeight((float)this.border);
                this.winApp.stroke(this.localColor.cbxBorder);
            } else {
                this.winApp.noStroke();
            }
            if (this.opaque) {
                this.winApp.fill(this.localColor.cbxBack);
            } else {
                this.winApp.noFill();
            }
            this.winApp.rect((float)point.x, (float)point.y, this.width, this.height);
            this.winApp.noStroke();
            this.winApp.fill(this.localColor.cbxFont);
            this.winApp.textFont(this.localFont, (float)this.localFont.getSize());
            this.winApp.text(this.text, (float)(point.x + this.alignX), (float)point.y + (this.height - (float)this.localFont.getSize()) / 2.0f - 2.0f, (float)this.textWidth, this.height);
        }
        this.winApp.fill(this.winApp.color(255, 255));
        if (imgSelected != null && imgCleared != null) {
            if (this.selected) {
                this.winApp.image(imgSelected, (float)point.x, (float)point.y + (this.height - (float)GCheckbox.imgSelected.height) / 2.0f);
            } else {
                this.winApp.image(imgCleared, (float)point.x, (float)point.y + (this.height - (float)GCheckbox.imgSelected.height) / 2.0f);
            }
        }
        this.winApp.popStyle();
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (!this.visible || !this.enabled) {
            return;
        }
        boolean bl = this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (bl) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (focusIsWith == this || !bl || this.z <= GCheckbox.focusObjectZ()) break;
                this.mdx = this.winApp.mouseX;
                this.mdy = this.winApp.mouseY;
                this.takeFocus();
                break;
            }
            case 500: {
                if (focusIsWith != this) break;
                this.selected = !this.selected;
                this.eventType = this.selected ? 1025 : 1026;
                this.fireEvent();
                this.loseFocus(null);
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                break;
            }
            case 502: {
                if (focusIsWith != this || !this.mouseHasMoved(this.winApp.mouseX, this.winApp.mouseY)) break;
                this.loseFocus(null);
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }
}

