/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GRoundControl;
import java.awt.Point;
import processing.core.PApplet;

public class GKnob
extends GRoundControl {
    protected int nbrTickMarks = 2;
    protected Point[][] mark;
    protected int bezelWidth = (int)Math.max(Math.min(this.sizeRadX, this.sizeRadY) / 3.0f, 4.0f);
    protected int knobRadX;
    protected int knobRadY;
    protected int barRadX;
    protected int barRadY;
    protected boolean valueTrackVisible = true;
    protected boolean rotArcOnly = false;

    protected GKnob(PApplet pApplet, int n, int n2, int n3, int n4, int n5, int n6) {
        super(pApplet, n, n2, n3, n4, n5, n6);
        this.calculateSizes(this.bezelWidth);
        this.calcTickMarkerPositions(this.nbrTickMarks);
        this.createEventHandler(G4P.mainWinApp, "handleKnobEvents", new Class[]{GKnob.class});
    }

    public GKnob(PApplet pApplet, int n, int n2, int n3, int n4, int n5) {
        this(pApplet, n, n2, n3, n3, n4, n5);
    }

    protected void calculateSizes(int n) {
        this.bezelWidth = (int)PApplet.constrain((float)n, (float)0.0f, (float)Math.min(this.sizeRadX, this.sizeRadY));
        this.knobRadX = (int)(this.sizeRadX - (float)this.bezelWidth);
        this.knobRadY = (int)(this.sizeRadY - (float)this.bezelWidth);
        if (this.knobRadX <= 0 || this.knobRadY <= 0) {
            this.knobRadY = 0;
            this.knobRadX = 0;
            int n2 = Math.min(Math.round(0.2f * (float)this.bezelWidth), 10);
            this.barRadX = (int)(this.sizeRadX - (float)n2);
            this.barRadY = (int)(this.sizeRadY - (float)n2);
        } else {
            this.barRadX = Math.round(0.5f * (this.sizeRadX + (float)this.knobRadX));
            this.barRadY = Math.round(0.5f * (this.sizeRadY + (float)this.knobRadY));
        }
    }

    protected void calcTickMarkerPositions(int n) {
        this.mark = new Point[n][2];
        for (int i = 0; i < n; ++i) {
            this.mark[i][0] = new Point();
            this.mark[i][1] = new Point();
        }
        float f = (float)(this.aHigh - this.aLow) / (float)(n - 1);
        for (int i = 0; i < n; ++i) {
            float f2 = (float)Math.cos(PApplet.radians((float)((float)this.aLow + (float)i * f)));
            float f3 = (float)Math.sin(PApplet.radians((float)((float)this.aLow + (float)i * f)));
            this.mark[i][0].x = Math.round((float)this.knobRadX * f2);
            this.mark[i][0].y = Math.round((float)this.knobRadY * f3);
            if (i == 0 || i == n - 1) {
                this.mark[i][1].x = Math.round(this.sizeRadX * f2);
                this.mark[i][1].y = Math.round(this.sizeRadY * f3);
                continue;
            }
            this.mark[i][1].x = Math.round((float)this.barRadX * f2);
            this.mark[i][1].y = Math.round((float)this.barRadY * f3);
        }
        this.nbrTickMarks = n;
    }

    public void setBezelWidth(int n) {
        this.calculateSizes(n);
        this.calcTickMarkerPositions(this.nbrTickMarks);
    }

    public int getBezelWidth() {
        return this.bezelWidth;
    }

    public void setValueTrackVisible(boolean bl) {
        this.valueTrackVisible = bl;
    }

    public boolean isValueTrackVisible() {
        return this.valueTrackVisible;
    }

    public void setNbrTickSpaces(int n) {
        this.setNbrTickMarks(n + 1);
    }

    public void setNbrTickMarks(int n) {
        n = n < 2 ? 2 : n;
        this.calcTickMarkerPositions(n);
    }

    public boolean isOver(int n, int n2) {
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        int n3 = (int)((float)(n - point.x) - this.cx);
        int n4 = (int)((float)(n2 - point.y) - this.cy);
        boolean bl = (float)(n3 * n3 + n4 * n4) < this.sizeRadX * this.sizeRadY;
        return bl;
    }

    public boolean isOverRotArc(int n, int n2) {
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        point.x = (int)((float)point.x + this.cx);
        point.y = (int)((float)point.y + this.cy);
        boolean bl = false;
        int n3 = n - point.x;
        int n4 = n2 - point.y;
        boolean bl2 = bl = (float)(n3 * n3 + n4 * n4) < this.sizeRadX * this.sizeRadY;
        if (bl) {
            int n5 = Math.round(PApplet.degrees((float)this.calcRealAngleFromXY(point, n, n2)));
            bl = this.isInValidArc(n5);
        }
        return bl;
    }

    public void setMouseORA(boolean bl) {
        if (bl || !bl && !this.rotArcOnly) {
            this.overRotArcOnly = bl;
        }
    }

    public boolean isRotArcOnly() {
        return this.rotArcOnly;
    }

    public void setRotArcOnly(boolean bl) {
        this.rotArcOnly = bl;
        if (bl) {
            this.overRotArcOnly = true;
        }
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        point.x = (int)((float)point.x + this.cx);
        point.y = (int)((float)point.y + this.cy);
        float f = PApplet.radians((float)this.needleAngle);
        this.winApp.pushMatrix();
        this.winApp.translate((float)point.x, (float)point.y);
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        if (this.bezelWidth > 0) {
            this.winApp.noStroke();
            if (this.rotArcOnly) {
                this.winApp.fill(this.winApp.color(128, 128));
            } else {
                this.winApp.fill(this.winApp.color(128, 48));
                this.winApp.ellipse(0.0f, 0.0f, 2.0f * this.sizeRadX, 2.0f * this.sizeRadY);
                this.winApp.fill(this.winApp.color(128, 80));
            }
            this.winApp.arc(0.0f, 0.0f, 2.0f * this.sizeRadX, 2.0f * this.sizeRadY, this.start, this.end);
            if (this.valueTrackVisible) {
                this.winApp.fill(this.localColor.knobTrack);
                this.winApp.noStroke();
                this.winApp.arc(0.0f, 0.0f, (float)(2 * this.barRadX), (float)(2 * this.barRadY), this.start, f);
            }
            this.winApp.stroke(this.localColor.knobBorder);
            this.winApp.strokeWeight(1.2f);
            for (int i = 0; i < this.mark.length; ++i) {
                if (i == 0 || i == this.mark.length - 1) {
                    this.winApp.strokeWeight(1.5f);
                } else {
                    this.winApp.strokeWeight(1.2f);
                }
                this.winApp.line((float)this.mark[i][0].x, (float)this.mark[i][0].y, (float)this.mark[i][1].x, (float)this.mark[i][1].y);
            }
        }
        if (this.knobRadX > 0) {
            this.winApp.stroke(this.localColor.knobBorder);
            this.winApp.strokeWeight(1.2f);
            this.winApp.fill(this.localColor.knobFill);
            if (this.rotArcOnly) {
                this.winApp.arc(0.0f, 0.0f, (float)(2 * this.knobRadX), (float)(2 * this.knobRadY), this.start, this.end);
                this.winApp.stroke(this.localColor.knobBorder);
                this.winApp.strokeWeight(1.2f);
                this.winApp.line(0.0f, 0.0f, (float)this.mark[0][0].x, (float)this.mark[0][0].y);
                this.winApp.line(0.0f, 0.0f, (float)this.mark[this.mark.length - 1][0].x, (float)this.mark[this.mark.length - 1][0].y);
            } else {
                this.winApp.ellipse(0.0f, 0.0f, (float)(2 * this.knobRadX), (float)(2 * this.knobRadY));
            }
            this.winApp.stroke(this.localColor.knobNeedle);
            this.winApp.strokeWeight(1.5f);
            this.winApp.line(0.0f, 0.0f, (float)Math.round((double)(this.sizeRadX - (float)this.bezelWidth) * Math.cos(f)), (float)Math.round((double)(this.sizeRadY - (float)this.bezelWidth) * Math.sin(f)));
        }
        this.winApp.popStyle();
        this.winApp.popMatrix();
    }
}

