/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.GComponent;
import java.awt.Point;
import java.awt.event.MouseEvent;
import processing.core.PApplet;

public abstract class GRoundControl
extends GComponent {
    protected float cx;
    protected float cy;
    protected float start;
    protected float end;
    protected float sizeRadX;
    protected float sizeRadY;
    protected boolean overRotArcOnly = false;
    protected int aLow;
    protected int aHigh;
    public boolean wrap0;
    public int needleAngle;
    public int lastTargetNeedleAngle;
    public int targetNeedleAngle;
    protected int needleDir;
    protected int mouseAngle;
    protected int lastMouseAngle;
    protected int offset;
    protected float valueStart = 20.0f;
    protected float valueEnd = 270.0f;
    protected float value = 300.0f;
    protected boolean isValueChanging;
    protected boolean clockwiseValues = this.valueStart < this.valueEnd;
    protected int inertia = 1;
    protected int mode = 1282;
    protected float sensitivity = 1.0f;
    protected int startMouseX;
    protected int startMouseY;

    public GRoundControl(PApplet pApplet, int n, int n2, int n3, int n4, int n5, int n6) {
        super(pApplet, n, n2);
        this.width = n3 < 20 ? 20.0f : (float)n3;
        this.height = n4 < 20 ? 20.0f : (float)n4;
        this.sizeRadX = this.cx = this.width / 2.0f;
        this.sizeRadY = this.cy = this.height / 2.0f;
        this.aLow = this.getValidArcAngle(n5);
        this.aHigh = this.getValidArcAngle(n6);
        this.wrap0 = n5 > n6;
        this.aLow = this.aLow >= this.aHigh ? this.aLow - 360 : this.aLow;
        this.start = PApplet.radians((float)this.aLow);
        this.end = PApplet.radians((float)this.aHigh);
        this.z = 24;
        this.registerAutos_DMPK(true, true, true, false);
        this.setLimits(50.0f, 0.0f, 100.0f);
    }

    public GRoundControl(PApplet pApplet, int n, int n2, int n3, int n4, int n5) {
        this(pApplet, n, n2, n3, n3, n4, n5);
    }

    public void pre() {
        int n = this.inertia;
        if (this.needleAngle == this.targetNeedleAngle) {
            this.isValueChanging = false;
            this.needleDir = 0;
        } else {
            int n2;
            while ((n2 = (this.targetNeedleAngle - this.needleAngle) / n) == 0 && --n > 0) {
            }
            this.needleDir = this.signInt(n2);
            if (n2 != 0) {
                this.needleAngle += n2;
                this.isValueChanging = true;
                this.fireEvent();
            } else {
                this.isValueChanging = false;
            }
        }
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (!this.visible || !this.enabled) {
            return;
        }
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        point.x = (int)((float)point.x + this.cx);
        point.y = (int)((float)point.y + this.cy);
        int n = 0;
        boolean bl = this.overRotArcOnly ? this.isOverRotArc(this.winApp.mouseX, this.winApp.mouseY) : this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (bl || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (focusIsWith == this || !bl || this.z <= GRoundControl.focusObjectZ()) break;
                this.startMouseX = this.winApp.mouseX - point.x;
                this.startMouseY = this.winApp.mouseY - point.y;
                n = this.getAngleFromUser(point);
                this.mouseAngle = n < 0 ? n + 360 : n;
                this.lastMouseAngle = this.mouseAngle;
                this.offset = this.targetNeedleAngle - this.mouseAngle;
                this.takeFocus();
                break;
            }
            case 502: {
                if (focusIsWith == this) {
                    this.loseFocus(null);
                }
                this.lastTargetNeedleAngle = this.targetNeedleAngle;
                break;
            }
            case 500: {
                break;
            }
            case 506: {
                if (focusIsWith != this) break;
                n = this.getAngleFromUser(point);
                int n2 = this.mouseAngle = n < 0 ? n + 360 : n;
                if (this.mouseAngle != this.lastMouseAngle) {
                    int n3 = this.mouseAngle - this.lastMouseAngle;
                    if (n3 < -180) {
                        n3 += 360;
                    } else if (n3 > 180) {
                        n3 -= 360;
                    }
                    this.targetNeedleAngle = PApplet.constrain((int)(this.targetNeedleAngle + n3), (int)this.aLow, (int)this.aHigh);
                    this.offset += this.targetNeedleAngle - this.lastTargetNeedleAngle - n3;
                    this.lastTargetNeedleAngle = this.targetNeedleAngle;
                    this.lastMouseAngle = this.mouseAngle;
                }
                this.isValueChanging = true;
            }
        }
    }

    public abstract boolean isOverRotArc(int var1, int var2);

    protected int getAngleFromUser(Point point) {
        int n = 0;
        switch (this.mode) {
            case 1281: {
                n = Math.round(PApplet.degrees((float)this.calcRealAngleFromXY(point, this.winApp.mouseX, this.winApp.mouseY)));
                break;
            }
            case 1282: {
                n = (int)(this.sensitivity * (float)(this.winApp.mouseX - point.x - this.startMouseX));
                break;
            }
            case 1283: {
                n = (int)(this.sensitivity * (float)(this.winApp.mouseY - point.y - this.startMouseY));
            }
        }
        return n;
    }

    protected float calcRealAngleFromXY(Point point, float f, float f2) {
        float f3 = (float)Math.atan2(f2 - (float)point.y, f - (float)point.x);
        f3 = f3 < 0.0f ? f3 + (float)Math.PI * 2 : f3;
        return f3;
    }

    public boolean isValueChanging() {
        return this.isValueChanging;
    }

    public int getControlMode() {
        return this.mode;
    }

    public void setControlMode(int n) {
        this.mode = n;
    }

    public float getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(float f) {
        this.sensitivity = f < 0.1f ? 0.1f : f;
    }

    public int getInertia() {
        return this.inertia;
    }

    public void setInertia(int n) {
        if (n >= 1) {
            this.inertia = n;
        }
    }

    public boolean isMouseORA() {
        return this.overRotArcOnly;
    }

    public void setMouseORA(boolean bl) {
        this.overRotArcOnly = bl;
    }

    public float getValuef() {
        if (this.clockwiseValues) {
            return PApplet.map((float)this.needleAngle, (float)this.aLow, (float)this.aHigh, (float)this.valueStart, (float)this.valueEnd);
        }
        return -PApplet.map((float)this.needleAngle, (float)this.aLow, (float)this.aHigh, (float)(-this.valueStart), (float)(-this.valueEnd));
    }

    public int getValue() {
        return Math.round(this.getValuef());
    }

    public void setLimits(float f, float f2, float f3) {
        this.valueStart = f2;
        this.valueEnd = f3;
        this.clockwiseValues = f2 < f3;
        this.setValue(f, true);
    }

    public void setValue(float f) {
        f = this.clockwiseValues ? PApplet.constrain((float)f, (float)this.valueStart, (float)this.valueEnd) : PApplet.constrain((float)f, (float)this.valueEnd, (float)this.valueStart);
        this.targetNeedleAngle = this.getAngleFromValue(f);
    }

    public void setValue(float f, boolean bl) {
        this.setValue(f);
        if (bl) {
            this.needleAngle = this.targetNeedleAngle;
        }
    }

    protected int getAngleFromValue(float f) {
        int n = this.clockwiseValues ? (int)PApplet.map((float)f, (float)this.valueStart, (float)this.valueEnd, (float)this.aLow, (float)this.aHigh) : (int)PApplet.map((float)(-f), (float)(-this.valueStart), (float)(-this.valueEnd), (float)this.aLow, (float)this.aHigh);
        return n;
    }

    protected boolean isInValidArc(int n) {
        return this.aLow < 0 ? n >= 360 + this.aLow || n <= this.aHigh : n >= this.aLow && n <= this.aHigh;
    }

    protected int getValidArcAngle(int n) {
        while (n < 0) {
            n += 360;
        }
        while (n > 360) {
            n -= 360;
        }
        return n;
    }

    protected int signInt(int n) {
        return n == 0 ? 0 : (n < 0 ? -1 : 1);
    }

    protected float convertRealAngleToOvalAngle(double d, float f, float f2) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = (double)Math.abs(f - f2) / 2.0;
        double d5 = (double)f * d2;
        double d6 = (double)f2 * d3;
        if (f > f2) {
            d5 -= d4 * d2;
            d6 += d4 * d3;
        } else {
            d5 += d4 * d2;
            d6 -= d4 * d3;
        }
        float f3 = (float)Math.atan2(d6, d5);
        while (d - (double)f3 >= 3.1415927410125732) {
            f3 += (float)Math.PI * 2;
        }
        while ((double)f3 - d >= 3.1415927410125732) {
            f3 -= (float)Math.PI * 2;
        }
        return f3;
    }

    protected void calcCircumferencePosition(Point point, float f, float f2, float f3, float f4) {
        double d = f3 * f4;
        double d2 = (float)Math.sqrt(f3 * f3 * f2 * f2 + f4 * f4 * f * f);
        point.x = (int)Math.round((double)f * d / d2);
        point.y = (int)Math.round((double)f2 * d / d2);
    }
}

