/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GClip;
import guicomponents.GComponent;
import guicomponents.GFont;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import processing.core.PApplet;

public class GTextField
extends GComponent {
    private static int fontLeadPad = 2;
    private int cursorPos = 0;
    private int startSelect = -1;
    private int endSelect = -1;
    private int startX = 0;
    private int startY = 0;
    private int endY = 1;
    private int leading;
    private boolean drawSepLines = false;
    private boolean multiLine = false;

    public GTextField(PApplet pApplet, String string, int n, int n2, int n3, int n4) {
        super(pApplet, n, n2);
        this.multiLine = false;
        this.textFieldCtorCore(string, n3, n4);
    }

    public GTextField(PApplet pApplet, String string, int n, int n2, int n3, int n4, boolean bl) {
        super(pApplet, n, n2);
        this.multiLine = bl;
        this.textFieldCtorCore(string, n3, n4);
    }

    private void textFieldCtorCore(String string, int n, int n2) {
        this.width = Math.max(n, this.textWidth + 8);
        this.height = Math.max(n2, (int)(1.5f * (float)this.localFont.getSize()));
        this.border = 1;
        this.leading = (int)(1.2f * (float)this.localFont.getSize());
        this.endY = Math.max(1, (int)Math.floor(this.height / (float)this.leading));
        this.setText(string);
        this.winApp.textFont(this.localFont);
        this.z = 0;
        this.createEventHandler(G4P.mainWinApp, "handleTextFieldEvents", new Class[]{GTextField.class});
        this.registerAutos_DMPK(true, true, false, false);
    }

    public void setFont(String string, int n, int n2) {
        this.localFont = GFont.getFont(this.winApp, string, n);
        this.height = Math.max(this.height, (float)((int)(1.5f * (float)this.localFont.getSize() + 0.5f)));
        this.leading = Math.max(n + fontLeadPad, n2);
        this.endY = (int)Math.floor(this.height / (float)n2);
        this.setText(this.text);
    }

    public void setFont(String string, int n) {
        this.setFont(string, n, this.leading);
    }

    protected void loseFocus(GComponent gComponent) {
        this.endSelect = -1;
        this.startSelect = -1;
        focusIsWith = null;
        this.eventType = 258;
        this.fireEvent();
    }

    private void appendToRightOfCursor(char c) {
        this.appendToRightOfCursor("" + c);
    }

    private void appendToRightOfCursor(String string) {
        String string2;
        String string3;
        if (this.startSelect != this.endSelect) {
            int n = Math.min(this.startSelect, this.endSelect);
            int n2 = Math.max(this.startSelect, this.endSelect);
            string3 = this.text.substring(0, n);
            string2 = this.text.substring(n2);
            this.endSelect = this.cursorPos = n;
            this.startSelect = this.cursorPos;
        } else {
            string3 = this.text.substring(0, this.cursorPos);
            string2 = this.text.substring(this.cursorPos);
        }
        this.text = string3 + string + string2;
        this.cursorPos += string.length();
        this.startSelect = this.endSelect = this.cursorPos;
        this.eventType = 257;
        this.fireEvent();
    }

    protected void backspaceChar() {
        if (this.startSelect != this.endSelect) {
            this.deleteSubstring(this.startSelect, this.endSelect);
        } else if (this.cursorPos > 0) {
            this.deleteSubstring(this.cursorPos - 1, this.cursorPos);
        }
    }

    private void deleteChar() {
        if (this.startSelect != this.endSelect) {
            this.deleteSubstring(this.startSelect, this.endSelect);
        } else if (this.cursorPos < this.text.length()) {
            this.deleteSubstring(this.cursorPos, this.cursorPos + 1);
        }
    }

    private void deleteSubstring(int n, int n2) {
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        this.text = this.text.substring(0, n3) + this.text.substring(n4);
        this.endSelect = this.cursorPos = n3;
        this.startSelect = this.cursorPos;
        this.eventType = 257;
        this.fireEvent();
    }

    private void copySubstring(int n, int n2) {
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        GClip.copy(this.text.substring(n3, n4));
    }

    private Point cursorPosition(int n) {
        if (n >= 0) {
            String string = this.text.substring(0, n);
            int n2 = string.length() - string.replaceAll("\n", "").length();
            int n3 = string.length() - string.lastIndexOf("\n") - 1;
            return new Point(n3, n2);
        }
        return new Point(0, 0);
    }

    private Point cursorPixPosition(int n) {
        if (n >= 0) {
            String string = this.text.substring(0, n);
            String string2 = string.substring(Math.max(string.lastIndexOf("\n") + 1, 0), string.length());
            int n2 = (int)this.winApp.textWidth(string2.substring(this.startX, string2.length()));
            int n3 = (string.length() - string.replaceAll("\n", "").length() - this.startY) * this.leading;
            return new Point(n2, n3);
        }
        return new Point(0, 0);
    }

    private int cursorPos1D(Point point) {
        String[] stringArray = this.text.split("\n");
        int n = 0;
        for (int i = 0; i < point.y; ++i) {
            n += stringArray[i].length() + 1;
        }
        return n + point.x;
    }

    private Point cursorPos2D(int n, int n2) {
        n -= 4;
        int n3 = (n2 -= 4) / this.leading + this.startY;
        String[] stringArray = this.text.split("\n");
        if (n3 >= stringArray.length) {
            return this.cursorPosition(this.cursorPos);
        }
        if (n3 < 0) {
            return new Point(0, 0);
        }
        float f = 0.0f;
        for (int i = this.startX; i < stringArray[n3].length(); ++i) {
            float f2 = this.winApp.textWidth(stringArray[n3].substring(this.startX, i));
            if (f2 > (float)n) {
                if (f2 - (float)n < (float)n - f) {
                    return new Point(i, n3);
                }
                return new Point(Math.max(0, i - 1), n3);
            }
            f = f2;
        }
        return new Point(stringArray[n3].length(), n3);
    }

    public String viewText() {
        this.showCursor();
        String[] stringArray = PApplet.split((String)this.text, (String)"\n");
        String[] stringArray2 = new String[this.endY - this.startY];
        for (int i = this.startY; i < this.endY; ++i) {
            if (i < stringArray.length) {
                float f;
                int n = stringArray[i].length() - 1;
                for (float f2 = this.winApp.textWidth(stringArray[i].substring(Math.min(this.startX, stringArray[i].length()))); f2 > this.width - 8.0f; f2 -= f) {
                    f = this.winApp.textWidth(stringArray[i].substring(n, n + 1));
                    --n;
                }
                stringArray2[i - this.startY] = stringArray[i].substring(Math.min(this.startX, stringArray[i].length()), Math.min(++n, stringArray[i].length()));
                continue;
            }
            stringArray2[i - this.startY] = "";
        }
        String string = PApplet.join((String[])stringArray2, (String)"\n");
        return string;
    }

    private void showCursor() {
        if (focusIsWith == this) {
            while (this.cursorPosition((int)this.cursorPos).x < this.startX) {
                --this.startX;
            }
            while ((float)this.cursorPixPosition((int)this.cursorPos).x > this.width - 8.0f) {
                ++this.startX;
            }
            while (this.cursorPosition((int)this.cursorPos).y > this.endY - 1) {
                ++this.startY;
                ++this.endY;
            }
            while (this.cursorPosition((int)this.cursorPos).y < this.startY) {
                --this.startY;
                --this.endY;
            }
        }
    }

    public String getSelectedText() {
        if (this.startSelect == this.endSelect) {
            return "";
        }
        return this.text.substring(Math.min(this.startSelect, this.endSelect), Math.max(this.startSelect, this.endSelect));
    }

    public void setText(String string) {
        this.text = string;
        if (!this.multiLine) {
            this.text = this.stripEOLs(this.text, ' ');
        }
        this.endSelect = -1;
        this.startSelect = -1;
        this.cursorPos = 0;
        this.eventType = 259;
        this.fireEvent();
    }

    public void setTextAlign(int n) {
        if (G4P.messages) {
            System.out.println("GTextfield controls does not support text alignment");
        }
    }

    public void setShowLines(boolean bl) {
        this.drawSepLines = bl;
    }

    public boolean getShowLines() {
        return this.drawSepLines;
    }

    public boolean scroll(int n) {
        boolean bl = false;
        switch (n) {
            case 273: {
                return this.scrollUp();
            }
            case 274: {
                return this.scrollDown();
            }
            case 275: {
                return this.scrollLeft();
            }
            case 276: {
                return this.scrollRight();
            }
        }
        return bl;
    }

    private boolean scrollRight() {
        String[] stringArray = PApplet.split((String)this.text, (String)"\n");
        this.winApp.textFont(this.localFont);
        for (int i = this.startY; i < this.endY; ++i) {
            float f;
            if (this.startX >= stringArray[i].length() || !((f = this.winApp.textWidth(stringArray[i].substring(this.startX))) > this.width - 8.0f)) continue;
            ++this.startX;
            return true;
        }
        return false;
    }

    private boolean scrollLeft() {
        if (this.startX > 0) {
            --this.startX;
            return true;
        }
        return false;
    }

    private boolean scrollUp() {
        if (this.multiLine && this.startY > 0) {
            --this.startY;
            --this.endY;
            return true;
        }
        return false;
    }

    private boolean scrollDown() {
        int n;
        if (this.multiLine && this.endY <= (n = this.text.split("\n").length)) {
            ++this.startY;
            ++this.endY;
            return true;
        }
        return false;
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (!this.visible || !this.enabled) {
            return;
        }
        this.winApp.textFont(this.localFont);
        boolean bl = this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (bl || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        switch (mouseEvent.getID()) {
            case 501: {
                if (!this.isOver(this.winApp.mouseX, this.winApp.mouseY)) break;
                if (focusIsWith != this && this.z >= GTextField.focusObjectZ()) {
                    this.takeFocus();
                }
                this.endSelect = this.cursorPos = this.cursorPos1D(this.cursorPos2D(mouseEvent.getX() - point.x, mouseEvent.getY() - point.y));
                this.startSelect = this.cursorPos;
                break;
            }
            case 502: {
                break;
            }
            case 506: {
                if (focusIsWith != this) break;
                this.endSelect = this.cursorPos = this.cursorPos1D(this.cursorPos2D(mouseEvent.getX() - point.x, mouseEvent.getY() - point.y));
            }
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        if (!this.enabled) {
            return;
        }
        if (focusIsWith == this) {
            boolean bl;
            this.winApp.textFont(this.localFont);
            int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            boolean bl2 = bl = (keyEvent.getModifiersEx() & 0x40) == 64;
            if (keyEvent.getID() == 401) {
                if (keyEvent.getKeyCode() == 35) {
                    if (bl) {
                        this.cursorPos = this.text.indexOf("\n", this.cursorPos) != -1 ? this.text.indexOf("\n", this.cursorPos) : this.text.length();
                        this.endSelect = this.cursorPos;
                    } else {
                        this.cursorPos = this.text.indexOf("\n", this.cursorPos) != -1 ? this.text.indexOf("\n", this.cursorPos) : this.text.length();
                        this.startSelect = this.endSelect = this.cursorPos;
                    }
                } else if (keyEvent.getKeyCode() == 36) {
                    if (bl) {
                        this.cursorPos = this.text.lastIndexOf("\n", this.cursorPos) != this.cursorPos ? this.text.lastIndexOf("\n", this.cursorPos) + 1 : this.text.lastIndexOf("\n", this.cursorPos - 1) + 1;
                        this.startSelect = this.cursorPos;
                    } else {
                        this.cursorPos = this.text.lastIndexOf("\n", this.cursorPos) != this.cursorPos ? this.text.lastIndexOf("\n", this.cursorPos) + 1 : this.text.lastIndexOf("\n", this.cursorPos - 1) + 1;
                        this.startSelect = this.endSelect = this.cursorPos;
                    }
                } else if (keyEvent.getKeyCode() == 37) {
                    if (bl) {
                        if (this.cursorPos > 0) {
                            --this.cursorPos;
                            this.endSelect = this.cursorPos;
                        }
                    } else {
                        if (this.cursorPos > 0) {
                            --this.cursorPos;
                        }
                        this.startSelect = this.endSelect = this.cursorPos;
                    }
                } else if (keyEvent.getKeyCode() == 39) {
                    if (bl) {
                        if (this.cursorPos < this.text.length()) {
                            ++this.cursorPos;
                            this.endSelect = this.cursorPos;
                        }
                    } else {
                        if (this.cursorPos < this.text.length()) {
                            ++this.cursorPos;
                        }
                        this.startSelect = this.endSelect = this.cursorPos;
                    }
                } else if (this.multiLine && keyEvent.getKeyCode() == 38) {
                    String[] stringArray = this.text.split("\n");
                    if (bl) {
                        if (this.cursorPosition((int)this.cursorPos).y > 0) {
                            this.startSelect = this.cursorPos = this.cursorPos1D(new Point(Math.min(this.cursorPosition((int)this.cursorPos).x, stringArray[this.cursorPosition((int)this.cursorPos).y - 1].length()), this.cursorPosition((int)this.cursorPos).y - 1));
                        }
                    } else {
                        if (this.cursorPosition((int)this.cursorPos).y > 0) {
                            this.cursorPos = this.cursorPos1D(new Point(Math.min(this.cursorPosition((int)this.cursorPos).x, stringArray[this.cursorPosition((int)this.cursorPos).y - 1].length()), this.cursorPosition((int)this.cursorPos).y - 1));
                        }
                        this.startSelect = this.endSelect = this.cursorPos;
                    }
                } else if (this.multiLine && keyEvent.getKeyCode() == 40) {
                    String[] stringArray = this.text.split("\n");
                    if (bl) {
                        if (this.cursorPosition((int)this.cursorPos).y < stringArray.length - 1) {
                            this.endSelect = this.cursorPos = this.cursorPos1D(new Point(Math.min(this.cursorPosition((int)this.cursorPos).x, stringArray[this.cursorPosition((int)this.cursorPos).y + 1].length()), this.cursorPosition((int)this.cursorPos).y + 1));
                        }
                    } else {
                        if (this.cursorPosition((int)this.cursorPos).y < stringArray.length - 1) {
                            this.cursorPos = this.cursorPos1D(new Point(Math.min(this.cursorPosition((int)this.cursorPos).x, stringArray[this.cursorPosition((int)this.cursorPos).y + 1].length()), this.cursorPosition((int)this.cursorPos).y + 1));
                        }
                        this.startSelect = this.endSelect = this.cursorPos;
                    }
                } else if (keyEvent.getKeyCode() == 127) {
                    this.deleteChar();
                } else if (keyEvent.getKeyCode() == 10) {
                    if (this.multiLine) {
                        this.appendToRightOfCursor("\n");
                    } else {
                        this.eventType = 258;
                        this.fireEvent();
                    }
                } else if ((keyEvent.getModifiers() & n) == n) {
                    switch (keyEvent.getKeyCode()) {
                        case 67: {
                            if (this.startSelect == this.endSelect) break;
                            this.copySubstring(this.startSelect, this.endSelect);
                            break;
                        }
                        case 86: {
                            if (this.multiLine) {
                                this.appendToRightOfCursor(GClip.paste());
                                break;
                            }
                            this.appendToRightOfCursor(this.stripEOLs(GClip.paste(), ' '));
                            break;
                        }
                        case 88: {
                            if (this.startSelect == this.endSelect) break;
                            this.copySubstring(this.startSelect, this.endSelect);
                            this.deleteSubstring(this.startSelect, this.endSelect);
                            break;
                        }
                        case 65: {
                            this.startSelect = 0;
                            this.endSelect = this.text.length();
                        }
                    }
                }
            } else if (keyEvent.getID() == 400 && (keyEvent.getModifiers() & n) != n) {
                if (keyEvent.getKeyChar() == '\b') {
                    this.backspaceChar();
                } else if (keyEvent.getKeyChar() != '\uffff' && GTextField.validUnicode(keyEvent.getKeyChar())) {
                    this.appendToRightOfCursor(keyEvent.getKeyChar());
                }
            }
        }
    }

    public void draw() {
        int n;
        if (!this.visible) {
            return;
        }
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        this.winApp.pushMatrix();
        this.winApp.translate((float)point.x, (float)point.y);
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        this.winApp.textFont(this.localFont);
        if (this.border > 0) {
            this.winApp.strokeWeight((float)this.border);
            this.winApp.stroke(this.localColor.txfBorder);
        } else {
            this.winApp.noStroke();
        }
        this.winApp.fill(this.localColor.txfBack);
        this.winApp.rect(0.0f, 0.0f, this.width, this.height);
        if (this.drawSepLines) {
            this.winApp.stroke(PApplet.blendColor((int)this.localColor.txfBorder, (int)this.winApp.color(100), (int)2));
            this.winApp.strokeWeight(1.0f);
            for (n = 1; n <= this.endY - this.startY; ++n) {
                this.winApp.line(4.0f, (float)(n * this.leading), this.width - 4.0f, (float)(n * this.leading));
            }
        }
        this.winApp.noStroke();
        if (this.startSelect != this.endSelect) {
            this.winApp.fill(this.localColor.txfSelBack);
            if (this.startSelect >= 0 && this.endSelect >= 0) {
                for (n = Math.min(this.startSelect, this.endSelect); n < Math.max(this.startSelect, this.endSelect); ++n) {
                    if (this.cursorPosition((int)n).x < this.startX || !((float)this.cursorPixPosition((int)n).x < this.width - 8.0f) || this.cursorPosition((int)n).y < this.startY || this.cursorPosition((int)n).y >= this.endY) continue;
                    this.winApp.rect((float)(4 + this.cursorPixPosition((int)n).x), (float)(2 + this.cursorPixPosition((int)n).y), Math.min(this.winApp.textWidth(this.text.substring(n, n + 1)), this.width - 8.0f - (float)this.cursorPixPosition((int)n).x), (float)(this.localFont.getSize() + 2));
                }
            }
        }
        this.winApp.fill(this.localColor.txfFont);
        this.winApp.textLeading((float)this.leading);
        this.winApp.text(this.viewText(), 4.0f, 1.0f, this.width + 8.0f, this.height - 2.0f);
        if (focusIsWith == this && this.winApp.millis() % 1000 > 500) {
            Point point2 = this.cursorPixPosition(this.cursorPos);
            this.winApp.noFill();
            this.winApp.stroke(this.localColor.txfCursor);
            this.winApp.strokeWeight(2.0f);
            this.winApp.line((float)(4 + point2.x), (float)(point2.y + 2), (float)(4 + point2.x), (float)(point2.y + this.localFont.getSize() + 2));
            this.winApp.fill(this.localColor.txfFont);
        }
        this.winApp.popStyle();
        this.winApp.popMatrix();
    }

    public void drawORG() {
        int n;
        if (!this.visible) {
            return;
        }
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        this.winApp.textFont(this.localFont);
        if (this.border > 0) {
            this.winApp.strokeWeight((float)this.border);
            this.winApp.stroke(this.localColor.txfBorder);
        } else {
            this.winApp.noStroke();
        }
        this.winApp.fill(this.localColor.txfBack);
        this.winApp.rect((float)point.x, (float)point.y, this.width, this.height);
        if (this.drawSepLines) {
            this.winApp.stroke(PApplet.blendColor((int)this.localColor.txfBorder, (int)this.winApp.color(100), (int)2));
            this.winApp.strokeWeight(1.0f);
            for (n = 1; n <= this.endY - this.startY; ++n) {
                this.winApp.line((float)(point.x + 4), (float)(point.y + n * this.leading), (float)point.x + this.width - 4.0f, (float)(point.y + n * this.leading));
            }
        }
        this.winApp.noStroke();
        if (this.startSelect != this.endSelect) {
            this.winApp.fill(this.localColor.txfSelBack);
            for (n = Math.min(this.startSelect, this.endSelect); n < Math.max(this.startSelect, this.endSelect); ++n) {
                if (this.cursorPosition((int)n).x < this.startX || !((float)this.cursorPixPosition((int)n).x < this.width - 8.0f) || this.cursorPosition((int)n).y < this.startY || this.cursorPosition((int)n).y >= this.endY) continue;
                this.winApp.rect((float)(point.x + 4 + this.cursorPixPosition((int)n).x), (float)(point.y + 2 + this.cursorPixPosition((int)n).y), Math.min(this.winApp.textWidth(this.text.substring(n, n + 1)), this.width - 8.0f - (float)this.cursorPixPosition((int)n).x), (float)(this.localFont.getSize() + 2));
            }
        }
        this.winApp.fill(this.localColor.txfFont);
        this.winApp.textLeading((float)this.leading);
        this.winApp.text(this.viewText(), (float)(point.x + 4), (float)(point.y + 1), this.width + 8.0f, this.height - 2.0f);
        if (focusIsWith == this && this.winApp.millis() % 1000 > 500) {
            Point point2 = this.cursorPixPosition(this.cursorPos);
            this.winApp.noFill();
            this.winApp.stroke(this.localColor.txfCursor);
            this.winApp.strokeWeight(2.0f);
            this.winApp.line((float)(point.x + 4 + point2.x), (float)(point.y + point2.y + 2), (float)(point.x + 4 + point2.x), (float)(point.y + point2.y + this.localFont.getSize() + 2));
            this.winApp.fill(this.localColor.txfFont);
        }
        this.winApp.popStyle();
    }

    private String stripEOLs(String string, char c) {
        String string2 = string.replace('\n', c);
        return string2;
    }

    private static boolean validUnicode(char c) {
        char c2 = c;
        return c2 >= ' ' && c2 <= '~' || c2 >= '\u00a1' && c2 <= '\u017f' || c2 == '\u018f' || c2 == '\u0192' || c2 >= '\u01a0' && c2 <= '\u01a1' || c2 >= '\u01af' && c2 <= '\u01b0' || c2 >= '\u01d0' && c2 <= '\u01dc' || c2 >= '\u01fa' && c2 <= '\u01ff' || c2 >= '\u0218' && c2 <= '\u021b' || c2 >= '\u0250' && c2 <= '\u02a8' || c2 >= '\u02b0' && c2 <= '\u02e9' || c2 >= '\u0300' && c2 <= '\u0345' || c2 >= '\u0374' && c2 <= '\u0375' || c2 == '\u037a' || c2 == '\u037e' || c2 >= '\u0384' && c2 <= '\u038a' || c2 >= '\u038e' && c2 <= '\u03a1' || c2 >= '\u03a3' && c2 <= '\u03ce' || c2 >= '\u03d0' && c2 <= '\u03d6' || c2 >= '\u03da' || c2 >= '\u03dc' || c2 >= '\u03de' || c2 >= '\u03e0' || c2 >= '\u03e2' && c2 <= '\u03f3' || c2 >= '\u0401' && c2 <= '\u044f' || c2 >= '\u0451' && c2 <= '\u045c' || c2 >= '\u045e' && c2 <= '\u0486' || c2 >= '\u0490' && c2 <= '\u04c4' || c2 >= '\u04c7' && c2 <= '\u04c9' || c2 >= '\u04cb' && c2 <= '\u04cc' || c2 >= '\u04d0' && c2 <= '\u04eb' || c2 >= '\u04ee' && c2 <= '\u04f5' || c2 >= '\u04f8' && c2 <= '\u04f9' || c2 >= '\u0591' && c2 <= '\u05a1' || c2 >= '\u05a3' && c2 <= '\u05c4' || c2 >= '\u05d0' && c2 <= '\u05ea' || c2 >= '\u05f0' && c2 <= '\u05f4' || c2 >= '\u060c' || c2 >= '\u061b' || c2 >= '\u061f' || c2 >= '\u0621' && c2 <= '\u063a' || c2 >= '\u0640' && c2 <= '\u0655' || c2 >= '\u0660' && c2 <= '\u06ee' || c2 >= '\u06f0' && c2 <= '\u06fe' || c2 >= '\u0901' && c2 <= '\u0939' || c2 >= '\u093c' && c2 <= '\u094d' || c2 >= '\u0950' && c2 <= '\u0954' || c2 >= '\u0958' && c2 <= '\u0970' || c2 >= '\u0e01' && c2 <= '\u0e3a' || c2 >= '\u1e80' && c2 <= '\u1e85' || c2 >= '\u1ea0' && c2 <= '\u1ef9' || c2 >= '\u2000' && c2 <= '\u202e' || c2 >= '\u2030' && c2 <= '\u2046' || c2 == '\u2070' || c2 >= '\u2074' && c2 <= '\u208e' || c2 == '\u2091' || c2 >= '\u20a0' && c2 <= '\u20ac' || c2 >= '\u2100' && c2 <= '\u2138' || c2 >= '\u2153' && c2 <= '\u2182' || c2 >= '\u2190' && c2 <= '\u21ea' || c2 >= '\u2190' && c2 <= '\u21ea' || c2 >= '\u2000' && c2 <= '\u22f1' || c2 == '\u2302' || c2 >= '\u2320' && c2 <= '\u2321' || c2 >= '\u2460' && c2 <= '\u2469' || c2 == '\u2500' || c2 == '\u2502' || c2 == '\u250c' || c2 == '\u2510' || c2 == '\u2514' || c2 == '\u2518' || c2 == '\u251c' || c2 == '\u2524' || c2 == '\u252c' || c2 == '\u2534' || c2 == '\u253c' || c2 >= '\u2550' && c2 <= '\u256c' || c2 == '\u2580' || c2 == '\u2584' || c2 == '\u2588' || c2 == '\u258c' || c2 >= '\u2590' && c2 <= '\u2593' || c2 == '\u25a0' || c2 >= '\u25aa' && c2 <= '\u25ac' || c2 == '\u25b2' || c2 == '\u25ba' || c2 == '\u25bc' || c2 == '\u25c4' || c2 == '\u25c6' || c2 >= '\u25ca' && c2 <= '\u25cc' || c2 == '\u25cf' || c2 >= '\u25d7' && c2 <= '\u25d9' || c2 == '\u25e6' || c2 == '\u2605' || c2 == '\u260e' || c2 == '\u261b' || c2 == '\u261e' || c2 >= '\u263a' && c2 <= '\u263c' || c2 == '\u2640' || c2 == '\u2642' || c2 == '\u2660' || c2 == '\u2663' || c2 == '\u2665' || c2 == '\u2666' || c2 == '\u266a' || c2 == '\u266b' || c2 >= '\u2701' && c2 <= '\u2709' || c2 >= '\u270c' && c2 <= '\u2727' || c2 >= '\u2729' && c2 <= '\u274b' || c2 == '\u274d' || c2 >= '\u274f' && c2 <= '\u2752' || c2 == '\u2756' || c2 >= '\u2758' && c2 <= '\u275e' || c2 >= '\u2761' && c2 <= '\u2767' || c2 >= '\u2776' && c2 <= '\u2794' || c2 >= '\u2798' && c2 <= '\u27be' || c2 >= '\uf001' && c2 <= '\uf002' || c2 >= '\uf021' && c2 <= '\uf0ff' || c2 >= '\uf601' && c2 <= '\uf605' || c2 >= '\uf610' && c2 <= '\uf616' || c2 >= '\uf800' && c2 <= '\uf807' || c2 >= '\uf80a' && c2 <= '\uf80b' || c2 >= '\uf80e' && c2 <= '\uf811' || c2 >= '\uf814' && c2 <= '\uf815' || c2 >= '\uf81f' && c2 <= '\uf820' || c2 >= '\uf81f' && c2 <= '\uf820' || c2 == '\uf833';
    }
}

