/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.Timer;
import processing.core.PApplet;

public class GTimer {
    protected PApplet app;
    protected Object eventHandlerObject = null;
    protected Method eventHandler = null;
    protected int nrepeats = -1;
    protected Timer timer = null;

    public GTimer(PApplet pApplet, Object object, String string, int n) {
        this.app = pApplet;
        this.createEventHandler(object, string);
        if (this.eventHandlerObject != null) {
            this.timer = new Timer(n, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GTimer.this.fireEvent();
                }
            });
            this.timer.setInitialDelay(n);
            this.timer.setDelay(n);
            this.timer.stop();
        }
    }

    protected void createEventHandler(Object object, String string) {
        try {
            this.eventHandler = object.getClass().getMethod(string, new Class[0]);
            this.eventHandlerObject = object;
        }
        catch (Exception exception) {
            this.eventHandlerObject = null;
            System.out.println("The class " + object.getClass().getSimpleName() + " does not have a method called " + string);
        }
    }

    protected void fireEvent() {
        if (this.eventHandler != null) {
            try {
                this.eventHandler.invoke(this.eventHandlerObject, (Object[])null);
                if (--this.nrepeats == 0) {
                    this.stop();
                }
            }
            catch (Exception exception) {
                System.out.println("Disabling " + this.eventHandler.getName() + " due to an unknown error");
                this.eventHandler = null;
                this.eventHandlerObject = null;
            }
        }
    }

    public void start() {
        this.nrepeats = -1;
        if (this.timer != null) {
            this.timer.start();
        }
    }

    public void start(int n) {
        this.nrepeats = n;
        if (this.timer != null) {
            this.timer.start();
        }
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public boolean isRunning() {
        if (this.timer != null) {
            return this.timer.isRunning();
        }
        return false;
    }

    public void setInterval(int n) {
        if (this.timer != null) {
            this.timer.setDelay(n);
        }
    }

    public void setInitialDelay(int n) {
        if (this.timer != null) {
            this.timer.setInitialDelay(n);
        }
    }

    public void setDelay(int n) {
        if (this.timer != null) {
            this.timer.setInitialDelay(n);
            this.timer.setDelay(n);
        }
    }

    public int getInterval() {
        if (this.timer != null) {
            return this.timer.getDelay();
        }
        return -1;
    }

    public int getInitialDelay() {
        if (this.timer != null) {
            return this.timer.getInitialDelay();
        }
        return -1;
    }

    public boolean isValid() {
        return this.eventHandlerObject != null && this.timer != null;
    }
}

