#include "Wire.h"
#include "I2Cdev.h"
#include "TimerOne.h"
#include "Adafruit_Sensor.h"
#include "Adafruit_HMC5883_U.h"
#include "LCD.h"
#include "LiquidCrystal_I2C.h"

#define I2C_ADDR 0x27 //address 
#define BACKLIGHT_PIN 3 //display configuration
#define En_pin 2 //display configuration
#define Rw_pin 1 //display configuration
#define Rs_pin 0 //display configuration
#define D4_pin 4 //display configuration
#define D5_pin 5 //display configuration
#define D6_pin 6 //display configuration
#define D7_pin 7 //display configuration
#define TRIGR 2 //trigger pin for the ultrasonic sensors
#define MOTOR 3 //first pin that configures the motors, the others are MOTOR+1, +2, +3 and +4
#define ECHO 8 //first pin that echoes the sonars, the others are ECHO+1, +2, +3, +4 and +5

#define MAX_DISTANCE 300 //maximum distance for sensor timeout, wont read above this
#define NUM1 5 //number of readings for compass on any given time to find the average
#define NUM2 10 //number of values to add to find I value for the PID
#define Kp 1.2      //proportional gain of PID
#define Ki 0.06 //integral value of PID
#define Kd 5     //derivative gain of PID
#define TRECUO 1500 //time robot will go backward when collide
#define TAVANCO 3000 //time the robot will have to turn to right direction after collide and after go back
#define TPARADO 500 //time the robot will take to find it got stuck
#define N 1 //error for sensors find it got stuck
#define M 2 //same as above but for different time
#define DIST 5 //reading in cm to find the wall is too near
#define PWM_T 110 //potency from 0 to 255 to send to sweeper motor
#define PWM_T2 0 //potency to send to sweeper motor when going backward or turning, etc 
#define timercalibrar 4000 //time to calibrate the compass - the robot will be turning around its axis
#define timersetup 3000 //time to display messages and stay still

//DISPLAY
LiquidCrystal_I2C lcd(I2C_ADDR, En_pin, Rw_pin, Rs_pin, D4_pin, D5_pin, D6_pin, D7_pin);
unsigned long int timerlcd = 0;

//SONAR
signed long int cm[6] = {0, 0, 0, 0, 0, 0}; 
signed long int cmOld[6] = {0, 0, 0, 0, 0, 0};
unsigned int cmi[6][5];
int obstaculo = 0;
int obstOld = 0;
unsigned long int timerObstaculo = 0;
long int sonarCount[6] = {0, 0, 0, 0, 0, 0};
int sonar[6] = {0, 0, 0, 0, 0, 0};
unsigned int aux02 = 0;
boolean sonarativo = 0;
unsigned int dirObst = 4;
unsigned long int timerOld = 0;
unsigned long int timerOld2 = 0;
unsigned int sonartimeout = 0;

//BLUETOOTH
const unsigned long periodicMessageFrequency = 1200;
unsigned long TIM = 0;
double velocidade;
double lado;
boolean mensagem = 0;

//MOTOR
int PWM_R, PWM_L, PWM_LIMP;
unsigned int PWMCount = 0;
boolean PWMR, PWML;
double POTENCIA = 1.3; //IMPORTANT - this goes from 0 to 2.55 and multiplies the power sent to motors

//BUSSOLA
double Xmax, Xmin, Ymax, Ymin;
unsigned int aux98 = 0;
double x[NUM1];
double y[NUM1];
double vector[2] = {0, 0};
double errorZero = 0;
double error = 0;
double errorI[NUM2];
double errorISUM = 0;
double errorD = 0;
int i = 0;
int k = 0;
double vectorOBJ[2] = {1, 0};
double sentido = 0;
double Zprim = 0;

/* Assign a unique ID to this sensor at the same time */
Adafruit_HMC5883_Unified mag = Adafruit_HMC5883_Unified(12345);

//DEMAIS
unsigned long int perigoTimer[6] = {0, 0, 0, 0, 0, 0};
double velRoda = 0;
unsigned long int perigo[6] = {0, 0, 0, 0, 0, 0};

//interruption activates PWM for three motors and increases a variable to find the distance of the sensors
void callback() {
  noInterrupts();
  if ((sonar[0] == 1) && (digitalRead(ECHO))) sonarCount[0]++;
  if ((sonar[0] == 1) && (!digitalRead(ECHO)) && (sonarCount[0] > 0)) sonar[0] = 2;
  if ((sonar[1] == 1) && (digitalRead(ECHO + 1))) sonarCount[1]++;
  if ((sonar[1] == 1) && (!digitalRead(ECHO + 1)) && (sonarCount[1] > 0)) sonar[1] = 2;
  if ((sonar[2] == 1) && (digitalRead(ECHO + 2))) sonarCount[2]++;
  if ((sonar[2] == 1) && (!digitalRead(ECHO + 2)) && (sonarCount[2] > 0)) sonar[2] = 2;
  if ((sonar[3] == 1) && (digitalRead(ECHO + 3))) sonarCount[3]++;
  if ((sonar[3] == 1) && (!digitalRead(ECHO + 3)) && (sonarCount[3] > 0)) sonar[3] = 2;
  if ((sonar[4] == 1) && (digitalRead(ECHO + 4))) sonarCount[4]++;
  if ((sonar[4] == 1) && (!digitalRead(ECHO + 4)) && (sonarCount[4] > 0)) sonar[4] = 2;
  if ((sonar[5] == 1) && (digitalRead(ECHO + 5))) sonarCount[5]++;
  if ((sonar[5] == 1) && (!digitalRead(ECHO + 5)) && (sonarCount[5] > 0)) sonar[5] = 2;

  //PWM_L = 0;
  //PWM_R = 0;
  if (PWMCount == 0) {
    if (PWML) {
      digitalWrite(MOTOR + 2, HIGH);
      digitalWrite(MOTOR + 3, LOW);
    } else {
      digitalWrite(MOTOR + 2, LOW);
      digitalWrite(MOTOR + 3, HIGH);
    }
    if (PWMR) {
      digitalWrite(MOTOR, LOW);
      digitalWrite(MOTOR + 1, HIGH);
    } else {
      digitalWrite(MOTOR, HIGH);
      digitalWrite(MOTOR + 1, LOW);
    }
    digitalWrite(MOTOR + 4, HIGH);
  }
  if (PWMCount >= abs(PWM_R)) {
    digitalWrite(MOTOR, LOW);
    digitalWrite(MOTOR + 1, LOW);
  }
  if (PWMCount >= abs(PWM_L)) {
    digitalWrite(MOTOR + 2, LOW);
    digitalWrite(MOTOR + 3, LOW);
  }
  if (PWMCount >= PWM_LIMP) {
    digitalWrite(MOTOR + 4, LOW);
  }

  PWMCount++;
  if (PWMCount == 250) PWMCount = 0;
  Timer1.attachInterrupt(callback);
}

void setup()
{
  double p;
  //Serial.println("HMC5883 Magnetometer Test"); Serial.println("");

  /* Initialise the sensor */
  if (!mag.begin())
  {
    /* There was a problem detecting the HMC5883 ... check your connections */
    //Serial.println("Ooops, no HMC5883 detected ... Check your wiring!");
    while (1);
  }

  Serial.begin(9600);

  lcd.begin (16, 2);
  lcd.setBacklightPin(BACKLIGHT_PIN, POSITIVE);
  lcd.home ();
  lcd.setBacklight(HIGH);
  lcd.setCursor (0, 0);
  lcd.print("Limpa-Limpa");
  lcd.setCursor (0, 1);
  lcd.print("Iniciando...");

  pinMode(ECHO, INPUT);
  pinMode(ECHO + 1, INPUT);
  pinMode(ECHO + 2, INPUT);
  pinMode(ECHO + 3, INPUT);
  pinMode(ECHO + 4, INPUT);
  pinMode(ECHO + 5, INPUT);
  pinMode(TRIGR, OUTPUT);
  pinMode(MOTOR, OUTPUT);
  pinMode(MOTOR + 1, OUTPUT);
  pinMode(MOTOR + 2, OUTPUT);
  pinMode(MOTOR + 3, OUTPUT);
  pinMode(MOTOR + 4, OUTPUT);
  CalibrarBussola();
  Timer1.initialize(58);
  Timer1.attachInterrupt(callback);
  PWM_LIMP = PWM_T2;
  Xmax = -250;
  Xmin = 250;
  Ymax = -250;
  Ymin = 250;

  PWM_L = -130;
  PWM_R = 130;
  PWMR = 1;
  PWML = 0;
  while (millis() < timercalibrar) {
    readings();
  }

  PWM_L = 0;
  PWM_R = 0;
  PWMR = 0;
  PWML = 0;

  lcd.clear();
  lcd.setCursor (0, 0);
  lcd.print("Iniciado!");
  delay(timersetup);
  lcd.setBacklight(LOW);
  lcd.clear();
  delay(timersetup);
  lcd.setBacklight(HIGH);
}

void loop()
{
  lcd.clear();
  delay(10);
  search();
  readings();
  calcPWM();
  if (!mensagem) {
    obst();
  }

  if (Serial.available()) {
    int commandSize = (int)Serial.read();
    char command[commandSize];
    int commandPos = 0;
    while (commandPos < commandSize) {
      if (Serial.available()) {
        command[commandPos] = (char)Serial.read();
        commandPos++;
      }
    }
    command[commandPos] = 0;
    processCommand(command);
  }

  if ((millis() - TIM) > periodicMessageFrequency) {
    sendPeriodicMessages();
    TIM = millis();
  }

  if (millis() - timerlcd >= 200) {
    timerlcd = millis();
  }
}

// Look for obstacles with all 6 possible sensors
void search() {
  unsigned int aux = 0;

  if ((sonar[0] == 0) && (sonar[1] == 0) && (sonar[2] == 0) && (sonar[3] == 0) && (sonar[4] == 0) && (sonar[5] == 0)) {
    digitalWrite(TRIGR, LOW);
    delayMicroseconds(10);
    digitalWrite(TRIGR, HIGH);
    delayMicroseconds(10);
    digitalWrite(TRIGR, LOW);
    sonar[0] = 1;
    sonar[1] = 1;
    sonar[2] = 1;
    sonar[3] = 1;
    sonar[4] = 1;
    sonar[5] = 1;
  }

  for (aux = 0; aux < 6; aux++) {
    if (sonar[aux] == 2) {
      sonar[aux] = 0;
      cmi[aux][aux02] = sonarCount[aux];
      sonarCount[aux] = 0;
      sonartimeout = millis();
    }
    if (sonarCount[aux] > MAX_DISTANCE) {
      sonar[aux] = 0;
      sonarCount[aux] = 0;
    }
    cm[aux] = (cmi[aux][0] + cmi[aux][1] + cmi[aux][2] + cmi[aux][3] + cmi[aux][4]) / 5;
  }

  if ((millis() - sonartimeout) > 1000) {
    sonar[0] = 0;
    sonar[1] = 0;
    sonar[2] = 0;
    sonar[3] = 0;
    sonar[4] = 0;
    sonar[5] = 0;
    sonarCount[0] = 0;
    sonarCount[1] = 0;
    sonarCount[2] = 0;
    sonarCount[3] = 0;
    sonarCount[4] = 0;
    sonarCount[5] = 0;
  }

  aux02++;
  if (aux02 >= 5) aux02 = 0;
}

// Look if collided with obstacles and have the conditions to avoid them and change path
// Can be adapted however you want
void obst() {
  double errorCalc = 0;
  if (millis() >= (timercalibrar + timersetup + 2000)) {
    if ((((cm[3] <= DIST) || (cm[4] <= DIST) || (cm[5] <= DIST)) && obstaculo == 0) || ((obstOld == 1) && obstaculo == 0)) {
      obstaculo = 1;
      timerObstaculo = millis();
      lcd.clear();
      lcd.setCursor (0, 0); lcd.print("Obstaculo!!");
      lcd.setCursor (0, 1);
      if (obstOld == 1) lcd.print("Enrosquei!!");

      while (millis() - timerObstaculo < TRECUO) {
        PWM_LIMP = PWM_T2;
        PWM_L = -100;
        PWM_R = -100;
        PWMR = 0;
        PWML = 0;
      }

      dirObst = 0;
      if (cm[0] >= cm[2]) {
        errorCalc = errorZero - 135;
      } else {
        errorCalc = errorZero + 135;
      }

      vectorOBJ[0] = cos((PI * errorCalc) / 180);
      vectorOBJ[1] = sin((PI * errorCalc) / 180);

      timerObstaculo = millis();

    }
  }

  if ((millis() - timerObstaculo > TAVANCO) && (obstaculo == 1)) {
    obstaculo = 0;
    obstOld = 0;
    timerOld = millis();
    timerOld2 = millis();
  }

  if ((millis() - timerOld2 >= (3 * TPARADO)) && (obstaculo == 0) && (obstOld == 0)) {
    /*if ((cmOld[0] >= cm[0] - M) && (cmOld[0] <= cm[0] + M) && (cmOld[1] >= cm[1] - M) && (cmOld[1] <= cm[1] + M) &&
        (cmOld[2] >= cm[2] - M) && (cmOld[2] <= cm[2] + M) && (cmOld[3] >= cm[3] - M) && (cmOld[3] <= cm[3] + M) &&
        (cmOld[4] >= cm[4] - M) && (cmOld[4] <= cm[4] + M) && (cmOld[5] >= cm[5] - M) && (cmOld[5] <= cm[5] + M)) */
    if ((cmOld[3] >= cm[3] - M) && (cmOld[3] <= cm[3] + M) && (cmOld[4] >= cm[4] - M) && (cmOld[4] <= cm[4] + M) && (cmOld[5] >= cm[5] - M) && (cmOld[5] <= cm[5] + M)) {
      obstOld = 1;
    }
    cmOld[0] = cm[0];
    cmOld[1] = cm[1];
    cmOld[2] = cm[2];
    cmOld[3] = cm[3];
    cmOld[4] = cm[4];
    cmOld[5] = cm[5];
    timerOld2 = millis();
  }  else {
    if ((millis() - timerOld >= TPARADO) && (obstaculo == 0) && (obstOld == 0)) {
      if ((cmOld[3] >= cm[3] - N) && (cmOld[3] <= cm[3] + N) && (cmOld[4] >= cm[4] - N) && (cmOld[4] <= cm[4] + N) && (cmOld[5] >= cm[5] - N) && (cmOld[5] <= cm[5] + N)) {
        obstOld = 1;
      }
      cmOld[0] = cm[0];
      cmOld[1] = cm[1];
      cmOld[2] = cm[2];
      cmOld[3] = cm[3];
      cmOld[4] = cm[4];
      cmOld[5] = cm[5];
      timerOld = millis();
    }
  }
}

// Read the value from the compass and calculate the error between its direction and the path you want to go
void readings()
{
  int j = 0;
  sensors_event_t event;
  mag.getEvent(&event);

  double rawX = event.magnetic.x;
  double rawY = event.magnetic.y;
  double rawZ = event.magnetic.z;

  if ((rawZ > Zprim + 10) || (rawZ < Zprim - 10)) return;
  if ((rawX > Xmax))Xmax = rawX;
  if ((rawX < Xmin)) Xmin = rawX;
  if ((rawY > Ymax)) Ymax = rawY;
  if ((rawY < Ymin)) Ymin = rawY;

  vector[1] = ((rawY) - ((Ymax + Ymin) / 2)) / ((Ymax - Ymin) / 2);
  vector[0] = ((rawX)  - ((Xmax + Xmin) / 2)) / ((Xmax - Xmin) / 2);

  errorZero = (acos(vector[0])) * 180 / PI;
  if (vector[1] < 0) errorZero = 360 - errorZero;

  //vectorial product to find the error between two vectors
  error = (vectorOBJ[0] * vector[0] + vectorOBJ[1] * vector[1]) / (sqrt(vectorOBJ[0] * vectorOBJ[0] + vectorOBJ[1] * vectorOBJ[1]) * sqrt(vector[0] * vector[0] + vector[1] * vector[1]));
  error = (acos(error)) * 180 / PI;
  //find out the way the result vector is pointing
  sentido = vector[0] * vectorOBJ[1] - vector[1] * vectorOBJ[0];
  if (sentido > 0) error = -error;

  errorI[k] = error;
  errorISUM = 0;
  for (j = 0; j < NUM2; j++) {
    errorISUM = errorISUM + errorI[j];
  }

  switch (k) {
    case 0:
      errorD = errorI[k] - errorI[NUM2 - 2];
      break;
    case 1:
      errorD = errorI[k] - errorI[NUM2 - 1];
      break;
    default:
      errorD = errorI[k] - errorI[k - 2];
      break;
  }

  i++;
  if (i >= NUM1) i = 0;
  k++;
  if (k >= NUM2) k = 0;
}

// Calculate the PID control to the power of the motors using the error of the compass as measured
void calcPWM()
{
  if (error >= 0) {
    PWM_R = 100 - Kp * error - Ki * errorISUM - Kd * errorD;
    PWM_L = 100;
  }
  else {
    PWM_L = 100 + Kp * error  + Ki * errorISUM + Kd * errorD;
    PWM_R = 100;
  }

  if (PWM_R <= 0) PWM_R = PWM_R * 3;
  if (PWM_L <= 0) PWM_L = PWM_L * 3;

  if (PWM_R <= -100) PWM_R = -100;
  if (PWM_L <= -100) PWM_L = -100;
  if (PWM_R >= 100) PWM_R = 100;
  if (PWM_L >= 100) PWM_L = 100;
  if (abs(error) > 10) POTENCIA = 1.05;
  if (abs(error) > 20) POTENCIA = 1.1;
  if (abs(error) > 30) POTENCIA = 1.15;
  if (abs(error) > 40) POTENCIA = 1.2;
  if (abs(error) > 50) POTENCIA = 1.25;

  PWM_R = PWM_R * POTENCIA;
  PWM_L = PWM_L * POTENCIA;
  if (PWM_R >= 0) PWMR = 1;
  else PWMR = 0;
  if (PWM_L >= 0) PWML = 1;
  else PWML = 0;

  PWM_LIMP = PWM_T;
}

// Calibrate the compass
void CalibrarBussola()
{
  int j = 0;
  int Z[25];
  sensors_event_t event;
  for (j = 0; j < 20; j++) {
    mag.getEvent(&event);
    Z[j] = event.magnetic.z;
  }
  for (j = 20; j > 4; j--) {
    if ((Z[j] == Z[j - 1]) && (Z[j] == Z[j - 2]) && (Z[j] == Z[j - 3]))
    {
      Zprim = Z[j];
    }
  }
}

// Send a command via bluetooth
void processCommand(char* command) {
  mensagem = 1;
  switch (command[0]) {
    case 'U':
      vectorOBJ[0] = vector[0];
      vectorOBJ[1] = vector[1];
      break;
    case 'D':
      vectorOBJ[0] = -vector[0];
      vectorOBJ[1] = -vector[1];
      break;
    case 'L':
      vectorOBJ[0] = cos(PI * (errorZero + 90) / 180);
      vectorOBJ[1] = sin(PI * (errorZero + 90) / 180);
      break;
    case 'R':
      vectorOBJ[0] = cos((PI * (errorZero - 90)) / 180);
      vectorOBJ[1] = sin((PI * (errorZero - 90)) / 180);
      break;
  }
}

// Send a hole massage via bluetooth
void sendMessage(char* message) {
  int messageLen = strlen(message);
  if (messageLen < 256) {
    Serial.write(messageLen);
    Serial.print(message);
  }
}

// Send periodic messages via Bluetooth
void sendPeriodicMessages() {
  char str98[13];
  String str99 = String();
  str99 = "BUSSOLA:" + str99;
  str99.toCharArray(str98, 13);
  sendMessage(str98);
}
