//
//  ManualController.m
//  Roboticcccccc
//
//  Created by Timothy Chong on 1/23/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "ManualController.h"
#import "Base.h"
#import "Bottom.h"
#import "Middle.h"
#import "Top.h"

@implementation ManualController

-(id) init
{
    self =[super init];
    
    if( self)
    {
        BASE_MIN = 635;BASE_MAX = 2500;
        BOTTOM_MIN = 500; BOTTOM_MAX = 2500;
        MIDDLE_MIN = 500; MIDDLE_MAX = 2500;
        TOP_MIN = 500; TOP_MAX = 2500;
        baseAngle = 90; bottomAngle = 90; middleAngle = 135; topAngle = 90;
        counter =0;
        Gripping = NO;
       
        locals = [[NSMutableArray alloc]init];
        [self addLocations];
        
        serialPort = [[NSMutableString alloc] initWithString:@"/dev/tty.usbmodemfa131"];
        base = [[Base alloc]initWithAngle:baseAngle name:@"0" serialPort:serialPort min:BASE_MIN max:BASE_MAX range:180];
        middle = [[Middle alloc] initWithAngle:middleAngle name:@"2" serialPort:serialPort min:MIDDLE_MIN max:MIDDLE_MAX range:180];
        bottom = [[Bottom alloc] initWithAngle:bottomAngle name:@"1" serialPort:serialPort min:BOTTOM_MIN max:BOTTOM_MAX range:180];
        top = [[Top alloc] initWithAngle:topAngle name:@"3" serialPort:serialPort min:TOP_MIN max:TOP_MAX range:180];
        [self gripperOn];
    }
    return self;
}

-(void)addLocations {
   [locals addObject:[[Locations alloc]initWithAngles:67  bottomAngle:73 middleAngle:114 topAngle:37 toGrip:YES]];
     [locals addObject:[[Locations alloc]initWithAngles:67  bottomAngle:90 middleAngle:114 topAngle:37 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:66  bottomAngle:90 middleAngle:90 topAngle:37 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:66  bottomAngle:90 middleAngle:90 topAngle:71 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:43  bottomAngle:90 middleAngle:80 topAngle:71 toGrip:YES]];
   [locals addObject:[[Locations alloc]initWithAngles:43  bottomAngle:71 middleAngle:80 topAngle:71 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:43  bottomAngle:71 middleAngle:80 topAngle:71 toGrip:NO]];
     [locals addObject:[[Locations alloc]initWithAngles:43  bottomAngle:90 middleAngle:80 topAngle:71 toGrip:NO]];
   [locals addObject:[[Locations alloc]initWithAngles:83  bottomAngle:90 middleAngle:80 topAngle:71 toGrip:NO]];
    
    //^battery 1
     
   [locals addObject:[[Locations alloc]initWithAngles:83  bottomAngle:74 middleAngle:120 topAngle:37 toGrip:YES]];
        
    [locals addObject:[[Locations alloc]initWithAngles:83  bottomAngle:90 middleAngle:120 topAngle:37 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:83  bottomAngle:90 middleAngle:90 topAngle:71 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:66  bottomAngle:90 middleAngle:90 topAngle:71 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:43  bottomAngle:90 middleAngle:80 topAngle:71 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:43  bottomAngle:71 middleAngle:80 topAngle:71 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:43  bottomAngle:71 middleAngle:80 topAngle:71 toGrip:NO]];
   
   [locals addObject:[[Locations alloc]initWithAngles:43  bottomAngle:90 middleAngle:80 topAngle:37 toGrip:NO]];
   //^battery 2
    
    [locals addObject:[[Locations alloc]initWithAngles:102  bottomAngle:74 middleAngle:120 topAngle:38 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:102  bottomAngle:90 middleAngle:115 topAngle:38 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:114  bottomAngle:90 middleAngle:90 topAngle:71 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:137  bottomAngle:90 middleAngle:75 topAngle:71 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:137  bottomAngle:75 middleAngle:75 topAngle:71 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:137  bottomAngle:75 middleAngle:75 topAngle:71 toGrip:NO]];
    [locals addObject:[[Locations alloc]initWithAngles:137  bottomAngle:90 middleAngle:75 topAngle:71 toGrip:NO]];
     
    //battery 3
    
    [locals addObject:[[Locations alloc]initWithAngles:117  bottomAngle:73 middleAngle:115 topAngle:37 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:117  bottomAngle:90 middleAngle:115 topAngle:37 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:114  bottomAngle:90 middleAngle:90 topAngle:71 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:137  bottomAngle:90 middleAngle:75 topAngle:71 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:137  bottomAngle:75 middleAngle:75 topAngle:71 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:137  bottomAngle:75 middleAngle:75 topAngle:71 toGrip:NO]];
    [locals addObject:[[Locations alloc]initWithAngles:137  bottomAngle:90 middleAngle:75 topAngle:71 toGrip:NO]];
    
    //^battery 4
     [locals addObject:[[Locations alloc]initWithAngles:64  bottomAngle:80 middleAngle:80 topAngle:42 toGrip:NO]];
     [locals addObject:[[Locations alloc]initWithAngles:64  bottomAngle:63 middleAngle:108 topAngle:33 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:64  bottomAngle:70 middleAngle:108 topAngle:33 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:64  bottomAngle:70 middleAngle:40 topAngle:33 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:92  bottomAngle:70 middleAngle:40 topAngle:33 toGrip:YES]];
     [locals addObject:[[Locations alloc]initWithAngles:92  bottomAngle:65 middleAngle:70 topAngle:16 toGrip:NO]]; 
     [locals addObject:[[Locations alloc]initWithAngles:92  bottomAngle:80 middleAngle:70 topAngle:16 toGrip:NO]]; 
     // ^nail 1
    [locals addObject:[[Locations alloc]initWithAngles:78  bottomAngle:80 middleAngle:80 topAngle:42 toGrip:NO]];
    [locals addObject:[[Locations alloc]initWithAngles:78  bottomAngle:63 middleAngle:109 topAngle:33 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:78  bottomAngle:67 middleAngle:40 topAngle:33 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:92  bottomAngle:65 middleAngle:70 topAngle:16 toGrip:NO]];
    [locals addObject:[[Locations alloc]initWithAngles:92  bottomAngle:80 middleAngle:70 topAngle:16 toGrip:NO]]; 
    
    //^nail 2
    [locals addObject:[[Locations alloc]initWithAngles:92  bottomAngle:80 middleAngle:80 topAngle:42 toGrip:NO]];
    [locals addObject:[[Locations alloc]initWithAngles:92  bottomAngle:63 middleAngle:112 topAngle:33 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:92  bottomAngle:80 middleAngle:108 topAngle:33 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:92  bottomAngle:67 middleAngle:40 topAngle:33 toGrip:YES]];
    
    [locals addObject:[[Locations alloc]initWithAngles:92  bottomAngle:65 middleAngle:70 topAngle:16 toGrip:NO]];
    
    [locals addObject:[[Locations alloc]initWithAngles:92  bottomAngle:80 middleAngle:70 topAngle:16 toGrip:NO]]; 
    
    /// nail 3
    
    [locals addObject:[[Locations alloc]initWithAngles:106  bottomAngle:80 middleAngle:80 topAngle:33 toGrip:NO]];
    [locals addObject:[[Locations alloc]initWithAngles:106  bottomAngle:64 middleAngle:108 topAngle:33 toGrip:YES]];
     [locals addObject:[[Locations alloc]initWithAngles:106  bottomAngle:80 middleAngle:108 topAngle:33 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:106  bottomAngle:80 middleAngle:40 topAngle:33 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:92  bottomAngle:65 middleAngle:64 topAngle:16 toGrip: YES]];
    [locals addObject:[[Locations alloc]initWithAngles:92  bottomAngle:80 middleAngle:70 topAngle:16 toGrip:NO]]; 
    //^^nail 4
     
    [locals addObject:[[Locations alloc]initWithAngles:121  bottomAngle:80 middleAngle:80 topAngle:42 toGrip:NO]];
    [locals addObject:[[Locations alloc]initWithAngles:121  bottomAngle:64 middleAngle:108 topAngle:33 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:121  bottomAngle:90 middleAngle:108 topAngle:33 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:92  bottomAngle:67 middleAngle:60 topAngle:33 toGrip:YES]];
    [locals addObject:[[Locations alloc]initWithAngles:92  bottomAngle:65 middleAngle:70 topAngle:16 toGrip:NO]];
    [locals addObject:[[Locations alloc]initWithAngles:92  bottomAngle:80 middleAngle:70 topAngle:16 toGrip:NO]]; 
    //^nail 5
}

-(IBAction)start:(id)sender {
    for(int a = counter; a < [locals count]; a++) {
        [self nextStep];
        [NSThread sleepForTimeInterval:0.5];
    }
}

-(IBAction)stop:(id)sender {
    [timer invalidate];
    timer = nil;
}

-(IBAction)step:(id)sender {[self nextStep];}

-(IBAction)gripperClicked:(id)sender {
    if([grip state] == NSOnState) {[self gripperOn];}
    else                          {[self gripperOff];}
}

-(void) gripperOn {
    if(Gripping) {return;}
    [grip setState: NSOnState];
    Gripping = YES;
    NSMutableString *str = [[NSMutableString alloc]initWithFormat:@"echo 40000 > %@",serialPort];
    NSLog(@"%@",str);
    char * toSend = [str UTF8String]; 
    [str release];
    FILE * a =popen(toSend, "r");
    pclose(a);
}

-(void) gripperOff {
    if(!Gripping) {return;}
    [grip setState: NSOffState];
    Gripping = NO;
    NSMutableString *str = [[NSMutableString alloc]initWithFormat:@"echo 40001 > %@",serialPort];
    NSLog(@"%@",str);
    char * toSend = [str UTF8String]; 
    FILE * a =popen(toSend, "r");
    pclose(a);
    [str release];
}

-(IBAction)radioRightClicked:(id)sender {}  // Not implemented
-(IBAction)radioLeftClicked: (id)sender {}  // Not implemented

-(void) nextStep
{
    if(counter > [locals count] || counter < 0) {
        counter = 0;
        return;
    }
    
    double ang = [[locals objectAtIndex:counter] getTopAngle];
    [top moveTo:ang];
    topAngle = ang;
    [topText setDoubleValue:ang];
    [topStep setDoubleValue:ang];
    
    ang = [[locals objectAtIndex:counter] getBaseAngle];
    
    [base moveTo:ang];
    baseAngle = ang;
    [baseText setDoubleValue:ang];
    [baseStep setDoubleValue:ang];
    
    ang = [[locals objectAtIndex:counter] getmiddleAngle];
    
    [middle moveTo:ang];
    middleAngle = ang;
    [middleText setDoubleValue:ang];
    [middleStep setDoubleValue:ang];
    
    ang = [[locals objectAtIndex:counter] getBottomAngle];
    
    [bottom moveTo:ang];
    bottomAngle = ang;
    [bottomText setDoubleValue:ang];
    [bottomStep setDoubleValue:ang];
    
    if([[locals objectAtIndex:counter] getToGrip]) {[self gripperOn];}
    else                                           {[self gripperOff];}
    
    if(counter >= [locals count] - 1) {counter =0;}
    else                              {counter++;}
    
    [count setDoubleValue:counter];
}

- (void)controlTextDidEndEditing:(NSNotification *)aNotification {
    if      ([aNotification object] == baseText)    {[base moveTo:[baseText doubleValue]];}
    else if ([aNotification object] == bottomText)  {[bottom moveTo:[bottomText doubleValue]];}
    else if ([aNotification object] == middleText)  {[middle moveTo:[middleText doubleValue]];}
    else if ([aNotification object] == topText)     {[top moveTo:[topText doubleValue]];}
}

-(IBAction)baseClicked:(id)sender   {[base moveActualTo:baseAngle];}
-(IBAction)bottmClicked:(id)sender  {[bottom moveActualTo:bottomAngle];}
-(IBAction)middleClicked:(id)sender {[middle moveActualTo:middleAngle];}
-(IBAction)topClicked:(id)sender    {[top moveActualTo:topAngle];}

@end