
// Sketch to blink prop eyes when someone approaches.
// Behavior can be modified depending on how long they stay
// Test version blinks LED

#include <Servo.h> 

void Open_Eyes();
void Close_Eyes();
void Blink_Eyes();

Servo myservo;  // create servo object to control a servo 
 
int motionPin = 3;  // analog pin used to connect the motion detector
int motionVal;      // variable to read the value from the analog pin 

// Servo is attached on pin 9
int ServoPin = 9;

// Pin 13 has an LED connected on most Arduino boards.
// give it a name:
int led = 13;

// Flag for previous state
boolean wasHIGH = false;


void setup() {
  Serial.begin(9600);

  // initialize the servo on 'ServoPin'
  myservo.attach(ServoPin);  // attaches the servo on defined pin to the servo object 

  // initialize the digital pin as an output.
  pinMode(led, OUTPUT); 
  digitalWrite(led, LOW);    // turn the LED off by making the voltage LOW

  // Allow the motion detector to warm up.
  delay(20000);
  
  // Start with eyes closed
  Close_Eyes();

}

void loop() {

  motionVal=digitalRead(motionPin);
  boolean motion = (motionVal == 1);

  if (motion) {
    Open_Eyes();
    delay(2000);
    Blink_Eyes();
    Blink_Eyes();
    delay(3000);
    Blink_Eyes();
    delay(15000);
    Blink_Eyes();
    delay(15000);
    wasHIGH=true;
    digitalWrite(led,HIGH);
  }

  motionVal=digitalRead(motionPin);
  if (! motion) {
    if (wasHIGH) {
      Close_Eyes();
      wasHIGH = false;
    }
    digitalWrite(led,LOW);
  }
   
  delay(200);
}

void Close_Eyes() {
  for(int pos = 179; pos>=1; pos-=2){    // goes from 180 degrees to 0 degrees 
    myservo.write(pos);              // tell servo to go to position in variable 'pos' 
    delay(3);
  }
} 

void Open_Eyes() {
  for(int pos = 0; pos<180; pos+=2) {   // goes from 0 degrees to 179 degrees 
    myservo.write(pos);              // tell servo to go to position in variable 'pos' 
    delay(3);    // waits 1ms for the servo to reach the position 
  }
}

void Blink_Eyes() {
  Close_Eyes();
  Open_Eyes();
  delay(10);
 }

