/* *** *** ***
Mega -  ok       18.758/253.952 - 2.090/8.192
Leonardo - ok    21.498/28.672 - 2.059/2.560
UNO - no ok      18.800/32.256 - 2.090/2.048
*** *** *** */

#include <String.h>
#include <SPI.h>
#include <Ethernet.h>
#include "IRremote.h"
#include <DHT.h>

/*
controllare un condizionatore via web
con sensori di temperatura e umidità
ARDUINO UNO - limitato
Mega o Leonardo
ETHERNET SHIELD
DHT22, IR led
*/

byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED }; // mac address
byte ip[] = { 192, 168, 1, 135 }; // ip arduino internet in
byte gateway[] = { 192, 168, 1, 254 }; // internet access via router
byte subnet[] = { 255, 255, 255, 0 }; //subnet mask
EthernetServer server(80); //server port

IRsend irsend;
int khz = 38; //NB Change this default value as neccessary to the correct modulation frequency

// ON Deumidificatore
unsigned dry[] = {6124, 7352, 584, 1652, 528, 1628, 576, 1632, 560, 1620, 584, 1652, 528, 1628, 576,
                  1632, 560, 1620, 584, 560, 552, 564, 560, 584, 560, 556, 556, 588, 556, 560, 552,
                  588, 556, 564, 548, 1632, 584, 1624, 556, 1624, 580, 1628, 552, 1628, 588, 1620,
                  552, 1628, 584, 1624, 560, 560, 584, 556, 556, 560, 584, 560, 552, 564, 580, 564,
                  560, 580, 532, 584, 560, 1620, 560, 1648, 556, 1628, 556, 1624, 580, 1628, 552,
                  1628, 584, 1624, 580, 1600, 584, 560, 552, 592, 552, 564, 548, 592, 552, 564, 560,
                  584, 560, 556, 556, 560, 584, 1620, 560, 556, 580, 1628, 552, 564, 584, 1624, 556,
                  560, 584, 560, 552, 1628, 584, 556, 560, 1620, 580, 564, 560, 1620, 584, 560, 552,
                  1628, 584, 1624, 548, 568, 576, 564, 560, 1620, 584, 1624, 556, 588, 556, 1624, 560,
                  1620, 584, 560, 552, 1652, 560, 1620, 552, 592, 552, 564, 560, 1648, 556, 560, 552,
                  588, 556, 1624, 556, 588, 556, 560, 552, 1628, 588, 552, 560, 1648, 556, 560, 564,
                  1644, 556, 560, 552, 564, 584, 1620, 560, 556, 588, 1620, 552, 564, 580, 1628, 552,
                  588, 560, 1620, 560, 1620, 616, 7316, 588
                 };
// OFF - AC
unsigned OFF[] = {6128, 7356, 560, 1648, 556, 1628, 552, 1628, 584, 1624, 560, 1624, 580, 1628, 564,
                  1620, 584, 1624, 556, 560, 584, 560, 552, 564, 560, 584, 560, 556, 556, 588, 556,
                  560, 552, 592, 556, 1624, 556, 1624, 588, 1624, 560, 1620, 584, 1624, 556, 1624,
                  580, 1632, 560, 1620, 584, 560, 552, 564, 580, 564, 560, 556, 556, 588, 556, 560,
                  552, 588, 556, 588, 524, 1656, 560, 1620, 560, 1624, 580, 1628, 556, 1624, 588,
                  1620, 552, 1628, 584, 1624, 560, 584, 560, 556, 556, 560, 584, 560, 552, 564, 580,
                  564, 560, 556, 556, 588, 556, 1624, 560, 1620, 580, 1628, 556, 584, 560, 1648, 532,
                  584, 560, 560, 556, 1648, 552, 564, 560, 584, 560, 556, 556, 1624, 580, 564, 560,
                  1644, 560, 1624, 556, 560, 584, 556, 556, 1624, 580, 1628, 552, 564, 584, 1652, 528,
                  1624, 580, 564, 560, 1644, 556, 1628, 556, 584, 560, 556, 556, 1624, 588, 556, 556,
                  560, 588, 1620, 560, 556, 576, 564, 560, 1620, 584, 560, 552, 1628, 584, 560, 556,
                  1624, 588, 556, 556, 560, 572, 1632, 564, 556, 576, 1628, 556, 560, 584, 1624, 556,
                  560, 608, 1600, 560, 1620, 580, 7348, 612
                 };

// ON cool 22°C FAN-auto - AC
unsigned COOL[] = {6104, 7368, 556, 1624, 580, 1624, 560, 1648, 556, 1624, 560,
                   1672, 532, 1624, 580, 1624, 556, 1624, 580, 564, 560, 556, 580, 560,
                   564, 552, 580, 564, 560, 556, 556, 584, 560, 556, 560, 1644, 560, 1620,
                   580, 1628, 556, 1624, 580, 1624, 560, 1648, 556, 1624, 556, 1648, 556,
                   560, 556, 588, 556, 560, 552, 588, 556, 560, 552, 592, 556, 560, 552,
                   588, 556, 1624, 560, 1644, 560, 1620, 584, 1624, 560, 1616, 584, 1624,
                   548, 1656, 560, 1620, 552, 592, 552, 564, 604, 536, 556, 560, 552, 588,
                   556, 560, 552, 592, 552, 564, 552, 1652, 560, 556, 556, 1648, 556, 560,
                   608, 532, 592, 1588, 616, 1588, 560, 1648, 556, 560, 556, 1648, 588,
                   552, 528, 1652, 584, 1596, 608, 512, 580, 528, 552, 592, 584, 1596, 608,
                   532, 592, 524, 556, 1648, 588, 1592, 580, 560, 584, 1620, 584, 1596,
                   608, 536, 588, 1588, 608, 1596, 564, 552, 612, 532, 584, 1592, 612, 532,
                   588, 528, 608, 532, 580, 1624, 592, 524, 556, 1648, 588, 528, 552, 1652,
                   584, 532, 604, 536, 588, 1592, 612, 528, 584, 1596, 608, 532, 560, 1644,
                   592, 524, 556, 1648, 588, 1592, 612, 7308, 588
                  };


#define DHTPIN 2 // PIN data of DHT22
#define DHTTYPE DHT22 // DHT 22 (AM2302)
DHT dht(DHTPIN, DHTTYPE);

int irPin = 9; // pin IR led
String readString; //string
boolean COOLON = false; // flag status Cooling
boolean DRYON = false; // flag status Drying

void setup() {
  Ethernet.begin(mac, ip, gateway, subnet);
  dht.begin();
  pinMode(irPin, OUTPUT);
  Serial.begin(9600);
}

void loop() {

  float t = dht.readTemperature(); // Value of Temp
  float h = dht.readHumidity(); // Value of Humidity

  /*inizio client*/
  EthernetClient client = server.available();
  if (client) {
    boolean currentLineIsBlank = true;
    while (client.connected()) {
      if (client.available()) {
        char c = client.read();
        readString.concat(c); //memorizzo ogni carattere della stringa
        //if HTTP request has ended
        if (c == '\n' && currentLineIsBlank) {
          Serial.print(readString);

          if (readString.indexOf("L=0") > 0) {
            if (COOLON || DRYON) { // if is ON, switch it OFF
              //Serial.println("AC -> OFF");
              irsend.sendRaw(OFF, sizeof(OFF) / sizeof(int), khz);
              COOLON = false;
              DRYON = false;
            }
          }
          else if (readString.indexOf("L=1") > 0) { // lettura del valore se il AC si deve accendere
            if (!DRYON) { //se non è acceso
              //Serial.println("Dry ON");
              irsend.sendRaw(dry, sizeof(dry) / sizeof(int), khz);
              DRYON = true;
              COOLON = false;
            }
          }
          else if (readString.indexOf("L=2") > 0) {
            if (!COOLON) { //se è acceso
              //Serial.println("Cool ON");
              irsend.sendRaw(COOL, sizeof(COOL) / sizeof(int), khz);
              COOLON = true;
              DRYON = false;
            }
          }

          // COSTRUZIONE PAGINA HTML
          client.println("HTTP/1.1 200 OK.....");
          client.println("Content-Type: text/html");
          client.println();
          // inizializzo pagina (da togliere se uso ajax)
          client.print("<html><head><title>MoniCris AC</title><meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1' ></head><body>");
          //iniza il body
          client.println("<div style='width:960px; height:1136px;'>"); //risoluzione per nokia 5800 640x360, iPhone4 960x640 pixel, iPhone5 1136x640
          client.println("<h1>Home STATUS</h1><hr />");
          //Scrive sul browser il valore del termistore
          client.println("<p>TEMPERATURE = ");
          client.print(t);
          client.println(" *C <br /></p>");

          //Scrive sul browser il valore della fotoresistenza
          client.println("<p>HUMIDITY = ");
          client.print(h);
          client.println(" % <br /></p>");

          // link per aggiornare pagina e valori
          client.print("<h2>Refresh: <a href=''>CHECK</a></h2><hr />");
          client.println("<h1>AC CONTROL</h1>");
          //scrivo il AC status
          client.print("<font size='5'>Status: ");
          if (DRYON) {
            client.println("<span style='color:green; font-weight:bold;'>DRY</span></font>");
          }
          else if (COOLON) {
            client.println("<span style='color:green; font-weight:bold;'>COOL</span></font>");
          }
          else {
            client.println("<span style='color:grey; font-weight:bold;'>OFF</span></font>");
          }
          client.print("<h2><a href='/?L=1'> DRY </a> | <a href='/?L=0'> OFF </a> | <a href='/?L=2'> COOL </a></h2>");

          //semnătura ;)
          client.println("<hr />");
          client.print("<h4>MoniCris Home Project 2015</h4>");
          client.println("<hr />");

          // chiudo il div
          client.println("</div>");
          // chiudo pagina da togliere se uso ajax
          client.println("</body></html>");

          // pulisco la stringa per la successiva lettura
          readString = "";
          //fermo il client
          client.stop();

        } //if c == /n
      } // if client available
    } // while client connesso
  } // FINE if client
} // fine loop
