﻿package com.SocketsConnection{
	import flash.events.Event;
	import flash.events.IEventDispatcher;
	import flash.events.IOErrorEvent;
	import flash.events.EventDispatcher;
	import flash.events.ProgressEvent;
	import flash.events.DataEvent;
	import flash.errors.*;
	import flash.net.XMLSocket;
	import flash.events.TimerEvent;
	import flash.utils.Timer;

	public class XMLSocketModel extends SocketsModel {
		private var xmlSocket:XMLSocket;
		private var _hostName:String;
		private var _port:uint;
		public var _appID:String;
		private var reconnectTimer:Timer;
		
		public static const SOCKET_INCOMING_DATA:String="socketIncomingData";
		public static const SOCKET_PROGRESS:String="socketProgress";

		public function XMLSocketModel(hostName:String,port:uint,appId:String) {
			trace("XMLSocketConnection")
			_hostName=hostName;
			_port=port;
			appID=appId;
			connectSocket();
			reconnectTimer=new Timer(5000);
			reconnectTimer.addEventListener("timer", timerHandler);
		}

		override protected function connectSocket():void{
			xmlSocket=new XMLSocket();
			configureListeners(xmlSocket);
			xmlSocket.addEventListener(DataEvent.DATA, dataHandler);
			xmlSocket.addEventListener(ProgressEvent.PROGRESS, progressHandler);
			
			if (_hostName&&_port) {
				xmlSocket.connect(_hostName, _port);
			}
		}
		
		override public function sendMessage(msg:String):void {
			xmlSocket.send(msg+"\n");
		}
		
		public function set appID(appId:String):void {
			_appID=appId;			
		}
		
		public function get appID():* {
			return _appID;
		}
		
		//////////////////////
		//THE LISTENERS		//
		//////////////////////
		override protected function connectHandler(event:Event):void {
			if (event) {
				if(reconnectTimer.running){
					reconnectTimer.stop();
				}				
			} else {
				reconnectTimer.start();
			}
			data="connectHandler";			
			dispatchEvent(new Event(SocketsModel.SOCKET_CONNECT));
		}

		override protected function ioErrorHandler(event:IOErrorEvent):void {
			reconnectTimer.start();
			dispatchEvent(new Event(SocketsModel.SOCKET_IO_ERROR));
		}

		
		private function dataHandler(event:DataEvent):void {
			//trace("dataHandler: " + event);
			data=event.data;
			dispatchEvent(new Event(XMLSocketModel.SOCKET_INCOMING_DATA));
		}

		private function progressHandler(event:ProgressEvent):void {
			trace("progressHandler loaded:" + event.bytesLoaded + " total: " + event.bytesTotal);
			dispatchEvent(new Event(XMLSocketModel.SOCKET_PROGRESS));
		}
		
		private function timerHandler(event:TimerEvent):void {
            trace("Reconnect XMLSocket.");
			connectSocket();	
        }
	}
}