﻿package com.SocketsConnection
{
	import fl.controls.TextArea;
	import flash.events.Event;
	import flash.events.IEventDispatcher;
	import flash.events.EventDispatcher;
	import flash.text.TextField;
	import flash.utils.Timer;
	
	public class XMLSocketView extends SocketsView
	{		
		public var messageTextArea:TextArea;
		private var statusTextField:TextField;		
		
		public function XMLSocketView(m:TextArea,statusDisplay:TextField) {
			messageTextArea = m;
			statusTextField=statusDisplay;
		}
		
		override public function set socketsModel(socket:SocketsModel):void {
			_socketsModel=socket;
			addListeners(_socketsModel);
			socketsModel.addEventListener(XMLSocketModel.SOCKET_INCOMING_DATA, socketData);
			socketsModel.addEventListener(XMLSocketModel.SOCKET_PROGRESS, socketProgress);
		}
		
		//////////////////////
		//THE LISTENERS		//
		//////////////////////
		
		
		public function socketData(event:Event = null):void {
			parseData(_socketsModel.data);
		}
		
		public function socketProgress(event:Event = null):void {

		}
		
		private function parseData(xmlString:String):void{
			var tempStr:String = xmlString.toString();
			var xml:XML;
			xml=new XML(tempStr);   // Here new keyword is important to have otherwise it doesn't converts string to xml fomat
			if(xml.name()=="server-announce"){
				//trace(xml);
				if(xml.child(0).name()=="auth-request"){
					messageTextArea.htmlText+="Authorisation request.\nSending authorisation...\n---------------------\n";					
				}else if(xml.child(0).name()=="resource-connected"){
					messageTextArea.htmlText+="User '"+xml.child(0).@resourceID+"' has connected.\n---------------------\n";
				}else if(xml.child(0).name()=="resource-disconnected"){
					messageTextArea.htmlText+="User '"+xml.child(0).@resourceID+"' has disconected.\n---------------------\n";
				}else if(xml.child(0).name()=="welcome-message"){
					messageTextArea.htmlText+="Welcome!\n---------------------\n";
				}else if(xml.child(0).name()=="message"){
					messageTextArea.htmlText+="User '"+xml.child(0).@sender+"' said:"+xml.child(0).toString()+"\n---------------------\n";
				}else if(xml.child(0).name()=="resource-count"){
					messageTextArea.htmlText+="There are "+xml.child(0).@resourcesCount+" users online...\n---------------------\n";
				}else if(xml.child(0).name()=="queue-position"){
					messageTextArea.htmlText+="Your queue number is "+xml.child(0).@queue+".\n---------------------\n";
				}
			}
		}
				
		override public function socketClose(event:Event = null):void {
			statusTextField.htmlText="Closed";
			statusTextField.textColor=0x333333;
		}
		
		override public function socketConnect(event:Event = null):void {
			statusTextField.htmlText="Connected";
			statusTextField.textColor=0x009900;
		}
		
		override public function socketIOError(event:Event = null):void {
			statusTextField.htmlText="Failed";
			statusTextField.textColor=0xCC3300;
		}
		
		override public function socketSecurityError(event:Event = null):void {
			trace("=======================");
			trace("SocketView / socketSecurityError");
			trace("=======================");
		}
		
	}
}