#!/usr/bin/php -q
<?php
 
error_reporting(E_ALL);
 
set_time_limit(0);
 
ob_implicit_flush();
 

// Here you have to enter you computers IP. If its the only computer in your LAN use 127.0.0.1
$address = '192.168.1.119';
$port = 8890;
$queue = 0;
 
//---- Function to Send out Messages to Everyone Connected ----------------------------------------
 
function send_Message($allclient, $buf) { 
  global $client_list; 
  foreach($allclient as $client) { 
    if($client_list[$client]['state'] && $client_list[$client]['nick'] != ""){ 
      socket_write($client, trim($buf).chr(0)); 
    } 
  } 
}

//---- Function to Send out Messages to Everyone Else except the sender ---------------------------
function send_Message_to_others($allclient, $buf, $sender) { 
  global $client_list; 
  foreach($allclient as $client) { 
    if($client_list[$client]['state'] && $client_list[$client]['nick'] != "" && $client_list[$client]['nick'] != $sender){ 
      socket_write($client, trim($buf).chr(0)); 
    } 
  } 
}

//---- Function to Send out Message to a single user ----------------------------------------
function send_Single($socket, $buf) { 
	socket_write($socket, $buf.chr(0)); 
}

//---- Function to get names and the count of Everyone Connected. Called when a new user connects ----------------------------
function who($allclient, $socket) { 
  global $client_list; 
  $buf = ""; 
  $counter = 0; 
  foreach($allclient as $client) { 
   	if($counter==0){
    	$buf.=$client_list[$client]['nick']; 
	}else{
		$buf.=", ".$client_list[$client]['nick'];
	}
    $counter++; 
  }
  	send_Message($allclient,"<server-announce><resource-count count=\"".$counter."\"></resource-count></server-announce>"); 
}

//---- Function to get the user count ----------------------------------------
function getUserCount($allclient){
	$count = 0; 
	foreach($allclient as $client) { 
		$count++; 
	}
	return $count;
}

function shutDown($allclients, $master){ 
  global $abort; 
  $abort = false; 
  foreach($allclients as $client){ 
    echo "$client connection closed\n"; 
    socket_close($client); 
  } 
  echo "$master connection closed\n"; 
  socket_close($master); 
  echo "Server shutdown complete\n"; 
}

function addToQueue($allclient,$clientToAdd){
	global $queue;
	global $client_list;
	
	foreach($allclient as $client) {
		$nick=$client_list[$client]['nick'];		
		if($nick!="AIR0"){
			if($nick==$clientToAdd && $client_list[$client]['queuePosition']==""){
				$client_list[$client]['queuePosition']=$queue;
				send_Single($client,"<server-announce><queue-position queue=\"".$client_list[$client]['queuePosition']."\"></queue-position></server-announce>");
				echo "$nick has entered the queue at number ".$client_list[$client]['queuePosition']."\n"; 
				$queue++;
				break;
			}
		}
	}
}

function timeoutFromQueue($allclient,$clientToRemove){
	global $queue;
	global $client_list;
	$queueToRemove=$clientToRemove['queuePosition'];
	$previousQueue=0;
	
	foreach($allclient as $client) { 
		$nick=$client_list[$client]['nick'];
		if($nick!="AIR0"){
			if($nick!=$clientToRemove['nick']){
				if($client_list[$client]['queuePosition']>=$queueToRemove){
					$queuePosition=$client_list[$client]['queuePosition'];
					$client_list[$client]['queuePosition']=intval($queuePosition)-1;
					echo $client_list[$client]['nick']. " new queue number is ".$client_list[$client]['queuePosition']."\n";
					send_Single($client,"<server-announce><queue-position queue=\"".$client_list[$client]['queuePosition']."\"></queue-position></server-announce>");
			}
			}else{
				$clientToRemove['queuePosition']="";
				$queue--;
				checkQueue();
				send_Single($client,"<server-announce><queue-position queue=\"".$clientToRemove['queuePosition']."\"></queue-position></server-announce>");
				echo $clientToRemove['nick']." has been timed out from the queue. New queue value is ".$queue."\n";
			}
		}
	}
}

function removeFromQueue($allclient,$upperQueueLimit){
	global $queue;
	global $client_list;	
	$previousQueue=0;
	
	foreach($allclient as $client) { 
		$nick=$client_list[$client]['nick'];
		if($nick!="AIR0"){
			if($client_list[$client]['queuePosition']>$upperQueueLimit){
				$queuePosition=$client_list[$client]['queuePosition'];
				$client_list[$client]['queuePosition']=intval($queuePosition)-1;
				echo $client_list[$client]['nick']. "new queue number is ".$client_list[$client]['queuePosition']."\n";
				send_Single($client,"<server-announce><queue-position queue=\"".$client_list[$client]['queuePosition']."\"></queue-position></server-announce>");
			}
		}
	}
	$queue--;
	checkQueue();
}

//---- Check if the queue whent below 0 -------------------------------------
function checkQueue(){	
	global $queue;
	if($queue<0){
		$queue=0;
	}
}

 
//---- Start Socket creation for PHP 5 Socket Server -------------------------------------
 
if (($master = socket_create(AF_INET, SOCK_STREAM, SOL_TCP)) < 0) {
	echo "socket_create() failed, reason: " . socket_strerror($master) . "\n";
}
 
socket_set_option($master, SOL_SOCKET,SO_REUSEADDR, 1);
 
 
if (($ret = socket_bind($master, $address, $port)) < 0) {
	echo "socket_bind() failed, reason: " . socket_strerror($ret) . "\n";
}else{ 
	echo "$ret socket bound to $address:$port\n"; 
}
 
 
if (($ret = socket_listen($master, 5)) < 0) {
	echo "socket_listen() failed, reason: " . socket_strerror($ret) . "\n";
}else{ 
  	echo "$ret listening...\n"; 
}
 
 
 
$read_sockets = array($master);
$client_list = array($master); 
$abort = true;

//---- This is the crossdomain policy. You hav to change which domains to alow so it can work ---------------------------------------- 
$policy_file = 
    '<'.'?xml version="1.0" encoding="UTF-8"?'.'>'. 
    '<cross-domain-policy xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="http://www.adobe.com/xml/schemas/PolicyFileSocket.xsd">'. 
        '<allow-access-from domain="arduinoproject.no-ip.org" to-ports="8890" secure="false" />'.'<allow-access-from domain="funkyzeitmac.local" to-ports="8890" secure="false" />'.'<allow-access-from domain="www.pimedius.com" to-ports="8890" secure="false" />'. 
        '<site-control permitted-cross-domain-policies="master-only" />'. 
    '</cross-domain-policy>'; 

 
//---- Create Persistent Loop to continuously handle incoming socket messages ---------------------
while (true) {
	$changed_sockets = $read_sockets;
 
	$num_changed_sockets = socket_select($changed_sockets, $write = NULL, $except = NULL, NULL);
 
	foreach($changed_sockets as $socket) { 
		if ($socket == $master) { 
			if (($client = socket_accept($master)) < 0) {
				echo "socket_accept() failed: reason: " . socket_strerror($msgsock) . "\n";
				continue;
			} else {
				//----This is when a new user connects. First send the crossdomain policy then request authentication
				array_push($read_sockets, $client);
				$client_list[$client]['state'] = false;
		    	$client_list[$client]['nick'] = "";
				$client_list[$socket]['queuePosition']="";
				send_Single($client, $policy_file);
				send_Single($client,"<server-announce><auth-request></auth-request></server-announce>");
			}
		} else { 
			$bytes = socket_recv($socket, $buffer, 2048, 0); 			
			if ($bytes == 0) {
				$nick = $client_list[$socket]['nick'];
				$queuePosition=$client_list[$socket]['queuePosition'];
        		$iindex = array_search($socket, $client_list); 
        		unset($client_list[$iindex]); 
        		$index = array_search($socket, $read_sockets); 
        		unset($read_sockets[$index]); 
        		$allclients = $read_sockets; 
        		array_shift($allclients); 
				if($client_list[$socket]['nick'] != "" && $client_list[$socket]['nick'] != "<policy-file-request/>"){ 
					//----This is when a user disconnects.					
					removeFromQueue($allclients,$queuePosition);
					echo "[connection-terminated]:$socket\n"; 
					send_Message($allclients, "<server-announce><resource-disconnected resourceID=\"".$nick."\"resourcesCount=\"".getUserCount($allclients)."\"></resource-disconnected></server-announce>");
					
    			}
				socket_close($socket);
			}else{
				if($bytes){ 
      				if($client_list[$socket]['state'] === false){ 
						echo $buffer;
        				$tempBuf = trim($buffer);
        				$testCase = false; 
        				foreach($read_sockets as $clients){ 
          					if ($client_list[$clients]['nick'] == $tempBuf) {
								//----This is when a new user authenticates with a username that is already taken
            					$testCase = true; 
            					send_Single($socket, "<server-announce><auth-request></auth-request></server-announce>");
            					break; 
          					} 
        				} 
        				if(!$testCase){
							//----This is when a new user is sucsefully athunticated. It sends a welcome message with the current user count
          					$client_list[$socket]['nick'] = $tempBuf; 
          					echo "$tempBuf assigned to $socket\n";
							$allclients = $read_sockets; 
              				array_shift($allclients);
          					send_Single($socket, "<server-announce><welcome-message resourcesCount=\"".getUserCount($allclients)."\"></welcome-message></server-announce>");
          					
							if($client_list[$socket]['nick'] != "" && $tempBuf != "<policy-file-request/>"){
                				//----This is sends the message to all other users the name of the new user and the new user count								
								addToQueue($allclients,$client_list[$socket]['nick']);
								send_Message_to_others($allclients,	"<server-announce><resource-connected resourceID=\"".$client_list[$socket]['nick']."\"resourcesCount=\"".getUserCount($allclients)."\"></resource-connected></server-announce>",$client_list[$socket]['nick']); 
          					} 
          					$client_list[$socket]['state'] = true; 
        				} 
      				}else{ 
            			$allclients = $read_sockets; 
            			array_shift($allclients); 
        				if(trim($buffer) == "shut-down-server"){ 
          					//shutDown($allclients, $master); 
        				}else{ 
          					if(trim($buffer) == "/who"){ 
            					who($allclients, $socket); 
          					}else if(trim($buffer) == "getInQueue"){ 
	            				addToQueue($allclients,$client_list[$socket]['nick']);
	          				}else if(trim($buffer) == "timeoutFromQueue"){ 
		            			timeoutFromQueue($allclients,$client_list[$socket]);
		          			}else{
								//----This is when a user sends a message
          						send_Message_to_others($allclients,	"<server-announce><message sender=\"".$client_list[$socket]['nick']."\">".trim($buffer)."</message></server-announce>",$client_list[$socket]['nick']);
          					}
 						}
					} 
				}
			}
		}
	}
} 
?>