/****************
 * Begin definition
 ****************/
#ifndef UTILITY_H
#define UTILITY_H

/****************************************************************
 * Libraries
 ****************************************************************/

/****************************************************************
 * Definitions
 ****************************************************************/

/********************************
 * Constants
 ********************************/

/****************
 * Debugging constants
 ****************/
#define DEBUGGING true
/*
 * Use this to turn on debugging to get annoying messages popping
 * up on serial.
 * Each function will also have its own debugging definition above
 * its function definition. This allows you to toggle debugging for
 * individual functions as well.
 */
#define LOOP_DEBUGGING false
#define PWM_SET_DEBUGGING false
  // This is the only debugging designed to work with another.
  // It's supposed to work with PID debugging, to let me know
  // how often PWM_SET updates our motor output, as compared to how
  // often our PID updates.
#define PID_ERROR_DEBUGGING false
#define VALUE_TO_SPEED_DEBUGGING false
#define PID_DEBUGGING false
#define TARGET_CTRL_DEBUGGING false

/****************
 * ISR constants
 ****************/
#define ENCODER_DIRECTION  RISING
/*
 * By changing the polarity of our encoder interrupt, we can change
 * which direction results in a positive polarity on the direction
 * pin.
 * Therefore, if applying a positive direction to the motors
 * (i.e. a positive or true value to the DIRECTION pin) does not result
 * in a positive value being read from SB during the interrupt,
 * then changes this from RISING to FALLING, or verse visa.
 * 
 * This constant is used in the setup() function.
 */

/****************
 * PWM constants
 ****************/
#define PWM_SETTLE_TIME 1
/*
 * Give the PWM 1 millisecond to settle when switching
 * directions, to prevent H-bridge shorting.
 * Honestly we could probably go for something shorter than this,
 * but this will work fine for us.
 */

/****************
 * Speed constants
 ****************/
#define SPEED_MIN 20
/*
 * Our measured value was 18
 * This is the lowest speed you're allowed to target. If you target
 * too much lower than this, the motor will no longer be able to
 * overcome dynamic friction and will stop spinning.
 */
#define SPEED_RANGE 320
/*
 * This range constant is conveniant when converting target value to
 * target speed.
 */

/****************
 * Period constants
 ****************/
#define PERIOD_MAX 63
/*
 * Our measured value was 63460 (microsections)
 * This is the period reported by the encoders when moving at the
 * slowest possible speed (39 PWM).
 */

/****************
 * PID constants
 ****************/
#define K_P 1.0
#define K_I 0.1
#define K_D 0.0
/*
 * These constants are used to adjust your PID.
 */

/********************************
 * Pins
 ********************************/
#define DIR 7 // The direction pin connected to the HB5
#define EN  6 // The enable pin connected to the HB5
              // used for PWM setting of motor speed
#define SA  3 // Signal A on the HB5, used for encoder interrupts
#define SB  9 // Signal B on the HB5, used for encoder direction
#define POT 8 // Onboard POT
#define BTN2  PIN_BTN1  // Onboard buttons labeled 2 and 3 for
#define BTN3  PIN_BTN2  // almost no reason.

/****************
 * End definition
 ****************/
#endif
