import processing.serial.*;
Serial myPort;        // The serial port
String value = "";
int time = 0;
int prev_time = 0;
ArrayList<Effect> effects = new ArrayList();
int numberOfEffects;
int t=0;

import ddf.minim.*;

Minim minim;
AudioSnippet player_1; 
AudioSnippet player_2; 
AudioSnippet player_3; 
AudioSnippet player_4; 

int starting_point = 0;
 
void setup () {
  
  frameRate(60);
  
  minim = new Minim(this);
  
  size(1000, 1000, P3D);  
  // List all the available serial ports
  println(Serial.list());
  myPort = new Serial(this, Serial.list()[2], 9600);
  myPort.bufferUntil('\n');
  
  background(255); // set inital background:
  noStroke();
  colorMode(RGB,255);
  
  numberOfEffects = 0;
  
  player_1 = minim.loadSnippet("test.wav");
  player_2 = minim.loadSnippet("Crash_01.wav");
  player_3 = minim.loadSnippet("Hat_01.wav");
  player_4 = minim.loadSnippet("Hat_02.wav");
}
 
void draw () {
  background(255);
  
 // everything happens in the serialEvent() 
 if(numberOfEffects > 0){
   for(int i=starting_point; i < numberOfEffects; i++){
      starting_point += effects.get(i).enlarging(); 
   }
 }
 
  time++;
  
}
 

void serialEvent (Serial myPort) {
 String inData = myPort.readStringUntil('\n');
 
  if (inData != null) {
   inData = trim(inData);
   value = inData;
   
   if(time - prev_time >= 10){
     numberOfEffects++;
 
      if(inData.charAt(0) == 'C'){
        player_1.rewind();
        player_1.play();
        effects.add(new Effect('c'));
        
      }else if(inData.charAt(0) == 'D'){
        player_2.rewind();
        player_2.play();
        effects.add(new Effect('d'));
      }else if(inData.charAt(0) == 'E'){
        player_3.rewind();
        player_3.play();
        effects.add(new Effect('e'));
      }else if(inData.charAt(0) == 'F'){
        player_4.rewind();
        player_4.play();
        effects.add(new Effect('f'));
      }
      
      prev_time = time;
   }
    
  }
}



