/* PPM output code created by Hasi, http://www.rcgroups.com/forums/member.php?u=378119
 * Here's the code page http://www.rcgroups.com/forums/showthread.php?t=1808432
 * 
 * The MeetAndroid library is by Bonifaz Kaufmann and Leah Buechley. Find his page at
 * http://www.amarino-toolkit.net/
 * 
 * Special thanks to Matthew Hyatt for his asistance with this project.   
 * 
 * Code created/edited by A.J. Robinson 
 * http://www.instructables.com/member/FoamboardRC/
 * https://www.youtube.com/channel/UC5kebdhcny3-y6wiiDlSZdw 
 * Link to full instructions: 
 */


#include <MeetAndroid.h> // the library for getting the accelerometer data over bluetooth
float data[3] = {0};  // creating an array for the accelerometer data
MeetAndroid meetAndroid(error); //The Android bluetooth stuff. Don't touch this.
void error(uint8_t flag, uint8_t values) // more bluetooth stuff.
 { 
   Serial.print("ERROR: ");
   Serial.print(flag);
 }


float roll;  // a variable for roll
float pitch; // pitch variable
int pitchval; //this is for the remmapped and constrained value of pitch
int rollval;  //this is for the remmapped and constrained value of roll
int throttlepot = A1; // throttle control with a 10 or 100K pot on pin A1
int throttle;

int statusLED = 6;
int statuspin = 7;
int statusstate;
int currentMillis = 0;
int previousMillis = 0;
int waittime = 750;


//////////////////////CONFIGURATION///////////////////////////////
#define chanel_number 8  //set the number of chanels
#define default_servo_value 1500  //set the default servo value
#define PPM_FrLen 22500  //set the PPM frame length in microseconds (1ms = 1000µs)
#define PPM_PulseLen 300  //set the pulse length
#define onState 1  //set polarity of the pulses: 1 is positive, 0 is negative
#define sigPin 10  //set PPM signal output pin on the arduino
//////////////////////////////////////////////////////////////////


/*this array holds the servo values for the ppm signal
 change theese values in your code (usually servo values move between 1000 and 2000)*/
int ppm[chanel_number];

void setup()
 {
  Serial.begin(115200);
  meetAndroid.registerFunction(floatValues, 'A');    //initiallize default ppm values
  for(int i=0; i<chanel_number; i++){
    ppm[i]= default_servo_value; }

  pinMode(sigPin, OUTPUT);
  pinMode(statuspin, INPUT);
  pinMode(statusLED, OUTPUT);
  pinMode(throttlepot, INPUT);
  digitalWrite(sigPin, !onState);  //set the PPM signal pin to the default state (off)
  
  cli();
  TCCR1A = 0; // set entire TCCR1 register to 0
  TCCR1B = 0;
  
  OCR1A = 100;  // compare match register, change this
  TCCR1B |= (1 << WGM12);  // turn on CTC mode
  TCCR1B |= (1 << CS11);  // 8 prescaler: 0,5 microseconds at 16mhz
  TIMSK1 |= (1 << OCIE1A); // enable timer compare interrupt
  sei();
}

void loop()
{
  meetAndroid.receive(); // this gets bluetooth data. Don't touch!
  throttle = analogRead(throttlepot);
  throttle = map(throttle, 0, 1023, 1000, 2000);
  ppm[0] = throttle;
  ppm[1] = rollval;
  ppm[2] = pitchval;

  statusstate = digitalRead(statuspin);

  if (statusstate == 0)
    {
      digitalWrite(statusLED, LOW);
    }

  if (statusstate == 1)
    {
     digitalWrite(statusLED, HIGH);
    }

}
////////////////////////////PPMOUPUTSTUFF//////////////////

ISR(TIMER1_COMPA_vect){  //leave this alone
  static boolean state = true;
  
  TCNT1 = 0;
  
  if(state) {  //start pulse
    digitalWrite(sigPin, onState);
    OCR1A = PPM_PulseLen * 2;
    state = false;
  }
  else{  //end pulse and calculate when to start the next pulse
    static byte cur_chan_numb;
    static unsigned int calc_rest;
  
    digitalWrite(sigPin, !onState);
    state = true;

    if(cur_chan_numb >= chanel_number){
      cur_chan_numb = 0;
      calc_rest = calc_rest + PPM_PulseLen;// 
      OCR1A = (PPM_FrLen - calc_rest) * 2;
      calc_rest = 0;
    }
    else{
      OCR1A = (ppm[cur_chan_numb] - PPM_PulseLen) * 2;
      calc_rest = calc_rest + ppm[cur_chan_numb];
      cur_chan_numb++;
    }     
  }
}

//////////////////////////Replace eveything below with page 1//////////////////////////

void floatValues(byte flag, byte numOfValues)
{
  // create an array where all event values should be stored
  // the number of values attached to this event is given by
  // a parameter(numOfValues)
  
  // call the library function to fill the array with values (floats)
  meetAndroid.getFloatValues(data);
  

  for (int i=0; i<3;i++)  // this prints the raw accelerometer data to the serial monitor.
   {
     meetAndroid.send(data[i]);//Used for debug purposes
   } 


   pitch = data[0]; // Assinging the variable pitch to the data assigned to index 0 in array 'data'
   roll = data[1];  // Assinging the variable pitch to the data assigned to index 1 in array 'data'

   pitch = (pitch * -1000); // multiply by 1000 to get rid of the decimals
   roll = (roll * 1000);   
   
   pitchval = map(pitch,-5500, 5500, 1000, 2000) -12 ; 
   rollval = map(roll, -5500, 5500, 1000, 2000) + 7;  
   pitchval = constrain(pitchval, 1000, 2000);  
   rollval = constrain(rollval, 1000, 2000);    


   // this jsut prints data to the serial monitor for easy viewing 
   Serial.print("              Roll ==  ");
   Serial.print(rollval);
   Serial.print("   Pitch == ");
   Serial.println(pitchval);
            
}

