/*
  This code will load two images
  Ignore all color but black
  Break pixel number into coordenates
  Sort pixels by Y value
  Do the same with 2nd image
  Assign x values from one image to z values from the other
  Render pixels as points in 3D space
  Output obj when 'r' is pressed
  Sebastian Morales March 2015
*/

//User Variables
int spacity=40  ;//if the program runs out of memory while running increase this variable. 
int voxelSize=3;

//Code variables
import peasy.*;
PeasyCam cam;
import nervoussystem.obj.*;

ArrayList<PVector> vertexes = new ArrayList();
ArrayList<PVector> CombVertexes = new ArrayList();
ArrayList<SortYVector> Yvertexes = new ArrayList();//SortYVector will be used to sort by Y
ArrayList<SortYVector> Y2vertexes = new ArrayList();//SortYVector will be used to sort by Y

PImage img;
PImage img2;

int dimension=0;
int dimension2=0;
int threshhold=-1675000;  //This value is the threshhold, in this case for a color close to black (-16777216)

int pixelImg1=0;
int pixelImg2=0;
int pixelArraySize=0;

float rotation=0;

PrintWriter output;
float rotate=0;
int pixelNum=0;

boolean matchFound=false;

void setup() {
  img2= loadImage("robot.jpg");
  img= loadImage("r2d2.jpg");
  size(img.width,img.height, P3D);  
  dimension = img.width * img.height;
  dimension2 = img2.width * img2.height;

  pixelToPoints();

//*  //Camera  
  cam = new PeasyCam(this,100);
  cam.setYawRotationMode(); 
  float fov = PI/200.0;
  float cameraZ = (img.height/2.0) / tan(fov/2.0);
  perspective(fov, float(img.width)/float(img.height), cameraZ/10.0, cameraZ*10.0);
  cam.setMinimumDistance(30000);
 // cam.setMaximumDistance(35000);
  
// Print to file
  output = createWriter("positions.txt"); 

//*/
}

void draw() {
 
  background(0);
  scale(01);
  lights();
  stroke(255);
  fill(250);
  beginShape(POINTS);
  //rotateY(rotate);
  //rotate=rotate+.1;

  for(int i=0; i<CombVertexes.size(); i++) {
   PVector p =CombVertexes.get(i);
   //Offset values to get image centered
   float x=(p.x-580); 
   float y=(p.y-img.height/2)*1;
   float z=(p.z-580);
   output.println(x+" "+y+" "+z);// save to file
   //vertex(x,y,z);
   pushMatrix();
   translate(x,y,z);
   box(voxelSize);
   popMatrix();
  }
  endShape();
 // println("frame rate: " + frameRate);
}



void pixelToPoints(){
  println("Transforming image into 3D points...");
  for(int i=0;i< dimension;i++){
    if(img.pixels[i]<threshhold){
      int y=ceil(i/width);
      int x=(i-(width*(y-1)));
     // int z=floor(random(width));
      int z=0;
      PVector v = new PVector(x,y,z); //x,y,z
      vertexes.add(v); //and add it!  
      SortYVector vY= new SortYVector(x,y,z);
      Yvertexes.add(vY);//add the new info into the array
      pixelImg1++;

     }
  }
  
  for(int i=0;i< dimension2;i++){
    if(img2.pixels[i]<threshhold){
      int y=ceil(i/width);
      int z=(i-(width*(y-1)));
      int x=floor(random(width));
      SortYVector vY2= new SortYVector(x,y,z);
      Y2vertexes.add(vY2);//add the new info into the array
      pixelImg2++; 
    }
  }
  
  println("Transformation finished");
  if (pixelImg1<=pixelImg2){pixelArraySize=pixelImg1;}
  if (pixelImg1>pixelImg2){pixelArraySize=pixelImg2;}
  println(pixelImg1+" "+pixelImg2+" "+pixelArraySize);
  combinePixels(pixelImg1,pixelImg2);
}

void record(){
    OBJExport obj = (OBJExport) createGraphics(10,10,"nervoussystem.obj.OBJExport","head.obj");
    obj.setColor(true);
    obj.beginDraw();
    obj.noFill();
    drawColorCube(obj);
    obj.endDraw();
    obj.dispose();
    println("Done! Remember to change the name for new files not to override.");  
}
void keyPressed() {
  if(key == 'r') record();
}

void drawColorCube(PGraphics pg) {
  pg.beginShape();
   for(int i=0; i<CombVertexes.size(); i++) {
   PVector p =CombVertexes.get(i);
   //Offset values to get image centered
   float x=(p.x-580); 
   float y=(p.y-img.height/2)*1;
   float z=(p.z-580);
   pg.pushMatrix();
   pg.translate(x,y,z);
   pg.box(voxelSize);
   pg.popMatrix();
  }
  pg.endShape();
}
