﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.IO.Ports;
using System.Windows.Forms;

namespace MPULogger
{
    public partial class COM : Form
    {
        static SerialPort _serialPort;

        DateTime new_date;
        DateTime old_date;

        double new_counter;
        double old_counter;
        double delta_counter;
        double dt;
        int filter;
        int rd_counter;
        double velocity; // m/s
       
        public COM()
        {
            InitializeComponent();
            InitMainPort();

            this.CHART_ACCX.Series["Values_OLD"].Points.Clear();
            this.CHART_ACCX.Series["Values_NEW"].Points.Clear();
            this.CHART_ACCX.Series["Values_DELTA"].Points.Clear();
            this.CHART_ACCX.ChartAreas[0].AxisY.Maximum = 2500;
            this.CHART_ACCX.ChartAreas[0].AxisY.Minimum = -2500;

            filter = this.VSB_Filter.Value;
            this.LB_TMR0Rate.Text = this.VSB_TMR0Rate.Value.ToString();
            this.LBL_Filter.Text = filter.ToString();
        }

        public void InitMainPort()
        {
            StringComparer stringComparer = StringComparer.OrdinalIgnoreCase;


            // Create a new SerialPort object with default settings.
            _serialPort = new SerialPort();

            // Allow the user to set the appropriate properties.
            _serialPort.PortName = "COM6";                 // SetPortName(_serialPort.PortName);
            _serialPort.BaudRate = 115200;                  // SetPortBaudRate(_serialPort.BaudRate);
            _serialPort.Parity = Parity.None;               // SetPortParity(_serialPort.Parity);
            _serialPort.DataBits = 8;                       // SetPortDataBits(_serialPort.DataBits);
            _serialPort.StopBits = StopBits.One;            // SetPortStopBits(_serialPort.StopBits);
            _serialPort.Handshake = Handshake.None;         // SetPortHandshake(_serialPort.Handshake);

            _serialPort.DataReceived += new SerialDataReceivedEventHandler(SP_MainPort_DataReceived);

            // Set the read/write timeouts
            _serialPort.ReadTimeout = 500;
            _serialPort.WriteTimeout = 500;
        }

        private void BT_OpenPort_Click(object sender, EventArgs e)
        {
            _serialPort.Open();
            this.BT_OpenPort.Enabled = false;
            this.TMR0.Enabled = true;
        }

        private void BT_ClosePort_Click(object sender, EventArgs e)
        {
            this.TMR0.Enabled = false;
            this.BT_OpenPort.Enabled = true;
            _serialPort.Close();
        }

        private void SP_MainPort_DataReceived(object sender, SerialDataReceivedEventArgs e)
        {

            SerialPort sp = (SerialPort)sender;
            string indata = sp.ReadTo("\r\n");
            Console.Write(indata);

            try
            {
                string[] pieces = indata.Split('|');

                rd_counter = System.Convert.ToInt16(pieces[1]);
            }
            catch 
            { 
            
            }
        }

        private void TMR0_Tick(object sender, EventArgs e)
        {
            double sum = 0;
            int a = 0;

            old_counter = new_counter;
            new_counter = rd_counter * 0.17094;
            delta_counter = new_counter - old_counter;          // mm

            old_date = new_date;
            new_date = DateTime.Now;
            dt = ((new_date - old_date).TotalMilliseconds);     // ms
            velocity = (delta_counter * (60 * (1000 / dt)));

            double displayvar = velocity;

            this.TXB_Micros.Text = dt.ToString();
            this.TXB_ACCX.Text = displayvar.ToString();

            // VELOCITY
            if (this.CHART_ACCX.Series["Values_Velocity"].Points.Count >= 100)
            {
                this.CHART_ACCX.Series["Values_Velocity"].Points.RemoveAt(0);
            }
            this.CHART_ACCX.Series["Values_Velocity"].Points.Add(velocity);

            if (this.CHART_ACCX.Series["Values_Velocity"].Points.Count == 100)
            {
                for (a = (100 - filter); a <= 99; a++)
                {
                    sum += this.CHART_ACCX.Series["Values_Velocity"].Points[a].YValues[0];
                }
                sum /= filter;

                this.TXB_RunningAverage.Text = sum.ToString();
            }

            // Average
            if (this.CHART_ACCX.Series["Values_Average"].Points.Count >= 100)
            {
                this.CHART_ACCX.Series["Values_Average"].Points.RemoveAt(0);
            }
            this.CHART_ACCX.Series["Values_Average"].Points.Add(sum);

            this.CHART_ACCX.Series["Values_Average"].Enabled = this.CHB_Average.Checked;
            this.CHART_ACCX.Series["Values_Velocity"].Enabled = this.CHB_Speed.Checked;

            //// OLD
            //if (this.CHART_ACCX.Series["Values_OLD"].Points.Count > 100)
            //{
            //    this.CHART_ACCX.Series["Values_OLD"].Points.RemoveAt(0);
            //}
            //this.CHART_ACCX.Series["Values_OLD"].Points.Add(old_counter * 10);

            //// NEW
            //if (this.CHART_ACCX.Series["Values_NEW"].Points.Count > 100)
            //{
            //    this.CHART_ACCX.Series["Values_NEW"].Points.RemoveAt(0);
            //}
            //this.CHART_ACCX.Series["Values_NEW"].Points.Add(new_counter * 10);

            //// DELTA
            //if (this.CHART_ACCX.Series["Values_DELTA"].Points.Count > 100)
            //{
            //    this.CHART_ACCX.Series["Values_DELTA"].Points.RemoveAt(0);
            //}
            //this.CHART_ACCX.Series["Values_DELTA"].Points.Add(delta_counter * 100);

            _serialPort.Write("1");

        }

        private void VSB_TMR0Rate_Scroll(object sender, ScrollEventArgs e)
        {
            this.LB_TMR0Rate.Text = this.VSB_TMR0Rate.Value.ToString();
            this.TMR0.Interval = this.VSB_TMR0Rate.Value;
        }

        private void VSB_Filter_Scroll(object sender, ScrollEventArgs e)
        {
            this.LBL_Filter.Text = this.VSB_Filter.Value.ToString();
            filter = this.VSB_Filter.Value;
        }
    }
}
