/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzln;
import com.google.android.gms.internal.zzlo;

public final class PendingResults {
    public static PendingResult<Status> immediatePendingResult(Status result) {
        zzx.zzb(result, (Object)"Result must not be null");
        zzlo zzlo2 = new zzlo(Looper.getMainLooper());
        zzlo2.zzb(result);
        return zzlo2;
    }

    public static PendingResult<Status> zza(Status status, GoogleApiClient googleApiClient) {
        zzx.zzb(status, (Object)"Result must not be null");
        zzlo zzlo2 = new zzlo(googleApiClient);
        zzlo2.zzb(status);
        return zzlo2;
    }

    public static <R extends Result> PendingResult<R> zza(R r, GoogleApiClient googleApiClient) {
        zzx.zzb(r, (Object)"Result must not be null");
        zzx.zzb(!r.getStatus().isSuccess(), (Object)"Status code must not be SUCCESS");
        zzb<R> zzb2 = new zzb<R>(googleApiClient, r);
        zzb2.zzb(r);
        return zzb2;
    }

    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(R result) {
        zzx.zzb(result, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(null);
        zzc2.zzb(result);
        return new zzln(zzc2);
    }

    public static PendingResult<Status> canceledPendingResult() {
        zzlo zzlo2 = new zzlo(Looper.getMainLooper());
        zzlo2.cancel();
        return zzlo2;
    }

    public static <R extends Result> PendingResult<R> canceledPendingResult(R result) {
        zzx.zzb(result, (Object)"Result must not be null");
        zzx.zzb(result.getStatus().getStatusCode() == 16, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zza<R> zza2 = new zza<R>(result);
        zza2.cancel();
        return zza2;
    }

    private PendingResults() {
    }

    private static final class zza<R extends Result>
    extends zzlc<R> {
        private final R zzaaW;

        public zza(R r) {
            super(Looper.getMainLooper());
            this.zzaaW = r;
        }

        @Override
        protected R zzb(Status status) {
            if (status.getStatusCode() != this.zzaaW.getStatus().getStatusCode()) {
                throw new UnsupportedOperationException("Creating failed results is not supported");
            }
            return this.zzaaW;
        }
    }

    private static final class zzb<R extends Result>
    extends zzlc<R> {
        private final R zzaaX;

        public zzb(GoogleApiClient googleApiClient, R r) {
            super(googleApiClient);
            this.zzaaX = r;
        }

        @Override
        protected R zzb(Status status) {
            return this.zzaaX;
        }
    }

    private static final class zzc<R extends Result>
    extends zzlc<R> {
        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        @Override
        protected R zzb(Status status) {
            throw new UnsupportedOperationException("Creating failed results is not supported");
        }
    }
}

