/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzli;
import com.google.android.gms.internal.zzlj;
import com.google.android.gms.internal.zzlk;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzqx;
import com.google.android.gms.signin.internal.AuthAccountResult;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;

public class zzlg
implements zzlj {
    private final zzli zzabr;
    private final Lock zzabt;
    private final Context mContext;
    private final GoogleApiAvailability zzaaP;
    private ConnectionResult zzabu;
    private int zzabv;
    private int zzabw = 0;
    private boolean zzabx = false;
    private int zzaby;
    private final Bundle zzabz = new Bundle();
    private final Set<Api.zzc> zzabA = new HashSet<Api.zzc>();
    private zzqw zzabB;
    private int zzabC;
    private boolean zzabD;
    private boolean zzabE;
    private zzp zzabF;
    private boolean zzabG;
    private boolean zzabH;
    private final com.google.android.gms.common.internal.zzf zzabI;
    private final Map<Api<?>, Integer> zzabJ;
    private final Api.zza<? extends zzqw, zzqx> zzaaQ;
    private ArrayList<Future<?>> zzabK = new ArrayList();

    public zzlg(zzli zzli2, com.google.android.gms.common.internal.zzf zzf2, Map<Api<?>, Integer> map, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzqw, zzqx> zza2, Lock lock, Context context) {
        this.zzabr = zzli2;
        this.zzabI = zzf2;
        this.zzabJ = map;
        this.zzaaP = googleApiAvailability;
        this.zzaaQ = zza2;
        this.zzabt = lock;
        this.mContext = context;
    }

    @Override
    public String getName() {
        return "CONNECTING";
    }

    @Override
    public void begin() {
        this.zzabr.zzabZ.zzpl();
        this.zzabr.zzach.clear();
        this.zzabx = false;
        this.zzabD = false;
        this.zzabu = null;
        this.zzabw = 0;
        this.zzabC = 2;
        this.zzabE = false;
        this.zzabG = false;
        boolean bl = false;
        HashMap<Api.zzb, GoogleApiClient.zza> hashMap = new HashMap<Api.zzb, GoogleApiClient.zza>();
        for (Api<?> api : this.zzabJ.keySet()) {
            Api.zzb zzb2 = this.zzabr.zzacg.get(api.zznx());
            int n = this.zzabJ.get(api);
            bl |= api.zznv().getPriority() == 1;
            if (zzb2.zzlN()) {
                this.zzabD = true;
                if (n < this.zzabC) {
                    this.zzabC = n;
                }
                if (n != 0) {
                    this.zzabA.add(api.zznx());
                }
            }
            hashMap.put(zzb2, new zzd(this, api, n));
        }
        if (bl) {
            this.zzabD = false;
        }
        if (this.zzabD) {
            this.zzabI.zza(this.zzabr.getSessionId());
            zzg zzg2 = new zzg();
            this.zzabB = this.zzaaQ.zza(this.mContext, this.zzabr.getLooper(), this.zzabI, this.zzabI.zzoQ(), zzg2, zzg2);
        }
        this.zzaby = this.zzabr.zzacg.size();
        this.zzabK.add(zzlk.zzoj().submit(new zze(hashMap)));
    }

    private boolean zznP() {
        --this.zzaby;
        if (this.zzaby > 0) {
            return false;
        }
        if (this.zzaby < 0) {
            Log.i((String)"GoogleApiClientConnecting", (String)this.zzabr.zzog());
            Log.wtf((String)"GoogleApiClientConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.", (Throwable)new Exception());
            this.zzf(new ConnectionResult(8, null));
            return false;
        }
        if (this.zzabu != null) {
            this.zzf(this.zzabu);
            return false;
        }
        return true;
    }

    private void zznQ() {
        if (this.zzaby != 0) {
            return;
        }
        if (this.zzabD) {
            if (this.zzabE) {
                this.zznR();
            }
        } else {
            this.zznT();
        }
    }

    private void zza(ResolveAccountResponse resolveAccountResponse) {
        if (!this.zzbn(0)) {
            return;
        }
        ConnectionResult connectionResult = resolveAccountResponse.zzpr();
        if (connectionResult.isSuccess()) {
            this.zzabF = resolveAccountResponse.zzpq();
            this.zzabE = true;
            this.zzabG = resolveAccountResponse.zzps();
            this.zzabH = resolveAccountResponse.zzpt();
            this.zznQ();
        } else if (this.zze(connectionResult)) {
            this.zznV();
            this.zznQ();
        } else {
            this.zzf(connectionResult);
        }
    }

    private void zznR() {
        ArrayList<Api.zzb> arrayList = new ArrayList<Api.zzb>();
        this.zzabw = 1;
        this.zzaby = this.zzabr.zzacg.size();
        for (Api.zzc<?> zzc2 : this.zzabr.zzacg.keySet()) {
            if (this.zzabr.zzach.containsKey(zzc2)) {
                if (!this.zznP()) continue;
                this.zznS();
                continue;
            }
            arrayList.add(this.zzabr.zzacg.get(zzc2));
        }
        if (!arrayList.isEmpty()) {
            this.zzabK.add(zzlk.zzoj().submit(new zzh(arrayList)));
        }
    }

    private void zznS() {
        this.zzabw = 2;
        this.zzabr.zzaci = this.zznX();
        this.zzabK.add(zzlk.zzoj().submit(new zzc()));
    }

    private void zzc(ConnectionResult connectionResult) {
        if (!this.zzbn(2)) {
            return;
        }
        if (connectionResult.isSuccess()) {
            this.zznT();
        } else if (this.zze(connectionResult)) {
            this.zznV();
            this.zznT();
        } else {
            this.zzf(connectionResult);
        }
    }

    private void zznT() {
        ArrayList<Api.zzb> arrayList = new ArrayList<Api.zzb>();
        this.zzabw = 3;
        this.zzaby = this.zzabr.zzacg.size();
        for (Api.zzc<?> zzc2 : this.zzabr.zzacg.keySet()) {
            if (this.zzabr.zzach.containsKey(zzc2)) {
                if (!this.zznP()) continue;
                this.zznU();
                continue;
            }
            arrayList.add(this.zzabr.zzacg.get(zzc2));
        }
        if (!arrayList.isEmpty()) {
            this.zzabK.add(zzlk.zzoj().submit(new zzf(arrayList)));
        }
    }

    @Override
    public void onConnected(Bundle connectionHint) {
        if (!this.zzbn(3)) {
            return;
        }
        if (connectionHint != null) {
            this.zzabz.putAll(connectionHint);
        }
        if (this.zznP()) {
            this.zznU();
        }
    }

    @Override
    public void zza(ConnectionResult connectionResult, Api<?> api, int n) {
        if (!this.zzbn(3)) {
            return;
        }
        this.zzb(connectionResult, api, n);
        if (this.zznP()) {
            this.zznU();
        }
    }

    private void zznU() {
        this.zzabr.zzob();
        zzlk.zzoj().execute(new Runnable(){

            @Override
            public void run() {
                zzlg.this.zzaaP.zzac(zzlg.this.mContext);
            }
        });
        if (this.zzabB != null) {
            if (this.zzabG) {
                this.zzabB.zza(this.zzabF, this.zzabH);
            }
            this.zzY(false);
        }
        for (Api.zzc<?> zzc2 : this.zzabr.zzach.keySet()) {
            Api.zzb zzb2 = this.zzabr.zzacg.get(zzc2);
            zzb2.disconnect();
        }
        if (this.zzabx) {
            this.zzabx = false;
            this.disconnect();
        } else {
            Bundle bundle = this.zzabz.isEmpty() ? null : this.zzabz;
            this.zzabr.zzabZ.zzh(bundle);
        }
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzlb.zza<R, A>> T zza(T t) {
        this.zzabr.zzaca.add(t);
        return t;
    }

    @Override
    public <A extends Api.zzb, T extends zzlb.zza<? extends Result, A>> T zzb(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public void connect() {
        this.zzabx = false;
    }

    @Override
    public void disconnect() {
        Iterator iterator = this.zzabr.zzaca.iterator();
        while (iterator.hasNext()) {
            zzli.zzf zzf2 = (zzli.zzf)iterator.next();
            if (zzf2.zznK() == 1) continue;
            zzf2.cancel();
            iterator.remove();
        }
        this.zzabr.zznY();
        if (this.zzabu == null && !this.zzabr.zzaca.isEmpty()) {
            this.zzabx = true;
            return;
        }
        this.zznW();
        this.zzY(true);
        this.zzabr.zzach.clear();
        this.zzabr.zzg(null);
        this.zzabr.zzabZ.zzpk();
    }

    @Override
    public void onConnectionSuspended(int cause) {
        this.zzf(new ConnectionResult(8, null));
    }

    private void zzb(ConnectionResult connectionResult, Api<?> api, int n) {
        int n2;
        if (n != 2 && this.zza(n2 = api.zznv().getPriority(), n, connectionResult)) {
            this.zzabu = connectionResult;
            this.zzabv = n2;
        }
        this.zzabr.zzach.put(api.zznx(), connectionResult);
    }

    private boolean zza(int n, int n2, ConnectionResult connectionResult) {
        if (n2 == 1 && !this.zzd(connectionResult)) {
            return false;
        }
        return this.zzabu == null || n < this.zzabv;
    }

    private boolean zzd(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return true;
        }
        return this.zzaaP.zzbi(connectionResult.getErrorCode()) != null;
    }

    private void zznV() {
        this.zzabD = false;
        this.zzabr.zzaci = Collections.emptySet();
        for (Api.zzc zzc2 : this.zzabA) {
            if (this.zzabr.zzach.containsKey(zzc2)) continue;
            this.zzabr.zzach.put(zzc2, new ConnectionResult(17, null));
        }
    }

    private boolean zze(ConnectionResult connectionResult) {
        return this.zzabC == 2 || this.zzabC == 1 && !connectionResult.hasResolution();
    }

    private void zzf(ConnectionResult connectionResult) {
        this.zznW();
        this.zzY(!connectionResult.hasResolution());
        this.zzabr.zzach.clear();
        this.zzabr.zzg(connectionResult);
        if (!this.zzaaP.zzd(this.mContext, connectionResult.getErrorCode())) {
            this.zzabr.zzof();
        }
        if (!this.zzabx && !this.zzabr.zzoc()) {
            this.zzabr.zzabZ.zzi(connectionResult);
        }
        this.zzabx = false;
        this.zzabr.zzabZ.zzpk();
    }

    private void zzY(boolean bl) {
        if (this.zzabB != null) {
            if (this.zzabB.isConnected() && bl) {
                this.zzabB.zzCe();
            }
            this.zzabB.disconnect();
            this.zzabF = null;
        }
    }

    private void zznW() {
        for (Future<?> future : this.zzabK) {
            future.cancel(true);
        }
        this.zzabK.clear();
    }

    private Set<Scope> zznX() {
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzabI.zzoK());
        Map<Api<?>, zzf.zza> map = this.zzabI.zzoM();
        for (Api<?> api : map.keySet()) {
            if (this.zzabr.zzach.containsKey(api.zznx())) continue;
            hashSet.addAll(map.get(api).zzTm);
        }
        return hashSet;
    }

    private boolean zzbn(int n) {
        if (this.zzabw != n) {
            Log.i((String)"GoogleApiClientConnecting", (String)this.zzabr.zzog());
            Log.wtf((String)"GoogleApiClientConnecting", (String)("GoogleApiClient connecting is in step " + this.zzbo(this.zzabw) + " but received callback for step " + this.zzbo(n)), (Throwable)new Exception());
            this.zzf(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private String zzbo(int n) {
        switch (n) {
            case 0: {
                return "STEP_GETTING_SERVICE_BINDINGS";
            }
            case 1: {
                return "STEP_VALIDATING_ACCOUNT";
            }
            case 2: {
                return "STEP_AUTHENTICATING";
            }
            case 3: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    private static class zza
    extends com.google.android.gms.signin.internal.zzb {
        private final WeakReference<zzlg> zzabM;

        zza(zzlg zzlg2) {
            this.zzabM = new WeakReference<zzlg>(zzlg2);
        }

        @Override
        public void zza(final ConnectionResult connectionResult, AuthAccountResult authAccountResult) {
            final zzlg zzlg2 = (zzlg)this.zzabM.get();
            if (zzlg2 == null) {
                return;
            }
            zzlg2.zzabr.zza(new zzli.zzb(zzlg2){

                @Override
                public void zznO() {
                    zzlg2.zzc(connectionResult);
                }
            });
        }
    }

    private static class zzd
    implements GoogleApiClient.zza {
        private final WeakReference<zzlg> zzabM;
        private final Api<?> zzabS;
        private final int zzabT;

        public zzd(zzlg zzlg2, Api<?> api, int n) {
            this.zzabM = new WeakReference<zzlg>(zzlg2);
            this.zzabS = api;
            this.zzabT = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(ConnectionResult connectionResult) {
            zzlg zzlg2 = (zzlg)this.zzabM.get();
            if (zzlg2 == null) {
                return;
            }
            zzx.zza(Looper.myLooper() == zzlg2.zzabr.getLooper(), (Object)"onReportServiceBinding must be called on the GoogleApiClient handler thread");
            zzlg2.zzabt.lock();
            try {
                if (!zzlg2.zzbn(0)) {
                    return;
                }
                if (!connectionResult.isSuccess()) {
                    zzlg2.zzb(connectionResult, this.zzabS, this.zzabT);
                }
                if (zzlg2.zznP()) {
                    zzlg2.zznQ();
                }
            }
            finally {
                zzlg2.zzabt.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzb(ConnectionResult connectionResult) {
            zzlg zzlg2 = (zzlg)this.zzabM.get();
            if (zzlg2 == null) {
                return;
            }
            zzx.zza(Looper.myLooper() == zzlg2.zzabr.getLooper(), (Object)"onReportAccountValidation must be called on the GoogleApiClient handler thread");
            zzlg2.zzabt.lock();
            try {
                if (!zzlg2.zzbn(1)) {
                    return;
                }
                if (!connectionResult.isSuccess()) {
                    zzlg2.zzb(connectionResult, this.zzabS, this.zzabT);
                }
                if (zzlg2.zznP()) {
                    zzlg2.zznS();
                }
            }
            finally {
                zzlg2.zzabt.unlock();
            }
        }
    }

    private class zzg
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zzg() {
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            zzlg.this.zzabB.zza(new zzb(zzlg.this));
        }

        @Override
        public void onConnectionSuspended(int cause) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectionFailed(ConnectionResult result) {
            zzlg.this.zzabt.lock();
            try {
                if (zzlg.this.zze(result)) {
                    zzlg.this.zznV();
                    zzlg.this.zznT();
                } else {
                    zzlg.this.zzf(result);
                }
            }
            finally {
                zzlg.this.zzabt.unlock();
            }
        }
    }

    private static class zzb
    extends zzt.zza {
        private final WeakReference<zzlg> zzabM;

        zzb(zzlg zzlg2) {
            this.zzabM = new WeakReference<zzlg>(zzlg2);
        }

        @Override
        public void zzb(final ResolveAccountResponse resolveAccountResponse) {
            final zzlg zzlg2 = (zzlg)this.zzabM.get();
            if (zzlg2 == null) {
                return;
            }
            zzlg2.zzabr.zza(new zzli.zzb(zzlg2){

                @Override
                public void zznO() {
                    zzlg2.zza(resolveAccountResponse);
                }
            });
        }
    }

    private class zzf
    extends zzi {
        private final ArrayList<Api.zzb> zzabX;

        public zzf(ArrayList<Api.zzb> arrayList) {
            this.zzabX = arrayList;
        }

        @Override
        public void zznO() {
            Set set = ((zzlg)zzlg.this).zzabr.zzaci;
            if (set.isEmpty()) {
                set = zzlg.this.zznX();
            }
            for (Api.zzb zzb2 : this.zzabX) {
                zzb2.zza(zzlg.this.zzabF, set);
            }
        }
    }

    private class zzc
    extends zzi {
        private zzc() {
        }

        @Override
        public void zznO() {
            zzlg.this.zzabB.zza(zzlg.this.zzabF, ((zzlg)zzlg.this).zzabr.zzaci, new zza(zzlg.this));
        }
    }

    private class zzh
    extends zzi {
        private final ArrayList<Api.zzb> zzabX;

        public zzh(ArrayList<Api.zzb> arrayList) {
            this.zzabX = arrayList;
        }

        @Override
        public void zznO() {
            for (Api.zzb zzb2 : this.zzabX) {
                zzb2.zza(zzlg.this.zzabF);
            }
        }
    }

    private class zze
    extends zzi {
        private final Map<Api.zzb, GoogleApiClient.zza> zzabU;

        public zze(Map<Api.zzb, GoogleApiClient.zza> map) {
            this.zzabU = map;
        }

        @Override
        public void zznO() {
            int n = zzlg.this.zzaaP.isGooglePlayServicesAvailable(zzlg.this.mContext);
            if (n != 0) {
                final ConnectionResult connectionResult = new ConnectionResult(n, null);
                zzlg.this.zzabr.zza(new zzli.zzb(zzlg.this){

                    @Override
                    public void zznO() {
                        zzlg.this.zzf(connectionResult);
                    }
                });
                return;
            }
            if (zzlg.this.zzabD) {
                zzlg.this.zzabB.connect();
            }
            for (Api.zzb zzb2 : this.zzabU.keySet()) {
                zzb2.zza(this.zzabU.get(zzb2));
            }
        }
    }

    private abstract class zzi
    implements Runnable {
        private zzi() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            zzlg.this.zzabt.lock();
            try {
                if (Thread.interrupted()) {
                    return;
                }
                this.zznO();
            }
            catch (RuntimeException runtimeException) {
                zzlg.this.zzabr.zza(runtimeException);
            }
            finally {
                zzlg.this.zzabt.unlock();
            }
        }

        protected abstract void zznO();
    }
}

