/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class DrawableUtils {
    private static final String TAG = "DrawableUtils";
    public static final Rect INSETS_NONE = new Rect();
    private static Class<?> sInsetsClazz;

    private DrawableUtils() {
    }

    public static Rect getOpticalBounds(Drawable drawable2) {
        if (sInsetsClazz != null) {
            try {
                drawable2 = DrawableCompat.unwrap((Drawable)drawable2);
                Method getOpticalInsetsMethod = drawable2.getClass().getMethod("getOpticalInsets", new Class[0]);
                Object insets = getOpticalInsetsMethod.invoke((Object)drawable2, new Object[0]);
                if (insets != null) {
                    Rect result = new Rect();
                    block14: for (Field field : sInsetsClazz.getFields()) {
                        switch (field.getName()) {
                            case "left": {
                                result.left = field.getInt(insets);
                                continue block14;
                            }
                            case "top": {
                                result.top = field.getInt(insets);
                                continue block14;
                            }
                            case "right": {
                                result.right = field.getInt(insets);
                                continue block14;
                            }
                            case "bottom": {
                                result.bottom = field.getInt(insets);
                            }
                        }
                    }
                    return result;
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Couldn't obtain the optical insets. Ignoring.");
            }
        }
        return INSETS_NONE;
    }

    static {
        if (Build.VERSION.SDK_INT >= 18) {
            try {
                sInsetsClazz = Class.forName("android.graphics.Insets");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

