//WahDuino by gelstronic
//uses the FreeSixIMU library
//see licence.txt and readme



#include <FreeSixIMU.h>
#include <FIMU_ADXL345.h>
#include <FIMU_ITG3200.h>

#include <Wire.h>
#include <SPI.h>
byte address = 0;
int CS= 10;
int i=0;
float angles[3]; // yaw pitch roll

// Set the FreeSixIMU object
FreeSixIMU sixDOF = FreeSixIMU();

void setup() { 
  Serial.begin(9600);
  Wire.begin();
  pinMode (CS, OUTPUT);
  digitalWrite(CS, HIGH);
  SPI.begin();
  sixDOF.init(); //begin the IMU
  delay(5);
  digitalPotWrite(0);
}

void loop() { 
  
  sixDOF.getEuler(angles);
  int winkel =7*(abs((int)angles[2]));
  if (winkel >= 255)  winkel = 255;
  //constrain(winkel, 0, 255);
  Serial.println(winkel);
  digitalPotWrite(winkel);
  delay(1); 
}

int digitalPotWrite(int value)
{
  
  digitalWrite(CS, LOW);
    
  SPI.transfer(0);
  SPI.transfer(value);
  
  digitalWrite(CS, HIGH);
}

