/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.security;

import com.sun.jmx.remote.security.JMXSubjectDomainCombiner;
import com.sun.jmx.remote.util.CacheMap;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.management.remote.SubjectDelegationPermission;
import javax.security.auth.Subject;

public class SubjectDelegator {
    private static final int PRINCIPALS_CACHE_SIZE = 10;
    private static final int ACC_CACHE_SIZE = 10;
    private CacheMap<Subject, Principal[]> principalsCache;
    private CacheMap<Subject, AccessControlContext> accCache;

    public synchronized AccessControlContext delegatedContext(AccessControlContext accessControlContext, Subject subject, boolean bl) throws SecurityException {
        AccessControlContext accessControlContext2;
        Principal[] principalArray;
        if (System.getSecurityManager() != null && accessControlContext == null) {
            throw new SecurityException("Illegal AccessControlContext: null");
        }
        if (this.principalsCache == null || this.accCache == null) {
            this.principalsCache = new CacheMap(10);
            this.accCache = new CacheMap(10);
        }
        if ((principalArray = this.principalsCache.get(subject)) == null) {
            principalArray = subject.getPrincipals().toArray(new Principal[0]);
            this.principalsCache.put(subject, principalArray);
        }
        if ((accessControlContext2 = this.accCache.get(subject)) == null) {
            accessControlContext2 = bl ? JMXSubjectDomainCombiner.getDomainCombinerContext(subject) : JMXSubjectDomainCombiner.getContext(subject);
            this.accCache.put(subject, accessControlContext2);
        }
        Principal[] principalArray2 = principalArray;
        final ArrayList<SubjectDelegationPermission> arrayList = new ArrayList<SubjectDelegationPermission>(principalArray2.length);
        for (Principal principal : principalArray2) {
            String string = principal.getClass().getName() + "." + principal.getName();
            arrayList.add(new SubjectDelegationPermission(string));
        }
        PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                for (Permission permission : arrayList) {
                    AccessController.checkPermission(permission);
                }
                return null;
            }
        };
        AccessController.doPrivileged(privilegedAction, accessControlContext);
        return accessControlContext2;
    }

    public static synchronized boolean checkRemoveCallerContext(Subject subject) {
        try {
            Principal[] principalArray = subject.getPrincipals().toArray(new Principal[0]);
            for (int i = 0; i < principalArray.length; ++i) {
                String string = principalArray[i].getClass().getName() + "." + principalArray[i].getName();
                SubjectDelegationPermission subjectDelegationPermission = new SubjectDelegationPermission(string);
                AccessController.checkPermission(subjectDelegationPermission);
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }
}

