/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarEntry;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.util.locale.BaseLocale;
import sun.util.locale.LocaleObjectCache;

public abstract class ResourceBundle {
    private static final int INITIAL_CACHE_SIZE = 32;
    private static final ResourceBundle NONEXISTENT_BUNDLE = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String string) {
            return null;
        }

        public String toString() {
            return "NONEXISTENT_BUNDLE";
        }
    };
    private static final ConcurrentMap<CacheKey, BundleReference> cacheList = new ConcurrentHashMap<CacheKey, BundleReference>(32);
    private static final ReferenceQueue referenceQueue = new ReferenceQueue();
    protected ResourceBundle parent = null;
    private Locale locale = null;
    private String name;
    private volatile boolean expired;
    private volatile CacheKey cacheKey;
    private volatile Set<String> keySet;

    public final String getString(String string) {
        return (String)this.getObject(string);
    }

    public final String[] getStringArray(String string) {
        return (String[])this.getObject(string);
    }

    public final Object getObject(String string) {
        Object object = this.handleGetObject(string);
        if (object == null) {
            if (this.parent != null) {
                object = this.parent.getObject(string);
            }
            if (object == null) {
                throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + string, this.getClass().getName(), string);
            }
        }
        return object;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private static ClassLoader getLoader(Class<?> clazz) {
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = clazz == null ? null : clazz.getClassLoader();
        if (classLoader == null) {
            classLoader = RBClassLoader.INSTANCE;
        }
        return classLoader;
    }

    protected void setParent(ResourceBundle resourceBundle) {
        assert (resourceBundle != NONEXISTENT_BUNDLE);
        this.parent = resourceBundle;
    }

    @CallerSensitive
    public static final ResourceBundle getBundle(String string) {
        return ResourceBundle.getBundleImpl(string, Locale.getDefault(), ResourceBundle.getLoader(Reflection.getCallerClass()), Control.INSTANCE);
    }

    @CallerSensitive
    public static final ResourceBundle getBundle(String string, Control control) {
        return ResourceBundle.getBundleImpl(string, Locale.getDefault(), ResourceBundle.getLoader(Reflection.getCallerClass()), control);
    }

    @CallerSensitive
    public static final ResourceBundle getBundle(String string, Locale locale) {
        return ResourceBundle.getBundleImpl(string, locale, ResourceBundle.getLoader(Reflection.getCallerClass()), Control.INSTANCE);
    }

    @CallerSensitive
    public static final ResourceBundle getBundle(String string, Locale locale, Control control) {
        return ResourceBundle.getBundleImpl(string, locale, ResourceBundle.getLoader(Reflection.getCallerClass()), control);
    }

    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        return ResourceBundle.getBundleImpl(string, locale, classLoader, Control.INSTANCE);
    }

    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader, Control control) {
        if (classLoader == null || control == null) {
            throw new NullPointerException();
        }
        return ResourceBundle.getBundleImpl(string, locale, classLoader, control);
    }

    private static ResourceBundle getBundleImpl(String string, Locale locale, ClassLoader classLoader, Control control) {
        if (locale == null || control == null) {
            throw new NullPointerException();
        }
        CacheKey cacheKey = new CacheKey(string, locale, classLoader);
        ResourceBundle resourceBundle = null;
        BundleReference bundleReference = (BundleReference)cacheList.get(cacheKey);
        if (bundleReference != null) {
            resourceBundle = (ResourceBundle)bundleReference.get();
            bundleReference = null;
        }
        if (ResourceBundle.isValidBundle(resourceBundle) && ResourceBundle.hasValidParentChain(resourceBundle)) {
            return resourceBundle;
        }
        boolean bl = control == Control.INSTANCE || control instanceof SingleFormatControl;
        List<String> list = control.getFormats(string);
        if (!bl && !ResourceBundle.checkList(list)) {
            throw new IllegalArgumentException("Invalid Control: getFormats");
        }
        ResourceBundle resourceBundle2 = null;
        Locale locale2 = locale;
        while (locale2 != null) {
            List<Locale> list2 = control.getCandidateLocales(string, locale2);
            if (!bl && !ResourceBundle.checkList(list2)) {
                throw new IllegalArgumentException("Invalid Control: getCandidateLocales");
            }
            resourceBundle = ResourceBundle.findBundle(cacheKey, list2, list, 0, control, resourceBundle2);
            if (ResourceBundle.isValidBundle(resourceBundle)) {
                boolean bl2 = Locale.ROOT.equals(resourceBundle.locale);
                if (!bl2 || resourceBundle.locale.equals(locale) || list2.size() == 1 && resourceBundle.locale.equals(list2.get(0))) break;
                if (bl2 && resourceBundle2 == null) {
                    resourceBundle2 = resourceBundle;
                }
            }
            locale2 = control.getFallbackLocale(string, locale2);
        }
        if (resourceBundle == null) {
            if (resourceBundle2 == null) {
                ResourceBundle.throwMissingResourceException(string, locale, cacheKey.getCause());
            }
            resourceBundle = resourceBundle2;
        }
        return resourceBundle;
    }

    private static final boolean checkList(List list) {
        boolean bl;
        boolean bl2 = bl = list != null && list.size() != 0;
        if (bl) {
            int n = list.size();
            for (int i = 0; bl && i < n; ++i) {
                bl = list.get(i) != null;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ResourceBundle findBundle(CacheKey cacheKey, List<Locale> list, List<String> list2, int n, Control control, ResourceBundle resourceBundle) {
        Object object;
        Reference reference;
        Locale locale = list.get(n);
        ResourceBundle resourceBundle2 = null;
        if (n != list.size() - 1) {
            resourceBundle2 = ResourceBundle.findBundle(cacheKey, list, list2, n + 1, control, resourceBundle);
        } else if (resourceBundle != null && Locale.ROOT.equals(locale)) {
            return resourceBundle;
        }
        while ((reference = referenceQueue.poll()) != null) {
            cacheList.remove(((CacheKeyReference)((Object)reference)).getCacheKey());
        }
        boolean bl = false;
        cacheKey.setLocale(locale);
        ResourceBundle resourceBundle3 = ResourceBundle.findBundleInCache(cacheKey, control);
        if (ResourceBundle.isValidBundle(resourceBundle3) && !(bl = resourceBundle3.expired)) {
            if (resourceBundle3.parent == resourceBundle2) {
                return resourceBundle3;
            }
            object = (BundleReference)cacheList.get(cacheKey);
            if (object != null && ((SoftReference)object).get() == resourceBundle3) {
                cacheList.remove(cacheKey, object);
            }
        }
        if (resourceBundle3 != NONEXISTENT_BUNDLE) {
            object = (CacheKey)cacheKey.clone();
            try {
                resourceBundle3 = ResourceBundle.loadBundle(cacheKey, list2, control, bl);
                if (resourceBundle3 != null) {
                    if (resourceBundle3.parent == null) {
                        resourceBundle3.setParent(resourceBundle2);
                    }
                    resourceBundle3.locale = locale;
                    ResourceBundle resourceBundle4 = resourceBundle3 = ResourceBundle.putBundleInCache(cacheKey, resourceBundle3, control);
                    return resourceBundle4;
                }
                ResourceBundle.putBundleInCache(cacheKey, NONEXISTENT_BUNDLE, control);
            }
            finally {
                if (((CacheKey)object).getCause() instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return resourceBundle2;
    }

    private static final ResourceBundle loadBundle(CacheKey cacheKey, List<String> list, Control control, boolean bl) {
        Locale locale = cacheKey.getLocale();
        ResourceBundle resourceBundle = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            try {
                resourceBundle = control.newBundle(cacheKey.getName(), locale, string, cacheKey.getLoader(), bl);
            }
            catch (LinkageError linkageError) {
                cacheKey.setCause(linkageError);
            }
            catch (Exception exception) {
                cacheKey.setCause(exception);
            }
            if (resourceBundle == null) continue;
            cacheKey.setFormat(string);
            resourceBundle.name = cacheKey.getName();
            resourceBundle.locale = locale;
            resourceBundle.expired = false;
            break;
        }
        return resourceBundle;
    }

    private static final boolean isValidBundle(ResourceBundle resourceBundle) {
        return resourceBundle != null && resourceBundle != NONEXISTENT_BUNDLE;
    }

    private static final boolean hasValidParentChain(ResourceBundle resourceBundle) {
        long l = System.currentTimeMillis();
        while (resourceBundle != null) {
            long l2;
            if (resourceBundle.expired) {
                return false;
            }
            CacheKey cacheKey = resourceBundle.cacheKey;
            if (cacheKey != null && (l2 = cacheKey.expirationTime) >= 0L && l2 <= l) {
                return false;
            }
            resourceBundle = resourceBundle.parent;
        }
        return true;
    }

    private static final void throwMissingResourceException(String string, Locale locale, Throwable throwable) {
        if (throwable instanceof MissingResourceException) {
            throwable = null;
        }
        throw new MissingResourceException("Can't find bundle for base name " + string + ", locale " + locale, string + "_" + locale, "", throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ResourceBundle findBundleInCache(CacheKey cacheKey, Control control) {
        BundleReference bundleReference = (BundleReference)cacheList.get(cacheKey);
        if (bundleReference == null) {
            return null;
        }
        ResourceBundle resourceBundle = (ResourceBundle)bundleReference.get();
        if (resourceBundle == null) {
            return null;
        }
        ResourceBundle resourceBundle2 = resourceBundle.parent;
        assert (resourceBundle2 != NONEXISTENT_BUNDLE);
        if (resourceBundle2 != null && resourceBundle2.expired) {
            assert (resourceBundle != NONEXISTENT_BUNDLE);
            resourceBundle.expired = true;
            resourceBundle.cacheKey = null;
            cacheList.remove(cacheKey, bundleReference);
            resourceBundle = null;
        } else {
            CacheKey cacheKey2 = bundleReference.getCacheKey();
            long l = cacheKey2.expirationTime;
            if (!resourceBundle.expired && l >= 0L && l <= System.currentTimeMillis()) {
                if (resourceBundle != NONEXISTENT_BUNDLE) {
                    ResourceBundle resourceBundle3 = resourceBundle;
                    synchronized (resourceBundle3) {
                        l = cacheKey2.expirationTime;
                        if (!resourceBundle.expired && l >= 0L && l <= System.currentTimeMillis()) {
                            try {
                                resourceBundle.expired = control.needsReload(cacheKey2.getName(), cacheKey2.getLocale(), cacheKey2.getFormat(), cacheKey2.getLoader(), resourceBundle, cacheKey2.loadTime);
                            }
                            catch (Exception exception) {
                                cacheKey.setCause(exception);
                            }
                            if (resourceBundle.expired) {
                                resourceBundle.cacheKey = null;
                                cacheList.remove(cacheKey, bundleReference);
                            } else {
                                ResourceBundle.setExpirationTime(cacheKey2, control);
                            }
                        }
                    }
                }
                cacheList.remove(cacheKey, bundleReference);
                resourceBundle = null;
            }
        }
        return resourceBundle;
    }

    private static final ResourceBundle putBundleInCache(CacheKey cacheKey, ResourceBundle resourceBundle, Control control) {
        ResourceBundle.setExpirationTime(cacheKey, control);
        if (cacheKey.expirationTime != -1L) {
            CacheKey cacheKey2 = (CacheKey)cacheKey.clone();
            BundleReference bundleReference = new BundleReference(resourceBundle, referenceQueue, cacheKey2);
            resourceBundle.cacheKey = cacheKey2;
            BundleReference bundleReference2 = cacheList.putIfAbsent(cacheKey2, bundleReference);
            if (bundleReference2 != null) {
                ResourceBundle resourceBundle2 = (ResourceBundle)bundleReference2.get();
                if (resourceBundle2 != null && !resourceBundle2.expired) {
                    resourceBundle.cacheKey = null;
                    resourceBundle = resourceBundle2;
                    bundleReference.clear();
                } else {
                    cacheList.put(cacheKey2, bundleReference);
                }
            }
        }
        return resourceBundle;
    }

    private static final void setExpirationTime(CacheKey cacheKey, Control control) {
        long l = control.getTimeToLive(cacheKey.getName(), cacheKey.getLocale());
        if (l >= 0L) {
            long l2 = System.currentTimeMillis();
            cacheKey.loadTime = l2;
            cacheKey.expirationTime = l2 + l;
        } else if (l >= -2L) {
            cacheKey.expirationTime = l;
        } else {
            throw new IllegalArgumentException("Invalid Control: TTL=" + l);
        }
    }

    @CallerSensitive
    public static final void clearCache() {
        ResourceBundle.clearCache(ResourceBundle.getLoader(Reflection.getCallerClass()));
    }

    public static final void clearCache(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        Set set = cacheList.keySet();
        for (CacheKey cacheKey : set) {
            if (cacheKey.getLoader() != classLoader) continue;
            set.remove(cacheKey);
        }
    }

    protected abstract Object handleGetObject(String var1);

    public abstract Enumeration<String> getKeys();

    public boolean containsKey(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        ResourceBundle resourceBundle = this;
        while (resourceBundle != null) {
            if (resourceBundle.handleKeySet().contains(string)) {
                return true;
            }
            resourceBundle = resourceBundle.parent;
        }
        return false;
    }

    public Set<String> keySet() {
        HashSet<String> hashSet = new HashSet<String>();
        ResourceBundle resourceBundle = this;
        while (resourceBundle != null) {
            hashSet.addAll(resourceBundle.handleKeySet());
            resourceBundle = resourceBundle.parent;
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> handleKeySet() {
        if (this.keySet == null) {
            ResourceBundle resourceBundle = this;
            synchronized (resourceBundle) {
                if (this.keySet == null) {
                    HashSet<String> hashSet = new HashSet<String>();
                    Enumeration<String> enumeration = this.getKeys();
                    while (enumeration.hasMoreElements()) {
                        String string = enumeration.nextElement();
                        if (this.handleGetObject(string) == null) continue;
                        hashSet.add(string);
                    }
                    this.keySet = hashSet;
                }
            }
        }
        return this.keySet;
    }

    private static final class NoFallbackControl
    extends SingleFormatControl {
        private static final Control NO_FALLBACK = new NoFallbackControl(FORMAT_DEFAULT);
        private static final Control PROPERTIES_ONLY_NO_FALLBACK = new NoFallbackControl(FORMAT_PROPERTIES);
        private static final Control CLASS_ONLY_NO_FALLBACK = new NoFallbackControl(FORMAT_CLASS);

        protected NoFallbackControl(List<String> list) {
            super(list);
        }

        @Override
        public Locale getFallbackLocale(String string, Locale locale) {
            if (string == null || locale == null) {
                throw new NullPointerException();
            }
            return null;
        }
    }

    private static class SingleFormatControl
    extends Control {
        private static final Control PROPERTIES_ONLY = new SingleFormatControl(FORMAT_PROPERTIES);
        private static final Control CLASS_ONLY = new SingleFormatControl(FORMAT_CLASS);
        private final List<String> formats;

        protected SingleFormatControl(List<String> list) {
            this.formats = list;
        }

        @Override
        public List<String> getFormats(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            return this.formats;
        }
    }

    public static class Control {
        public static final List<String> FORMAT_DEFAULT = Collections.unmodifiableList(Arrays.asList("java.class", "java.properties"));
        public static final List<String> FORMAT_CLASS = Collections.unmodifiableList(Arrays.asList("java.class"));
        public static final List<String> FORMAT_PROPERTIES = Collections.unmodifiableList(Arrays.asList("java.properties"));
        public static final long TTL_DONT_CACHE = -1L;
        public static final long TTL_NO_EXPIRATION_CONTROL = -2L;
        private static final Control INSTANCE = new Control();
        private static final CandidateListCache CANDIDATES_CACHE = new CandidateListCache();

        protected Control() {
        }

        public static final Control getControl(List<String> list) {
            if (list.equals(FORMAT_PROPERTIES)) {
                return SingleFormatControl.PROPERTIES_ONLY;
            }
            if (list.equals(FORMAT_CLASS)) {
                return SingleFormatControl.CLASS_ONLY;
            }
            if (list.equals(FORMAT_DEFAULT)) {
                return INSTANCE;
            }
            throw new IllegalArgumentException();
        }

        public static final Control getNoFallbackControl(List<String> list) {
            if (list.equals(FORMAT_DEFAULT)) {
                return NoFallbackControl.NO_FALLBACK;
            }
            if (list.equals(FORMAT_PROPERTIES)) {
                return NoFallbackControl.PROPERTIES_ONLY_NO_FALLBACK;
            }
            if (list.equals(FORMAT_CLASS)) {
                return NoFallbackControl.CLASS_ONLY_NO_FALLBACK;
            }
            throw new IllegalArgumentException();
        }

        public List<String> getFormats(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            return FORMAT_DEFAULT;
        }

        public List<Locale> getCandidateLocales(String string, Locale locale) {
            if (string == null) {
                throw new NullPointerException();
            }
            return new ArrayList<Locale>((Collection)CANDIDATES_CACHE.get(locale.getBaseLocale()));
        }

        public Locale getFallbackLocale(String string, Locale locale) {
            if (string == null) {
                throw new NullPointerException();
            }
            Locale locale2 = Locale.getDefault();
            return locale.equals(locale2) ? null : locale2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IllegalAccessException, InstantiationException, IOException {
            String string3 = this.toBundleName(string, locale);
            ResourceBundle resourceBundle = null;
            if (string2.equals("java.class")) {
                try {
                    Class<?> clazz = classLoader.loadClass(string3);
                    if (!ResourceBundle.class.isAssignableFrom(clazz)) {
                        throw new ClassCastException(clazz.getName() + " cannot be cast to ResourceBundle");
                    }
                    resourceBundle = (ResourceBundle)clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else if (string2.equals("java.properties")) {
                final String string4 = this.toResourceName(string3, "properties");
                final ClassLoader classLoader2 = classLoader;
                final boolean bl2 = bl;
                InputStream inputStream = null;
                try {
                    inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws IOException {
                            InputStream inputStream = null;
                            if (bl2) {
                                URLConnection uRLConnection;
                                URL uRL = classLoader2.getResource(string4);
                                if (uRL != null && (uRLConnection = uRL.openConnection()) != null) {
                                    uRLConnection.setUseCaches(false);
                                    inputStream = uRLConnection.getInputStream();
                                }
                            } else {
                                inputStream = classLoader2.getResourceAsStream(string4);
                            }
                            return inputStream;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
                if (inputStream != null) {
                    try {
                        resourceBundle = new PropertyResourceBundle(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                }
            } else {
                throw new IllegalArgumentException("unknown format: " + string2);
            }
            return resourceBundle;
        }

        public long getTimeToLive(String string, Locale locale) {
            if (string == null || locale == null) {
                throw new NullPointerException();
            }
            return -2L;
        }

        public boolean needsReload(String string, Locale locale, String string2, ClassLoader classLoader, ResourceBundle resourceBundle, long l) {
            if (resourceBundle == null) {
                throw new NullPointerException();
            }
            if (string2.equals("java.class") || string2.equals("java.properties")) {
                string2 = string2.substring(5);
            }
            boolean bl = false;
            try {
                String string3 = this.toResourceName(this.toBundleName(string, locale), string2);
                URL uRL = classLoader.getResource(string3);
                if (uRL != null) {
                    long l2 = 0L;
                    URLConnection uRLConnection = uRL.openConnection();
                    if (uRLConnection != null) {
                        uRLConnection.setUseCaches(false);
                        if (uRLConnection instanceof JarURLConnection) {
                            JarEntry jarEntry = ((JarURLConnection)uRLConnection).getJarEntry();
                            if (jarEntry != null && (l2 = jarEntry.getTime()) == -1L) {
                                l2 = 0L;
                            }
                        } else {
                            l2 = uRLConnection.getLastModified();
                        }
                    }
                    bl = l2 >= l;
                }
            }
            catch (NullPointerException nullPointerException) {
                throw nullPointerException;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl;
        }

        public String toBundleName(String string, Locale locale) {
            if (locale == Locale.ROOT) {
                return string;
            }
            String string2 = locale.getLanguage();
            String string3 = locale.getScript();
            String string4 = locale.getCountry();
            String string5 = locale.getVariant();
            if (string2 == "" && string4 == "" && string5 == "") {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append('_');
            if (string3 != "") {
                if (string5 != "") {
                    stringBuilder.append(string2).append('_').append(string3).append('_').append(string4).append('_').append(string5);
                } else if (string4 != "") {
                    stringBuilder.append(string2).append('_').append(string3).append('_').append(string4);
                } else {
                    stringBuilder.append(string2).append('_').append(string3);
                }
            } else if (string5 != "") {
                stringBuilder.append(string2).append('_').append(string4).append('_').append(string5);
            } else if (string4 != "") {
                stringBuilder.append(string2).append('_').append(string4);
            } else {
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }

        public final String toResourceName(String string, String string2) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + 1 + string2.length());
            stringBuilder.append(string.replace('.', '/')).append('.').append(string2);
            return stringBuilder.toString();
        }

        private static class CandidateListCache
        extends LocaleObjectCache<BaseLocale, List<Locale>> {
            private CandidateListCache() {
            }

            @Override
            protected List<Locale> createObject(BaseLocale baseLocale) {
                String string = baseLocale.getLanguage();
                String string2 = baseLocale.getScript();
                String string3 = baseLocale.getRegion();
                String string4 = baseLocale.getVariant();
                boolean bl = false;
                boolean bl2 = false;
                if (string.equals("no")) {
                    if (string3.equals("NO") && string4.equals("NY")) {
                        string4 = "";
                        bl2 = true;
                    } else {
                        bl = true;
                    }
                }
                if (string.equals("nb") || bl) {
                    List<Locale> list = CandidateListCache.getDefaultList("nb", string2, string3, string4);
                    LinkedList<Locale> linkedList = new LinkedList<Locale>();
                    for (Locale locale : list) {
                        linkedList.add(locale);
                        if (locale.getLanguage().length() == 0) break;
                        linkedList.add(Locale.getInstance("no", locale.getScript(), locale.getCountry(), locale.getVariant(), null));
                    }
                    return linkedList;
                }
                if (string.equals("nn") || bl2) {
                    List<Locale> list = CandidateListCache.getDefaultList("nn", string2, string3, string4);
                    int n = list.size() - 1;
                    list.add(n++, Locale.getInstance("no", "NO", "NY"));
                    list.add(n++, Locale.getInstance("no", "NO", ""));
                    list.add(n++, Locale.getInstance("no", "", ""));
                    return list;
                }
                if (string.equals("zh")) {
                    if (string2.length() == 0 && string3.length() > 0) {
                        if (string3.equals("TW") || string3.equals("HK") || string3.equals("MO")) {
                            string2 = "Hant";
                        } else if (string3.equals("CN") || string3.equals("SG")) {
                            string2 = "Hans";
                        }
                    } else if (string2.length() > 0 && string3.length() == 0) {
                        if (string2.equals("Hans")) {
                            string3 = "CN";
                        } else if (string2.equals("Hant")) {
                            string3 = "TW";
                        }
                    }
                }
                return CandidateListCache.getDefaultList(string, string2, string3, string4);
            }

            private static List<Locale> getDefaultList(String string, String string2, String string3, String string4) {
                LinkedList<String> linkedList = null;
                if (string4.length() > 0) {
                    linkedList = new LinkedList<String>();
                    int n = string4.length();
                    while (n != -1) {
                        linkedList.add(string4.substring(0, n));
                        --n;
                        n = string4.lastIndexOf(95, n);
                    }
                }
                LinkedList<Locale> linkedList2 = new LinkedList<Locale>();
                if (linkedList != null) {
                    for (String string5 : linkedList) {
                        linkedList2.add(Locale.getInstance(string, string2, string3, string5, null));
                    }
                }
                if (string3.length() > 0) {
                    linkedList2.add(Locale.getInstance(string, string2, string3, "", null));
                }
                if (string2.length() > 0) {
                    linkedList2.add(Locale.getInstance(string, string2, "", "", null));
                    if (linkedList != null) {
                        for (String string5 : linkedList) {
                            linkedList2.add(Locale.getInstance(string, "", string3, string5, null));
                        }
                    }
                    if (string3.length() > 0) {
                        linkedList2.add(Locale.getInstance(string, "", string3, "", null));
                    }
                }
                if (string.length() > 0) {
                    linkedList2.add(Locale.getInstance(string, "", "", "", null));
                }
                linkedList2.add(Locale.ROOT);
                return linkedList2;
            }
        }
    }

    private static final class BundleReference
    extends SoftReference<ResourceBundle>
    implements CacheKeyReference {
        private CacheKey cacheKey;

        BundleReference(ResourceBundle resourceBundle, ReferenceQueue referenceQueue, CacheKey cacheKey) {
            super(resourceBundle, referenceQueue);
            this.cacheKey = cacheKey;
        }

        @Override
        public CacheKey getCacheKey() {
            return this.cacheKey;
        }
    }

    private static final class LoaderReference
    extends WeakReference<ClassLoader>
    implements CacheKeyReference {
        private CacheKey cacheKey;

        LoaderReference(ClassLoader classLoader, ReferenceQueue referenceQueue, CacheKey cacheKey) {
            super(classLoader, referenceQueue);
            this.cacheKey = cacheKey;
        }

        @Override
        public CacheKey getCacheKey() {
            return this.cacheKey;
        }
    }

    private static interface CacheKeyReference {
        public CacheKey getCacheKey();
    }

    private static final class CacheKey
    implements Cloneable {
        private String name;
        private Locale locale;
        private LoaderReference loaderRef;
        private String format;
        private volatile long loadTime;
        private volatile long expirationTime;
        private Throwable cause;
        private int hashCodeCache;

        CacheKey(String string, Locale locale, ClassLoader classLoader) {
            this.name = string;
            this.locale = locale;
            this.loaderRef = classLoader == null ? null : new LoaderReference(classLoader, referenceQueue, this);
            this.calculateHashCode();
        }

        String getName() {
            return this.name;
        }

        CacheKey setName(String string) {
            if (!this.name.equals(string)) {
                this.name = string;
                this.calculateHashCode();
            }
            return this;
        }

        Locale getLocale() {
            return this.locale;
        }

        CacheKey setLocale(Locale locale) {
            if (!this.locale.equals(locale)) {
                this.locale = locale;
                this.calculateHashCode();
            }
            return this;
        }

        ClassLoader getLoader() {
            return this.loaderRef != null ? (ClassLoader)this.loaderRef.get() : null;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            try {
                CacheKey cacheKey = (CacheKey)object;
                if (this.hashCodeCache != cacheKey.hashCodeCache) {
                    return false;
                }
                if (!this.name.equals(cacheKey.name)) {
                    return false;
                }
                if (!this.locale.equals(cacheKey.locale)) {
                    return false;
                }
                if (this.loaderRef == null) {
                    return cacheKey.loaderRef == null;
                }
                ClassLoader classLoader = (ClassLoader)this.loaderRef.get();
                return cacheKey.loaderRef != null && classLoader != null && classLoader == cacheKey.loaderRef.get();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return false;
        }

        public int hashCode() {
            return this.hashCodeCache;
        }

        private void calculateHashCode() {
            this.hashCodeCache = this.name.hashCode() << 3;
            this.hashCodeCache ^= this.locale.hashCode();
            ClassLoader classLoader = this.getLoader();
            if (classLoader != null) {
                this.hashCodeCache ^= classLoader.hashCode();
            }
        }

        public Object clone() {
            try {
                CacheKey cacheKey = (CacheKey)super.clone();
                if (this.loaderRef != null) {
                    cacheKey.loaderRef = new LoaderReference((ClassLoader)this.loaderRef.get(), referenceQueue, cacheKey);
                }
                cacheKey.cause = null;
                return cacheKey;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        String getFormat() {
            return this.format;
        }

        void setFormat(String string) {
            this.format = string;
        }

        private void setCause(Throwable throwable) {
            if (this.cause == null) {
                this.cause = throwable;
            } else if (this.cause instanceof ClassNotFoundException) {
                this.cause = throwable;
            }
        }

        private Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            String string = this.locale.toString();
            if (string.length() == 0) {
                string = this.locale.getVariant().length() != 0 ? "__" + this.locale.getVariant() : "\"\"";
            }
            return "CacheKey[" + this.name + ", lc=" + string + ", ldr=" + this.getLoader() + "(format=" + this.format + ")]";
        }
    }

    private static class RBClassLoader
    extends ClassLoader {
        private static final RBClassLoader INSTANCE = AccessController.doPrivileged(new PrivilegedAction<RBClassLoader>(){

            @Override
            public RBClassLoader run() {
                return new RBClassLoader();
            }
        });
        private static final ClassLoader loader = ClassLoader.getSystemClassLoader();

        private RBClassLoader() {
        }

        @Override
        public Class<?> loadClass(String string) throws ClassNotFoundException {
            if (loader != null) {
                return loader.loadClass(string);
            }
            return Class.forName(string);
        }

        @Override
        public URL getResource(String string) {
            if (loader != null) {
                return loader.getResource(string);
            }
            return ClassLoader.getSystemResource(string);
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            if (loader != null) {
                return loader.getResourceAsStream(string);
            }
            return ClassLoader.getSystemResourceAsStream(string);
        }
    }
}

