/*
 * Decompiled with CFR 0.152.
 */
package peasy.org.apache.commons.math;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MathException
extends Exception {
    private static final long serialVersionUID = -8602234299177097102L;
    private static final boolean JDK_SUPPORTS_NESTED;
    private static ResourceBundle cachedResources;
    private final String pattern;
    private final Object[] arguments;
    private final Throwable rootCause;

    private static String translate(String string, Locale locale) {
        try {
            if (cachedResources == null || !cachedResources.getLocale().equals(locale)) {
                cachedResources = ResourceBundle.getBundle("peasy.org.apache.commons.math.MessagesResources", locale);
            }
            if (cachedResources.getLocale().getLanguage().equals(locale.getLanguage())) {
                return cachedResources.getString(string);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string;
    }

    private static String buildMessage(String string, Object[] objectArray, Locale locale) {
        MessageFormat messageFormat = new MessageFormat(MathException.translate(string, locale));
        messageFormat.setLocale(locale);
        return messageFormat.format(objectArray);
    }

    public MathException() {
        this.pattern = null;
        this.arguments = new Object[0];
        this.rootCause = null;
    }

    @Deprecated
    public MathException(String string) {
        super(string);
        this.pattern = string;
        this.arguments = new Object[0];
        this.rootCause = null;
    }

    public MathException(String string, Object[] objectArray) {
        super(MathException.buildMessage(string, objectArray, Locale.US));
        this.pattern = string;
        this.arguments = (Object[])objectArray.clone();
        this.rootCause = null;
    }

    public MathException(Throwable throwable) {
        super(throwable == null ? null : throwable.getMessage());
        this.pattern = this.getMessage();
        this.arguments = new Object[0];
        this.rootCause = throwable;
    }

    @Deprecated
    public MathException(String string, Throwable throwable) {
        super(string);
        this.pattern = string;
        this.arguments = new Object[0];
        this.rootCause = throwable;
    }

    public MathException(String string, Object[] objectArray, Throwable throwable) {
        super(MathException.buildMessage(string, objectArray, Locale.US));
        this.pattern = string;
        this.arguments = (Object[])objectArray.clone();
        this.rootCause = throwable;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Object[] getArguments() {
        return (Object[])this.arguments.clone();
    }

    public String getMessage(Locale locale) {
        return this.pattern == null ? null : MathException.buildMessage(this.pattern, this.arguments, locale);
    }

    @Override
    public Throwable getCause() {
        return this.rootCause;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            PrintWriter printWriter = new PrintWriter(printStream, false);
            this.printStackTrace(printWriter);
            printWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            super.printStackTrace(printWriter);
            if (this.rootCause != null && !JDK_SUPPORTS_NESTED) {
                printWriter.print("Caused by: ");
                this.rootCause.printStackTrace(printWriter);
            }
        }
    }

    static {
        boolean bl = false;
        try {
            Throwable.class.getDeclaredMethod("getCause", new Class[0]);
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = false;
        }
        JDK_SUPPORTS_NESTED = bl;
        cachedResources = null;
    }
}

