/*
 * Decompiled with CFR 0.152.
 */
import controlP5.ControlP5;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import peasy.PeasyCam;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;

public class Wave_Generators
extends PApplet {
    PeasyCam cam;
    PImage gradient;
    ControlP5 controlP5;
    boolean writing = false;
    boolean writingFloor = false;
    boolean floorPresent = false;
    int canvasWidth = 832;
    int canvasHeight = 224;
    int sparcityPoints = 2;
    int cols;
    int rows;
    ArrayList<PVector> points = new ArrayList();
    float amp1;
    float amp2;
    float amp3;
    float amp4;
    float amp5;
    float amp6;
    float frq1;
    float frq2;
    float frq3;
    float frq4;
    float frq5;
    float frq6;
    int direction1;
    int direction2;
    int direction3;
    int direction4;
    int direction5;
    int direction6;
    int distance1;
    int distance2;
    int distance3;
    int distance4;
    int distance5;
    int distance6;
    boolean Wave1;
    boolean Wave2;
    boolean Wave3;
    boolean Wave4;
    boolean Wave5;
    boolean Wave6;
    boolean floor;
    boolean centroids;
    int age1;
    int age2;
    int age3;
    int age4;
    int age5;
    int age6;
    float z;
    float z1;
    float z2;
    float z3;
    float z4;
    float z5;
    float z6;
    float zNeg;
    float zMax = 0.0f;
    float zMin = 0.0f;
    float radians = (float)Math.PI / 180;
    PrintWriter write;
    PrintWriter writeFloor;
    float[] zRowSum = new float[this.canvasHeight / this.sparcityPoints];
    float[] zRowMult = new float[this.canvasHeight / this.sparcityPoints];
    float Floor = 0.0f;
    int topMenu = 40;
    int sideMenu = 120;
    int minThickness = 10;
    int thicknessMultiplier = 20;

    public void setup() {
        this.size(1440, 850, "processing.opengl.PGraphics3D");
        this.age6 = 1000;
        this.age5 = 1000;
        this.age4 = 1000;
        this.age3 = 1000;
        this.age2 = 1000;
        this.age1 = 1000;
        this.controlP5 = new ControlP5((PApplet)this);
        this.controlP5.addKnob("direction1", 0.0f, 360.0f, 0.0f, this.sideMenu - 80, this.topMenu, 70);
        this.controlP5.addToggle("Wave1", false, (float)this.sideMenu, (float)this.topMenu, 25, 10);
        this.controlP5.addSlider("distance1", 400.0f, 2000.0f, 0.0f, this.sideMenu, this.topMenu + 30, 100, 10);
        this.controlP5.addSlider("amp1", 0.0f, 50.0f, 0.0f, this.sideMenu, this.topMenu + 50, 100, 10);
        this.controlP5.addSlider("frq1", 0.0f, 5.0f, 0.0f, this.sideMenu, this.topMenu + 70, 100, 10);
        this.controlP5.addKnob("direction2", 0.0f, 360.0f, 0.0f, this.sideMenu - 80, this.topMenu + 100, 70);
        this.controlP5.addToggle("Wave2", false, (float)this.sideMenu, (float)(this.topMenu + 100), 25, 10);
        this.controlP5.addSlider("distance2", 0.0f, 2000.0f, 0.0f, this.sideMenu, this.topMenu + 130, 100, 10);
        this.controlP5.addSlider("amp2", 0.0f, 50.0f, 0.0f, this.sideMenu, this.topMenu + 150, 100, 10);
        this.controlP5.addSlider("frq2", 0.0f, 6.0f, 0.0f, this.sideMenu, this.topMenu + 170, 100, 10);
        this.controlP5.addKnob("direction3", 0.0f, 360.0f, 0.0f, this.sideMenu - 80, this.topMenu + 200, 70);
        this.controlP5.addToggle("Wave3", false, (float)this.sideMenu, (float)(this.topMenu + 200), 25, 10);
        this.controlP5.addSlider("distance3", 200.0f, 2000.0f, 0.0f, this.sideMenu, this.topMenu + 230, 100, 10);
        this.controlP5.addSlider("amp3", 0.0f, 30.0f, 0.0f, this.sideMenu, this.topMenu + 250, 100, 10);
        this.controlP5.addSlider("frq3", 0.0f, 15.0f, 0.0f, this.sideMenu, this.topMenu + 270, 100, 10);
        this.controlP5.addKnob("direction4", 0.0f, 360.0f, 0.0f, this.sideMenu - 80, this.topMenu + 300, 70);
        this.controlP5.addToggle("Wave4", false, (float)this.sideMenu, (float)(this.topMenu + 300), 25, 10);
        this.controlP5.addSlider("distance4", 0.0f, 2000.0f, 0.0f, this.sideMenu, this.topMenu + 330, 100, 10);
        this.controlP5.addSlider("amp4", 0.0f, 15.0f, 0.0f, this.sideMenu, this.topMenu + 350, 100, 10);
        this.controlP5.addSlider("frq4", 0.0f, 20.0f, 0.0f, this.sideMenu, this.topMenu + 370, 100, 10);
        this.controlP5.addKnob("direction5", 0.0f, 360.0f, 0.0f, this.sideMenu - 80, this.topMenu + 400, 70);
        this.controlP5.addToggle("Wave5", false, (float)this.sideMenu, (float)(this.topMenu + 400), 25, 10);
        this.controlP5.addSlider("distance5", 0.0f, 2000.0f, 0.0f, this.sideMenu, this.topMenu + 430, 100, 10);
        this.controlP5.addSlider("amp5", 0.0f, 10.0f, 0.0f, this.sideMenu, this.topMenu + 450, 100, 10);
        this.controlP5.addSlider("frq5", 0.0f, 20.0f, 0.0f, this.sideMenu, this.topMenu + 470, 100, 10);
        this.controlP5.addKnob("direction6", 0.0f, 360.0f, 0.0f, this.sideMenu - 80, this.topMenu + 500, 70);
        this.controlP5.addToggle("Wave6", false, (float)this.sideMenu, (float)(this.topMenu + 500), 25, 10);
        this.controlP5.addSlider("distance6", 0.0f, 2000.0f, 0.0f, this.sideMenu, this.topMenu + 530, 100, 10);
        this.controlP5.addSlider("amp6", 0.0f, 40.0f, 0.0f, this.sideMenu, this.topMenu + 550, 100, 10);
        this.controlP5.addSlider("frq6", 0.0f, 20.0f, 0.0f, this.sideMenu, this.topMenu + 570, 100, 10);
        this.controlP5.addToggle("floor", false, (float)(this.sideMenu - 80), (float)(this.topMenu + 600), 20, 20);
        this.controlP5.addToggle("centroids", false, (float)(this.sideMenu - 80 + 30), (float)(this.topMenu + 600), 20, 20);
        this.controlP5.addSlider("thicknessMultiplier", 1.0f, 100.0f, 0.0f, this.sideMenu - 80, this.topMenu + 640, 100, 10);
        this.controlP5.addSlider("minThickness", 0.0f, 30.0f, 10.0f, this.sideMenu - 80, this.topMenu + 660, 100, 10);
        this.controlP5.addBang("LoadGradient", this.sideMenu - 80, this.topMenu + 680, 20, 20);
        this.controlP5.addBang("save", this.sideMenu - 80, this.topMenu + 720, 20, 20);
        this.controlP5.setAutoDraw(false);
        this.cols = this.canvasWidth / this.sparcityPoints;
        this.rows = this.canvasHeight / this.sparcityPoints;
        this.cam = new PeasyCam((PApplet)this, (double)(this.canvasWidth / 2 - 100), (double)(this.canvasHeight / 2), 0.0, 1000.0);
        this.cam.setMinimumDistance(0.0);
        this.cam.setMaximumDistance(3000.0);
    }

    public void draw() {
        this.background(0);
        int n = 0;
        while (n < this.rows) {
            int n2 = 0;
            while (n2 < this.cols) {
                int n3 = n2 * this.sparcityPoints;
                int n4 = n * this.sparcityPoints;
                if (this.Wave1) {
                    this.distToPoint(this.direction1, this.distance1, n3, n4, this.amp1, this.frq1, this.age1);
                    this.z1 = this.z;
                }
                if (this.Wave2) {
                    this.distToPoint(this.direction2, this.distance2, n3, n4, this.amp2, this.frq2, this.age2);
                    this.z2 = this.z;
                }
                if (this.Wave3) {
                    this.distToPoint(this.direction3, this.distance3, n3, n4, this.amp3, this.frq3, this.age3);
                    this.z3 = this.z;
                }
                if (this.Wave4) {
                    this.distToPoint(this.direction4, this.distance4, n3, n4, this.amp4, this.frq4, this.age4);
                    this.z4 = this.z;
                }
                if (this.Wave5) {
                    this.distToPoint(this.direction5, this.distance5, n3, n4, this.amp5, this.frq5, this.age5);
                    this.z5 = this.z;
                }
                if (this.Wave6) {
                    this.distToPoint(this.direction6, this.distance6, n3, n4, this.amp6, this.frq6, this.age6);
                    this.z6 = this.z;
                }
                this.z = this.z1 + this.z2 + this.z3 + this.z4 + this.z5 + this.z6;
                if (this.z < this.zMin) {
                    this.zMin = PApplet.parseInt((float)this.z);
                }
                if (this.z > this.zMax) {
                    this.zMax = PApplet.parseInt((float)this.z);
                }
                if (this.floor && this.gradient != null) {
                    this.getFloor(n3, n4);
                    this.fill(255);
                    this.stroke(50.0f, 100.0f, 120.0f);
                    this.findingFloor(n3, n4, this.z);
                    this.point(n3, n4, this.zNeg);
                    if (n2 == 0) {
                        this.zRowSum[n] = 0.0f;
                        this.zRowMult[n] = 0.0f;
                    }
                    int n5 = n;
                    this.zRowSum[n5] = this.zRowSum[n5] + (this.z - this.zNeg);
                    this.zRowMult[n] = this.zRowMult[n] + (float)n2 * (this.z - this.zNeg);
                }
                if (this.floor && !this.floorPresent) {
                    this.selectInput("Select a gradient:", "fileSelected");
                    this.floorPresent = true;
                }
                if (this.writingFloor) {
                    this.writeFloor.println(String.valueOf(n3) + " " + n4 + " " + this.zNeg);
                    if (n == this.rows - 1) {
                        this.writingFloor = false;
                        this.writeFloor.flush();
                        this.writeFloor.close();
                        Wave_Generators.println((String)"finished writing Floor to file");
                    }
                }
                this.stroke(255);
                this.point(n3, n4, this.z);
                if (this.writing) {
                    this.write.println(String.valueOf(n3) + " " + n4 + " " + this.z);
                    if (n == this.rows - 1) {
                        this.writing = false;
                        this.write.flush();
                        this.write.close();
                        Wave_Generators.println((String)"finished writing to file");
                    }
                }
                ++n2;
            }
            if (this.centroids) {
                this.stroke(51.0f, 255.0f, 0.0f);
                this.point(this.zRowMult[n] / this.zRowSum[n] * 2.0f, n * 2, this.zRowSum[n] / (float)(this.canvasWidth / this.sparcityPoints));
                this.stroke(255.0f, 10.0f, 10.0f);
                this.line(this.canvasWidth / 2, 0.0f, 0.0f, this.canvasWidth / 2, this.canvasHeight, 0.0f);
                this.stroke(10.0f, 10.0f, 255.0f);
                this.line(this.canvasWidth / 3, 0.0f, 0.0f, this.canvasWidth / 3, this.canvasHeight, 0.0f);
            }
            ++n;
        }
        this.gui();
        this.zMin = 0.0f;
        this.zMax = 0.0f;
    }

    public void distToPoint(int n, int n2, int n3, int n4, float f, float f2, int n5) {
        float f3 = (float)n2 * Wave_Generators.sin((float)((float)n * this.radians));
        float f4 = (float)n2 * Wave_Generators.cos((float)((float)n * this.radians));
        float f5 = Wave_Generators.sqrt((float)(Wave_Generators.sq((float)((float)n3 - f4)) + Wave_Generators.sq((float)((float)n4 - f3))));
        this.z = f * Wave_Generators.sin((float)(6.283f * f2 / (float)this.canvasWidth * f5));
        if (f5 >= (float)this.canvasWidth / f2 * (float)n5) {
            this.z = 0.0f;
        }
    }

    public void findingFloor(int n, int n2, float f) {
        this.getFloor(n, n2);
        this.zNeg = this.z - (this.Floor / 255.0f * (float)this.thicknessMultiplier + (float)this.minThickness);
    }

    public void gui() {
        this.hint(2);
        this.cam.beginHUD();
        this.controlP5.draw();
        this.text("Max Z diff: " + (this.zMax - this.zMin), this.sideMenu - 80 + 30, this.topMenu + 738);
        this.text("Sebastian Morales | adorevolution.com | Julio 2015", this.width - 200, this.height - 20);
        this.cam.endHUD();
        this.hint(-2);
    }

    public void save() {
        this.writing = true;
        this.writingFloor = true;
        this.write = this.createWriter("Points.txt");
        this.writeFloor = this.createWriter("PointsFloor.txt");
        this.saveFrame("Waves.png");
    }

    public void getFloor(int n, int n2) {
        int n3 = this.gradient.pixels[n + n2 * this.canvasWidth];
        int n4 = (n3 & 0xFF0000) >> 16;
        int n5 = (n3 & 0xFF00) >> 8;
        int n6 = n3 & 0xFF;
        this.Floor = (n4 + n6 + n5) / -3 + 255;
    }

    public void LoadGradient() {
        this.selectInput("Select a gradient:", "fileSelected");
    }

    public void fileSelected(File file) {
        if (file == null) {
            Wave_Generators.println((String)"Window was closed or the user hit cancel.");
        } else {
            Wave_Generators.println((String)("User selected " + file.getAbsolutePath()));
            this.gradient = this.loadImage(file.getAbsolutePath());
            this.loadPixels();
            this.floorPresent = true;
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"Wave_Generators"};
        if (stringArray != null) {
            PApplet.main((String[])Wave_Generators.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }
}

