// interrupt routines (these are called by the hardware interrupts, not by the main code)
// __________________________________________________________________________________________________

void rainIRQ()
{
  raintime = micros(); // grab current time
  raininterval = raintime - rainlast; // calculate interval between this and last event

  if (raininterval > 500) // ignore switch-bounce glitches less than 100uS after initial edge
  {
    rain++; // increment bucket counter
    rainlast = raintime; // set up for next event
  }
}

void wspeedIRQ()
{
  
  windtime = micros(); // grab current time
  windbounce = windtime - windlast;
  windinterval += windbounce;
  
  
  if (windbounce > debounceDelay)
  {
    windlast = windtime; // save the current time so that we can calculate the interval between now and the next interrupt
    windintcount++;
    if (windinterval >= 1000000)
    {
      if (windinterval < 8000000)
      {
        gotwspeed = true;
      }
      else
      {
        windinterval = 0;
        windintcount = 0;
      }
    }
  }
}

void rainDetectIRQ()
{
  rainDetected = !(digitalRead(ciRainDetectPin));
}

void MOD1016Irq()
{
  MOD1016IrqTriggered = 1;
}

void handleWindSpeed(){
  fWindSpeed = (1.492 * windintcount) / (windinterval / 1000000);
  fAvgWindSpeed = fAvgWindSpeed +fWindSpeed;
  iWindSpeedCount++;
  if(fMaxGust < fWindSpeed)
    fMaxGust = fWindSpeed;
  windinterval = 0;
  windintcount = 0;
  gotwspeed = false;
  zerotime = millis();
}

void handleLightning(){
  // reset the flag
  MOD1016IrqTriggered = 0;
  // first step is to find out what caused interrupt
  // as soon as we read interrupt cause register, irq pin goes low
  uns8 irqSource = mod1016.getIRQ();
  
  // returned value is bitmap field, bit 0 - noise level too high, bit 2 - disturber detected, and finally bit 3 - lightning!
  if (irqSource == 1)
    //Serial.print("Noise level too high, try adjusting noise floor "); Serial.println(irqSource);
  if (irqSource == 4)
    iLightningDisturber++;
    //Serial.print("Disturber detected "); Serial.println(irqSource);
  if (irqSource == 8){
    //Serial.print("Lightning detected "); Serial.println(irqSource);
    iLightningCount++;
  }
}
