// Run-time Functions
// __________________________________________________________________________________________________

float get_wind_direction() 
// read the wind direction sensor, return heading in degrees
{
  unsigned int adc;

  adc = analogRead(ciWindDirPin); // get the current reading from the sensor
  //Serial.print("Analog wind reading: ");
  //Serial.println(adc);
  // The following table is ADC readings for the wind direction sensor output, sorted from low to high.
  // Each threshold is the midpoint between adjacent headings. The output is degrees for that ADC reading.
  // Note that these are not in compass degree order!  See Weather Meters datasheet for more information.

  if (adc < 435){
    fWindMatrix[0][1]=fWindMatrix[0][1]+1;
    return (292.5);
  }
  if (adc < 505){
    fWindMatrix[1][1]=fWindMatrix[1][1]+1;
    return (247.5);
  }
  if (adc < 530){
    fWindMatrix[2][1]=fWindMatrix[2][1]+1;
    return (270);
  }
  if (adc < 615){
    fWindMatrix[3][1]=fWindMatrix[3][1]+1;
    return (337.5);
  }
  if (adc < 725){
    fWindMatrix[4][1]=fWindMatrix[4][1]+1;
    return (315);
  }
  if (adc < 830){
    fWindMatrix[5][1]=fWindMatrix[5][1]+1;
    return (0);
  }
  if (adc < 930){
    fWindMatrix[6][1]=fWindMatrix[6][1]+1;
    return (225);
  }
  if (adc < 960){
    fWindMatrix[7][1]=fWindMatrix[7][1]+1;
    return (67.5);
  }
  if (adc < 975){
    fWindMatrix[8][1]=fWindMatrix[8][1]+1;
    return (45);
  }
  if (adc < 989){
    fWindMatrix[9][1]=fWindMatrix[9][1]+1;
    return (157.5);
  }
  if (adc < 998){
    fWindMatrix[10][1]=fWindMatrix[10][1]+1;
    return (180);
  }
  if (adc < 1004){
    fWindMatrix[11][1]=fWindMatrix[11][1]+1;
    return (112.5);
  }
  if (adc < 1013){
    fWindMatrix[12][1]=fWindMatrix[12][1]+1;
    return (135);
  }
  if (adc < 1005){
    fWindMatrix[13][1]=fWindMatrix[13][1]+1;
    return (292.5);
  }
  if (adc < 1020){
    fWindMatrix[14][1]=fWindMatrix[14][1]+1;
    return (90);
  }
  if (adc < 1024){
    fWindMatrix[15][1]=fWindMatrix[15][1]+1;
    return (22.5);
  }
  return (-1); // error
}

// prepFloat returns a String of float 'value' rounded to 'places' places after the decimal point
String prepFloat(float value, int places) {
  // this is used to cast digits 
  int digit;
  float tens = 0.1;
  int tenscount = 0;
  int i;
  float tempfloat = value;
  String tempString = "";
  
  // make sure we round properly. this could use pow from <math.h>, but doesn't seem worth the import
  // if this rounding step isn't here, the value 54.321 prints as 54.3209
  
  // calculate rounding term d: 0.5/pow(10,places) 
  float d = 0.5;
  if (value < 0)
    d *= -1.0;
    
  // divide by ten for each decimal place
  for (i = 0; i < places; i++)
    d/= 10.0; 
  
  // this small addition, combined with truncation will round our values properly 
  tempfloat += d;
  
  // first get value tens to be the large power of ten less than value
  // tenscount isn't necessary but it would be useful if you wanted to know after this how many chars the number will take
  
  if (value < 0)
    tempfloat *= -1.0;
  while ((tens * 10.0) <= tempfloat) {
    tens *= 10.0;
    tenscount += 1;
  }
  
  // write out the negative if needed
  if (value < 0){
    tempString = tempString + "-";
    //Serial.print('-');
  }
  
  if (tenscount == 0){
    tempString = tempString + "0";
    //Serial.print(0, DEC);
  }
  
  for (i=0; i< tenscount; i++) {
    digit = (int) (tempfloat/tens);
    tempString = tempString + digit;
    //Serial.print(digit, DEC);
    tempfloat = tempfloat - ((float)digit * tens);
    tens /= 10.0;
  }
  
  // if no places after decimal, stop now and return
  if (places <= 0)
    return tempString;
  
  // otherwise, write the point and continue on
  tempString = tempString + ".";
  //Serial.print('.'); 
  
  // now write out each decimal place by shifting digits one by one into the ones place and writing the truncated value
  for (i = 0; i < places; i++) {
    tempfloat *= 10.0; 
    digit = (int) tempfloat;
    tempString = tempString + digit;
    //Serial.print(digit,DEC); 
    // once written, subtract off that digit
    tempfloat = tempfloat - (float) digit; 
  }
  return tempString;
}

void callback(char* topic, byte* payload, unsigned int length) {
  /*Serial.print("Message arrived [");
  Serial.print(topic);
  Serial.print("] ");
  for (int i = 0; i < length; i++) {
    Serial.print((char)payload[i]);
  }
  Serial.println("");*/
  
  if (String(topic) == "environment/edate"){
    da = "";
    for (int i = 0; i < length; i++) {
      da.concat((char)payload[i]);
    }
  }
  
  if (String(topic) == "environment/mtime"){
    ti = "";
    for (int i = 0; i < length; i++) {
      ti.concat((char)payload[i]);
    }
  }
  UpdateTime((da.length() +1), (ti.length() +1));
}

boolean reconnect() {

    if (mqttClient.connect(mqtt_pub_topic, mqtt_user, mqtt_pass)) {
      //Serial.println("MQTT connected");
      mqttClient.subscribe("environment/edate");
      mqttClient.subscribe("environment/mtime");
    } else {
      //Serial.print("failed, rc=");
      //Serial.print(mqttClient.state());
      //Serial.println(" try again in 5 seconds");
    }
    return mqttClient.connected();
}

void UpdateTime(unsigned int dai, unsigned int tii){
  if ((da == "") || (ti == "")){
    //Serial.println("Can't update date / time yet");
  }else{
    DateTime now = rtc.now();
    char dt[dai];
    da.toCharArray(dt,dai);
    //Serial.println(dt);
    
    char mt[tii];
    ti.toCharArray(mt,tii);
    //Serial.println(mt);
    rtc.adjust(DateTime(dt, mt));
  
    /*Serial.print(da); Serial.print(" "); Serial.println(ti);
    
    Serial.print(now.month(), DEC);
    Serial.print('/');
    Serial.print(now.day(), DEC);
    Serial.print('/');
    Serial.print(now.year(), DEC);
    Serial.print(' ');
    Serial.print(now.hour(), DEC);
    Serial.print(':');
    Serial.print(now.minute(), DEC);
    Serial.print(':');
    Serial.println(now.second(), DEC);*/
  }
}

void getMemory() {
  char top;
  int currentMem = 0;
  #ifdef __arm__
    currentMem = &top - reinterpret_cast<char*>(sbrk(0));
  #elif defined(CORE_TEENSY) || (ARDUINO > 103 && ARDUINO != 151)
    currentMem = &top - __brkval;
  #else  // __arm__
    currentMem = __brkval ? &top - __brkval : &top - __malloc_heap_start;
  #endif  // __arm__

  if(iMemCount > 0){
    if(currentMem < iMinMem){
      iMinMem = currentMem;
    }
  }else{
    iMinMem = currentMem;
  }

  iAvgMem = iAvgMem + currentMem;
  iMemCount++;

  //Serial.print("Min mem: "); Serial.println(iMinMem);
  //Serial.print(iAvgMem); Serial.print(" / "); Serial.println(iMemCount);
  //Serial.print("Avg Mem: "); Serial.println((iAvgMem / iMemCount));
}

int freeMemory() {
  char top;
#ifdef __arm__
  return &top - reinterpret_cast<char*>(sbrk(0));
#elif defined(CORE_TEENSY) || (ARDUINO > 103 && ARDUINO != 151)
  return &top - __brkval;
#else  // __arm__
  return __brkval ? &top - __brkval : &top - __malloc_heap_start;
#endif  // __arm__
}
