void TransmitData(float greatestDir){

  // Get moment in time readings and convert to strings
  
  String lux;
  if (!bLUXSensorError){
    /* Get a new sensor event */ 
    sensors_event_t event;
    sensorTSL.getEvent(&event);
  
    // LUX Data
    
    if (event.light)
    {
      //Serial.print(event.light); Serial.println(" lux");
      lux = prepFloat(event.light, 2);
    }
    else
    {
      /* If event.light = 0 lux the sensor is probably saturated
         and no reliable data could be generated! */
      //Serial.println("Sensor overload");
      lux = "0";
    }
    
  }else{
    lux = "0";
  }
  char lx[9];
  lux.toCharArray(lx,9);
  sLastLux = lux;

  // Temperature Data - Internal
  String internaltemperature = prepFloat(sensorDHT.readTemperature(TEMPTYPE), 1);
  char itp[6];
  internaltemperature.toCharArray(itp,6);
  sLastInternalTemperature = internaltemperature;

  // Humidity Data - Internal
  String internalhumidity = String(sensorDHT.readHumidity(), 1);
  char ihm[6];
  internalhumidity.toCharArray(ihm,6);
  sLastInternalHumidity = internalhumidity;
  delay(100);
  // Dew Point Data - Internal
  String internaldewpoint = prepFloat(calcDewpoint(sensorDHT.readTemperature(TEMPTYPE), sensorDHT.readHumidity()), 1);
  char idp[6];
  internaldewpoint.toCharArray(idp,6);
  sLastInternalDewPoint = internaldewpoint;

  float temp(NAN), hum(NAN), pres(NAN);
  BME280::TempUnit tempUnit(BME280::TempUnit_Fahrenheit);
  BME280::PresUnit presUnit(BME280::PresUnit_hPa);
  sensorTHP.read(pres, temp, hum, tempUnit, presUnit);
  
  // Temperature Data - External
  String temperature = prepFloat(temp, 1);
  char tp[6];
  temperature.toCharArray(tp,6);
  sLastTemperature = temperature;

  // Humidity Data
  String humidity = String(hum, 1);
  char hm[6];
  humidity.toCharArray(hm,6);
  sLastHumidity = humidity;

  // Dew Point Data
  String dewpoint = prepFloat(calcDewpoint(temp, hum), 1);
  char dp[6];
  dewpoint.toCharArray(dp,6);
  sLastDewPoint = dewpoint;

  //Feels Like Data
  String feelslike = prepFloat(calcFeelsLike(temp, hum, fMaxGust), 1);
  char fl[6];
  feelslike.toCharArray(fl,6);
  sLastFeelsLike = feelslike;

  // Pressure Data
  String bp = String(pres, 2);
  char ba[8];
  bp.toCharArray(ba,8);
  sLastBarometricPressure = bp;
  
  // Lightning Count Data
  String lightning = String(iLightningCount);
  char li[4];
  lightning.toCharArray(li,4);
  sLastLightning = lightning;

  String lightningdisturbers = String(iLightningDisturber);
  char ld[4];
  lightningdisturbers.toCharArray(ld,4);
  sLastLightningDisturber = lightningdisturbers;

  // Rain Detection Data
  String raining = String(rainDetected);
  char rd[2];
  raining.toCharArray(rd,2);
  sLastRaining = raining;

  // Wind Speed Data
  String windSpeed = "0.00";
  if (iWindSpeedCount > 0){
    windSpeed = prepFloat((fAvgWindSpeed / iWindSpeedCount), 2);
  }
  char ws[6];
  windSpeed.toCharArray(ws,6);
  sLastWindSpeed = windSpeed;

  // Gust Data 
  String gusts = String(fMaxGust, 2);
  char gu[6];
  gusts.toCharArray(gu,6);
  sLastGusts = gusts;

  // Wind Direction Data
  String windDirection = "";
  String windOrdinalDirection = "";
  for(int r=0; r<16; r++){
    if(fWindMatrix[r][1]>greatestDir){
      windDirection = String(fWindMatrix[r][0], 1);
      greatestDir = fWindMatrix[r][1];
      windOrdinalDirection = fWindOrdinal[r];
    }
  }
  char wd[6];
  windDirection.toCharArray(wd,6);
  char wo[4];
  windOrdinalDirection.toCharArray(wo,6);
  sLastWindDirection = windDirection;
  sLastWindOrdinalDirection = windOrdinalDirection;

  // Rainfall Data
  fRainfall = rain * cfRainBucketsToInches;
  String rainfall = String(fRainfall, 3);
  char rf[6];
  rainfall.toCharArray(rf,6);
  sLastRainfall = rainfall;

  // UV data
  String ultrava = String(uv.readUVA());
  char uva[9];
  ultrava.toCharArray(uva,9);
  sUVA = ultrava;
  
  String ultravb = String(uv.readUVB());
  char uvb[9];
  ultravb.toCharArray(uvb,9);
  sUVB = ultravb;
  
  String ultravi = String(uv.readUVI());
  char uvi[6];
  ultravi.toCharArray(uvi,6);
  sUVIndex = ultravi;
  
  // Connect to MQTT broker and publish topics
  //Serial.print("Attempting MQTT connection...");
  getMemory();
  if (!mqttClient.connected()) {
    // Attempt to reconnect
    if (!reconnect()) {
      //Serial.println("error connecting to mqtt");
      iMQTTErrorCount++;
    }else{
      mqttClient.publish(mqtt_pub_temperature,tp);
      mqttClient.publish(mqtt_pub_humidity,hm);
      mqttClient.publish(mqtt_pub_dewpoint,dp);
      mqttClient.publish(mqtt_pub_feelslike,fl);
      mqttClient.publish(mqtt_pub_pressure,ba);
      mqttClient.publish(mqtt_pub_windspeed,ws);
      mqttClient.publish(mqtt_pub_winddirection,wd);
      mqttClient.publish(mqtt_pub_windordinaldirection,wo);
      mqttClient.publish(mqtt_pub_raining,rd);
      mqttClient.publish(mqtt_pub_rainfall,rf);
      mqttClient.publish(mqtt_pub_lightning,li);
      mqttClient.publish(mqtt_pub_lightningdisturber,ld);
      mqttClient.publish(mqtt_pub_gusts,gu);
      mqttClient.publish(mqtt_pub_lux,lx);
      mqttClient.publish(mqtt_pub_uva,uva);
      mqttClient.publish(mqtt_pub_uvb,uvb);
      mqttClient.publish(mqtt_pub_uvindex,uvi);
      iMQTTErrorCount=0;
    }
  }else{
    mqttClient.publish(mqtt_pub_temperature,tp);
    mqttClient.publish(mqtt_pub_humidity,hm);
    mqttClient.publish(mqtt_pub_dewpoint,dp);
    mqttClient.publish(mqtt_pub_feelslike,fl);
    mqttClient.publish(mqtt_pub_pressure,ba);
    mqttClient.publish(mqtt_pub_windspeed,ws);
    mqttClient.publish(mqtt_pub_winddirection,wd);
    mqttClient.publish(mqtt_pub_windordinaldirection,wo);
    mqttClient.publish(mqtt_pub_raining,rd);
    mqttClient.publish(mqtt_pub_rainfall,rf);
    mqttClient.publish(mqtt_pub_lightning,li);
    mqttClient.publish(mqtt_pub_lightningdisturber,ld);
    mqttClient.publish(mqtt_pub_gusts,gu);
    mqttClient.publish(mqtt_pub_lux,lx);
    mqttClient.publish(mqtt_pub_uva,uva);
    mqttClient.publish(mqtt_pub_uvb,uvb);
    mqttClient.publish(mqtt_pub_uvindex,uvi);
    iMQTTErrorCount=0;
  }
  
  // Connect to the database and transmit data 
  //Serial.print("Connecting... ");
  if (mysqlClient.connect(oMySQLServerAddress, 3306, user, password)) {
    delay(500);
    //Serial.println("Success!  ");
    DateTime now = rtc.now();
    String dtstamp = String(now.year(), DEC) + "/" + String(now.month(), DEC) + "/" + String(now.day(), DEC) + " " + String(now.hour(), DEC) + ":" + String(now.minute(), DEC)  + ":" + String(now.second(), DEC);
    String insert_string = "INSERT INTO " + dbIntervalDataTableName + " VALUES (" + temperature + ", " + humidity + ", " + dewpoint + ", " + feelslike + ", " + bp + 
      ", " + windSpeed + ", " + windDirection + ", '" + windOrdinalDirection + "', " + raining + ", " + rainfall + ", " + lightning + ", " + gusts + ", " + lux + 
      ", " + ultrava + ", " + ultravb + ", " + ultravi + ", '" + dtstamp + "')";
    Serial.println(insert_string);
    char query[200];
    insert_string.toCharArray(query,200);
    MySQL_Cursor *cur_mem = new MySQL_Cursor(&mysqlClient);
    cur_mem->execute(query);
    getMemory();
    //Serial.println(freeMemory());
    delete cur_mem;

    now = rtc.now();
    dtstamp = String(now.year(), DEC) + "/" + String(now.month(), DEC) + "/" + String(now.day(), DEC) + " " + String(now.hour(), DEC) + ":" + String(now.minute(), DEC)  + ":" + String(now.second(), DEC);
    insert_string = "INSERT INTO " + dbSystemDataTableName + " VALUES (" + internaltemperature + ", " + internalhumidity + ", " + internaldewpoint + ", " + iLightningDisturber + 
    ", " + iDBConnectionFailures + ", " + iDBConnectionFailuresSinceBoot + ", " + iMQTTErrorCount + ", " + bDHTSensorError + ", " + bTHPSensorError + ", " + bLightingSensorError + 
    ", " + bLUXSensorError + ", " + bUVSensorError + ", " + bRTCError + ", " + iMinMem + ", " + (iAvgMem / iMemCount) + ", " + iUserCount + ", '" + startupdtstamp + "'" + ", '" + dtstamp + "')";
    Serial.println(insert_string);
    char query2[200];
    insert_string.toCharArray(query2,200);
    MySQL_Cursor *cur_mem2 = new MySQL_Cursor(&mysqlClient);
    cur_mem2->execute(query2);
    iMinMem = 0;
    iAvgMem = 0;
    iMemCount = 0;
    iUserCount = 0;
    
    getMemory();
    //Serial.println(freeMemory());
    delete cur_mem2;
    mysqlClient.close();
    lastDataRecorded = millis();
    iDBConnectionFailures = 0;
  } else {
    //Serial.println("Connection failed.");
    iDBConnectionFailures++;
    iDBConnectionFailuresSinceBoot++;
    //displayStatus(4);
  }

  // Reset globals
  fAvgWindSpeed = 0.0;
  iWindSpeedCount = 0;
  fRainfall = 0.0;
  rain = 0;
  fMaxGust = 0.0;
  iLightningCount = 0;
  iLightningDisturber = 0;
  for(int r=0; r<16; r++){
    fWindMatrix[r][1] = 1;
    
  }

  // Reset timer
  dataRecordTimer = millis() + dataRecordPeriod;
  
}
