/*
 * Setup.h
 *
 * Created: 01/01/2018 11:52:44
 *  Author: Thoma
 */ 

#ifndef SETUP_H_
#define SETUP_H_

// RED: PB6
// GREEN: PC3
// BLUE: PB7
// COMMON: PD3

#define RED_OFF()		PORTB &= ~(1<<PB6)
#define RED_ON()		PORTB |= (1<<PB6)
#define GREEN_OFF()		PORTC &= ~(1<<PC3)
#define GREEN_ON()		PORTC |= (1<<PC3)
#define BLUE_OFF()		PORTB &= ~(1<<PB7)
#define BLUE_ON()		PORTB |= (1<<PB7)

void setupPins(void);
volatile uint8_t ISRcounter;
volatile uint8_t REDcounter; 
volatile uint8_t GREENcounter; 
volatile uint8_t BLUEcounter; 

__always_inline static void setupISR(void)
{
	// Initialize the timer counter to zero
	TCNT0 = 0;
	// Enable the overflow interrupt
	//TIMSK0 |= _BV(TOIE0);
	// Enable Output compare match A
	TIMSK0 |= _BV(OCIE0A);
	// Set the clock source to internal with no prescaler.
	// Note: all other bits are cleared in this step (force OC not activated
	// and waveform generation set to mode 0).
	TCCR0B = _BV(CS00);
	
	// Normal port operations, top value of counter = OCRA0
	TCCR0A = _BV(WGM01);
	// Define top counter value
	OCR0A = 100;
}
#define LEDS_DRIVER_TIMER_ISR	ISR(TIMER0_COMPA_vect)
//#define LEDS_DRIVER_TIMER_ISR	ISR(TIMER0_OVF_vect)



#endif /* SETUP_H_ */