#include <asf.h>
#include <avr/wdt.h>

uint16_t numberOfDelays;
uint16_t totalNumberOfDelays = 255;

int main (void)
{
	// Setup
	wdt_disable();
	setupISR();
	setupPins();
	sei();

	// Light up white
	REDcounter = 255;
	GREENcounter = 255;
	BLUEcounter = 255;
	delay100ms();
	BLUEcounter = 0;
	
	// Main
	while(true){			
		// FLASH BETWEEN COLORS
		for (uint16_t i = 0; i<30; i++){
			REDcounter = 255;
			GREENcounter = 0;
			BLUEcounter = 0;
			delay50ms();
			REDcounter = 255;
			GREENcounter = 255;
			BLUEcounter = 0;
			delay50ms();
			REDcounter = 0;
			GREENcounter = 255;
			BLUEcounter = 0;
			delay50ms();
			REDcounter = 0;
			GREENcounter = 255;
			BLUEcounter = 255;
			delay50ms();
			REDcounter = 0;
			GREENcounter = 0;
			BLUEcounter = 255;
			delay50ms();
			REDcounter = 255;
			GREENcounter = 0;
			BLUEcounter = 255;
			delay50ms();
		}
		
		// BREATHE BLUE
		for (uint16_t i = 0; i<5; i++){
			GREENcounter = 0;
			REDcounter = 0;
			for (uint16_t j = 5; j<255; j++){
				BLUEcounter = j;
				delayms(2);
			}
			for (uint16_t j = 255; j>5; j--){
				BLUEcounter = j;
				delayms(1);
			}
		}		
		
		// FLASH COLORS AT VARYING SPEED
		for (uint16_t i = 0; i<20; i++){
			for (uint16_t j = 0; j<5; j++){
				REDcounter = 255;
				GREENcounter = 0;
				BLUEcounter = 0;
				delayms(j<<3);
				REDcounter = 0;
				GREENcounter = 0;
				BLUEcounter = 0;
				delayms(j<<3);
			}
			for (uint16_t j = 0; j<5; j++){
				REDcounter = 0;
				GREENcounter = 255;
				BLUEcounter = 0;
				delayms(j<<3);
				REDcounter = 0;
				GREENcounter = 0;
				BLUEcounter = 0;
				delayms(j<<3);
			}
			for (uint16_t j = 0; j<5; j++){
				REDcounter = 0;
				GREENcounter = 0;
				BLUEcounter = 255;
				delayms(j<<3);
				REDcounter = 0;
				GREENcounter = 0;
				BLUEcounter = 0;
				delayms(j<<3);
			}
		}
		
		// FADE RED ORANGE GREEN
		for (uint16_t i = 0; i<25; i++){
			for (numberOfDelays = 0; numberOfDelays<totalNumberOfDelays; numberOfDelays++){
				REDcounter = numberOfDelays;
				GREENcounter = totalNumberOfDelays - numberOfDelays;
				BLUEcounter = 0;
				delay250us();
				delay250us();
				delay250us();
			}
		}
						
		// GO THROUGH THE FULL COLOR SPECTRUM
		for(uint16_t j = 1; j<4; j++){
			// Ramp up green
			REDcounter = 255;
			GREENcounter = 0;
			BLUEcounter = 0;
			for(uint8_t i = 0; i < 255; i++){
				GREENcounter++;
				delayms(j);
			}
			// Ramp down red
			REDcounter = 255;
			GREENcounter = 255;
			BLUEcounter = 0;
			for(uint8_t i = 0; i < 255; i++){
				REDcounter--;
				delayms(j);
			}
			// Ramp up blue
			REDcounter = 0;
			GREENcounter = 255;
			BLUEcounter = 0;
			for(uint8_t i = 0; i < 255; i++){
				BLUEcounter++;
				delayms(j);
			}
			// Ramp down green
			REDcounter = 0;
			GREENcounter = 255;
			BLUEcounter = 255;
			for(uint8_t i = 0; i < 255; i++){
				GREENcounter--;
				delayms(j);
			}
			// Ramp up red
			REDcounter = 0;
			GREENcounter = 0;
			BLUEcounter = 255;
			for(uint8_t i = 0; i < 255; i++){
				REDcounter++;
				delayms(j);
			}
			// Ramp down blue
			REDcounter = 255;
			GREENcounter = 0;
			BLUEcounter = 255;
			for(uint8_t i = 0; i < 255; i++){
				BLUEcounter--;
				delayms(j);
			}
		}
		
		// FLASH BETWEEN COLORS
		for (uint16_t i = 0; i<30; i++){
			REDcounter = 255;
			GREENcounter = 0;
			BLUEcounter = 0;
			delay50ms();
			REDcounter = 255;
			GREENcounter = 255;
			BLUEcounter = 0;
			delay50ms();
			REDcounter = 0;
			GREENcounter = 255;
			BLUEcounter = 0;
			delay50ms();
			REDcounter = 0;
			GREENcounter = 255;
			BLUEcounter = 255;
			delay50ms();
			REDcounter = 0;
			GREENcounter = 0;
			BLUEcounter = 255;
			delay50ms();
			REDcounter = 255;
			GREENcounter = 0;
			BLUEcounter = 255;
			delay50ms();
		}
		
		// BREATHE GREEN
		for (uint16_t i = 0; i<5; i++){
			BLUEcounter = 0;
			REDcounter = 0;
			for (uint16_t j = 5; j<255; j++){
				GREENcounter = j;
				delayms(2);
			}
			for (uint16_t j = 255; j>5; j--){
				GREENcounter = j;
				delayms(1);
			}
		}
		
		// FADE RED PURPLE BLUE
		for (uint16_t i = 0; i<25; i++){
			for (numberOfDelays = 0; numberOfDelays<totalNumberOfDelays; numberOfDelays++){
				REDcounter = numberOfDelays;
				BLUEcounter = totalNumberOfDelays - numberOfDelays;
				GREENcounter = 0;
				delay250us();
				delay250us();
				delay250us();
			}
		}
		
		// FLASH WHITE, SLOW TO FAST TO SLOW
		for (uint16_t i = 0; i<5; i++){
			for (uint16_t j = 0; j<8; j++){
				REDcounter = 255;
				GREENcounter = 255;
				BLUEcounter = 255;
				delayms(1<<j);
				REDcounter = 0;
				GREENcounter = 0;
				BLUEcounter = 0;
				delayms(1<<j);
			}
			for (uint16_t j = 8; j>0; j--){
				REDcounter = 255;
				GREENcounter = 255;
				BLUEcounter = 255;
				delayms(1<<j);
				REDcounter = 0;
				GREENcounter = 0;
				BLUEcounter = 0;
				delayms(1<<j);
			}
		}		
	
		// BREATHE RED
		for (uint16_t i = 0; i<5; i++){
			BLUEcounter = 0;
			GREENcounter = 0;
			for (uint16_t j = 5; j<255; j++){
				REDcounter = j;
				delayms(1);
			}
			for (uint16_t j = 255; j>5; j--){
				REDcounter = j;
				delayms(2);
			}
		}
	
		// SOME MORE
		
	}
}