/***********************************************************
 *  YouTube Channel counter with Matrix Led and Motors     *
 *  By YouLab. Inspired by Brian Lough and  Ashish Adhikari*
 *  https://www.youtube.com/user/youlab                    *
 ***********************************************************/

#include "LedMatrix.h"        // Library for Matrix Led display
#include <SPI.h>              // Library required by Matrix Led library
#include <YoutubeApi.h>       // YouTube API Library for Arduino
#include <ESP8266WiFi.h>      // Wi-Fi library for ESP8266
#include <WiFiClientSecure.h> // Variant of WiFiClient with TLS support
#include <ArduinoJson.h>      // Library required by other libraries.

// ######## Custom configuration to be replaced  ######### //
char ssid[]     = "WIFI_Name";                             // your network SSID (name)
char password[] = "WIFI_Password";                         // your network key
#define CHANNEL_ID "UCQVsjlyPMlN4tZ7cGd5NnnA"              // URL of your YouTube channel (www.youtube.com./channel/XXXX)
#define API_KEY "AIzaSyA3XqvXsSAQxdryQsAzp7PnH3G6Nvf5Aks"  // your google apps API Token
// ####################################################### //

WiFiClientSecure client;
YoutubeApi api(API_KEY, client);
long OLDsub     = 0;

//Setting Led Matrix
#define NUMBER_OF_DEVICES 4
#define CS_PIN 15
LedMatrix ledMatrix = LedMatrix(NUMBER_OF_DEVICES, CS_PIN);

//Setting motors pins
int aPlus = D1;
int aMoins = D3;
int bPlus = D2;
int bMoins = D4;


void setup() {

  //Matrix Led initialisation
  ledMatrix.init();
  ledMatrix.setRotation(true);  //Rotation of 90°
  ledMatrix.setText("Init");
  ledMatrix.setIntensity(15); // range is 0-15
  ledMatrix.setTextAlignment(4);
  ledMatrix.clear();
  ledMatrix.drawText();
  ledMatrix.commit();

// Set Motor pins as output
  pinMode(aPlus, OUTPUT);
  pinMode(aMoins, OUTPUT);  
  pinMode(bPlus, OUTPUT); 
  pinMode(bMoins, OUTPUT);  

  // Set WiFi to station mode and disconnect from an AP if it was Previously connected
  WiFi.mode(WIFI_STA);
  WiFi.disconnect();
  delay(100);

  // Attempt to connect to Wifi network:
  Serial.begin(115200);
  Serial.print("Connecting Wifi: ");
  Serial.println(ssid);
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    Serial.print(".");
    delay(500);
  }
  Serial.println("");
  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  IPAddress ip = WiFi.localIP();
  Serial.println(ip);
}

void loop() {

  Serial.println("Request API");
  if(api.getChannelStatistics(CHANNEL_ID))
  {
    Serial.println("---------Stats---------");
    Serial.print("Subscriber Count: ");
    Serial.println(api.channelStats.subscriberCount);
    Serial.println("------------------------");

    // Display the subscribers count
     ledMatrix.clear();
     ledMatrix.setText(String(api.channelStats.subscriberCount));
     ledMatrix.drawText();
     ledMatrix.commit(); 

    // Power motors if a new subscriber is gained
    if ( api.channelStats.subscriberCount > OLDsub ) { // New subscriber Gained
     digitalWrite(aPlus, HIGH);   // Motor A ON
     digitalWrite(aMoins, LOW);    
     digitalWrite(bPlus, HIGH);   // Motor B ON
     digitalWrite(bMoins, LOW);   
     delay(5000);                  // Motors running for x milliseconds -> 5000 = 5s
     digitalWrite(aPlus, LOW);    // Motor A OFF
     digitalWrite(bPlus, LOW);    // Motor B OFF
  
     OLDsub = api.channelStats.subscriberCount;
     }
   }
   delay(2000); // Time before next YouTube API call -> 2000 = 2s
}
