// Pointer Robot with Raspberry Pi and Arduino
// Copyright (C) 2018, ArduinoDeXXX All Rights Reserved.
//
// materials:
// Raspberry Pi 3,
// Arduino NANO,
// Logic level converter (3.3V -- 5V),
// USB camera with microphone C270,
// servo SG90 (x2)
// and a motor driver IC L298N for 2 DC motors.
//
// information:
// It is Presupposed that DC 5V is supplied to 2 DC motors via L298N in this sketch.
// Connect TX and RX pins to RX and TX in GPIO in Pi 3 via logic level converter.
// They should be unpluged when this sketch is uploaded.
// View the sites bellow to see more detail.
// https://www.instructables.com/id/Pointer-Robot-With-RPi-and-Arduino/
// https://www.instructables.com/id/Pointer-Robot-With-RPi-and-Arduino-JPN/

#include <Servo.h> 
Servo myservo_h;  // create servo object to control servo_horizontal 
Servo myservo_v;  // create servo object to control servo_vertical 
int srv_hrzn =90;
int srv_vrtc =90;
int dcMotor = 215;

void setup() {
  Serial.begin( 115200 );
  myservo_h.attach(9);  // attaches the servo on pin 9 to the servo object 
  myservo_v.attach(6);  // attaches the servo on pin 6 to the servo object
 
  pinMode(11, OUTPUT); // Right motor    
  pinMode(12, OUTPUT);     
  pinMode(5, OUTPUT); // PWM1 (dcMotor)
  pinMode(4, OUTPUT);  // Left Motor     
  pinMode(7, OUTPUT);     
  pinMode(3, OUTPUT); // PWM2 (dcMotor)     

  analogWrite( 5, dcMotor );
  analogWrite( 3, dcMotor );
  
  myservo_h.write(srv_hrzn);
  myservo_v.write(srv_vrtc);
}

void loop() { 
  if ( Serial.available() > 0 ) {
    delay(1);  // Change the delay time if reading error is often occuered.
    int code = serialReadAsInt();
    int rec_SrvHrzn = srv_hrzn;
    int rec_SrvVrtc = srv_vrtc;
    if ( code < -100 ) {
      code = - code;
      srv_hrzn = code % 180;  // Replace % with /, if camera is attached in horizontal.
      srv_vrtc = code / 180;  // Replace / with %, if camera is attached in horizontal.
    }
    else if ( code > 199 ) {
      int stepping = code / 180;
      if ( stepping > 1 ) {
        
        if ( stepping == 2 ) { forward(); }
        else if ( stepping == 3 ) { stopping(); }
        else if ( stepping == 4 ) { back(); }
        else if ( stepping == 9 ) { rightR(); }
        else if ( stepping == 10 ) { leftL(); }
      }
      dcMotor = ( code % 180 ) * 20 / 12;  // 255/180 = 17/12
    }
    //Serial.println(code);

    if ( abs(rec_SrvHrzn - srv_hrzn) < 21 ) {  // A filter against reading error in UART
      myservo_h.write(srv_hrzn);
      myservo_v.write(srv_vrtc);
      analogWrite( 5, dcMotor );
      analogWrite( 3, dcMotor );
    }
  }
}

int serialReadAsInt() {
  char c[ 11 ];
  for ( int i = 0; i < 11; i++ ) {
    c[ i ] = Serial.read();
    if ( c[ i ] == '\0' )
      break;
  } 
  return atoi( c );
}

void forward() {
  digitalWrite( 11, HIGH );
  digitalWrite( 12, LOW );
  digitalWrite( 4, LOW );
  digitalWrite( 7, HIGH );
}
void stopping() {
  digitalWrite( 11, LOW );
  digitalWrite( 12, LOW );
  digitalWrite( 4, LOW );
  digitalWrite( 7, LOW );
}
void back() {
  digitalWrite( 11, LOW );
  digitalWrite( 12, HIGH );
  digitalWrite( 4, HIGH );
  digitalWrite( 7, LOW );
}
void rightR() {
  digitalWrite( 11, LOW );
  digitalWrite( 12, HIGH );
  digitalWrite( 4, LOW );
  digitalWrite( 7, HIGH );
}
void leftL() {
  digitalWrite( 11, HIGH );
  digitalWrite( 12, LOW );
  digitalWrite( 4, HIGH );
  digitalWrite( 7, LOW );
}
