const boolean inputMode = HIGH;// high for buttons LOW for piezo

const int numPorts=4;
int led[numPorts]={5,6,7,8};
int ins[numPorts]={A0,A1,A2,A3};
int goButton=A4;
int rotarySwitch[3]={2,3,9};

int theDelay=1;

unsigned long time1;
unsigned long time2;
float interval1;

String stringOne, stringTwo; //Needed for my Serial LCD

void setup() 
{
  pinMode(goButton,INPUT);
  digitalWrite(goButton,HIGH);
  
  for (int i=0; i<numPorts; i++)
  {  
    pinMode(led[i], OUTPUT);
    pinMode(ins[i],INPUT); 
  }
  
  for (int i=0; i<3; i++)
  {
    pinMode(rotarySwitch[i],INPUT);
    digitalWrite(rotarySwitch[i],HIGH);//internal pullup
  }
  
  Serial.begin(9600);
  //This is how i write to my Serial LCD
  Serial.print("sc;");
  Serial.println("sd0,2;");
  Serial.println("ssAO Shooting;");
  Serial.println("sd1,4;");
  Serial.println("ssGame v1.32;");
  delay(6000);
  Serial.print("sc;");
  Serial.println("sd0,2;");
  Serial.println("ssMade by:;");
  Serial.println("sd1,0;");
  Serial.println("ssAndreas Olsson;");
  delay(6000);
  Serial.print("sc;");
  Serial.println("sd0,2;");
  Serial.println("ssSystem control;");
  Serial.println("sd1,0;");
  Serial.println("ssof sensors;");
  Serial.write(0x0C); delay(5);
  
  doPost();

  Serial.write(0x0C); delay(5);
  Serial.write(0xFA);
  Serial.write(B00000100); 
  Serial.write(B00000100); 
  Serial.write(B00011111); 
  Serial.write(B00000100); 
  Serial.write(B00000100); 
  Serial.write(B00000100); 
  Serial.write(B00000000); 
  Serial.write(B00011111); 
  Serial.write(0x11);
  Serial.write(0x0C); delay(5);


}

void loop() 
{

  Serial.write(0x0C); delay(5);
  //Write to LCD
  Serial.print("sc;");
  delay(5);
  Serial.println("sd0,0;");
  Serial.println("ssLoad game and;");
  delay(5);
  Serial.println("sd1,0;");
  Serial.println("sspress start;");
  delay(3000);

  Serial.write(0x0C); delay(5);

  while ((PINC & B00010000));

  
  if (digitalRead(rotarySwitch[0])==LOW) doQuickDraw();
  else if (digitalRead(rotarySwitch[1])==LOW) doTimedMode();
    else if (digitalRead(rotarySwitch[2])==LOW) doRapidFire();  
 
}

void doTimedMode()
{
  randomSeed(millis());

  int currentPort=random(4);
  int newPort=random(4);
  int maxRounds=32;
  int hitCounter=0;
  time1=millis();
  interval1=0;

  Serial.write(0x0C); delay(5);
  Serial.print("sc;");
  Serial.println("sd0,0;");
  Serial.println("ssTimed mode;");
  delay(3000);
  Serial.write(0x0C); delay(5);
  Serial.write(0xDF); // C note
  Serial.println("sd1,0;");
  Serial.println("ssSTART;");  
  while (interval1 < 10000) // 10 seconds
  {
    digitalWrite(led[currentPort],HIGH);
    switch (currentPort)
    {
      case 0:
        while (!(PINC & B00000001));
        break;
      case 1:
        while (!(PINC & B00000010));
        break;
      case 2:
        while (!(PINC & B00000100));
        break;
      case 3:
        while (!(PINC & B00001000));
        break;
    }
    hitCounter++;
    time2=millis(); 
    interval1=(time2-time1);
    digitalWrite(led[currentPort],LOW);
    Serial.write(0x0C); delay(5);
    //Need to format for writing to LCD with value (Yes i know i have a crazy LCD)
    stringOne ="ss";
    stringOne += hitCounter;
    stringOne += ";";
    Serial.print("sc;");
    Serial.println("sd0,0;");
    Serial.println("ssTimed mode;");
    Serial.println("sd1,0;");
    Serial.println("ssFire:;");
    Serial.println("sd1,7;");
    Serial.println(stringOne);
    newPort=random(4);
    while (newPort==currentPort) newPort=random(4);
    currentPort=newPort;
  }
    Serial.write(0x0C); delay(5);
    stringOne ="ss";
    stringOne += hitCounter;
    stringOne += " ";
    stringOne += ";";
    Serial.print("sc;");
    Serial.println("sd0,0;");
    Serial.print(stringOne);
    Serial.println("sd0,4;");
    Serial.println("ssFire;");
    Serial.write(0x0D);
    Serial.println("sd1,0;");
    Serial.println("ssin 10 Sec;");
  delay(5000);
}
void doRapidFire()
{
  randomSeed(millis());

  int currentPort=random(4);
  int newPort=random(4);
  int maxRounds=32;
  time1=millis();

  Serial.write(0x0C); delay(5);
  //              0000000000111111     
  Serial.print("sc;");
  Serial.println("sd0,0;");
  Serial.println("ssRapid Fire;");
  
  delay(2000);
  
  Serial.write(0xDF); // C note

  
  for (int i=0; i<maxRounds; i++)
  {
    Serial.write(0x0C); delay(10);    
    stringOne ="ssRound ";
    stringOne += i+1;
    stringOne += " of ";
    stringOne += maxRounds;
    stringOne += ";";
    Serial.print("sc;");
    Serial.println("sd0,0;");
    Serial.println("ssRapid Fire;");
    Serial.println("sd1,0;");
    Serial.println(stringOne);
    digitalWrite(led[currentPort],HIGH);
    switch (currentPort)
    {
      case 0:
        while (!(PINC & B00000001));
        break;
      case 1:
        while (!(PINC & B00000010));
        break;
      case 2:
        while (!(PINC & B00000100));
        break;
      case 3:
        while (!(PINC & B00001000));
        break;
    }
    digitalWrite(led[currentPort],LOW);
    newPort=random(4);
    while (newPort==currentPort) newPort=random(4);
    
    
    currentPort=newPort;
  }

    time2=millis(); 
    interval1=(time2-time1);
    interval1=interval1/1000; 
    Serial.write(0x0C); delay(5);
    stringTwo ="ss";
    stringTwo += interval1,4;
    stringTwo += " sec";
    stringTwo += ";";
    Serial.print("sc;");
    Serial.println("sd0,0;");
    Serial.println("ssRapid Time:;"); Serial.write(0x0D);
    Serial.println("sd1,0;");
    Serial.println(stringTwo);

  delay(5000);
}


void doQuickDraw()
{
  randomSeed(millis());

  int firstTime=true;

  int currentPort=random(4);
  int maxRounds=8;

  Serial.write(0x0C); delay(5);
  Serial.print("sc;");
  Serial.println("sd0,0;");
  Serial.println("ssQuickdraw;");
  delay(2000);
  
  for (int i=0; i<maxRounds; i++)
  {
    Serial.write(0x0C); delay(5);
    stringOne ="ssRound ";
    stringOne += i+1;
    stringOne += " of ";
    stringOne += maxRounds;
    stringOne += ";";
    Serial.print("sc;");
    Serial.println("sd0,0;");    
    Serial.println("ssQuickdraw;");
    Serial.println("sd1,0;");
    Serial.println(stringOne);
    delay(random(3000)+1000);
    if (firstTime==true) { Serial.write(0xDF); firstTime=false; }// C note

    time1=millis();
    digitalWrite(led[currentPort],HIGH);
    switch (currentPort)
    {
      case 0:
        while (!(PINC & B00000001));
        break;
      case 1:
        while (!(PINC & B00000010));
        break;
      case 2:
        while (!(PINC & B00000100));
        break;
      case 3:
        while (!(PINC & B00001000));
        break;
    }
    time2=millis(); 
    interval1=(time2-time1);
    interval1=interval1/1000; 
    digitalWrite(led[currentPort],LOW);
    Serial.write(0x0C); delay(5);
    stringTwo ="ss";
    stringTwo += interval1,3;
    stringTwo += " sec";
    stringTwo += ";";
    Serial.print("sc;");
    Serial.println("sd0,0;");
    Serial.println("ssQuickdraw Time:;");
    Serial.println("sd1,0;");
    Serial.println(stringTwo);
    delay(2000);
    currentPort=random(4);
  }
  delay(5000);
}

void doPost()
{
  Serial.write(0xD2); // 1/16 note
  Serial.write(0xE3);//E
  //delay(100);
  Serial.write(0xDC);//A
  //delay(100);
  Serial.write(0xDE);//B
  for (int lop=0; lop<20; lop++)
  {
    theDelay+=10;
    if (theDelay>500) theDelay=1;
  
    for (int i=0; i<numPorts; i++)
    {
      //if (digitalRead(ins[i])==HIGH)
      {
        digitalWrite(led[i], HIGH);   // turn the LED on (HIGH is the voltage level)
      }
    }
    delay(theDelay);               // wait for a second
    for (int i=0; i<numPorts; i++)
    {
      digitalWrite(led[i], LOW);    // turn the LED off by making the voltage LOW
    }
    delay(theDelay);               // wait for a second
  }
}








