/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax.im;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.text.BadLocationException;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.TextAreaPainter;
import processing.app.syntax.im.CompositionTextPainter;

public class CompositionTextManager {
    private JEditTextArea textArea;
    private String prevComposeString;
    private int prevCommittedCount;
    private boolean isInputProcess;
    private int initialCaretPosition;
    public static final int COMPOSING_UNDERBAR_HEIGHT = 5;

    public CompositionTextManager(JEditTextArea textArea) {
        this.textArea = textArea;
        this.prevComposeString = "";
        this.isInputProcess = false;
        this.prevCommittedCount = 0;
    }

    public boolean getIsInputProcess() {
        return this.isInputProcess;
    }

    public void beginCompositionText(AttributedCharacterIterator text, int committed_count) {
        this.isInputProcess = true;
        this.prevComposeString = "";
        this.initialCaretPosition = this.textArea.getCaretPosition();
        this.processCompositionText(text, committed_count);
    }

    public void processCompositionText(AttributedCharacterIterator text, int committed_count) {
        int textLength;
        int layoutCaretPosition = this.initialCaretPosition + committed_count;
        CompositionTextPainter compositionPainter = this.textArea.getPainter().getCompositionTextpainter();
        compositionPainter.setComposedTextLayout(this.getTextLayout(text, committed_count), layoutCaretPosition);
        StringBuffer unCommitedStringBuf = new StringBuffer(textLength);
        char c = text.setIndex(committed_count);
        for (textLength = text.getEndIndex() - text.getBeginIndex() - committed_count; c != '\uffff' && textLength > 0; --textLength) {
            unCommitedStringBuf.append(c);
            c = text.next();
        }
        String unCommittedString = unCommitedStringBuf.toString();
        try {
            if (this.canRemovePreviousInput(committed_count)) {
                this.textArea.getDocument().remove(layoutCaretPosition, this.prevComposeString.length());
            }
            this.textArea.getDocument().insertString(layoutCaretPosition, unCommittedString, null);
            if (committed_count > 0) {
                this.initialCaretPosition += committed_count;
            }
            this.prevComposeString = unCommittedString;
            this.prevCommittedCount = committed_count;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private boolean canRemovePreviousInput(int committed_count) {
        return this.prevCommittedCount == committed_count || this.prevCommittedCount > committed_count;
    }

    public void endCompositionText(AttributedCharacterIterator text, int committed_count) {
        this.isInputProcess = false;
        if (committed_count == 0) {
            this.removeNotCommittedText(text);
        }
        CompositionTextPainter compositionPainter = this.textArea.getPainter().getCompositionTextpainter();
        compositionPainter.invalidateComposedTextLayout(this.initialCaretPosition + committed_count);
        this.prevComposeString = "";
        this.isInputProcess = false;
    }

    private void removeNotCommittedText(AttributedCharacterIterator text) {
        if (this.prevComposeString.length() == 0) {
            return;
        }
        try {
            this.textArea.getDocument().remove(this.initialCaretPosition, this.prevComposeString.length());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private TextLayout getTextLayout(AttributedCharacterIterator text, int committed_count) {
        AttributedString composed = new AttributedString(text, committed_count, text.getEndIndex());
        Font font = this.textArea.getPainter().getFont();
        FontRenderContext context = ((Graphics2D)this.textArea.getPainter().getGraphics()).getFontRenderContext();
        composed.addAttribute(TextAttribute.FONT, font);
        TextLayout layout = new TextLayout(composed.getIterator(), context);
        return layout;
    }

    private Point getCaretLocation() {
        Point loc = new Point();
        TextAreaPainter painter = this.textArea.getPainter();
        FontMetrics fm = painter.getFontMetrics();
        int offsetY = fm.getHeight() - 5;
        int lineIndex = this.textArea.getCaretLine();
        loc.y = lineIndex * fm.getHeight() + offsetY;
        int offsetX = this.textArea.getCaretPosition() - this.textArea.getLineStartOffset(lineIndex);
        loc.x = this.textArea.offsetToX(lineIndex, offsetX);
        return loc;
    }

    public Rectangle getTextLocation() {
        Point caret = this.getCaretLocation();
        return this.getCaretRectangle(caret.x, caret.y);
    }

    private Rectangle getCaretRectangle(int x, int y) {
        TextAreaPainter painter = this.textArea.getPainter();
        Point origin = painter.getLocationOnScreen();
        int height = painter.getFontMetrics().getHeight();
        return new Rectangle(origin.x + x, origin.y + y, 0, height);
    }

    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex) {
        int length = endIndex - beginIndex;
        String textAreaString = this.textArea.getText(beginIndex, length);
        return new AttributedString(textAreaString).getIterator();
    }

    public int getInsertPositionOffset() {
        return this.textArea.getCaretPosition() * -1;
    }
}

